/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Completable;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.ruby.CodeCompleter;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhtmlCompleter
extends CodeCompleter {
    public List<CompletionProposal> complete(@NonNull CompilationInfo compilationInfo, int n, String string, NameKind nameKind, Completable.QueryType queryType, boolean bl, HtmlFormatter htmlFormatter) {
        try {
            Document document = compilationInfo.getDocument();
            if (RhtmlCompleter.isWithinRuby(document, n)) {
                return super.complete(compilationInfo, n, string, nameKind, queryType, bl, htmlFormatter);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return Collections.emptyList();
    }

    public Completable.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        Document document = jTextComponent.getDocument();
        int n = jTextComponent.getCaret().getDot();
        if (RhtmlCompleter.isWithinRuby(jTextComponent.getDocument(), n)) {
            return super.getAutoQuery(jTextComponent, string);
        }
        return Completable.QueryType.NONE;
    }

    static boolean isWithinRuby(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == RhtmlTokenId.RUBY || tokenId == RhtmlTokenId.RUBY_EXPR) {
                return true;
            }
            if (tokenId == RhtmlTokenId.DELIMITER) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == RhtmlTokenId.RUBY || tokenSequence.token().id() == RhtmlTokenId.RUBY_EXPR) {
                    return true;
                }
            }
        }
        return false;
    }
}

