/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.ws.wadl2java.ast;

import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl2java.ast.MethodNode;
import com.sun.research.ws.wadl2java.ast.PathSegment;
import com.sun.research.ws.wadl2java.ast.ResourceTypeNode;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceNode {
    private ResourceNode parentResource;
    private String className;
    private PathSegment pathSegment;
    private List<ResourceNode> childResources;
    private List<MethodNode> methods;
    private List<ResourceTypeNode> types;
    private List<Doc> doc;

    public ResourceNode(Application app, Resources resources) {
        this.doc = app.getDoc();
        this.parentResource = null;
        this.className = "Endpoint";
        this.pathSegment = new PathSegment(resources == null ? "" : resources.getBase());
        this.childResources = new ArrayList<ResourceNode>();
        this.methods = new ArrayList<MethodNode>();
        this.types = new ArrayList<ResourceTypeNode>();
    }

    public ResourceNode(Resource resource, ResourceNode parent) {
        this.doc = resource.getDoc();
        this.parentResource = parent;
        this.pathSegment = new PathSegment(resource);
        this.className = ResourceNode.makeClassName(this.pathSegment.evaluate(null));
        this.childResources = new ArrayList<ResourceNode>();
        this.methods = new ArrayList<MethodNode>();
        this.types = new ArrayList<ResourceTypeNode>();
    }

    public ResourceNode addChild(Resource r) {
        ResourceNode n = new ResourceNode(r, this);
        this.childResources.add(n);
        return n;
    }

    public String getClassName() {
        return this.className;
    }

    public static String makeClassName(String input) {
        if (input == null || input.length() == 0) {
            input = "Index";
        }
        input = input.replaceAll("\\W", "_");
        input = input.substring(0, 1).toUpperCase() + input.substring(1);
        return input;
    }

    public List<ResourceNode> getChildResources() {
        return this.childResources;
    }

    public PathSegment getPathSegment() {
        return this.pathSegment;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public void addResourceType(ResourceTypeNode n) {
        this.types.add(n);
        this.methods.addAll(n.getMethods());
    }

    public List<ResourceTypeNode> getResourceTypes() {
        return this.types;
    }

    public ResourceNode getParentResource() {
        return this.parentResource;
    }

    public List<PathSegment> getPathSegments() {
        ArrayList<PathSegment> list = new ArrayList<PathSegment>();
        for (ResourceNode n = this; n != null; n = n.getParentResource()) {
            list.add(0, n.getPathSegment());
        }
        return list;
    }

    public List<Param> getQueryParams() {
        ArrayList<Param> params = new ArrayList<Param>();
        params.addAll(this.getPathSegment().getQueryParameters());
        for (ResourceTypeNode type : this.getResourceTypes()) {
            params.addAll(type.getQueryParams());
        }
        return params;
    }

    public List<Doc> getDoc() {
        return this.doc;
    }
}

