/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.ws.wadl2java.ast;

import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl2java.ast.FaultNode;
import com.sun.research.ws.wadl2java.ast.RepresentationNode;
import com.sun.research.ws.wadl2java.ast.ResourceNode;
import com.sun.research.ws.wadl2java.ast.ResourceTypeNode;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodNode {
    private ResourceNode parentResource;
    private ResourceTypeNode parentResourceType;
    private String name;
    private List<Param> queryParams;
    private List<RepresentationNode> supportedInputs;
    private List<RepresentationNode> supportedOutputs;
    private List<FaultNode> faults;
    private Method method;

    public MethodNode(Method m, ResourceNode r) {
        this.method = m;
        this.name = m.getName();
        this.parentResource = r;
        this.parentResourceType = null;
        this.queryParams = new ArrayList<Param>();
        this.queryParams.addAll(this.parentResource.getQueryParams());
        this.supportedInputs = new ArrayList<RepresentationNode>();
        this.supportedOutputs = new ArrayList<RepresentationNode>();
        this.faults = new ArrayList<FaultNode>();
        r.getMethods().add(this);
    }

    public MethodNode(Method m, ResourceTypeNode r) {
        this.method = m;
        this.name = m.getName();
        this.parentResource = null;
        this.parentResourceType = r;
        this.queryParams = new ArrayList<Param>();
        this.queryParams.addAll(r.getQueryParams());
        this.supportedInputs = new ArrayList<RepresentationNode>();
        this.supportedOutputs = new ArrayList<RepresentationNode>();
        this.faults = new ArrayList<FaultNode>();
        r.getMethods().add(this);
    }

    public String getName() {
        return this.name;
    }

    public List<Param> getQueryParameters() {
        return this.queryParams;
    }

    public List<Param> getRequiredParameters() {
        ArrayList<Param> required = new ArrayList<Param>();
        for (Param p : this.getQueryParameters()) {
            if (!p.isRequired()) continue;
            required.add(p);
        }
        return required;
    }

    public List<Param> getOptionalParameters() {
        ArrayList<Param> optional = new ArrayList<Param>();
        for (Param p : this.getQueryParameters()) {
            if (p.isRequired()) continue;
            optional.add(p);
        }
        return optional;
    }

    public boolean hasOptionalParameters() {
        return this.getOptionalParameters().size() > 0;
    }

    public List<RepresentationNode> getSupportedInputs() {
        return this.supportedInputs;
    }

    public List<RepresentationNode> getSupportedOutputs() {
        return this.supportedOutputs;
    }

    public List<FaultNode> getFaults() {
        return this.faults;
    }

    public List<Doc> getDoc() {
        return this.method.getDoc();
    }
}

