/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.ws.wadl2java;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import com.sun.research.ws.wadl.Option;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl2java.JavaDocUtil;
import com.sun.research.ws.wadl2java.ast.ResourceNode;
import javax.xml.namespace.QName;

public class GeneratorUtil {
    public static String makeConstantName(String input) {
        if (input == null || input.length() == 0) {
            input = "CONSTANT";
        }
        input = input.replaceAll("\\W", "_");
        input = input.toUpperCase();
        return input;
    }

    public static JClass getJavaType(Param param, JCodeModel model, JDefinedClass parentClass, JavaDocUtil javaDoc) {
        if (param.getOption().size() > 0) {
            JDefinedClass $enum;
            try {
                $enum = parentClass._package()._enum(ResourceNode.makeClassName(param.getName()));
                javaDoc.generateEnumDoc(param, $enum);
                for (Option o : param.getOption()) {
                    JEnumConstant c = $enum.enumConstant(GeneratorUtil.makeConstantName(o.getValue()));
                    c.arg(JExpr.lit((String)o.getValue()));
                    javaDoc.generateEnumConstantDoc(o, c);
                }
                JFieldVar $stringVal = $enum.field(4, String.class, "stringVal");
                JMethod $ctor = $enum.constructor(4);
                JVar $val = $ctor.param(String.class, "v");
                $ctor.body().assign((JAssignmentTarget)$stringVal, (JExpression)$val);
                JMethod $toString = $enum.method(1, String.class, "toString");
                $toString.body()._return((JExpression)$stringVal);
            }
            catch (JClassAlreadyExistsException ex) {
                $enum = ex.getExistingClass();
            }
            return $enum;
        }
        Class type = String.class;
        QName xmlType = param.getType();
        if (xmlType != null && xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            String localPart = xmlType.getLocalPart();
            if (localPart.equals("boolean")) {
                type = Boolean.class;
            } else if (localPart.equals("integer")) {
                type = Integer.class;
            } else if (localPart.equals("nonPositiveInteger")) {
                type = Integer.class;
            } else if (localPart.equals("long")) {
                type = Long.class;
            } else if (localPart.equals("nonNegativeInteger")) {
                type = Integer.class;
            } else if (localPart.equals("negativeInteger")) {
                type = Integer.class;
            } else if (localPart.equals("int")) {
                type = Integer.class;
            } else if (localPart.equals("unsignedLong")) {
                type = Long.class;
            } else if (localPart.equals("positiveInteger")) {
                type = Integer.class;
            } else if (localPart.equals("unsignedInt")) {
                type = Integer.class;
            } else if (localPart.equals("unsignedShort")) {
                type = Integer.class;
            } else if (localPart.equals("unsignedByte")) {
                type = Byte.class;
            } else if (localPart.equals("int")) {
                type = Integer.class;
            } else if (localPart.equals("short")) {
                type = Integer.class;
            } else if (localPart.equals("byte")) {
                type = Byte.class;
            } else if (localPart.equals("float")) {
                type = Float.class;
            } else if (localPart.equals("double")) {
                type = Double.class;
            } else if (localPart.equals("decimal")) {
                type = Double.class;
            } else if (localPart.equals("QName")) {
                type = QName.class;
            }
        }
        return (JClass)model._ref(type);
    }
}

