/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.SyntaxUpdateTokens;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.cnd.editor.cplusplus.BracketCompletion;
import org.netbeans.modules.cnd.editor.cplusplus.CCFormatter;
import org.netbeans.modules.cnd.editor.cplusplus.CCSyntax;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.netbeans.modules.cnd.editor.spi.cplusplus.CCSyntaxSupport;
import org.netbeans.modules.cnd.editor.spi.cplusplus.CndEditorActionsProvider;
import org.netbeans.modules.cnd.editor.spi.cplusplus.SyntaxSupportProvider;
import org.netbeans.modules.editor.NbEditorKit;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCKit
extends NbEditorKit {
    private InputAttributes lexerAttrs = null;

    public String getContentType() {
        return "text/x-c++";
    }

    public Document createDefaultDocument() {
        Document document = super.createDefaultDocument();
        return document;
    }

    protected void initDocument(BaseDocument baseDocument) {
        super.initDocument(baseDocument);
        baseDocument.putProperty(InputAttributes.class, (Object)this.getLexerAttributes());
        baseDocument.putProperty(Language.class, this.getLanguage());
        baseDocument.putProperty(SyntaxUpdateTokens.class, (Object)new SyntaxUpdateTokens(){
            private List<SyntaxUpdateTokens.TokenInfo> tokenList = new ArrayList<SyntaxUpdateTokens.TokenInfo>();

            public void syntaxUpdateStart() {
                this.tokenList.clear();
            }

            public List syntaxUpdateEnd() {
                return this.tokenList;
            }

            public void syntaxUpdateToken(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
                if (CCTokenContext.LINE_COMMENT == tokenID) {
                    this.tokenList.add(new SyntaxUpdateTokens.TokenInfo((SyntaxUpdateTokens)this, tokenID, tokenContextPath, n, n2));
                }
            }
        });
    }

    protected Language<CppTokenId> getLanguage() {
        return CppTokenId.languageCpp();
    }

    protected final synchronized InputAttributes getLexerAttributes() {
        if (this.lexerAttrs == null) {
            this.lexerAttrs = new InputAttributes();
            this.lexerAttrs.setValue(this.getLanguage(), (Object)"lexer-filter", this.getFilter(), true);
        }
        return this.lexerAttrs;
    }

    protected Filter<CppTokenId> getFilter() {
        return CndLexerUtilities.getGccCppFilter();
    }

    public Syntax createSyntax(Document document) {
        return new CCSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        SyntaxSupportProvider syntaxSupportProvider = (SyntaxSupportProvider)Lookup.getDefault().lookup(SyntaxSupportProvider.class);
        Object object = null;
        if (syntaxSupportProvider != null) {
            object = syntaxSupportProvider.createSyntaxSupport(baseDocument);
        }
        if (object == null) {
            object = new CCSyntaxSupport(baseDocument);
        }
        return object;
    }

    public Formatter createFormatter() {
        return new CCFormatter(((Object)((Object)this)).getClass());
    }

    protected Action getCommentAction() {
        return new ExtKit.CommentAction("//");
    }

    protected Action getUncommentAction() {
        return new ExtKit.UncommentAction("//");
    }

    protected Action getToggleCommentAction() {
        return new ExtKit.ToggleCommentAction("//");
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new CCDefaultKeyTypedAction(), new CCFormatAction(), new CCInsertBreakAction(), new CCDeleteCharAction("delete-previous", false), this.getToggleCommentAction(), this.getCommentAction(), this.getUncommentAction()};
        actionArray = TextAction.augmentList(super.createActions(), actionArray);
        Action[] actionArray2 = CndEditorActionsProvider.getDefault().getActions(this.getContentType());
        if (actionArray2.length > 0) {
            actionArray = TextAction.augmentList(actionArray, actionArray2);
        }
        return actionArray;
    }

    protected void updateActions() {
        super.updateActions();
        this.addSystemActionMapping("format", CCFormatAction.class);
    }

    public static class CCDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public CCDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
            BracketCompletion.charBackspaced(baseDocument, n, caret, c);
        }
    }

    public static class CCInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;
        static final boolean DEBUG = false;

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            int n = caret.getDot();
            if (BracketCompletion.posWithinString(baseDocument, n)) {
                try {
                    baseDocument.insertString(n, "\"\"", null);
                    caret.setDot(++n);
                    return new Integer(n);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                try {
                    if (BracketCompletion.isAddRightBrace(baseDocument, n)) {
                        TokenItem tokenItem;
                        int n2 = BracketCompletion.getRowOrBlockEnd(baseDocument, n);
                        String string = "}";
                        CCSyntaxSupport cCSyntaxSupport = (CCSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
                        for (tokenItem = cCSyntaxSupport.getTokenChain(n - 1, n); tokenItem != null && tokenItem.getTokenID() == CCTokenContext.WHITESPACE; tokenItem = tokenItem.getPrevious()) {
                        }
                        if (tokenItem == null || tokenItem.getTokenID() != CCTokenContext.LBRACE) {
                            return Boolean.FALSE;
                        }
                        int n3 = tokenItem.getOffset();
                        int n4 = cCSyntaxSupport.getLastCommandSeparator(n3 - 1);
                        if (n4 == -1 && n3 > 0) {
                            n4 = 0;
                        }
                        if (n4 != -1 && n4 < n) {
                            for (TokenItem tokenItem2 = cCSyntaxSupport.getTokenChain(n4, n3); tokenItem2 != null && tokenItem2.getOffset() < n3; tokenItem2 = tokenItem2.getNext()) {
                                if (tokenItem2.getTokenID() != CCTokenContext.CLASS && tokenItem2.getTokenID() != CCTokenContext.UNION && tokenItem2.getTokenID() != CCTokenContext.STRUCT && tokenItem2.getTokenID() != CCTokenContext.ENUM) continue;
                                string = "};";
                                break;
                            }
                        }
                        baseDocument.insertString(n2, string, null);
                        baseDocument.getFormatter().indentNewLine((Document)baseDocument, n2);
                        caret.setDot(n);
                        return Boolean.TRUE;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
            if (object != null && object instanceof Integer) {
                int n = caret.getDot();
                caret.setDot(n + 1);
            }
        }
    }

    public static class CCDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void checkIndentHotChars(JTextComponent jTextComponent, String string) {
            BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
            if (baseDocument != null) {
                baseDocument.putProperty((Object)"IgnoreInCommentMode", (Object)Boolean.TRUE);
                super.checkIndentHotChars(jTextComponent, string);
                baseDocument.putProperty((Object)"IgnoreInCommentMode", null);
            }
        }

        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            super.insertString(baseDocument, n, caret, string, bl);
            BracketCompletion.charInserted(baseDocument, n, caret, string.charAt(0));
        }
    }

    public class CCFormatAction
    extends BaseAction {
        public CCFormatAction() {
            super("format", 10);
            this.putValue("helpID", CCFormatAction.class.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                Cursor cursor = jTextComponent.getCursor();
                jTextComponent.setCursor(Cursor.getPredefinedCursor(3));
                baseDocument.atomicLock();
                try {
                    int n;
                    Position position;
                    int n2;
                    int n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)caret.getDot());
                    if (Utilities.isSelectionShowing((Caret)caret)) {
                        n2 = jTextComponent.getSelectionStart();
                        position = baseDocument.createPosition(jTextComponent.getSelectionEnd());
                    } else {
                        n2 = 0;
                        position = baseDocument.createPosition(baseDocument.getLength());
                    }
                    Formatter formatter = baseDocument.getFormatter();
                    formatter.reformatLock();
                    try {
                        int n4;
                        for (n = n2; n < position.getOffset(); n += n4) {
                            int n5 = position.getOffset();
                            n4 = formatter.reformat(baseDocument, n, n5);
                        }
                    }
                    finally {
                        formatter.reformatUnlock();
                    }
                    n = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n3);
                    if (n >= 0) {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                    jTextComponent.setCursor(cursor);
                }
            }
        }
    }
}

