/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseImageTokenID;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.cnd.editor.cplusplus.CCKit;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;

public class BracketCompletion {
    static void charInserted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        char[] cArray;
        TokenID tokenID;
        SyntaxSupport syntaxSupport = baseDocument.getSyntaxSupport();
        if (!(syntaxSupport instanceof ExtSyntaxSupport) || !BracketCompletion.completionSettingEnabled()) {
            return;
        }
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)syntaxSupport;
        if (c == ')' || c == ']' || c == '(' || c == '[') {
            TokenID tokenID2 = extSyntaxSupport.getTokenID(n);
            if (tokenID2 == CCTokenContext.RBRACKET || tokenID2 == CCTokenContext.RPAREN) {
                BracketCompletion.skipClosingBracket(baseDocument, caret, c);
            } else if (tokenID2 == CCTokenContext.LBRACKET || tokenID2 == CCTokenContext.LPAREN) {
                BracketCompletion.completeOpeningBracket(baseDocument, n, caret, c);
            }
        } else if (c == '\"' || c == '\'') {
            BracketCompletion.completeQuote(baseDocument, n, caret, c);
        } else if (c == ';') {
            BracketCompletion.moveSemicolon(baseDocument, n, caret);
        } else if (c == '<') {
            TokenID tokenID3 = extSyntaxSupport.getTokenID(n);
            if (tokenID3 == CCTokenContext.INCOMPLETE_SYS_INCLUDE) {
                BracketCompletion.completeOpeningBracket(baseDocument, n, caret, c);
            }
        } else if (c == '>' && ((tokenID = extSyntaxSupport.getTokenID(n)) == CCTokenContext.SYS_INCLUDE || tokenID == CCTokenContext.INCOMPLETE_SYS_INCLUDE) && (cArray = baseDocument.getChars(n + 1, 1)) != null && cArray[0] == '>') {
            baseDocument.remove(n + 1, 1);
        }
    }

    private static void moveSemicolon(BaseDocument baseDocument, int n, Caret caret) throws BadLocationException {
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        int n3 = n;
        TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n2);
        for (TokenItem tokenItem2 = tokenItem.getNext(); tokenItem2 != null && tokenItem2.getOffset() <= n2; tokenItem2 = tokenItem2.getNext()) {
            TokenID tokenID = tokenItem2.getTokenID();
            if (tokenID == CCTokenContext.RPAREN) {
                n3 = tokenItem2.getOffset();
                continue;
            }
            if (tokenID == CCTokenContext.WHITESPACE) continue;
            return;
        }
        if (BracketCompletion.isForLoopSemicolon(tokenItem) || BracketCompletion.posWithinAnyQuote(baseDocument, n)) {
            return;
        }
        baseDocument.remove(n, 1);
        baseDocument.insertString(n3, ";", null);
        caret.setDot(n3 + 1);
    }

    private static boolean isForLoopSemicolon(TokenItem tokenItem) {
        if (tokenItem == null || tokenItem.getTokenID() != CCTokenContext.SEMICOLON) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (tokenItem = tokenItem.getPrevious(); tokenItem != null; tokenItem = tokenItem.getPrevious()) {
            if (tokenItem.getTokenID() == CCTokenContext.LPAREN) {
                if (n == 0) {
                    for (tokenItem = tokenItem.getPrevious(); tokenItem != null && (tokenItem.getTokenID() == CCTokenContext.WHITESPACE || tokenItem.getTokenID() == CCTokenContext.BLOCK_COMMENT || tokenItem.getTokenID() == CCTokenContext.LINE_COMMENT); tokenItem = tokenItem.getPrevious()) {
                    }
                    return tokenItem.getTokenID() == CCTokenContext.FOR;
                }
                --n;
                continue;
            }
            if (tokenItem.getTokenID() == CCTokenContext.RPAREN) {
                ++n;
                continue;
            }
            if (tokenItem.getTokenID() == CCTokenContext.LBRACE) {
                if (n2 == 0) {
                    return false;
                }
                --n2;
                continue;
            }
            if (tokenItem.getTokenID() == CCTokenContext.RBRACE) {
                ++n2;
                continue;
            }
            if (tokenItem.getTokenID() != CCTokenContext.SEMICOLON) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return false;
    }

    static void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (BracketCompletion.completionSettingEnabled()) {
            TokenID tokenID;
            if (c == '(' || c == '[') {
                TokenID tokenID2 = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenID(n);
                if (tokenID2 == CCTokenContext.RBRACKET && BracketCompletion.tokenBalance(baseDocument, (TokenID)CCTokenContext.LBRACKET, (TokenID)CCTokenContext.RBRACKET) != 0 || tokenID2 == CCTokenContext.RPAREN && BracketCompletion.tokenBalance(baseDocument, (TokenID)CCTokenContext.LPAREN, (TokenID)CCTokenContext.RPAREN) != 0) {
                    baseDocument.remove(n, 1);
                }
            } else if (c == '\"') {
                char[] cArray = baseDocument.getChars(n, 1);
                if (cArray != null && cArray[0] == '\"') {
                    baseDocument.remove(n, 1);
                }
            } else if (c == '\'') {
                char[] cArray = baseDocument.getChars(n, 1);
                if (cArray != null && cArray[0] == '\'') {
                    baseDocument.remove(n, 1);
                }
            } else if (c == '<' && (tokenID = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenID(n)) == CCTokenContext.GT) {
                char[] cArray;
                TokenItem tokenItem = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenChain(n - 1, n);
                TokenItem tokenItem2 = tokenItem != null ? tokenItem.getPrevious() : null;
                TokenID[] tokenIDArray = new TokenID[]{CCTokenContext.CPPINCLUDE, CCTokenContext.CPPINCLUDE_NEXT};
                if ((tokenItem != null && BracketCompletion.matchIDs(tokenItem.getTokenID(), tokenIDArray) || tokenItem2 != null && BracketCompletion.matchIDs(tokenItem2.getTokenID(), tokenIDArray)) && (cArray = baseDocument.getChars(n, 1)) != null && cArray[0] == '>') {
                    baseDocument.remove(n, 1);
                }
            }
        }
    }

    static boolean isAddRightBrace(BaseDocument baseDocument, int n) throws BadLocationException {
        boolean bl = false;
        if (BracketCompletion.completionSettingEnabled() && n > 0) {
            int n2 = n;
            TokenItem tokenItem = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenChain(n2 - 1, n2);
            if (tokenItem == null) {
                return false;
            }
            bl = true;
            int n3 = n - tokenItem.getOffset();
            if (n3 > 0 && n3 < tokenItem.getImage().length()) {
                switch (tokenItem.getTokenID().getNumericID()) {
                    case 6: 
                    case 8: {
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
            if (bl) {
                int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                while (tokenItem != null && tokenItem.getOffset() >= n4) {
                    boolean bl2 = false;
                    switch (tokenItem.getTokenID().getNumericID()) {
                        case 6: 
                        case 8: 
                        case 9: {
                            bl2 = true;
                        }
                    }
                    if (!bl2) break;
                    tokenItem = tokenItem.getPrevious();
                }
                if (tokenItem == null || tokenItem.getTokenID() != CCTokenContext.LBRACE || tokenItem.getOffset() < n4) {
                    bl = false;
                }
            }
            if (bl) {
                bl = BracketCompletion.braceBalance(baseDocument) > 0;
            }
        }
        return bl;
    }

    static int getRowOrBlockEnd(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 == -1 || n >= n2) {
            return n;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        block8: for (TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, ++n2); tokenItem != null && tokenItem.getOffset() < n2; tokenItem = tokenItem.getNext()) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 60: {
                    ++n3;
                    continue block8;
                }
                case 61: {
                    if (n3-- != 0) continue block8;
                    return tokenItem.getOffset();
                }
                case 64: {
                    ++n4;
                    continue block8;
                }
                case 65: {
                    if (n4-- != 0) continue block8;
                    return tokenItem.getOffset();
                }
                case 62: {
                    ++n5;
                    continue block8;
                }
                case 63: {
                    if (n5-- != 0) continue block8;
                    return tokenItem.getOffset();
                }
            }
        }
        return n2;
    }

    private static int braceBalance(BaseDocument baseDocument) throws BadLocationException {
        return BracketCompletion.tokenBalance(baseDocument, (TokenID)CCTokenContext.LBRACE, (TokenID)CCTokenContext.RBRACE);
    }

    private static int tokenBalance(BaseDocument baseDocument, TokenID tokenID, TokenID tokenID2) throws BadLocationException {
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        BalanceTokenProcessor balanceTokenProcessor = new BalanceTokenProcessor(tokenID, tokenID2);
        extSyntaxSupport.tokenizeText((TokenProcessor)balanceTokenProcessor, 0, baseDocument.getLength(), true);
        return balanceTokenProcessor.getBalance();
    }

    private static void skipClosingBracket(BaseDocument baseDocument, Caret caret, char c) throws BadLocationException {
        BaseImageTokenID baseImageTokenID = c == ')' ? CCTokenContext.RPAREN : CCTokenContext.RBRACKET;
        int n = caret.getDot();
        if (BracketCompletion.isSkipClosingBracket(baseDocument, n, (TokenID)baseImageTokenID)) {
            baseDocument.remove(n - 1, 1);
            caret.setDot(n);
        }
    }

    static boolean isSkipClosingBracket(BaseDocument baseDocument, int n, TokenID tokenID) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return false;
        }
        boolean bl = false;
        TokenItem tokenItem = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenChain(n, n + 1);
        if (tokenItem != null && tokenItem.getTokenID() == tokenID) {
            int n2;
            int n3 = tokenID.getNumericID();
            int n4 = n3 == 61 ? 60 : 62;
            for (TokenItem tokenItem2 = tokenItem.getNext(); tokenItem2 != null && tokenItem2.getTokenID() == tokenID; tokenItem2 = tokenItem2.getNext()) {
                tokenItem = tokenItem2;
            }
            int n5 = 0;
            int n6 = -1;
            TokenItem tokenItem3 = tokenItem;
            boolean bl2 = false;
            block13: for (tokenItem = tokenItem.getPrevious(); !bl2 && tokenItem != null; tokenItem = tokenItem.getPrevious()) {
                n2 = tokenItem.getTokenID().getNumericID();
                switch (n2) {
                    case 60: 
                    case 62: {
                        if (n2 != n3 || ++n6 != 0) continue block13;
                        if (n5 != 0) {
                            n6 = 1;
                        }
                        bl2 = true;
                        continue block13;
                    }
                    case 61: 
                    case 63: {
                        if (n2 != n3) continue block13;
                        --n6;
                        continue block13;
                    }
                    case 64: {
                        if (++n5 <= 0) continue block13;
                        bl2 = true;
                        continue block13;
                    }
                    case 65: {
                        --n5;
                    }
                }
            }
            if (n6 != 0) {
                bl = true;
            } else {
                n5 = 0;
                n6 = 1;
                bl2 = false;
                block14: for (tokenItem = tokenItem3.getNext(); !bl2 && tokenItem != null; tokenItem = tokenItem.getPrevious()) {
                    n2 = tokenItem.getTokenID().getNumericID();
                    switch (n2) {
                        case 60: 
                        case 62: {
                            if (n2 != n4) continue block14;
                            ++n6;
                            continue block14;
                        }
                        case 61: 
                        case 63: {
                            if (n2 != n3 || --n6 != 0) continue block14;
                            if (n5 != 0) {
                                n6 = -1;
                            }
                            bl2 = true;
                            continue block14;
                        }
                        case 64: {
                            ++n5;
                            continue block14;
                        }
                        case 65: {
                            if (--n5 >= 0) continue block14;
                            bl2 = true;
                        }
                    }
                }
                bl = n6 == 0;
            }
        }
        return bl;
    }

    private static void completeOpeningBracket(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (BracketCompletion.isCompletablePosition(baseDocument, n + 1)) {
            String string = "" + BracketCompletion.matching(c);
            baseDocument.insertString(n + 1, string, null);
            caret.setDot(n + 1);
        }
    }

    private static boolean isEscapeSequence(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n <= 0) {
            return false;
        }
        char c = baseDocument.getChars(n - 1, 1)[0];
        return c == '\\';
    }

    private static void completeQuote(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        TokenID[] tokenIDArray;
        if (BracketCompletion.isEscapeSequence(baseDocument, n)) {
            return;
        }
        if (c == '\"') {
            TokenID[] tokenIDArray2 = new TokenID[2];
            tokenIDArray2[0] = CCTokenContext.STRING_LITERAL;
            tokenIDArray = tokenIDArray2;
            tokenIDArray2[1] = CCTokenContext.INCOMPLETE_USR_INCLUDE;
        } else {
            TokenID[] tokenIDArray3 = new TokenID[1];
            tokenIDArray = tokenIDArray3;
            tokenIDArray3[0] = CCTokenContext.CHAR_LITERAL;
        }
        TokenID[] tokenIDArray4 = tokenIDArray;
        if (BracketCompletion.posWithinQuotes(baseDocument, n + 1, c, tokenIDArray4) && BracketCompletion.isCompletablePosition(baseDocument, n + 1) && BracketCompletion.isUnclosedStringAtLineEnd(baseDocument, n, tokenIDArray4) && (baseDocument.getLength() == n + 1 || baseDocument.getLength() != n + 1 && baseDocument.getChars(n + 1, 1)[0] != c)) {
            baseDocument.insertString(n + 1, "" + c, null);
            caret.setDot(n + 1);
        } else {
            char[] cArray = baseDocument.getChars(n + 1, 1);
            if (cArray != null && cArray[0] == c) {
                baseDocument.remove(n + 1, 1);
            }
        }
    }

    private static boolean isCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        char c = baseDocument.getChars(n, 1)[0];
        return c == ')' || c == ',' || c == '\"' || c == '\'' || c == ' ' || c == '-' || c == '+' || c == '|' || c == '&' || c == ']' || c == '}' || c == '\n' || c == '\t' || c == ';';
    }

    private static boolean completionSettingEnabled() {
        Boolean bl = (Boolean)Settings.getValue(CCKit.class, (String)"pair-characters-completion");
        if (bl != null) {
            return bl;
        }
        return true;
    }

    private static char matching(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '<': {
                return '>';
            }
        }
        return ' ';
    }

    static boolean posWithinString(BaseDocument baseDocument, int n) {
        return BracketCompletion.posWithinQuotes(baseDocument, n, '\"', new TokenID[]{CCTokenContext.STRING_LITERAL, CCTokenContext.USR_INCLUDE});
    }

    static boolean posWithinQuotes(BaseDocument baseDocument, int n, char c, TokenID[] tokenIDArray) {
        try {
            MyTokenProcessor myTokenProcessor = new MyTokenProcessor();
            baseDocument.getSyntaxSupport().tokenizeText((TokenProcessor)myTokenProcessor, n - 1, baseDocument.getLength(), true);
            if (BracketCompletion.matchIDs(myTokenProcessor.tokenID, tokenIDArray)) {
                return n - myTokenProcessor.tokenStart == 1 || baseDocument.getChars(n - 1, 1)[0] != c;
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    static boolean posWithinAnyQuote(BaseDocument baseDocument, int n) {
        try {
            MyTokenProcessor myTokenProcessor = new MyTokenProcessor();
            baseDocument.getSyntaxSupport().tokenizeText((TokenProcessor)myTokenProcessor, n - 1, baseDocument.getLength(), true);
            if (myTokenProcessor.tokenID == CCTokenContext.STRING_LITERAL || myTokenProcessor.tokenID == CCTokenContext.CHAR_LITERAL || myTokenProcessor.tokenID == CCTokenContext.SYS_INCLUDE || myTokenProcessor.tokenID == CCTokenContext.USR_INCLUDE) {
                char[] cArray = baseDocument.getChars(n - 1, 1);
                return n - myTokenProcessor.tokenStart == 1 || cArray[0] != '\"' && cArray[0] != '\'';
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    static boolean isUnclosedStringAtLineEnd(BaseDocument baseDocument, int n, TokenID[] tokenIDArray) {
        try {
            MyTokenProcessor myTokenProcessor = new MyTokenProcessor();
            baseDocument.getSyntaxSupport().tokenizeText((TokenProcessor)myTokenProcessor, Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n), baseDocument.getLength(), true);
            return BracketCompletion.matchIDs(myTokenProcessor.tokenID, tokenIDArray);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    static boolean matchIDs(TokenID tokenID, TokenID[] tokenIDArray) {
        for (int i = tokenIDArray.length - 1; i >= 0; --i) {
            if (tokenID != tokenIDArray[i]) continue;
            return true;
        }
        return false;
    }

    private static class BalanceTokenProcessor
    implements TokenProcessor {
        private TokenID leftTokenID;
        private TokenID rightTokenID;
        private Stack<Integer> stack = new Stack();
        private int balance;
        private boolean isDefine;
        private char[] buffer;
        private int bufferStartPos;

        BalanceTokenProcessor(TokenID tokenID, TokenID tokenID2) {
            this.leftTokenID = tokenID;
            this.rightTokenID = tokenID2;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            if (tokenID.getCategory() == CCTokenContext.CPP) {
                switch (tokenID.getNumericID()) {
                    case 144: 
                    case 145: 
                    case 146: {
                        this.stack.push(this.balance);
                        break;
                    }
                    case 140: 
                    case 141: {
                        if (this.stack.empty()) break;
                        this.balance = this.stack.peek();
                        break;
                    }
                    case 142: {
                        if (this.stack.empty()) break;
                        this.stack.pop();
                        break;
                    }
                    case 139: {
                        this.isDefine = true;
                    }
                }
            } else if (tokenID == this.leftTokenID) {
                if (!this.isDefine) {
                    ++this.balance;
                }
            } else if (tokenID == this.rightTokenID) {
                if (!this.isDefine) {
                    --this.balance;
                }
            } else if (tokenID.getNumericID() == 6) {
                for (int i = n; i < n + n2; ++i) {
                    if (this.buffer[i] != '\n') continue;
                    this.isDefine = false;
                }
            }
            return true;
        }

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.buffer = cArray;
            this.bufferStartPos = n3 - n;
        }

        public int getBalance() {
            return this.balance;
        }
    }

    static class MyTokenProcessor
    implements TokenProcessor {
        public TokenID tokenID = null;
        public int tokenStart = -1;
        private int bufferStartPos = 0;

        MyTokenProcessor() {
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            this.tokenStart = this.tokenBuffer2DocumentOffset(n);
            this.tokenID = tokenID;
            return false;
        }

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.bufferStartPos = n3 - n;
        }

        private int tokenBuffer2DocumentOffset(int n) {
            return n + this.bufferStartPos;
        }
    }
}

