/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java.support;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Inflector {
    private static transient Inflector instance = null;
    private List plurals = new LinkedList();
    private List singulars = new ArrayList();
    private List uncountables = new LinkedList();

    private Inflector() {
        this.addPlural("$", "s", false);
        this.addPlural("(.*)$", "\\1s");
        this.addPlural("(.*)(ax|test)is$", "\\1\\2es");
        this.addPlural("(.*)(octop|vir)us$", "\\1\\2i");
        this.addPlural("(.*)(alias|status)$", "\\1\\2es");
        this.addPlural("(.*)(bu)s$", "\\1\\2ses");
        this.addPlural("(.*)(buffal|tomat)o$", "\\1\\2oes");
        this.addPlural("(.*)([ti])um$", "\\1\\2a");
        this.addPlural("(.*)sis$", "\\1ses");
        this.addPlural("(.*)(?:([^f])fe|([lr])f)$", "\\1\\3ves");
        this.addPlural("(.*)(hive)$", "\\1\\2s");
        this.addPlural("(.*)(tive)$", "\\1\\2s");
        this.addPlural("(.*)([^aeiouy]|qu)y$", "\\1\\2ies");
        this.addPlural("(.*)(series)$", "\\1\\2");
        this.addPlural("(.*)(movie)$", "\\1\\2s");
        this.addPlural("(.*)(x|ch|ss|sh)$", "\\1\\2es");
        this.addPlural("(.*)(matr|vert|ind)ix|ex$", "\\1\\2ices");
        this.addPlural("(.*)(o)$", "\\1\\2es");
        this.addPlural("(.*)(shoe)$", "\\1\\2s");
        this.addPlural("(.*)([m|l])ouse$", "\\1\\2ice");
        this.addPlural("^(ox)$", "\\1en");
        this.addPlural("(.*)(vert|ind)ex$", "\\1\\2ices");
        this.addPlural("(.*)(matr)ix$", "\\1\\2ices");
        this.addPlural("(.*)(quiz)$", "\\1\\2zes");
        this.addSingular("(.*)s$", "\\1");
        this.addSingular("(.*)(n)ews$", "\\1\\2ews");
        this.addSingular("(.*)([ti])a$", "\\1\\2um");
        this.addSingular("(.*)((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "\\1\\2sis");
        this.addSingular("(.*)(^analy)ses$", "\\1\\2sis");
        this.addSingular("(.*)([^f])ves$", "\\1\\2fe");
        this.addSingular("(.*)(hive)s$", "\\1\\2");
        this.addSingular("(.*)(tive)s$", "\\1\\2");
        this.addSingular("(.*)([lr])ves$", "\\1\\2f");
        this.addSingular("(.*)([^aeiouy]|qu)ies$", "\\1\\2y");
        this.addSingular("(.*)(s)eries$", "\\1\\2eries");
        this.addSingular("(.*)(m)ovies$", "\\1\\2ovie");
        this.addSingular("(.*)(x|ch|ss|sh)es$", "\\1\\2");
        this.addSingular("(.*)([m|l])ice$", "\\1\\2ouse");
        this.addSingular("(.*)(bus)es$", "\\1\\2");
        this.addSingular("(.*)(o)es$", "\\1\\2");
        this.addSingular("(.*)(shoe)s$", "\\1\\2");
        this.addSingular("(.*)(cris|ax|test)es$", "\\1\\2is");
        this.addSingular("(.*)(octop|vir)i$", "\\1\\2us");
        this.addSingular("(.*)(alias|status)es$", "\\1\\2");
        this.addSingular("^(ox)en", "\\1");
        this.addSingular("(.*)(vert|ind)ices$", "\\1\\2ex");
        this.addSingular("(.*)(matr)ices$", "\\1\\2ix");
        this.addSingular("(.*)(quiz)zes$", "\\1\\2");
        this.addIrregular("child", "children");
        this.addIrregular("man", "men");
        this.addIrregular("move", "moves");
        this.addIrregular("person", "people");
        this.addIrregular("sex", "sexes");
        this.addUncountable("equipment");
        this.addUncountable("fish");
        this.addUncountable("information");
        this.addUncountable("money");
        this.addUncountable("rice");
        this.addUncountable("series");
        this.addUncountable("sheep");
        this.addUncountable("species");
    }

    public static Inflector getInstance() {
        if (instance == null) {
            instance = new Inflector();
        }
        return instance;
    }

    public String camelize(String string) {
        return this.camelize(string, false);
    }

    public String camelize(String string, boolean bl) {
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (bl) {
            stringBuffer.append(Character.toLowerCase(string.charAt(0)));
        } else {
            stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        }
        boolean bl2 = false;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl2) {
                stringBuffer.append(Character.toUpperCase(c));
                bl2 = false;
                continue;
            }
            if (c == '_') {
                bl2 = true;
                continue;
            }
            if (c == '/') {
                bl2 = true;
                stringBuffer.append('.');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String classify(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return this.camelize(this.singularize(string));
    }

    public String dasherize(String string) {
        return string.replace('_', '-');
    }

    public String demodulize(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String foreignKey(String string) {
        return this.foreignKey(string, true);
    }

    public String foreignKey(String string, boolean bl) {
        return this.underscore(this.demodulize(string) + (bl ? "_id" : "id"));
    }

    public String humanize(String string) {
        if (string.endsWith("_id")) {
            string = string.substring(0, string.length() - 3);
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String ordinalize(int n) {
        int n2 = n % 100;
        if (n2 >= 11 && n2 <= 13) {
            return "" + n + "th";
        }
        switch (n % 10) {
            case 1: {
                return "" + n + "st";
            }
            case 2: {
                return "" + n + "nd";
            }
            case 3: {
                return "" + n + "rd";
            }
        }
        return "" + n + "th";
    }

    public String pluralize(String string) {
        int n;
        for (n = 0; n < this.uncountables.size(); ++n) {
            if (!this.uncountables.get(n).equals(string)) continue;
            return string;
        }
        for (n = 0; n < this.plurals.size(); ++n) {
            Replacer replacer = (Replacer)this.plurals.get(n);
            if (!replacer.matches(string)) continue;
            return replacer.replacement();
        }
        return string;
    }

    public String singularize(String string) {
        int n;
        for (n = 0; n < this.uncountables.size(); ++n) {
            if (!this.uncountables.get(n).equals(string)) continue;
            return string;
        }
        for (n = 0; n < this.singulars.size(); ++n) {
            Replacer replacer = (Replacer)this.singulars.get(n);
            if (!replacer.matches(string)) continue;
            return replacer.replacement();
        }
        return string;
    }

    public String tableize(String string) {
        return this.pluralize(this.underscore(string));
    }

    public String titleize(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                stringBuffer.append(' ');
                bl = true;
                continue;
            }
            if (c == '-') {
                stringBuffer.append(' ');
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String underscore(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                stringBuffer.append(Character.toLowerCase(c));
                bl = false;
                continue;
            }
            if (c == '.') {
                stringBuffer.append('/');
                bl = true;
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    stringBuffer.append('_');
                }
                stringBuffer.append(Character.toLowerCase(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void addIrregular(String string, String string2) {
        this.addPlural("(.*)(" + string.substring(0, 1) + ")" + string.substring(1) + "$", "\\1\\2" + string2.substring(1));
        this.addSingular("(.*)(" + string2.substring(0, 1) + ")" + string2.substring(1) + "$", "\\1\\2" + string.substring(1));
    }

    public void addPlural(String string, String string2) {
        this.addPlural(string, string2, true);
    }

    public void addPlural(String string, String string2, boolean bl) {
        this.plurals.add(0, new Replacer(string, string2, bl));
    }

    public void addSingular(String string, String string2) {
        this.addSingular(string, string2, true);
    }

    public void addSingular(String string, String string2, boolean bl) {
        this.singulars.add(0, new Replacer(string, string2, bl));
    }

    public void addUncountable(String string) {
        this.uncountables.add(0, string.toLowerCase());
    }

    private class Replacer {
        private String input = null;
        private Matcher matcher = null;
        private Pattern pattern = null;
        private String rule = null;

        public Replacer(String string, String string2, boolean bl) {
            this.pattern = Pattern.compile(string, bl ? 2 : 0);
            this.rule = string2;
        }

        public boolean matches(String string) {
            this.matcher = this.pattern.matcher(string);
            if (this.matcher.matches()) {
                this.input = string;
                return true;
            }
            this.input = null;
            this.matcher = null;
            return false;
        }

        public String replacement() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            for (int i = 0; i < this.rule.length(); ++i) {
                char c = this.rule.charAt(i);
                if (bl) {
                    stringBuffer.append(this.matcher.group(Character.digit(c, 10)));
                    bl = false;
                    continue;
                }
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
    }
}

