/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.websvc.saas.codegen.java.Constants;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.java.support.Inflector;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifact;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifacts;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomSaasBean
extends SaasBean {
    public static final String ARTIFACT_TYPE_TEMPLATE = "template";
    private String url;
    private CustomSaasMethod m;
    private Map<String, String> templates;
    private Map<String, String> libs;
    private boolean canGenerateJaxb;
    private String serviceMethodName;

    public CustomSaasBean(CustomSaasMethod customSaasMethod) throws IOException {
        super(customSaasMethod.getSaas(), CustomSaasBean.deriveResourceName(customSaasMethod), null, CustomSaasBean.deriveUriTemplate(customSaasMethod), new Constants.MimeType[]{Constants.MimeType.XML}, new String[]{"java.lang.String"}, new Constants.HttpMethodType[]{Constants.HttpMethodType.GET});
        this.m = customSaasMethod;
        this.init();
    }

    private void init() throws IOException {
        List list;
        Method.Output output;
        this.setHttpMethod(Constants.HttpMethodType.GET);
        if (this.m.getHref() != null) {
            this.setResourceClassTemplate(this.m.getHref());
        }
        this.findAuthentication((SaasMethod)this.m);
        ArrayList<Constants.MimeType> arrayList = new ArrayList<Constants.MimeType>();
        try {
            output = this.m.getOutput();
            this.findSaasMediaType(arrayList, output.getMedia());
            if (arrayList.size() > 0) {
                this.setMimeTypes(arrayList.toArray(new Constants.MimeType[arrayList.size()]));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        this.templates = new HashMap<String, String>();
        this.libs = new HashMap<String, String>();
        output = this.m.getSaas().getSaasMetadata().getCodeGen();
        if (output != null && (list = output.getArtifacts()) != null) {
            for (Artifacts artifacts : list) {
                List list2 = artifacts.getArtifact();
                if (list2 == null) continue;
                for (Artifact artifact : list2) {
                    String string;
                    if (artifact.getRequires() != null) {
                        // empty if block
                    }
                    if ((string = artifact.getType()) == null) {
                        throw new IOException("saas-metadata/code-gen/artifacts/artifact/@type value is null.");
                    }
                    String string2 = artifact.getId();
                    String string3 = artifact.getUrl();
                    if (string2 == null || string3 == null) {
                        throw new IOException("saas-metadata/code-gen/artifacts/artifact/@id|@url value is null.");
                    }
                    if (string.equals(ARTIFACT_TYPE_TEMPLATE)) {
                        this.templates.put(string2, string3);
                        if (!this.getResourceClassTemplate().equals(artifact.getId())) continue;
                        this.setResourceClassTemplate(string3);
                        continue;
                    }
                    if (!string.equals(ARTIFACT_TYPE_TEMPLATE)) continue;
                    this.libs.put(string2, string3);
                }
            }
        }
    }

    public String getSaasServiceMethodName() {
        if (this.serviceMethodName == null) {
            this.serviceMethodName = Util.deriveMethodName(this.getMethod().getName());
            this.serviceMethodName = this.serviceMethodName.substring(0, 1).toLowerCase() + this.serviceMethodName.substring(1);
        }
        return this.serviceMethodName;
    }

    public CustomSaasMethod getMethod() {
        return this.m;
    }

    @Override
    protected List<ParameterInfo> initInputParameters() {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        Method.Input input = this.m.getInput();
        if (input != null && input.getParams() != null && input.getParams().getParam() != null) {
            List list = input.getParams().getParam();
            this.findSaasParams(arrayList, list);
            for (ParameterInfo parameterInfo : arrayList) {
                parameterInfo.setStyle(ParameterInfo.ParamStyle.QUERY);
            }
        }
        return arrayList;
    }

    public String getUrl() {
        return this.url;
    }

    protected static String deriveResourceName(CustomSaasMethod customSaasMethod) {
        String string = customSaasMethod.getName();
        if (customSaasMethod.getHref() != null && !customSaasMethod.getHref().trim().equals("")) {
            string = customSaasMethod.getHref();
        }
        return Inflector.getInstance().camelize(string + "Resource");
    }

    protected static String deriveUriTemplate(CustomSaasMethod customSaasMethod) {
        String string = customSaasMethod.getName();
        if (customSaasMethod.getHref() != null && !customSaasMethod.getHref().trim().equals("")) {
            string = customSaasMethod.getHref();
        }
        return Inflector.getInstance().camelize(string, true) + "/";
    }

    public Map<String, String> getArtifactLibs() {
        return this.libs;
    }

    public void setArtifactLibs(Map<String, String> map) {
        this.libs = map;
    }

    public Map<String, String> getArtifactTemplates() {
        return this.templates;
    }

    public void setArtifactTemplates(Map<String, String> map) {
        this.templates = map;
    }

    public boolean canGenerateJAXBUnmarshaller() {
        return this.canGenerateJaxb;
    }

    public void setCanGenerateJAXBUnmarshaller(boolean bl) {
        this.canGenerateJaxb = bl;
    }
}

