/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.saas.codegen.java.Constants;
import org.netbeans.modules.websvc.saas.codegen.java.JaxRsCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.JaxRsJavaClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.JaxRsJspCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.JaxRsServletCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JaxRsCodeGeneratorFactory {
    public static JaxRsCodeGenerator create(JTextComponent jTextComponent, FileObject fileObject, WadlSaasMethod wadlSaasMethod) throws IOException {
        JaxRsJavaClientCodeGenerator jaxRsJavaClientCodeGenerator = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (Util.isRestJavaFile(dataObject) || Util.isServlet(dataObject)) {
                jaxRsJavaClientCodeGenerator = new JaxRsServletCodeGenerator(jTextComponent, fileObject, wadlSaasMethod);
                if (Util.isServlet(dataObject)) {
                    jaxRsJavaClientCodeGenerator.setDropFileType(Constants.DropFileType.SERVLET);
                } else {
                    jaxRsJavaClientCodeGenerator.setDropFileType(Constants.DropFileType.RESOURCE);
                }
            } else if (Util.isJsp(dataObject)) {
                jaxRsJavaClientCodeGenerator = new JaxRsJspCodeGenerator(jTextComponent, fileObject, wadlSaasMethod);
                jaxRsJavaClientCodeGenerator.setDropFileType(Constants.DropFileType.JSP);
            } else {
                jaxRsJavaClientCodeGenerator = new JaxRsJavaClientCodeGenerator(jTextComponent, fileObject, wadlSaasMethod);
                jaxRsJavaClientCodeGenerator.setDropFileType(Constants.DropFileType.JAVA_CLIENT);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new IOException(dataObjectNotFoundException.getMessage());
        }
        return jaxRsJavaClientCodeGenerator;
    }
}

