/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Access {
    PUBLIC,
    PROTECTED,
    PACKAGE,
    PRIVATE;


    public static Access resolve(String string) {
        if (string != null) {
            if ("public".equals(string = string.trim().toLowerCase())) {
                return PUBLIC;
            }
            if ("protected".equals(string)) {
                return PROTECTED;
            }
            if ("private".equals(string)) {
                return PRIVATE;
            }
            if ("package".equals(string)) {
                return PACKAGE;
            }
        }
        return PROTECTED;
    }

    public boolean isAccessible(Set<Modifier> set) {
        switch (this) {
            case PRIVATE: {
                return true;
            }
            case PACKAGE: {
                return !set.contains((Object)Modifier.PRIVATE);
            }
            case PROTECTED: {
                return set.contains((Object)Modifier.PUBLIC) || set.contains((Object)Modifier.PROTECTED);
            }
            case PUBLIC: {
                return set.contains((Object)Modifier.PUBLIC);
            }
        }
        throw new IllegalStateException();
    }

    public boolean isAccessible(CompilationInfo compilationInfo, TreePath treePath, boolean bl) {
        Object object;
        TreePath treePath2 = treePath.getParentPath();
        Tree tree = treePath.getLeaf();
        if (treePath2 != null) {
            object = treePath2.getLeaf().getKind();
            if (object != Tree.Kind.CLASS && object != Tree.Kind.COMPILATION_UNIT) {
                return false;
            }
            if (!this.isAccessible(compilationInfo, treePath2, bl)) {
                return false;
            }
        }
        switch (tree.getKind()) {
            case COMPILATION_UNIT: {
                return true;
            }
            case CLASS: {
                object = ((ClassTree)tree).getModifiers().getFlags();
                break;
            }
            case METHOD: {
                object = ((MethodTree)tree).getModifiers().getFlags();
                break;
            }
            case VARIABLE: {
                object = ((VariableTree)tree).getModifiers().getFlags();
                break;
            }
            default: {
                return false;
            }
        }
        return bl || this.isInterfaceMember(compilationInfo, treePath) || this.isAccessible((Set<Modifier>)object);
    }

    private boolean isInterfaceMember(CompilationInfo compilationInfo, TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return false;
        }
        Tree tree = treePath2.getLeaf();
        TreeUtilities treeUtilities = compilationInfo.getTreeUtilities();
        return Tree.Kind.CLASS == tree.getKind() && (treeUtilities.isInterface((ClassTree)tree) || treeUtilities.isAnnotation((ClassTree)tree));
    }
}

