/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.BCoord;

public class Coord
implements Comparable {
    public int row;
    public int col;

    public Coord() {
        this.row = 0;
        this.col = 0;
    }

    private Coord(int n, int n2) {
        this.row = n;
        this.col = n2;
    }

    public static Coord make(int n, int n2) {
        return new Coord(n, n2);
    }

    public Coord(Coord coord) {
        this.row = coord.row;
        this.col = coord.col;
    }

    Coord(BCoord bCoord, int n) {
        this.row = bCoord.row + n;
        this.col = bCoord.col;
    }

    BCoord toBCoord(int n) {
        int n2 = this.row - n;
        if (n2 < 0) {
            return new BCoord(0, 0);
        }
        return new BCoord(n2, this.col);
    }

    public void copyFrom(Coord coord) {
        this.row = coord.row;
        this.col = coord.col;
    }

    public Object clone() {
        return new Coord(this.row, this.col);
    }

    public boolean equals(Coord coord) {
        if (this.row != coord.row) {
            return false;
        }
        return this.col == coord.col;
    }

    public String toString() {
        return "(r=" + this.row + ",c=" + this.col + ")";
    }

    public int compareTo(Object object) throws ClassCastException {
        Coord coord = (Coord)object;
        if (this.row < coord.row) {
            return -1;
        }
        if (this.row > coord.row) {
            return 1;
        }
        return this.col - coord.col;
    }

    void clip(int n, int n2, int n3) {
        if (this.row < n3) {
            this.row = n3;
        } else if (this.row > n3 + n) {
            this.row = n3 + n;
        }
        if (this.col < 0) {
            this.col = 0;
        } else if (this.col > n2) {
            this.col = n2;
        }
    }
}

