/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalogsupport.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.catalogsupport.util.ProjectVisitor;
import org.netbeans.modules.xml.catalogsupport.util.ProjectWSDL;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtilities {
    public static final String XSD = "xsd";
    public static final String WSDL = "wsdl";
    public static final String SRC_FOLDER = "src";
    public static final String SLASHED_SRC = "/src/";

    private ProjectUtilities() {
    }

    public static List<FileObject> getXSDFilesRecursively(Project project) {
        return ProjectUtilities.getFilesRecursively(project, XSD);
    }

    public static List<FileObject> getWSDLFilesRecursively(Project project) {
        return ProjectUtilities.getFilesRecursively(project, WSDL);
    }

    private static List<FileObject> getFilesRecursively(Project project, final String string) {
        final ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        ProjectUtilities.visitRecursively(project, new ProjectVisitor(){

            public void visit(Project project) {
                SourceGroup[] sourceGroupArray;
                Sources sources = ProjectUtils.getSources((Project)project);
                for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("xml")) {
                    Enumeration enumeration = sourceGroup.getRootFolder().getChildren(true);
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject = (FileObject)enumeration.nextElement();
                        if (!fileObject.getExt().toLowerCase().equals(string)) continue;
                        arrayList.add(fileObject);
                    }
                }
            }
        });
        return arrayList;
    }

    public static List<ProjectWSDL> getProjectWSDLRecursively(Project project) {
        final ArrayList<ProjectWSDL> arrayList = new ArrayList<ProjectWSDL>();
        ProjectUtilities.visitRecursively(project, new ProjectVisitor(){

            public void visit(Project project) {
                SourceGroup[] sourceGroupArray;
                Sources sources = ProjectUtils.getSources((Project)project);
                for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("xml")) {
                    Enumeration enumeration = sourceGroup.getRootFolder().getChildren(true);
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject = (FileObject)enumeration.nextElement();
                        if (!fileObject.getExt().toLowerCase().equals(ProjectUtilities.WSDL)) continue;
                        arrayList.add(new ProjectWSDL(fileObject, project));
                    }
                }
            }
        });
        return arrayList;
    }

    public static Set getReferencedProjects(Project project) {
        HashSet<Project> hashSet = new HashSet<Project>();
        ProjectUtilities.populateReferencedProjects(project, hashSet);
        return hashSet;
    }

    private static void populateReferencedProjects(Project project, Set<Project> set) {
        DefaultProjectCatalogSupport defaultProjectCatalogSupport = DefaultProjectCatalogSupport.getInstance(project.getProjectDirectory());
        if (defaultProjectCatalogSupport != null) {
            Set set2 = defaultProjectCatalogSupport.getProjectReferences();
            for (Object e : set2) {
                assert (e instanceof Project);
                set.add((Project)e);
                ProjectUtilities.populateReferencedProjects((Project)e, set);
            }
        }
    }

    public static List<FileObject> getDirectSources(Project project, String string) {
        SourceGroup[] sourceGroupArray;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("xml")) {
            Enumeration enumeration = sourceGroup.getRootFolder().getChildren(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject = (FileObject)enumeration.nextElement();
                if (fileObject.isFolder()) {
                    arrayList.add(fileObject);
                    continue;
                }
                if (string == null) {
                    arrayList.add(fileObject);
                    continue;
                }
                if (!fileObject.getExt().toLowerCase().equals(string)) continue;
                arrayList.add(fileObject);
            }
        }
        return arrayList;
    }

    private static void visitRecursively(Project project, ProjectVisitor projectVisitor) {
        ProjectUtilities.visitRecursively(project, projectVisitor, new ArrayList<Project>());
    }

    private static void visitRecursively(Project project, ProjectVisitor projectVisitor, List<Project> list) {
        if (project == null) {
            return;
        }
        if (list.contains(project)) {
            return;
        }
        list.add(project);
        projectVisitor.visit(project);
        DefaultProjectCatalogSupport defaultProjectCatalogSupport = DefaultProjectCatalogSupport.getInstance(project.getProjectDirectory());
        if (defaultProjectCatalogSupport == null) {
            return;
        }
        for (Project project2 : defaultProjectCatalogSupport.getProjectReferences()) {
            ProjectUtilities.visitRecursively(project2, projectVisitor, list);
        }
    }

    public static FileObject getSrcFolder(Project project) {
        return project.getProjectDirectory().getFileObject(SRC_FOLDER);
    }
}

