/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.web.ui.dt.component.customizers;

import com.sun.rave.web.ui.model.Option;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.faces.model.SelectItem;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class OptionsListPanel
extends JPanel {
    static ResourceBundle bundle = ResourceBundle.getBundle(OptionsListPanel.class.getPackage().getName() + ".Bundle-DT");
    private ItemsTableModel tableModel = new ItemsTableModel();
    private boolean acceptsMultipleChoice;
    private JPanel buttonsPanel;
    private JPanel checkBoxesPanel;
    private JScrollPane dataPane;
    private JTable dataTable;
    private JButton deleteButton;
    private JButton downButton;
    private JCheckBox multipleChoiceCheckBox;
    private JButton newButton;
    private JCheckBox selectValuesCheckBox;
    private JButton upButton;

    public OptionsListPanel() {
        this(false);
    }

    public OptionsListPanel(boolean bl) {
        this.acceptsMultipleChoice = bl;
        this.initComponents();
        SelectedCellEditor selectedCellEditor = new SelectedCellEditor(this.selectValuesCheckBox, this.multipleChoiceCheckBox);
        this.dataTable.setDefaultEditor(Boolean.class, selectedCellEditor);
    }

    private void initComponents() {
        this.dataPane = new JScrollPane();
        this.dataTable = new JTable(this.tableModel);
        this.dataTable.setSelectionMode(0);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        defaultTableCellRenderer.setBackground(new Color(212, 208, 200));
        this.dataTable.getTableHeader().setDefaultRenderer(defaultTableCellRenderer);
        JTextField jTextField = new JTextField();
        CellEditor cellEditor = new CellEditor(this.dataTable, jTextField);
        this.dataTable.setDefaultEditor(String.class, cellEditor);
        this.dataTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ((DefaultCellEditor)this.dataTable.getDefaultEditor(String.class)).setClickCountToStart(1);
        this.dataTable.setDefaultRenderer(String.class, new HomogonousCellRenderer());
        SelectedCellRenderer selectedCellRenderer = new SelectedCellRenderer();
        this.dataTable.setDefaultRenderer(Boolean.class, selectedCellRenderer);
        this.buttonsPanel = new JPanel();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.checkBoxesPanel = new JPanel();
        this.selectValuesCheckBox = new JCheckBox();
        this.multipleChoiceCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.dataPane.setEnabled(false);
        this.dataTable.setAutoResizeMode(4);
        this.dataPane.setViewportView(this.dataTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.add((Component)this.dataPane, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridLayout(4, 1, 0, 5));
        this.newButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("NEW_BUTTON_MNEMONIC").charAt(0));
        this.newButton.setText(bundle.getString("OptionsListPanel.button.new"));
        this.newButton.setLabel(bundle.getString("OptionsListPanel.button.new"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsListPanel.this.newActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.newButton);
        this.newButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.button.new"));
        this.newButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.button.new"));
        this.deleteButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("DELETE_BUTTON_MNEMONIC").charAt(0));
        this.deleteButton.setText(bundle.getString("OptionsListPanel.button.delete"));
        this.deleteButton.setLabel(bundle.getString("OptionsListPanel.button.delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsListPanel.this.deleteActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.deleteButton);
        this.deleteButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.button.delete"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.button.delete"));
        this.upButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("UP_BUTTON_MNEMONIC").charAt(0));
        this.upButton.setText(bundle.getString("OptionsListPanel.button.up"));
        this.upButton.setLabel(bundle.getString("OptionsListPanel.button.up"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsListPanel.this.upActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.upButton);
        this.upButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.button.up"));
        this.upButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.button.up"));
        this.downButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("DOWN_BUTTON_MNEMONIC").charAt(0));
        this.downButton.setText(bundle.getString("OptionsListPanel.button.down"));
        this.downButton.setLabel(bundle.getString("OptionsListPanel.button.down"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsListPanel.this.downActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.downButton);
        this.downButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.button.down"));
        this.downButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.button.down"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 6, 0, 10);
        this.add((Component)this.buttonsPanel, gridBagConstraints);
        this.checkBoxesPanel.setLayout(new FlowLayout(0, 6, 0));
        this.selectValuesCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("SELECT_VALUES_CHECKBOX_MNEMONIC").charAt(0));
        this.selectValuesCheckBox.setLabel(bundle.getString("OptionsListPanel.checkbox.select.label"));
        this.selectValuesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsListPanel.this.selectValuesCheckBoxStateChanged(itemEvent);
            }
        });
        this.selectValuesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsListPanel.this.selectValuesCheckBoxActionPerformed(actionEvent);
            }
        });
        this.checkBoxesPanel.add(this.selectValuesCheckBox);
        this.selectValuesCheckBox.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.checkbox.select.label"));
        this.selectValuesCheckBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.checkbox.select.label"));
        this.multipleChoiceCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("MULTIPLE_CHOICE_CHECKBOX_MNEMONIC").charAt(0));
        this.multipleChoiceCheckBox.setEnabled(this.acceptsMultipleChoice && this.selectValuesCheckBox.isSelected());
        this.multipleChoiceCheckBox.setLabel(bundle.getString("OptionsListPanel.checkbox.multiple.label"));
        this.multipleChoiceCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsListPanel.this.multipleChoiceCheckBoxStateChanged(itemEvent);
            }
        });
        this.checkBoxesPanel.add(this.multipleChoiceCheckBox);
        this.multipleChoiceCheckBox.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.checkbox.multiple.label"));
        this.multipleChoiceCheckBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/web/ui/dt/component/customizers/Bundle-DT").getString("OptionsListPanel.checkbox.multiple.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.checkBoxesPanel, gridBagConstraints);
    }

    private void selectValuesCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void multipleChoiceCheckBoxStateChanged(ItemEvent itemEvent) {
        ItemsTableModel itemsTableModel = (ItemsTableModel)this.dataTable.getModel();
        if (itemEvent.getStateChange() == 1) {
            itemsTableModel.setMultipleSelect(true);
            ((SelectedCellRenderer)this.dataTable.getDefaultRenderer(Boolean.class)).setMultipleChoice(true);
        } else {
            itemsTableModel.setMultipleSelect(false);
            ((SelectedCellRenderer)this.dataTable.getDefaultRenderer(Boolean.class)).setMultipleChoice(false);
        }
        SelectItem[] selectItemArray = itemsTableModel.getItems();
        for (int i = 0; i < selectItemArray.length; ++i) {
            itemsTableModel.fireTableCellUpdated(i, 2);
        }
    }

    private void selectValuesCheckBoxStateChanged(ItemEvent itemEvent) {
        ItemsTableModel itemsTableModel = (ItemsTableModel)this.dataTable.getModel();
        int n = this.dataTable.getSelectedRow();
        if (itemEvent.getStateChange() == 1) {
            itemsTableModel.setItemsSelectable(true);
            this.adjustColumnWidth(this.dataTable, 2);
            this.dataTable.revalidate();
            if (this.acceptsMultipleChoice) {
                this.multipleChoiceCheckBox.setEnabled(true);
            }
        } else {
            this.multipleChoiceCheckBox.setEnabled(false);
            itemsTableModel.setItemsSelectable(false);
        }
        this.dataTable.changeSelection(n, 0, false, false);
    }

    private void downActionPerformed(ActionEvent actionEvent) {
        ItemsTableModel itemsTableModel = (ItemsTableModel)this.dataTable.getModel();
        if (this.dataTable.getSelectedRowCount() > 0) {
            int[] nArray = this.dataTable.getSelectedRows();
            itemsTableModel.moveRowDown(nArray[0]);
            this.dataTable.setModel(itemsTableModel);
            this.dataTable.changeSelection(nArray[0] + 1, 0, false, false);
        }
    }

    private void upActionPerformed(ActionEvent actionEvent) {
        ItemsTableModel itemsTableModel = (ItemsTableModel)this.dataTable.getModel();
        if (this.dataTable.getSelectedRowCount() > 0) {
            int[] nArray = this.dataTable.getSelectedRows();
            itemsTableModel.moveRowUp(nArray[0]);
            this.dataTable.setModel(itemsTableModel);
            this.dataTable.changeSelection(nArray[0] - 1, 0, false, false);
        }
    }

    private void deleteActionPerformed(ActionEvent actionEvent) {
        ItemsTableModel itemsTableModel = (ItemsTableModel)this.dataTable.getModel();
        int n = itemsTableModel.getRowCount();
        if (this.dataTable.getSelectedRowCount() > 0) {
            boolean bl;
            int[] nArray = this.dataTable.getSelectedRows();
            boolean bl2 = bl = nArray[0] == n - 1;
            if (itemsTableModel.canRemoveRow(nArray[0])) {
                itemsTableModel.removeRow(nArray[0]);
                this.dataTable.setModel(itemsTableModel);
                this.dataTable.changeSelection(nArray[0], 0, false, false);
            }
            if (itemsTableModel.getRowCount() == 0) {
                return;
            }
            if (bl) {
                this.dataTable.changeSelection(itemsTableModel.getRowCount() - 1, 0, false, false);
            } else {
                this.dataTable.changeSelection(nArray[0], 0, false, false);
            }
        }
    }

    private void newActionPerformed(ActionEvent actionEvent) {
        ItemsTableModel itemsTableModel = (ItemsTableModel)this.dataTable.getModel();
        if (itemsTableModel.canAddRow()) {
            itemsTableModel.addRow();
            this.dataTable.setModel(itemsTableModel);
            this.dataTable.changeSelection(itemsTableModel.getRowCount() - 1, 0, false, false);
            this.dataTable.requestFocusInWindow();
        }
    }

    public void setItems(SelectItem[] selectItemArray) {
        this.tableModel.setItems(selectItemArray);
    }

    public SelectItem[] getItems() {
        return this.tableModel.getItems();
    }

    public void setOptions(Option[] optionArray) {
        this.setItems((SelectItem[])optionArray);
        if (optionArray.length > 0) {
            this.dataTable.changeSelection(0, 0, false, false);
        }
    }

    public Option[] getOptions() {
        SelectItem[] selectItemArray = this.getItems();
        Option[] optionArray = new Option[selectItemArray.length];
        for (int i = 0; i < selectItemArray.length; ++i) {
            optionArray[i] = new Option(selectItemArray[i].getValue(), selectItemArray[i].getLabel());
        }
        return optionArray;
    }

    public boolean isMultipleChoice() {
        return this.multipleChoiceCheckBox.getSelectedObjects() != null;
    }

    public void setMultipleChoice(boolean bl) {
        this.multipleChoiceCheckBox.setSelected(bl);
    }

    public boolean isValueSelecting() {
        return this.selectValuesCheckBox.isSelected();
    }

    public void setValueSelecting(boolean bl) {
        this.selectValuesCheckBox.setSelected(bl);
    }

    public Object getSelectedValues() {
        Object[] objectArray = this.tableModel.getSelectedValues();
        if (objectArray.length == 0) {
            return null;
        }
        return this.isMultipleChoice() ? objectArray : objectArray[0];
    }

    public void setSelectedValues(Object object) {
        if (object == null) {
            this.tableModel.setSelectedValues(new Object[0]);
        } else if (this.isMultipleChoice() && object instanceof Object[]) {
            this.tableModel.setSelectedValues((Object[])object);
        } else {
            this.tableModel.setSelectedValues(new Object[]{object});
        }
    }

    private void adjustColumnWidth(JTable jTable, int n) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, n);
        int n2 = component.getPreferredSize().width;
        tableColumn.setPreferredWidth(n2);
    }

    class SelectedCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JRadioButton radioBtn;
        JCheckBox checkbox;
        JCheckBox selectValuesCheckBox;
        JCheckBox multipleChoiceCheckBox;

        public SelectedCellEditor(JCheckBox jCheckBox, JCheckBox jCheckBox2) {
            this.selectValuesCheckBox = jCheckBox;
            this.multipleChoiceCheckBox = jCheckBox2;
            this.radioBtn = new JRadioButton();
            this.checkbox = new JCheckBox();
            this.radioBtn.setHorizontalAlignment(0);
            this.checkbox.setHorizontalAlignment(0);
            this.radioBtn.addActionListener(this);
            this.checkbox.addActionListener(this);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (this.selectValuesCheckBox.isSelected() && this.multipleChoiceCheckBox.isSelected()) {
                this.checkbox.setSelected((Boolean)object);
                return this.checkbox;
            }
            this.radioBtn.setSelected((Boolean)object);
            return this.radioBtn;
        }

        public Object getCellEditorValue() {
            if (this.selectValuesCheckBox.isSelected() && this.multipleChoiceCheckBox.isSelected()) {
                return new Boolean(this.checkbox.isSelected());
            }
            return new Boolean(this.radioBtn.isSelected());
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                int n = 1;
                return ((MouseEvent)eventObject).getClickCount() >= n;
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fireEditingStopped();
        }
    }

    class CellEditor
    extends DefaultCellEditor {
        private JTable table;

        public CellEditor(JTable jTable, JTextField jTextField) {
            super(jTextField);
            this.table = jTable;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ((JTextField)super.getComponent()).setText((String)object);
            if (bl) {
                ((JTextField)super.getComponent()).selectAll();
                jTable.repaint();
            }
            return super.getComponent();
        }
    }

    class HomogonousCellRenderer
    extends DefaultTableCellRenderer {
        Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("TextField.selectionBackground");

        HomogonousCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl) {
                component.setBackground(this.SELECTION_BACKGROUND);
            } else {
                component.setBackground(Color.WHITE);
            }
            return component;
        }
    }

    class SelectedCellRenderer
    extends DefaultTableCellRenderer {
        Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("TextField.selectionBackground");
        JCheckBox checkBox = new JCheckBox();
        JRadioButton radioButton;
        JToggleButton currentComponent;

        SelectedCellRenderer() {
            this.checkBox.setHorizontalAlignment(0);
            this.checkBox.setBackground(Color.WHITE);
            this.radioButton = new JRadioButton();
            this.radioButton.setHorizontalAlignment(0);
            this.radioButton.setBackground(Color.WHITE);
            this.currentComponent = this.radioButton;
        }

        public void setMultipleChoice(boolean bl) {
            this.currentComponent = bl ? this.checkBox : this.radioButton;
        }

        public boolean isMultipleChoice() {
            return this.currentComponent == this.checkBox;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.currentComponent.setBackground(this.SELECTION_BACKGROUND);
            } else {
                this.currentComponent.setBackground(Color.WHITE);
            }
            if (Boolean.TRUE.equals(object)) {
                this.currentComponent.setSelected(true);
            } else {
                this.currentComponent.setSelected(false);
            }
            return this.currentComponent;
        }
    }

    static class ItemRowModel {
        private String label;
        private Object value;
        private boolean selected;

        ItemRowModel(String string, Object object) {
            this.setLabel(string);
            this.setValue(object);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }
    }

    static class ItemsTableModel
    extends AbstractTableModel {
        static final int DISPLAY_COLUMN = 0;
        static final int VALUE_COLUMN = 1;
        static final int SELECT_COLUMN = 2;
        int columnCount = 2;
        boolean multipleSelect;
        ArrayList rows = new ArrayList();

        ItemsTableModel() {
        }

        public SelectItem[] getItems() {
            SelectItem[] selectItemArray = new SelectItem[this.rows.size()];
            for (int i = 0; i < this.rows.size(); ++i) {
                selectItemArray[i] = new SelectItem();
                selectItemArray[i].setLabel(((ItemRowModel)this.rows.get(i)).getLabel());
                selectItemArray[i].setValue(((ItemRowModel)this.rows.get(i)).getValue());
            }
            return selectItemArray;
        }

        public void setItems(SelectItem[] selectItemArray) {
            this.rows.clear();
            if (selectItemArray != null) {
                for (int i = 0; i < selectItemArray.length; ++i) {
                    this.rows.add(new ItemRowModel(selectItemArray[i].getLabel(), selectItemArray[i].getValue()));
                }
            }
            this.fireTableDataChanged();
        }

        public void setItemsSelectable(boolean bl) {
            int n;
            int n2 = n = bl ? 3 : 2;
            if (n != this.columnCount) {
                this.columnCount = n;
                this.fireTableStructureChanged();
            }
        }

        public boolean isItemsSelectable() {
            return this.columnCount == 3;
        }

        public void setMultipleSelect(boolean bl) {
            if (!bl && this.multipleSelect) {
                int n = -1;
                for (int i = this.rows.size() - 1; i >= 0; --i) {
                    if (!((ItemRowModel)this.rows.get(i)).isSelected()) continue;
                    ((ItemRowModel)this.rows.get(i)).setSelected(false);
                    this.fireTableCellUpdated(i, 2);
                    n = i;
                }
                if (n >= 0) {
                    ((ItemRowModel)this.rows.get(n)).setSelected(true);
                    this.fireTableCellUpdated(n, 2);
                }
            }
            this.multipleSelect = bl;
        }

        public void setSelectedValues(Object[] objectArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
            for (int i = 0; i < this.rows.size(); ++i) {
                if (arrayList.contains(((ItemRowModel)this.rows.get(i)).getValue())) {
                    ((ItemRowModel)this.rows.get(i)).setSelected(true);
                    continue;
                }
                ((ItemRowModel)this.rows.get(i)).setSelected(false);
            }
        }

        public Object[] getSelectedValues() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < this.rows.size(); ++i) {
                if (!((ItemRowModel)this.rows.get(i)).isSelected()) continue;
                arrayList.add(((ItemRowModel)this.rows.get(i)).getValue());
            }
            return arrayList.toArray(new Object[arrayList.size()]);
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            if (n == 2) {
                return Boolean.class;
            }
            if (this.rows.size() > 0) {
                return ((ItemRowModel)this.rows.get(0)).getValue().getClass();
            }
            return String.class;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return bundle.getString("OptionsListPanel.table.column.display");
            }
            if (n == 1) {
                return bundle.getString("OptionsListPanel.table.column.value");
            }
            if (n == 2) {
                return bundle.getString("OptionsListPanel.table.column.selected");
            }
            return null;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public boolean canRemoveRow(int n) {
            return n >= 0 && n < this.rows.size();
        }

        public boolean removeRow(int n) {
            if (this.canRemoveRow(n)) {
                this.rows.remove(n);
                this.fireTableRowsDeleted(n, n);
                return true;
            }
            return false;
        }

        public boolean removeAllRows() {
            if (this.rows.isEmpty()) {
                return true;
            }
            int n = this.rows.size();
            this.rows.clear();
            this.fireTableRowsDeleted(0, n);
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                ((ItemRowModel)this.rows.get(n)).setLabel((String)object);
            } else if (n2 == 1) {
                ((ItemRowModel)this.rows.get(n)).setValue(object);
            } else if (n2 == 2) {
                if (!this.multipleSelect && Boolean.TRUE.equals(object)) {
                    for (int i = 0; i < this.rows.size(); ++i) {
                        if (!((ItemRowModel)this.rows.get(i)).isSelected()) continue;
                        ((ItemRowModel)this.rows.get(i)).setSelected(false);
                        this.fireTableCellUpdated(i, n2);
                    }
                }
                ((ItemRowModel)this.rows.get(n)).setSelected(Boolean.TRUE.equals(object));
            }
            this.fireTableCellUpdated(n, n2);
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((ItemRowModel)this.rows.get(n)).getLabel();
            }
            if (n2 == 1) {
                return ((ItemRowModel)this.rows.get(n)).getValue();
            }
            if (n2 == 2) {
                return ((ItemRowModel)this.rows.get(n)).isSelected() ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }

        public boolean canAddRow() {
            return true;
        }

        public void addRow() {
            this.rows.add(new ItemRowModel(bundle.getString("OptionsListPanel.default.display"), bundle.getString("OptionsListPanel.default.value")));
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        }

        public boolean canMoveRowUp(int n) {
            return n > 0;
        }

        public boolean canMoveRowDown(int n) {
            return n < this.rows.size() - 1;
        }

        public void moveRowUp(int n) {
            if (this.canMoveRowUp(n)) {
                Object e = this.rows.remove(n);
                this.rows.add(n - 1, e);
                this.fireTableDataChanged();
            }
        }

        public void moveRowDown(int n) {
            if (this.canMoveRowDown(n)) {
                Object e = this.rows.remove(n);
                this.rows.add(n + 1, e);
                this.fireTableDataChanged();
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

