/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class UserProjectSettings {
    private static final UserProjectSettings INSTANCE = new UserProjectSettings();
    private static final String NEW_PROJECT_COUNT = "newProjectCount";
    private static final String NEW_APP_COUNT = "newApplicationCount";
    private static final String LAST_USED_CP_FOLDER = "lastUsedClassPathFolder";
    private static final String LAST_USED_ARTIFACT_FOLDER = "lastUsedArtifactFolder";
    private static final String SHOW_AGAIN_BROKEN_REF_ALERT = "showAgainBrokenRefAlert";
    private static final String SHOW_AGAIN_BROKEN_SERVER_ALERT = "showAgainBrokenServerAlert";
    public static final String LAST_USED_CHOOSER_LOCATIONS = "lastUsedChooserLocations";
    private static final String AGREED_SET_JDK_14 = "agreeSetJdk14";
    private static final String AGREED_SET_SOURCE_LEVEL_14 = "agreeSetSourceLevel14";
    private static final String AGREED_SET_JDK_15 = "agreeSetJdk15";
    private static final String AGREED_SET_SOURCE_LEVEL_15 = "agreeSetSourceLevel15";
    private static final String LAST_USED_SERVER = "lastUsedServer";
    private static final String LAST_USED_IMPORT_LOCATION = "lastUsedImportLocation";

    public static UserProjectSettings getDefault() {
        return INSTANCE;
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(UserProjectSettings.class);
    }

    public String displayName() {
        return NbBundle.getMessage(UserProjectSettings.class, (String)"TXT_ProjectFolderList");
    }

    public int getNewProjectCount() {
        return UserProjectSettings.getPreferences().getInt(NEW_PROJECT_COUNT, 0);
    }

    public void setNewProjectCount(int n) {
        UserProjectSettings.getPreferences().putInt(NEW_PROJECT_COUNT, n);
    }

    public int getNewApplicationCount() {
        return UserProjectSettings.getPreferences().getInt(NEW_APP_COUNT, 0);
    }

    public void setNewApplicationCount(int n) {
        UserProjectSettings.getPreferences().putInt(NEW_APP_COUNT, n);
    }

    public File getLastUsedClassPathFolder() {
        return new File(UserProjectSettings.getPreferences().get(LAST_USED_CP_FOLDER, System.getProperty("user.home")));
    }

    public void setLastUsedClassPathFolder(File file) {
        assert (file != null) : "ClassPath root can not be null";
        String string = file.getAbsolutePath();
        UserProjectSettings.getPreferences().put(LAST_USED_CP_FOLDER, string);
    }

    public File getLastUsedArtifactFolder(File file) {
        String string = UserProjectSettings.getPreferences().get(LAST_USED_ARTIFACT_FOLDER, null);
        if (string != null) {
            return FileUtil.normalizeFile((File)new File(string));
        }
        if (file != null) {
            return file;
        }
        return FileUtil.normalizeFile((File)new File(System.getProperty("user.home")));
    }

    public void setLastUsedArtifactFolder(File file) {
        assert (file != null) : "Folder can not be null";
        String string = file.getAbsolutePath();
        UserProjectSettings.getPreferences().put(LAST_USED_ARTIFACT_FOLDER, string);
    }

    public boolean isShowAgainBrokenRefAlert() {
        return UserProjectSettings.getPreferences().getBoolean(SHOW_AGAIN_BROKEN_REF_ALERT, true);
    }

    public void setShowAgainBrokenRefAlert(boolean bl) {
        UserProjectSettings.getPreferences().putBoolean(SHOW_AGAIN_BROKEN_REF_ALERT, bl);
    }

    public boolean isShowAgainBrokenServerAlert() {
        return UserProjectSettings.getPreferences().getBoolean(SHOW_AGAIN_BROKEN_SERVER_ALERT, true);
    }

    public void setShowAgainBrokenServerAlert(boolean bl) {
        UserProjectSettings.getPreferences().putBoolean(SHOW_AGAIN_BROKEN_SERVER_ALERT, bl);
    }

    public boolean isAgreedSetJdk14() {
        return UserProjectSettings.getPreferences().getBoolean(AGREED_SET_JDK_14, true);
    }

    public void setAgreedSetJdk14(boolean bl) {
        UserProjectSettings.getPreferences().putBoolean(AGREED_SET_JDK_14, bl);
    }

    public boolean isAgreedSetSourceLevel14() {
        return UserProjectSettings.getPreferences().getBoolean(AGREED_SET_SOURCE_LEVEL_14, true);
    }

    public void setAgreedSetSourceLevel14(boolean bl) {
        UserProjectSettings.getPreferences().putBoolean(AGREED_SET_SOURCE_LEVEL_14, bl);
    }

    public boolean isAgreedSetJdk15() {
        return UserProjectSettings.getPreferences().getBoolean(AGREED_SET_JDK_15, true);
    }

    public void setAgreedSetJdk15(boolean bl) {
        UserProjectSettings.getPreferences().putBoolean(AGREED_SET_JDK_15, bl);
    }

    public boolean isAgreedSetSourceLevel15() {
        return UserProjectSettings.getPreferences().getBoolean(AGREED_SET_SOURCE_LEVEL_15, true);
    }

    public void setAgreedSetSourceLevel15(boolean bl) {
        UserProjectSettings.getPreferences().putBoolean(AGREED_SET_SOURCE_LEVEL_15, bl);
    }

    public void setLastUsedServer(String string) {
        UserProjectSettings.getPreferences().put(LAST_USED_SERVER, string);
    }

    public String getLastUsedServer() {
        return UserProjectSettings.getPreferences().get(LAST_USED_SERVER, null);
    }

    public void setLastUsedImportLocation(File file) {
        String string = file.getAbsolutePath();
        UserProjectSettings.getPreferences().put(LAST_USED_IMPORT_LOCATION, string);
    }

    public File getLastUsedImportLocation() {
        String string = UserProjectSettings.getPreferences().get(LAST_USED_IMPORT_LOCATION, null);
        if (string == null) {
            return null;
        }
        return new File(string);
    }
}

