/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.j2ee.common.project.ui.FileChooser;
import org.netbeans.modules.j2ee.common.project.ui.ProjectImportLocationWizardPanel;
import org.netbeans.modules.j2ee.common.project.ui.ProjectLocationPanel;
import org.netbeans.modules.j2ee.common.project.ui.UserProjectSettings;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ProjectImportLocationPanel
extends JPanel
implements HelpCtx.Provider {
    private final ProjectImportLocationWizardPanel wizard;
    private WizardDescriptor wizardDescriptor;
    private String currentLibrariesLocation;
    private String nameFormatter;
    private String lastModuleLocation = null;
    private Object j2eeModuleType;
    private boolean allowAlternativeBuildXml;
    private JButton browseLibraries;
    private JButton jButtonPrjLocation;
    private JButton jButtonSrcLocation;
    private JLabel jLabelPrjLocation;
    private JLabel jLabelPrjLocationDesc;
    private JLabel jLabelPrjName;
    private JLabel jLabelSrcLocation;
    private JLabel jLabelSrcLocationDesc;
    private JSeparator jSeparator1;
    private JLabel librariesLabel;
    private JTextField librariesLocation;
    public JTextField moduleLocationTextField;
    public JTextField projectLocationTextField;
    public JTextField projectNameTextField;
    private JCheckBox setAsMainCheckBox;
    private JCheckBox sharableProject;

    public ProjectImportLocationPanel(Object object, String string, String string2, ProjectImportLocationWizardPanel projectImportLocationWizardPanel, String string3, String string4, boolean bl) {
        this.wizard = projectImportLocationWizardPanel;
        this.j2eeModuleType = object;
        this.nameFormatter = string3;
        this.allowAlternativeBuildXml = bl;
        this.initComponents();
        this.jLabelSrcLocationDesc.setText(string4);
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.librariesLocation.setText(this.currentLibrariesLocation);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACS_NWP1_NamePanel_A11YDesc"));
        this.setName(string);
        this.putClientProperty("NewProjectWizard_Title", string2);
        this.moduleLocationTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ProjectImportLocationPanel.this.locationDataChanged(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ProjectImportLocationPanel.this.locationDataChanged(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ProjectImportLocationPanel.this.locationDataChanged(documentEvent);
            }
        });
        this.projectLocationTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ProjectImportLocationPanel.this.fireChanges();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ProjectImportLocationPanel.this.fireChanges();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ProjectImportLocationPanel.this.fireChanges();
            }
        });
        this.sharableProjectActionPerformed(null);
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null && wizardDescriptor.getProperty("projdir") != null) {
            int n = 1;
            while ((string = this.validFreeProjectName(file, this.nameFormatter, n)) == null) {
                ++n;
            }
        }
        this.projectNameTextField.setText(string == null ? "" : string);
        this.projectNameTextField.selectAll();
    }

    void store(WizardDescriptor wizardDescriptor) {
        File file = null;
        String string = this.moduleLocationTextField.getText();
        if (string.length() > 0) {
            file = FileUtil.normalizeFile((File)new File(string));
        }
        if (file != null) {
            UserProjectSettings.getDefault().setLastUsedImportLocation(file);
        }
        wizardDescriptor.putProperty("sourceRoot", (Object)file);
        wizardDescriptor.putProperty("name", (Object)this.projectNameTextField.getText().trim());
        String string2 = this.projectLocationTextField.getText().trim();
        if (string2.length() >= 0) {
            wizardDescriptor.putProperty("projdir", (Object)new File(string2));
        }
        wizardDescriptor.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        wizardDescriptor.putProperty("sharedLibraries", this.sharableProject.isSelected() ? this.librariesLocation.getText() : null);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File[] fileArray;
        String string = this.moduleLocationTextField.getText().trim();
        if (string.length() == 0) {
            this.setErrorMessage("MSG_ProvideExistingSourcesLocation");
            return false;
        }
        File file = new File(string);
        if (!file.isDirectory() || !file.canRead()) {
            String string2 = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"MSG_IllegalSources");
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(string2, string));
            return false;
        }
        String string3 = this.projectLocationTextField.getText().trim();
        file = new File(string3);
        String string4 = this.projectNameTextField.getText().trim();
        file = new File(file, string4);
        if ((file = ProjectLocationPanel.getCanonicalFile(file)) == null || !string4.equals(file.getName())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"MSG_ProvideProjectName"));
            return false;
        }
        if (string3.length() == 0) {
            this.setErrorMessage("MSG_ProvideProjectFolder");
            return false;
        }
        File file2 = new File(string3);
        if (file2.exists() && !file2.canWrite()) {
            this.setErrorMessage("MSG_ProjectLocationRO");
            return false;
        }
        File file3 = FileUtil.normalizeFile((File)new File(string3));
        if (file3.isDirectory()) {
            fileArray = FileUtil.toFileObject((File)file3);
            assert (fileArray != null) : "No FileObject for " + file3;
            boolean bl = false;
            try {
                bl = ProjectManager.getDefault().findProject((FileObject)fileArray) == null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl) {
                this.setErrorMessage("MSG_ProjectFolderHasDeletedProject");
                return false;
            }
        }
        fileArray = file3.listFiles();
        if (file3.exists() && fileArray != null && fileArray.length > 0) {
            String string5 = null;
            for (int i = 0; i < fileArray.length; ++i) {
                String string6 = fileArray[i].getName();
                if ("nbproject".equals(string6)) {
                    string5 = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"TXT_NetBeansProject");
                } else if ("build".equals(string6)) {
                    string5 = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"TXT_BuildFolder");
                } else if ("build.xml".equals(string6) && !this.allowAlternativeBuildXml) {
                    string5 = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"TXT_BuildXML");
                } else if ("dist".equals(string6)) {
                    string5 = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"TXT_DistFolder");
                } else if ("manifest.mf".equals(string6)) {
                    string5 = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"TXT_Manifest");
                }
                if (string5 == null) continue;
                String string7 = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"MSG_ProjectFolderInvalid");
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(string7, string5));
                return false;
            }
        }
        if (this.j2eeModuleType == J2eeModule.CLIENT && FileSearchUtility.guessJavaRoots(FileUtil.toFileObject((File)file3)) == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"MSG_NoAppClientModule"));
            return false;
        }
        if (this.sharableProject.isSelected()) {
            String string8 = this.librariesLocation.getText();
            if (new File(string8).isAbsolute()) {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)ProjectLocationPanel.decorateMessage(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"PanelSharability.absolutePathWarning.text")));
            } else {
                File file4 = PropertyUtils.resolveFile((File)file2, (String)string8);
                if (!CollocationQuery.areCollocated((File)file2, (File)file4)) {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)ProjectLocationPanel.decorateMessage(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"PanelSharability.relativePathWarning.text")));
                }
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private void setErrorMessage(String string) {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", string == null ? null : NbBundle.getMessage(ProjectImportLocationPanel.class, (String)string));
    }

    private void initComponents() {
        this.jLabelSrcLocationDesc = new JLabel();
        this.jLabelSrcLocation = new JLabel();
        this.moduleLocationTextField = new JTextField();
        this.jButtonSrcLocation = new JButton();
        this.jLabelPrjLocationDesc = new JLabel();
        this.jLabelPrjName = new JLabel();
        this.projectNameTextField = new JTextField();
        this.jLabelPrjLocation = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.jButtonPrjLocation = new JButton();
        this.jSeparator1 = new JSeparator();
        this.sharableProject = new JCheckBox();
        this.librariesLabel = new JLabel();
        this.librariesLocation = new JTextField();
        this.browseLibraries = new JButton();
        this.setAsMainCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabelSrcLocationDesc, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_LocationSrcDesc"));
        this.jLabelSrcLocation.setDisplayedMnemonic(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_ImportLocation_LabelMnemonic").charAt(0));
        this.jLabelSrcLocation.setHorizontalAlignment(2);
        this.jLabelSrcLocation.setLabelFor(this.moduleLocationTextField);
        this.jLabelSrcLocation.setText(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_LocationSrc_Label"));
        this.jButtonSrcLocation.setMnemonic(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_BrowseLocation_MNE").charAt(0));
        this.jButtonSrcLocation.setText(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.jButtonSrcLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectImportLocationPanel.this.jButtonSrcLocationActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabelPrjLocationDesc, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_LocationPrjDesc"));
        this.jLabelPrjName.setDisplayedMnemonic(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_ProjectName_LabelMnemonic").charAt(0));
        this.jLabelPrjName.setHorizontalAlignment(2);
        this.jLabelPrjName.setLabelFor(this.projectNameTextField);
        this.jLabelPrjName.setText(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_ProjectName_Label"));
        this.jLabelPrjLocation.setDisplayedMnemonic(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_CreatedProjectFolder_LabelMnemonic").charAt(0));
        this.jLabelPrjLocation.setHorizontalAlignment(2);
        this.jLabelPrjLocation.setLabelFor(this.projectLocationTextField);
        this.jLabelPrjLocation.setText(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_CreatedProjectFolder_Label"));
        this.jButtonPrjLocation.setMnemonic(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_BrowseProjectFolder_MNE").charAt(0));
        this.jButtonPrjLocation.setText(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_BrowseProjectLocation_Button"));
        this.jButtonPrjLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectImportLocationPanel.this.jButtonPrjLocationActionPerformed(actionEvent);
            }
        });
        this.sharableProject.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        Mnemonics.setLocalizedText((AbstractButton)this.sharableProject, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ProjectLocationPanel.sharableProject.text"));
        this.sharableProject.setMargin(new Insets(2, 0, 2, 2));
        this.sharableProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectImportLocationPanel.this.sharableProjectActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ProjectLocationPanel.librariesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseLibraries, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"PanelSharabilityVisual.browseLibraries.text"));
        this.browseLibraries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectImportLocationPanel.this.browseLibrariesActionPerformed(actionEvent);
            }
        });
        this.setAsMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.setAsMainCheckBox, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_SetAsMain_CheckBox"));
        this.setAsMainCheckBox.setMargin(new Insets(2, 0, 2, 2));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelSrcLocation).add((Component)this.jLabelPrjLocation).add((Component)this.jLabelPrjName, -2, 71, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.projectNameTextField, -1, 353, Short.MAX_VALUE).add(2, (Component)this.moduleLocationTextField, -1, 353, Short.MAX_VALUE).add(2, (Component)this.projectLocationTextField, -1, 353, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.jButtonSrcLocation).add(2, (Component)this.jButtonPrjLocation))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelPrjLocationDesc).addContainerGap()).add((Component)this.jSeparator1, -1, 515, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.sharableProject).addContainerGap(296, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.librariesLabel).addPreferredGap(0).add((Component)this.librariesLocation, -1, 347, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseLibraries)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.setAsMainCheckBox).addContainerGap()).add((Component)this.jLabelSrcLocationDesc, -1, 515, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelSrcLocationDesc).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelSrcLocation).add((Component)this.jButtonSrcLocation).add((Component)this.moduleLocationTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabelPrjLocationDesc).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelPrjName).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelPrjLocation).add((Component)this.jButtonPrjLocation).add((Component)this.projectLocationTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.sharableProject).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.librariesLabel).add((Component)this.browseLibraries).add((Component)this.librariesLocation, -2, -1, -2)).add(18, 18, 18).add((Component)this.setAsMainCheckBox).add(52, 52, 52)));
        this.moduleLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACS_LBL_IW_ImportLocation_A11YDesc"));
        this.jButtonSrcLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACS_LBL_IW_ImportLocationBrowse_A11YDesc"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACS_LBL_NWP1_ProjectName_A11YDesc"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACS_LBL_NPW1_ProjectLocation_A11YDesc"));
        this.jButtonPrjLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACS_LBL_NWP1_BrowseLocation_A11YDesc"));
    }

    private void jButtonPrjLocationActionPerformed(ActionEvent actionEvent) {
        FileChooser fileChooser = FileChooser.createDirectoryChooser("ImportLocationVisual.Project", this.projectLocationTextField.getText());
        fileChooser.setDialogTitle(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_BrowseProjectFolder"));
        if (0 == fileChooser.showOpenDialog(this)) {
            File file = fileChooser.getSelectedFile();
            this.projectLocationTextField.setText(file.getAbsolutePath());
        }
    }

    private void jButtonSrcLocationActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_BrowseExistingSource"));
        if (this.moduleLocationTextField.getText().length() > 0 && this.getProjectLocation().exists()) {
            jFileChooser.setSelectedFile(this.getProjectLocation());
        } else {
            File file2;
            file = null;
            FileObject fileObject = Templates.getExistingSourcesFolder((WizardDescriptor)this.wizardDescriptor);
            if (fileObject != null && (file2 = FileUtil.toFile((FileObject)fileObject)) != null && file2.isDirectory()) {
                file = file2;
            }
            if (file != null) {
                jFileChooser.setCurrentDirectory(file);
            } else {
                file2 = UserProjectSettings.getDefault().getLastUsedImportLocation();
                if (file2 != null) {
                    jFileChooser.setCurrentDirectory(file2.getParentFile());
                } else {
                    jFileChooser.setSelectedFile(ProjectChooser.getProjectsFolder());
                }
            }
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.moduleLocationTextField.setText(file.getAbsolutePath());
        }
    }

    private void sharableProjectActionPerformed(ActionEvent actionEvent) {
        this.librariesLocation.setEnabled(this.sharableProject.isSelected());
        this.browseLibraries.setEnabled(this.sharableProject.isSelected());
        this.librariesLabel.setEnabled(this.sharableProject.isSelected());
        if (this.sharableProject.isSelected()) {
            this.librariesLocation.setText(this.currentLibrariesLocation);
        } else {
            this.librariesLocation.setText("");
        }
        this.wizard.fireChangeEvent();
    }

    private void browseLibrariesActionPerformed(ActionEvent actionEvent) {
        File file = new File(this.projectLocationTextField.getText());
        String string = SharableLibrariesUtils.browseForLibraryLocation((String)this.librariesLocation.getText().trim(), (Component)this, (File)file);
        if (string != null) {
            this.currentLibrariesLocation = string;
            if (this.sharableProject.isSelected()) {
                this.librariesLocation.setText(this.currentLibrariesLocation);
            }
        }
    }

    private String computeProjectName() {
        if (this.getProjectLocation() == null) {
            return "";
        }
        FileObject fileObject = FileUtil.toFileObject((File)this.getProjectLocation());
        if (fileObject != null) {
            return fileObject.getName();
        }
        return "";
    }

    private String computeProjectFolder() {
        File file = this.getProjectLocation();
        if (file == null) {
            return "";
        }
        return file.getAbsolutePath();
    }

    private void locationDataChanged(DocumentEvent documentEvent) {
        if (this.lastModuleLocation == null || !this.lastModuleLocation.equals(this.moduleLocationTextField.getText())) {
            this.lastModuleLocation = this.moduleLocationTextField.getText();
            this.projectNameTextField.setText(this.computeProjectName());
            this.projectLocationTextField.setText(this.computeProjectFolder());
        }
        this.fireChanges();
    }

    private void fireChanges() {
        this.wizard.fireChangeEvent();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectImportLocationPanel.generateHelpID(ProjectImportLocationPanel.class, this.j2eeModuleType));
    }

    static String generateHelpID(Class clazz, Object object) {
        if (object == J2eeModule.CLIENT) {
            return clazz.getName() + "_APPCLIENT";
        }
        if (object == J2eeModule.EJB) {
            return clazz.getName() + "_EJB";
        }
        if (object == J2eeModule.EAR) {
            return clazz.getName() + "_EAR";
        }
        if (object == J2eeModule.WAR) {
            return clazz.getName() + "_WAR";
        }
        throw new AssertionError((Object)("Unknown module type: " + object));
    }

    private String validFreeProjectName(File file, String string, int n) {
        String string2 = MessageFormat.format(string, n);
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }

    public File getProjectLocation() {
        if (this.moduleLocationTextField.getText().trim().length() == 0) {
            return null;
        }
        return this.getAsFile(this.moduleLocationTextField.getText());
    }

    private File getAsFile(String string) {
        return FileUtil.normalizeFile((File)new File(string));
    }
}

