/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.openide.util.NbBundle;

public class J2eePlatformUiSupport {
    private static final String JAVA_EE_5_DISPLAY_NAME = NbBundle.getMessage(J2eePlatformUiSupport.class, (String)"JAVA_EE_5_displayName");
    private static final String J2EE_1_4_DISPLAY_NAME = NbBundle.getMessage(J2eePlatformUiSupport.class, (String)"J2EE_1_4_displayName");
    private static final String J2EE_1_3_DISPLAY_NAME = NbBundle.getMessage(J2eePlatformUiSupport.class, (String)"J2EE_1_3_displayName");

    private J2eePlatformUiSupport() {
    }

    public static ComboBoxModel createPlatformComboBoxModel(String string, String string2) {
        return new J2eePlatformComboBoxModel(string, string2);
    }

    public static ComboBoxModel createSpecVersionComboBoxModel(String string) {
        return new J2eeSpecVersionComboBoxModel(string);
    }

    public static boolean getJ2eePlatformAndSpecVersionMatch(Object object, Object object2) {
        if (!(object instanceof J2eePlatformAdapter) || !(object2 instanceof String)) {
            return false;
        }
        J2eePlatform j2eePlatform = ((J2eePlatformAdapter)object).getJ2eePlatform();
        String string = (String)object2;
        return j2eePlatform.getSupportedSpecVersions(J2eeModule.EJB).contains(string);
    }

    public static String getSpecVersion(Object object) {
        return ((J2eePlatformComboBoxItem)object).getCode();
    }

    public static String getServerInstanceID(Object object) {
        if (object == null) {
            return null;
        }
        J2eePlatform j2eePlatform = ((J2eePlatformAdapter)object).getJ2eePlatform();
        String[] stringArray = Deployment.getDefault().getServerInstanceIDs();
        for (int i = 0; i < stringArray.length; ++i) {
            J2eePlatform j2eePlatform2 = Deployment.getDefault().getJ2eePlatform(stringArray[i]);
            if (j2eePlatform2 == null || !j2eePlatform2.getDisplayName().equals(j2eePlatform.getDisplayName())) continue;
            return stringArray[i];
        }
        return null;
    }

    public static void setSelectedPlatform(ComboBoxModel comboBoxModel, String string) {
        if (!(comboBoxModel instanceof J2eePlatformComboBoxModel)) {
            return;
        }
        ((J2eePlatformComboBoxModel)comboBoxModel).setSelectedItem(string);
    }

    private static final class J2eePlatformComboBoxItem {
        private String code;
        private String displayName;

        public J2eePlatformComboBoxItem(String string, String string2) {
            this.code = string;
            this.displayName = string2;
        }

        public J2eePlatformComboBoxItem(String string) {
            this(string, J2eePlatformComboBoxItem.findDisplayName(string));
        }

        private static String findDisplayName(String string) {
            if (string.equals("1.5")) {
                return JAVA_EE_5_DISPLAY_NAME;
            }
            if (string.equals("1.4")) {
                return J2EE_1_4_DISPLAY_NAME;
            }
            if (string.equals("1.3")) {
                return J2EE_1_3_DISPLAY_NAME;
            }
            return string;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private static final class J2eeSpecVersionComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 20366133932230984L;
        private J2eePlatformComboBoxItem[] j2eeSpecVersions;
        private J2eePlatformComboBoxItem initialJ2eeSpecVersion;
        private J2eePlatformComboBoxItem selectedJ2eeSpecVersion;

        public J2eeSpecVersionComboBoxModel(String string) {
            this.initialJ2eeSpecVersion = new J2eePlatformComboBoxItem(string);
            ArrayList<J2eePlatformComboBoxItem> arrayList = new ArrayList<J2eePlatformComboBoxItem>();
            arrayList.add(new J2eePlatformComboBoxItem("1.5"));
            arrayList.add(new J2eePlatformComboBoxItem("1.4"));
            if (!this.initialJ2eeSpecVersion.getCode().equals("1.5") && !this.initialJ2eeSpecVersion.getCode().equals("1.4")) {
                arrayList.add(0, new J2eePlatformComboBoxItem("1.3"));
            }
            this.j2eeSpecVersions = arrayList.toArray(new J2eePlatformComboBoxItem[arrayList.size()]);
            this.selectedJ2eeSpecVersion = this.initialJ2eeSpecVersion;
        }

        public Object getElementAt(int n) {
            return this.j2eeSpecVersions[n];
        }

        public int getSize() {
            return this.j2eeSpecVersions.length;
        }

        public Object getSelectedItem() {
            return this.selectedJ2eeSpecVersion;
        }

        public void setSelectedItem(Object object) {
            this.selectedJ2eeSpecVersion = (J2eePlatformComboBoxItem)object;
        }
    }

    private static final class J2eePlatformAdapter
    implements Comparable {
        private J2eePlatform platform;
        private String serverInstanceID;

        public J2eePlatformAdapter(J2eePlatform j2eePlatform, String string) {
            this.platform = j2eePlatform;
            this.serverInstanceID = string;
        }

        public J2eePlatform getJ2eePlatform() {
            return this.platform;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            return this.platform.getDisplayName();
        }

        public int compareTo(Object object) {
            J2eePlatformAdapter j2eePlatformAdapter = (J2eePlatformAdapter)object;
            return this.toString().compareTo(j2eePlatformAdapter.toString());
        }
    }

    private static final class J2eePlatformComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private J2eePlatformAdapter[] j2eePlatforms;
        private String initialJ2eePlatform;
        private J2eePlatformAdapter selectedJ2eePlatform;
        private String j2eeLevel;

        public J2eePlatformComboBoxModel(String string, String string2) {
            this.initialJ2eePlatform = string;
            this.j2eeLevel = string2;
            this.getJ2eePlatforms();
        }

        public Object getElementAt(int n) {
            return this.getJ2eePlatforms()[n];
        }

        public int getSize() {
            return this.getJ2eePlatforms().length;
        }

        public Object getSelectedItem() {
            return this.selectedJ2eePlatform;
        }

        public void setSelectedItem(Object object) {
            this.selectedJ2eePlatform = (J2eePlatformAdapter)object;
        }

        public void setSelectedItem(String string) {
            for (int i = 0; i < this.j2eePlatforms.length; ++i) {
                if (!this.j2eePlatforms[i].getServerInstanceID().equals(string)) continue;
                this.selectedJ2eePlatform = this.j2eePlatforms[i];
                return;
            }
        }

        private synchronized J2eePlatformAdapter[] getJ2eePlatforms() {
            if (this.j2eePlatforms == null) {
                String[] stringArray = Deployment.getDefault().getServerInstanceIDs();
                TreeSet<J2eePlatformAdapter> treeSet = new TreeSet<J2eePlatformAdapter>();
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(stringArray[i]);
                    if (j2eePlatform == null || !j2eePlatform.getSupportedModuleTypes().contains(J2eeModule.WAR) || !j2eePlatform.getSupportedSpecVersions(J2eeModule.WAR).contains(this.j2eeLevel)) continue;
                    J2eePlatformAdapter j2eePlatformAdapter = new J2eePlatformAdapter(j2eePlatform, stringArray[i]);
                    treeSet.add(j2eePlatformAdapter);
                    if (this.selectedJ2eePlatform != null || bl || this.initialJ2eePlatform == null || !stringArray[i].equals(this.initialJ2eePlatform)) continue;
                    this.selectedJ2eePlatform = j2eePlatformAdapter;
                    bl = true;
                }
                this.j2eePlatforms = treeSet.toArray(new J2eePlatformAdapter[treeSet.size()]);
            }
            return this.j2eePlatforms;
        }
    }
}

