/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.ProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.util.RequestProcessor;

public final class LibrariesLocationUpdater
implements PropertyChangeListener {
    private String classPathProperty;
    private String projectXMLElement;
    private String additionalClassPathProperty;
    private String additionalProjectXMLElement;
    private final Project project;
    private final UpdateHelper helper;
    private final PropertyEvaluator eval;
    private final ClassPathSupport cs;
    private final AntProjectHelper antHelper;
    private String oldValue;
    private String oldAdditionalValue;
    private final PropertyChangeListener listener;
    private boolean destroyed = false;
    private static final Logger LOG = Logger.getLogger(LibrariesLocationUpdater.class.getName());
    private List<Library> libsBeingListenOn = new ArrayList<Library>();

    public LibrariesLocationUpdater(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ClassPathSupport classPathSupport, String string, String string2, String string3, String string4) {
        assert (project != null);
        assert (updateHelper != null);
        assert (propertyEvaluator != null);
        this.listener = this;
        this.project = project;
        this.helper = updateHelper;
        this.eval = propertyEvaluator;
        this.antHelper = updateHelper.getAntProjectHelper();
        this.cs = classPathSupport;
        this.classPathProperty = string;
        this.projectXMLElement = string2;
        this.additionalClassPathProperty = string3;
        this.additionalProjectXMLElement = string4;
        EditableProperties editableProperties = updateHelper.getProperties("nbproject/project.properties");
        this.oldValue = editableProperties.getProperty(string);
        if (string3 != null) {
            this.oldAdditionalValue = editableProperties.getProperty(string3);
        }
        this.registerLibraryListeners();
        propertyEvaluator.addPropertyChangeListener(this.listener);
    }

    private synchronized boolean needsUpdate(String string, String string2) {
        boolean bl = false;
        if (!LibrariesLocationUpdater.stringEquals(string, this.oldValue)) {
            this.oldValue = string;
            bl = true;
        }
        if (this.additionalClassPathProperty != null && !LibrariesLocationUpdater.stringEquals(string2, this.oldAdditionalValue)) {
            this.oldAdditionalValue = string2;
            bl = true;
        }
        return bl;
    }

    private synchronized void unregisterLibraryListeners() {
        for (Library library : this.libsBeingListenOn) {
            library.removePropertyChangeListener(this.listener);
        }
        this.libsBeingListenOn.clear();
    }

    public synchronized void destroy() {
        this.destroyed = true;
        this.eval.removePropertyChangeListener((PropertyChangeListener)this);
        this.unregisterLibraryListeners();
    }

    private synchronized void registerLibraryListeners() {
        if (this.destroyed) {
            return;
        }
        ProjectManager.mutex().readAccess(new Runnable(){

            public void run() {
                LibrariesLocationUpdater.this.unregisterLibraryListeners();
                EditableProperties editableProperties = LibrariesLocationUpdater.this.helper.getProperties("nbproject/project.properties");
                HashSet<ClassPathSupport.Item> hashSet = new HashSet<ClassPathSupport.Item>();
                hashSet.addAll(LibrariesLocationUpdater.this.cs.itemsList(editableProperties.getProperty(LibrariesLocationUpdater.this.classPathProperty), null));
                if (LibrariesLocationUpdater.this.additionalClassPathProperty != null) {
                    hashSet.addAll(LibrariesLocationUpdater.this.cs.itemsList(editableProperties.getProperty(LibrariesLocationUpdater.this.additionalClassPathProperty), null));
                }
                for (ClassPathSupport.Item item : hashSet) {
                    if (item.getType() != 1 || item.isBroken()) continue;
                    item.getLibrary().addPropertyChangeListener(LibrariesLocationUpdater.this.listener);
                    LibrariesLocationUpdater.this.libsBeingListenOn.add(item.getLibrary());
                }
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!ProjectManager.getDefault().isValid(this.project)) {
            return;
        }
        if (propertyChangeEvent.getSource().equals(this.eval)) {
            if (propertyChangeEvent.getPropertyName().equals(this.classPathProperty) || this.additionalClassPathProperty != null && propertyChangeEvent.getPropertyName().equals(this.additionalClassPathProperty)) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        EditableProperties editableProperties = LibrariesLocationUpdater.this.helper.getProperties("nbproject/project.properties");
                        if (LibrariesLocationUpdater.this.needsUpdate(editableProperties.getProperty(LibrariesLocationUpdater.this.classPathProperty), editableProperties.getProperty(LibrariesLocationUpdater.this.additionalClassPathProperty))) {
                            LibrariesLocationUpdater.this.registerLibraryListeners();
                        }
                    }
                });
            }
        } else if (propertyChangeEvent.getPropertyName().equals("content")) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    LibrariesLocationUpdater.this.storeLibLocations();
                }
            });
        }
    }

    private static boolean stringEquals(String string, String string2) {
        return string == null || string.trim().length() == 0 ? string2 == null || string2.trim().length() == 0 : string.equals(string2);
    }

    private void storeLibLocations() {
        String[] stringArray;
        String[] stringArray2;
        if (this.additionalClassPathProperty != null) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this.classPathProperty;
            stringArray2 = stringArray3;
            stringArray3[1] = this.additionalClassPathProperty;
        } else {
            String[] stringArray4 = new String[1];
            stringArray2 = stringArray4;
            stringArray4[0] = this.classPathProperty;
        }
        if (this.additionalClassPathProperty != null) {
            String[] stringArray5 = new String[2];
            stringArray5[0] = this.projectXMLElement;
            stringArray = stringArray5;
            stringArray5[1] = this.additionalProjectXMLElement;
        } else {
            String[] stringArray6 = new String[1];
            stringArray = stringArray6;
            stringArray6[0] = this.projectXMLElement;
        }
        ProjectProperties.storeLibrariesLocations(this.project, this.antHelper, this.cs, stringArray2, stringArray, true);
    }
}

