/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.method.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReturnTypeUIHelper {
    private static final List<String> LVALUE_TYPES = Arrays.asList("boolean", "int", "char", "byte", "short", "long", "float", "double", "Object", "String");
    static final Separator SEPARATOR_ITEM = new Separator();
    static final Object NEW_ITEM = new Object(){

        public String toString() {
            return NbBundle.getMessage(ReturnTypeUIHelper.class, (String)"LBL_Choose");
        }
    };

    public static ListCellRenderer createDatasourceListCellRenderer() {
        return new ReturnTypeListCellRenderer();
    }

    private ReturnTypeUIHelper() {
    }

    public static void connect(JComboBox jComboBox, ClasspathInfo classpathInfo) {
        ReturnTypeUIHelper.connect(jComboBox, null, classpathInfo);
    }

    private static final void connect(final JComboBox jComboBox, String string, final ClasspathInfo classpathInfo) {
        jComboBox.setEditable(true);
        jComboBox.setEditor(new ReturnTypeComboBoxEditor(jComboBox.getEditor()));
        jComboBox.setRenderer(new ReturnTypeListCellRenderer());
        ReturnTypeUIHelper.populate(LVALUE_TYPES, true, jComboBox, string, false);
        JComboBox jComboBox2 = jComboBox.isEditable() ? jComboBox.getEditor().getEditorComponent() : jComboBox;
        jComboBox2.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Object object;
                int n = keyEvent.getKeyCode();
                if (10 == n && (object = jComboBox.getSelectedItem()) == NEW_ITEM) {
                    ReturnTypeUIHelper.performBrowseType(jComboBox, classpathInfo);
                    keyEvent.consume();
                }
            }
        });
        jComboBox.addActionListener(new ActionListener(){
            Object previousItem;
            int previousIndex;
            {
                this.previousIndex = jComboBox.getSelectedIndex();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                if (object == SEPARATOR_ITEM) {
                    int n = jComboBox.getSelectedIndex();
                    if (n > this.previousIndex) {
                        this.previousIndex = n + 1;
                        this.previousItem = jComboBox.getItemAt(this.previousIndex);
                    } else {
                        this.previousIndex = n - 1;
                        this.previousItem = jComboBox.getItemAt(this.previousIndex);
                    }
                    jComboBox.setSelectedItem(this.previousItem);
                } else if ((actionEvent.getModifiers() & 0x10) != 0 && object == NEW_ITEM) {
                    ReturnTypeUIHelper.performBrowseType(jComboBox, classpathInfo);
                }
            }
        });
    }

    private static void performBrowseType(final JComboBox jComboBox, final ClasspathInfo classpathInfo) {
        final ReturnTypeComboBoxModel returnTypeComboBoxModel = (ReturnTypeComboBoxModel)jComboBox.getModel();
        jComboBox.setPopupVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ElementHandle elementHandle = TypeElementFinder.find((ClasspathInfo)classpathInfo, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String string, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> set) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(string, nameKind, set);
                    }

                    public boolean accept(ElementHandle<TypeElement> elementHandle) {
                        return true;
                    }
                });
                jComboBox.setPopupVisible(false);
                if (elementHandle == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ReturnTypeUIHelper.setSelectedItem(jComboBox, returnTypeComboBoxModel.getPreviousItem());
                        }
                    });
                } else {
                    ReturnTypeUIHelper.setSelectedItem(jComboBox, elementHandle.getQualifiedName());
                }
            }
        });
    }

    private static List populate(List<String> list, boolean bl, final JComboBox jComboBox, final String string, boolean bl2) {
        LinkedList<Object> linkedList;
        LinkedList<Object> linkedList2 = linkedList = list == null ? new LinkedList<Object>() : new LinkedList<String>(list);
        if (linkedList.size() > 0) {
            linkedList.add(SEPARATOR_ITEM);
        }
        if (bl) {
            linkedList.add(NEW_ITEM);
        }
        ReturnTypeComboBoxModel returnTypeComboBoxModel = new ReturnTypeComboBoxModel(list, linkedList);
        jComboBox.setModel(returnTypeComboBoxModel);
        if (string != null) {
            ReturnTypeUIHelper.setSelectedItem(jComboBox, string);
            if (bl2) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ReturnTypeUIHelper.setSelectedItem(jComboBox, string);
                    }
                });
            }
        }
        return list;
    }

    private static void setSelectedItem(JComboBox jComboBox, Object object) {
        jComboBox.setSelectedItem(object);
        if (jComboBox.isEditable() && jComboBox.getEditor() != null) {
            jComboBox.configureEditor(jComboBox.getEditor(), jComboBox.getSelectedItem());
        }
    }

    private static class ReturnTypeComboBoxEditor
    implements ComboBoxEditor {
        private ComboBoxEditor delegate;
        private Object oldValue;

        ReturnTypeComboBoxEditor(ComboBoxEditor comboBoxEditor) {
            this.delegate = comboBoxEditor;
        }

        public Component getEditorComponent() {
            return this.delegate.getEditorComponent();
        }

        public void setItem(Object object) {
            JTextComponent jTextComponent = this.getEditor();
            if (object != null) {
                String string = object.toString();
                jTextComponent.setText(string);
                this.oldValue = object;
            } else {
                jTextComponent.setText("");
            }
        }

        public Object getItem() {
            JTextComponent jTextComponent = this.getEditor();
            Object object = jTextComponent.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (object.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> clazz = this.oldValue.getClass();
                try {
                    Method method = clazz.getMethod("valueOf", String.class);
                    object = method.invoke(this.oldValue, jTextComponent.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }

        public void selectAll() {
            this.delegate.selectAll();
        }

        public void addActionListener(ActionListener actionListener) {
            this.delegate.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.delegate.removeActionListener(actionListener);
        }

        private JTextComponent getEditor() {
            Component component = this.getEditorComponent();
            assert (component instanceof JTextComponent);
            return (JTextComponent)component;
        }
    }

    private static class ReturnTypeListCellRenderer
    extends DefaultListCellRenderer {
        private ReturnTypeListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object == SEPARATOR_ITEM) {
                return SEPARATOR_ITEM;
            }
            this.setText(object != null ? object.toString() : "");
            this.setToolTipText("");
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReturnTypeComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private List<Object> items;
        private Object selectedItem;
        private List<String> returnTypes;
        private Object previousItem;

        private ReturnTypeComboBoxModel(List<String> list, List<Object> list2) {
            this.returnTypes = list;
            this.items = list2;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selectedItem == null || !this.selectedItem.equals(object)) {
                this.previousItem = this.selectedItem;
                this.selectedItem = object;
                this.fireContentsChanged(this, 0, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public Object getElementAt(int n) {
            return this.items.get(n);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        Object getPreviousItem() {
            return this.previousItem;
        }

        List<String> getReturnTypes() {
            return this.returnTypes;
        }

        public void addElement(Object object) {
            this.items.add(object);
        }

        @Override
        public void removeElement(Object object) {
            this.items.remove(object);
        }

        public void insertElementAt(Object object, int n) {
            this.items.set(n, object);
        }

        @Override
        public void removeElementAt(int n) {
            this.items.remove(n);
        }
    }

    private static final class Separator
    extends JSeparator {
        Separator() {
            this.setPreferredSize(new Dimension(this.getWidth(), 1));
            this.setForeground(Color.BLACK);
        }
    }
}

