/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.method.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.impl.ReturnTypeUIHelper;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParametersPanel
extends JPanel {
    private static final int COL_NAME_INDEX = 0;
    private static final int COL_TYPE_INDEX = 1;
    private static final int COL_FINAL_INDEX = 2;
    private static final String[] columnNames = new String[]{NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.LBL_Name"), NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.LBL_Type"), NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.LBL_Final")};
    public static final String SELECTION = "selection";
    private final ParamsTableModel tableModel;
    private JButton addButton;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JTable table;
    private JButton upButton;

    public ParametersPanel(ClasspathInfo classpathInfo, List<MethodModel.Variable> list) {
        this.initComponents();
        this.tableModel = new ParamsTableModel(list);
        this.table.setModel(this.tableModel);
        JComboBox jComboBox = new JComboBox();
        ReturnTypeUIHelper.connect(jComboBox, classpathInfo);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        this.table.setRowHeight(jComboBox.getPreferredSize().height);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ListSelectionListenerImpl listSelectionListenerImpl = new ListSelectionListenerImpl();
        this.table.getSelectionModel().addListSelectionListener(listSelectionListenerImpl);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListenerImpl);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ParametersPanel.this.updateButtons();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ParametersPanel.this.updateButtons();
            }
        });
        this.updateButtons();
    }

    public List<MethodModel.Variable> getParameters() {
        return this.tableModel.getParameters();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.table);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParametersPanel.class, (String)"ACSN_ParametersTab"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_ParametersTab"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.upButton.text"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.upButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.downButton.text"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.downButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 241, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addButton).add((Component)this.removeButton).add((Component)this.upButton).add((Component)this.downButton)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addButton, this.downButton, this.removeButton, this.upButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton).add(22, 22, 22).add((Component)this.upButton).addPreferredGap(0).add((Component)this.downButton)).add((Component)this.jScrollPane1, -1, 276, Short.MAX_VALUE)).addContainerGap()));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_AddParameterIntoTab"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_RemoveParameterIntoTab"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_MoveUpInParamTab"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_MoveDownInParamTab"));
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        int n2 = n - 1;
        if (n2 >= 0) {
            this.tableModel.set(n2, this.tableModel.set(n, this.tableModel.getParameter(n2)));
            this.table.setRowSelectionInterval(n2, n2);
            this.updateButtons();
        }
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        int n2 = n + 1;
        if (n2 < this.tableModel.getParameters().size()) {
            this.tableModel.set(n2, this.tableModel.set(n, this.tableModel.getParameter(n2)));
            this.table.setRowSelectionInterval(n2, n2);
            this.updateButtons();
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n > -1) {
            this.tableModel.removeParameter(n);
        }
        if (n == this.table.getRowCount()) {
            --n;
        }
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.updateButtons();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.tableModel.addParameter();
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        this.updateButtons();
    }

    private void updateButtons() {
        int n = this.table.getSelectedRow();
        boolean bl = this.table.getSelectedRowCount() == 1;
        this.removeButton.setEnabled(bl);
        this.upButton.setEnabled(bl && n > 0);
        this.downButton.setEnabled(bl && n < this.tableModel.getRowCount() - 1);
    }

    private static String chooseType(Object object, String string) {
        if (!(object instanceof String)) {
            return "Object";
        }
        String string2 = ((String)object).trim();
        if (string2.equals("")) {
            return string;
        }
        return string2;
    }

    private static String chooseName(Object object, String string) {
        String string2 = ((String)object).trim();
        if (string2.equals("")) {
            return string;
        }
        return string2;
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ParametersPanel.this.table.editCellAt(ParametersPanel.this.table.getSelectedRow(), ParametersPanel.this.table.getSelectedColumn());
            Component component = ParametersPanel.this.table.getEditorComponent();
            if (component instanceof JComboBox) {
                component = ((JComboBox)component).getEditor().getEditorComponent();
            }
            if (component != null) {
                component.requestFocus();
            }
            if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                jTextComponent.selectAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParamsTableModel
    extends AbstractTableModel {
        private final List<MethodModel.Variable> parameters;

        public ParamsTableModel(List<MethodModel.Variable> list) {
            this.parameters = new ArrayList<MethodModel.Variable>(list);
        }

        public List<MethodModel.Variable> getParameters() {
            return this.parameters;
        }

        public int addParameter() {
            String string = this.generateUniqueName("parameter");
            MethodModel.Variable variable = MethodModel.Variable.create("java.lang.String", string, false);
            int n = this.parameters.size();
            this.parameters.add(variable);
            this.fireTableRowsInserted(n, n);
            return n;
        }

        public void removeParameter(int n) {
            this.parameters.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public MethodModel.Variable getParameter(int n) {
            return this.parameters.get(n);
        }

        public MethodModel.Variable set(int n, MethodModel.Variable variable) {
            return this.parameters.set(n, variable);
        }

        @Override
        public int getRowCount() {
            return this.parameters.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            MethodModel.Variable variable;
            Object object = null;
            if (n >= 0 && (variable = this.parameters.get(n)) != null) {
                switch (n2) {
                    case 0: {
                        object = variable.getName();
                        break;
                    }
                    case 1: {
                        object = variable.getType();
                        break;
                    }
                    case 2: {
                        object = variable.getFinalModifier();
                        break;
                    }
                }
            }
            return object;
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            if (n2 == 0 && !Utilities.isJavaIdentifier((String)((String)(object2 = (String)object)).trim())) {
                return;
            }
            object2 = this.parameters.get(n);
            MethodModel.Variable variable = MethodModel.Variable.create(n2 == 1 ? ParametersPanel.chooseType(object, ((MethodModel.Variable)object2).getType()) : ((MethodModel.Variable)object2).getType(), n2 == 0 ? ParametersPanel.chooseName(object, ((MethodModel.Variable)object2).getName()) : ((MethodModel.Variable)object2).getName(), n2 == 2 ? ((Boolean)object).booleanValue() : ((MethodModel.Variable)object2).getFinalModifier());
            this.parameters.set(n, variable);
            this.fireTableCellUpdated(n, n2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        private String generateUniqueName(String string) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (MethodModel.Variable variable : this.parameters) {
                String string2;
                if (string.equals(variable.getName()) || !variable.getName().startsWith(string) || !this.isNumber(string2 = variable.getName().substring(string.length()))) continue;
                arrayList.add(Integer.parseInt(string2));
            }
            Collections.sort(arrayList);
            Object object = string;
            if (arrayList.size() > 0) {
                int n = (Integer)arrayList.get(arrayList.size() - 1) + 1;
                object = string + n;
            } else if (this.parameters.size() > 0) {
                object = string + 1;
            }
            return object;
        }

        private boolean isNumber(String string) {
            for (char c : string.toCharArray()) {
                if (Character.isDigit(c)) continue;
                return false;
            }
            return true;
        }
    }
}

