/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static void changeLabelInComponent(JComponent jComponent, String string, String string2) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setText(string2);
        }
    }

    public static void hideLabelAndLabelFor(JComponent jComponent, String string) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setVisible(false);
            Component component = jLabel.getLabelFor();
            if (component != null) {
                component.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] componentArray, Collection<Component> collection) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            collection.add(componentArray[i]);
            if (((Container)componentArray[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)componentArray[i]).getComponents(), collection);
        }
    }

    public static JLabel findLabel(JComponent jComponent, String string) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Util.getAllComponents(jComponent.getComponents(), arrayList);
        for (Component component : arrayList) {
            JLabel jLabel;
            if (!(component instanceof JLabel) || !(jLabel = (JLabel)component).getText().equals(string)) continue;
            return jLabel;
        }
        return null;
    }

    public static ClassPath getFullClasspath(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source"), ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot"), ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile")});
    }

    public static boolean isJavaEE5orHigher(Project project) {
        J2eeModule j2eeModule;
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            Object object = j2eeModule.getModuleType();
            double d = Double.parseDouble(j2eeModule.getModuleVersion());
            if (J2eeModule.EJB.equals(object) && d > 2.1) {
                return true;
            }
            if (J2eeModule.WAR.equals(object) && d > 2.4) {
                return true;
            }
            if (J2eeModule.CLIENT.equals(object) && d > 1.4) {
                return true;
            }
        }
        return false;
    }

    public static String getSourceLevel(Project project) {
        SourceLevelQueryImplementation sourceLevelQueryImplementation = (SourceLevelQueryImplementation)project.getLookup().lookup(SourceLevelQueryImplementation.class);
        return sourceLevelQueryImplementation.getSourceLevel(project.getProjectDirectory());
    }

    public static boolean isSourceLevel14orLower(Project project) {
        String string = Util.getSourceLevel(project);
        if (string != null) {
            double d = Double.parseDouble(string);
            return d <= 1.4;
        }
        return false;
    }

    public static boolean isSourceLevel16orHigher(Project project) {
        String string = Util.getSourceLevel(project);
        if (string != null) {
            double d = Double.parseDouble(string);
            return d >= 1.6;
        }
        return false;
    }

    public static boolean isValidServerInstance(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return false;
        }
        return Util.isValidServerInstance(j2eeModuleProvider);
    }

    public static boolean isValidServerInstance(J2eeModuleProvider j2eeModuleProvider) {
        String string = j2eeModuleProvider.getServerInstanceID();
        if (string == null) {
            return false;
        }
        return Deployment.getDefault().getServerID(string) != null;
    }

    public static File[] getJ2eePlatformClasspathEntries(Project project) {
        J2eePlatform j2eePlatform;
        J2eeModuleProvider j2eeModuleProvider;
        ArrayList arrayList = new ArrayList();
        if (project != null && (j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID())) != null) {
            return j2eePlatform.getClasspathEntries();
        }
        return new File[0];
    }

    public static boolean containsClass(List<URL> list, String string) throws IOException {
        Parameters.notNull((CharSequence)"classpath", list);
        Parameters.notNull((CharSequence)"className", (Object)string);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Serializable serializable : list) {
            Serializable serializable2;
            FileObject fileObject;
            URL uRL = FileUtil.getArchiveFile((URL)serializable);
            if (uRL != null) {
                serializable = uRL;
            }
            if ("nbinst".equals(serializable.getProtocol()) && (fileObject = URLMapper.findFileObject((URL)serializable)) != null && (serializable2 = URLMapper.findURL((FileObject)fileObject, (int)1)) != null) {
                serializable = serializable2;
            }
            if ((fileObject = URLMapper.findFileObject((URL)serializable)) == null || (serializable2 = FileUtil.toFile((FileObject)fileObject)) == null) continue;
            arrayList.add((File)serializable2);
        }
        return Util.containsClass(arrayList, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsClass(Collection<File> collection, String string) throws IOException {
        Parameters.notNull((CharSequence)"classpath", collection);
        Parameters.notNull((CharSequence)"driverClassName", (Object)string);
        String string2 = string.replace('.', '/') + ".class";
        for (File file : collection) {
            if (file.isFile()) {
                JarFile jarFile = new JarFile(file);
                try {
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        if (!string2.equals(jarEntry.getName())) continue;
                        boolean bl = true;
                        return bl;
                    }
                    continue;
                }
                finally {
                    jarFile.close();
                    continue;
                }
            }
            if (!new File(file, string2).exists()) continue;
            return true;
        }
        return false;
    }

    public static String getJ2eeSpecificationLabel(String string) {
        Parameters.notNull((CharSequence)"specificationVersion", (Object)string);
        if ("1.3".equals(string)) {
            return NbBundle.getMessage(Util.class, (String)"LBL_J2EESpec_13");
        }
        if ("1.4".equals(string)) {
            return NbBundle.getMessage(Util.class, (String)"LBL_J2EESpec_14");
        }
        if ("1.5".equals(string)) {
            return NbBundle.getMessage(Util.class, (String)"LBL_JavaEESpec_5");
        }
        throw new IllegalArgumentException("Unknown specification version: " + string);
    }
}

