/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SharabilityUtility {
    public static final String DEFAULT_LIBRARIES_FILENAME = "nblibraries.properties";

    private SharabilityUtility() {
    }

    public static String getLibraryLocation(String string) {
        String string2 = string;
        if (string2 != null) {
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separatorChar;
            }
            string2 = string2 + DEFAULT_LIBRARIES_FILENAME;
        }
        return string2;
    }

    public static Library findSharedServerLibrary(File file, String string) throws IOException {
        Parameters.notNull((CharSequence)"location", (Object)file);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            return null;
        }
        LibraryManager libraryManager = LibraryManager.forLocation((URL)URLMapper.findURL((FileObject)fileObject, (int)1));
        Library library = libraryManager.getLibrary(string);
        if (library != null && library.getType().equals("serverlibrary")) {
            return library;
        }
        return null;
    }

    public static Library createLibrary(File file, String string, String string2) throws IOException {
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string2);
        if (j2eePlatform == null) {
            throw new IOException("Server instance does not exist");
        }
        return j2eePlatform.createLibrary(file, string);
    }

    public static Library findOrCreateLibrary(File file, String string) throws IOException {
        Library library;
        String string2;
        Library[] libraryArray = SharabilityUtility.getLibraries(file, string);
        if (libraryArray.length > 0) {
            return libraryArray[0];
        }
        LibraryManager libraryManager = LibraryManager.forLocation((URL)file.toURI().toURL());
        Deployment deployment = Deployment.getDefault();
        String string3 = string2 = PropertyUtils.getUsablePropertyName((String)deployment.getServerDisplayName(deployment.getServerID(string)));
        int n = 1;
        while ((library = libraryManager.getLibrary(string3)) != null) {
            string3 = string2 + "-" + n;
            ++n;
        }
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string);
        if (j2eePlatform == null) {
            throw new IOException("Server instance does not exist");
        }
        return j2eePlatform.createLibrary(file, string3);
    }

    public static Library[] getLibraries(File file, String string) throws IOException {
        if (string == null) {
            return new Library[0];
        }
        Deployment deployment = Deployment.getDefault();
        String string2 = deployment.getServerDisplayName(deployment.getServerID(string));
        if (string2 == null) {
            return new Library[0];
        }
        string2 = PropertyUtils.getUsablePropertyName((String)string2);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            return new Library[0];
        }
        LibraryManager libraryManager = LibraryManager.forLocation((URL)URLMapper.findURL((FileObject)fileObject, (int)1));
        ArrayList<Library> arrayList = new ArrayList<Library>();
        for (Library library : libraryManager.getLibraries()) {
            String string3;
            if (!library.getType().equals("serverlibrary") || !library.getName().startsWith(string2) || !"".equals(string3 = library.getName().substring(string2.length())) && !string3.matches("-\\d+")) continue;
            arrayList.add(library);
        }
        return arrayList.toArray(new Library[arrayList.size()]);
    }

    public static String[] getServerInstances(File file, Library library) {
        if (library == null) {
            return new String[0];
        }
        String string = library.getName();
        Deployment deployment = Deployment.getDefault();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : deployment.getServerInstanceIDs()) {
            String string3;
            String string4 = PropertyUtils.getUsablePropertyName((String)deployment.getServerDisplayName(deployment.getServerID(string2)));
            if (!string.startsWith(string4) || !"".equals(string3 = string.substring(string4.length())) && !string3.matches("-\\d+")) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void switchServerLibrary(String string, String string2, List<ClassPathSupport.Item> list, UpdateHelper updateHelper) throws IOException {
        if (string != null && !string.equals(string2) && updateHelper.getAntProjectHelper().getLibrariesLocation() != null) {
            AntProjectHelper antProjectHelper = updateHelper.getAntProjectHelper();
            File file = antProjectHelper.resolveFile(antProjectHelper.getLibrariesLocation());
            HashSet<String> hashSet = new HashSet<String>();
            for (Library object2 : SharabilityUtility.getLibraries(file, string2)) {
                hashSet.add(object2.getName());
            }
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            Iterator<ClassPathSupport.Item> iterator = list.iterator();
            while (iterator.hasNext()) {
                ClassPathSupport.Item item = iterator.next();
                if (item.getType() == 1 && !item.isBroken() && item.getLibrary().getType().equals("serverlibrary") && hashSet.contains(item.getLibrary().getName())) {
                    iterator.remove();
                    bl = true;
                    n2 = n;
                }
                ++n;
            }
            if (bl) {
                Library library = SharabilityUtility.findOrCreateLibrary(file, string);
                boolean bl2 = true;
                for (ClassPathSupport.Item item : list) {
                    if (item.getType() != 1 || item.isBroken() || !item.getLibrary().getType().equals("serverlibrary") || !item.getLibrary().getName().equals(library.getName())) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    list.add(n2, ClassPathSupport.Item.create(library, null));
                }
            }
        }
    }

    public static boolean isLibrarySwitchIntended(String string, String string2, List<ClassPathSupport.Item> list, UpdateHelper updateHelper) throws IOException {
        boolean bl = false;
        if (string != null && !string.equals(string2) && updateHelper.getAntProjectHelper().getLibrariesLocation() != null) {
            AntProjectHelper antProjectHelper = updateHelper.getAntProjectHelper();
            File file = antProjectHelper.resolveFile(antProjectHelper.getLibrariesLocation());
            HashSet<String> hashSet = new HashSet<String>();
            for (Library library : SharabilityUtility.getLibraries(file, string2)) {
                hashSet.add(library.getName());
            }
            for (ClassPathSupport.Item item : list) {
                if (item.getType() != 1 || !item.getLibrary().getType().equals("serverlibrary") || !hashSet.contains(item.getLibrary().getName())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

