/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ParamTag;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.DocLocale;
import com.sun.tools.javadoc.ParamTagImpl;
import com.sun.tools.javadoc.SeeTagImpl;
import com.sun.tools.javadoc.SerialFieldTagImpl;
import com.sun.tools.javadoc.TagImpl;
import com.sun.tools.javadoc.ThrowsTagImpl;

class Comment {
    private final ListBuffer<Tag> tagList = new ListBuffer();
    private String text;
    private final DocEnv docenv;

    Comment(final DocImpl holder, final String commentString) {
        this.docenv = holder.env;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CommentStringParser {
            CommentStringParser() {
            }

            void parseCommentStateMachine() {
                boolean IN_TEXT = true;
                int TAG_GAP = 2;
                int TAG_NAME = 3;
                int state = 2;
                boolean newLine = true;
                String tagName = null;
                int tagStart = 0;
                int textStart = 0;
                int lastNonWhite = -1;
                int len = commentString.length();
                for (int inx = 0; inx < len; ++inx) {
                    char ch = commentString.charAt(inx);
                    boolean isWhite = Character.isWhitespace(ch);
                    switch (state) {
                        case 3: {
                            if (!isWhite) break;
                            tagName = commentString.substring(tagStart, inx);
                            state = 2;
                            break;
                        }
                        case 2: {
                            if (isWhite) break;
                            textStart = inx;
                            state = 1;
                        }
                        case 1: {
                            if (!newLine || ch != '@') break;
                            this.parseCommentComponent(tagName, textStart, lastNonWhite + 1);
                            tagStart = inx;
                            state = 3;
                        }
                    }
                    if (ch == '\n') {
                        newLine = true;
                        continue;
                    }
                    if (isWhite) continue;
                    lastNonWhite = inx;
                    newLine = false;
                }
                switch (state) {
                    case 3: {
                        tagName = commentString.substring(tagStart, len);
                    }
                    case 2: {
                        textStart = len;
                    }
                    case 1: {
                        this.parseCommentComponent(tagName, textStart, lastNonWhite + 1);
                    }
                }
            }

            void parseCommentComponent(String tagName, int from, int upto) {
                String tx;
                String string = tx = upto <= from ? "" : commentString.substring(from, upto);
                if (tagName == null) {
                    Comment.this.text = tx;
                } else {
                    TagImpl tag;
                    if (tagName.equals("@exception") || tagName.equals("@throws")) {
                        this.warnIfEmpty(tagName, tx);
                        tag = new ThrowsTagImpl(holder, tagName, tx);
                    } else if (tagName.equals("@param")) {
                        this.warnIfEmpty(tagName, tx);
                        tag = new ParamTagImpl(holder, tagName, tx);
                    } else if (tagName.equals("@see")) {
                        this.warnIfEmpty(tagName, tx);
                        tag = new SeeTagImpl(holder, tagName, tx);
                    } else if (tagName.equals("@serialField")) {
                        this.warnIfEmpty(tagName, tx);
                        tag = new SerialFieldTagImpl(holder, tagName, tx);
                    } else if (tagName.equals("@return")) {
                        this.warnIfEmpty(tagName, tx);
                        tag = new TagImpl(holder, tagName, tx);
                    } else if (tagName.equals("@author")) {
                        this.warnIfEmpty(tagName, tx);
                        tag = new TagImpl(holder, tagName, tx);
                    } else if (tagName.equals("@version")) {
                        this.warnIfEmpty(tagName, tx);
                        tag = new TagImpl(holder, tagName, tx);
                    } else {
                        tag = new TagImpl(holder, tagName, tx);
                    }
                    Comment.this.tagList.append(tag);
                }
            }

            void warnIfEmpty(String tagName, String tx) {
                if (tx.length() == 0) {
                    Comment.this.docenv.warning(holder, "tag.tag_has_no_arguments", tagName);
                }
            }
        }
        new CommentStringParser().parseCommentStateMachine();
    }

    String commentText() {
        return this.text;
    }

    Tag[] tags() {
        return this.tagList.toArray(new Tag[this.tagList.length()]);
    }

    Tag[] tags(String tagname) {
        ListBuffer<Tag> found = new ListBuffer<Tag>();
        String target = tagname;
        if (target.charAt(0) != '@') {
            target = "@" + target;
        }
        for (Tag tag : this.tagList) {
            if (!tag.kind().equals(target)) continue;
            found.append(tag);
        }
        return found.toArray(new Tag[found.length()]);
    }

    ThrowsTag[] throwsTags() {
        ListBuffer<ThrowsTag> found = new ListBuffer<ThrowsTag>();
        for (Tag next : this.tagList) {
            if (!(next instanceof ThrowsTag)) continue;
            found.append((ThrowsTag)next);
        }
        return found.toArray(new ThrowsTag[found.length()]);
    }

    ParamTag[] paramTags() {
        return this.paramTags(false);
    }

    ParamTag[] typeParamTags() {
        return this.paramTags(true);
    }

    private ParamTag[] paramTags(boolean typeParams) {
        ListBuffer<ParamTag> found = new ListBuffer<ParamTag>();
        for (Tag next : this.tagList) {
            ParamTag p;
            if (!(next instanceof ParamTag) || typeParams != (p = (ParamTag)next).isTypeParameter()) continue;
            found.append(p);
        }
        return found.toArray(new ParamTag[found.length()]);
    }

    SeeTag[] seeTags() {
        ListBuffer<SeeTag> found = new ListBuffer<SeeTag>();
        for (Tag next : this.tagList) {
            if (!(next instanceof SeeTag)) continue;
            found.append((SeeTag)next);
        }
        return found.toArray(new SeeTag[found.length()]);
    }

    SerialFieldTag[] serialFieldTags() {
        ListBuffer<SerialFieldTag> found = new ListBuffer<SerialFieldTag>();
        for (Tag next : this.tagList) {
            if (!(next instanceof SerialFieldTag)) continue;
            found.append((SerialFieldTag)next);
        }
        return found.toArray(new SerialFieldTag[found.length()]);
    }

    static Tag[] getInlineTags(DocImpl holder, String inlinetext) {
        ListBuffer<TagImpl> taglist = new ListBuffer<TagImpl>();
        int delimend = 0;
        int textstart = 0;
        int len = inlinetext.length();
        DocEnv docenv = holder.env;
        if (len == 0) {
            return taglist.toArray(new Tag[taglist.length()]);
        }
        do {
            int linkstart;
            if ((linkstart = Comment.inlineTagFound(holder, inlinetext, textstart)) == -1) {
                taglist.append(new TagImpl(holder, "Text", inlinetext.substring(textstart)));
                break;
            }
            int seetextstart = linkstart;
            for (int i = linkstart; i < inlinetext.length(); ++i) {
                char c = inlinetext.charAt(i);
                if (!Character.isWhitespace(c) && c != '}') continue;
                seetextstart = i;
                break;
            }
            String linkName = inlinetext.substring(linkstart + 2, seetextstart);
            while (Character.isWhitespace(inlinetext.charAt(seetextstart))) {
                if (inlinetext.length() <= seetextstart) {
                    taglist.append(new TagImpl(holder, "Text", inlinetext.substring(textstart, seetextstart)));
                    docenv.warning(holder, "tag.Improper_Use_Of_Link_Tag", inlinetext);
                    return taglist.toArray(new Tag[taglist.length()]);
                }
                ++seetextstart;
            }
            taglist.append(new TagImpl(holder, "Text", inlinetext.substring(textstart, linkstart)));
            textstart = seetextstart;
            delimend = Comment.findInlineTagDelim(inlinetext, textstart);
            if (delimend == -1) {
                taglist.append(new TagImpl(holder, "Text", inlinetext.substring(textstart)));
                docenv.warning(holder, "tag.End_delimiter_missing_for_possible_SeeTag", inlinetext);
                return taglist.toArray(new Tag[taglist.length()]);
            }
            if (linkName.equals("see") || linkName.equals("link") || linkName.equals("linkplain") || linkName.equals("value")) {
                taglist.append(new SeeTagImpl(holder, "@" + linkName, inlinetext.substring(textstart, delimend)));
                continue;
            }
            taglist.append(new TagImpl(holder, "@" + linkName, inlinetext.substring(textstart, delimend)));
        } while ((textstart = delimend + 1) != inlinetext.length());
        return taglist.toArray(new Tag[taglist.length()]);
    }

    private static int findInlineTagDelim(String inlineText, int searchStart) {
        int delimEnd = inlineText.indexOf("}", searchStart);
        if (delimEnd == -1) {
            return -1;
        }
        int nestedOpenBrace = inlineText.indexOf("{", searchStart);
        if (nestedOpenBrace != -1 && nestedOpenBrace < delimEnd) {
            int nestedCloseBrace = Comment.findInlineTagDelim(inlineText, nestedOpenBrace + 1);
            return nestedCloseBrace != -1 ? Comment.findInlineTagDelim(inlineText, nestedCloseBrace + 1) : -1;
        }
        return delimEnd;
    }

    private static int inlineTagFound(DocImpl holder, String inlinetext, int start) {
        int linkstart;
        DocEnv docenv = holder.env;
        if (start == inlinetext.length() || (linkstart = inlinetext.indexOf("{@", start)) == -1) {
            return -1;
        }
        if (inlinetext.indexOf(125, start) == -1) {
            docenv.warning(holder, "tag.Improper_Use_Of_Link_Tag", inlinetext.substring(linkstart, inlinetext.length()));
            return -1;
        }
        return linkstart;
    }

    static Tag[] firstSentenceTags(DocImpl holder, String text) {
        DocLocale doclocale = holder.env.doclocale;
        return Comment.getInlineTags(holder, doclocale.localeSpecificFirstSentence(holder, text));
    }

    public String toString() {
        return this.text;
    }
}

