/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.element.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flags {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICTFP = 2048;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int StandardFlags = 4095;
    public static final int ACC_SUPER = 32;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int DEPRECATED = 131072;
    public static final int HASINIT = 262144;
    public static final int BLOCK = 0x100000;
    public static final int IPROXY = 0x200000;
    public static final int NOOUTERTHIS = 0x400000;
    public static final int EXISTS = 0x800000;
    public static final int COMPOUND = 0x1000000;
    public static final int CLASS_SEEN = 0x2000000;
    public static final int SOURCE_SEEN = 0x4000000;
    public static final int LOCKED = 0x8000000;
    public static final int UNATTRIBUTED = 0x10000000;
    public static final int ANONCONSTR = 0x20000000;
    public static final int ACYCLIC = 0x40000000;
    public static final long BRIDGE = 0x80000000L;
    public static final long PARAMETER = 0x200000000L;
    public static final long VARARGS = 0x400000000L;
    public static final long ACYCLIC_ANN = 0x800000000L;
    public static final long GENERATEDCONSTR = 0x1000000000L;
    public static final long HYPOTHETICAL = 0x2000000000L;
    public static final long PROPRIETARY = 0x4000000000L;
    public static final long FROMCLASS = 0x8000000000L;
    public static final int AccessFlags = 7;
    public static final int LocalClassFlags = 23568;
    public static final int MemberClassFlags = 24087;
    public static final int ClassFlags = 32273;
    public static final int InterfaceVarFlags = 25;
    public static final int VarFlags = 16607;
    public static final int ConstructorFlags = 7;
    public static final int InterfaceMethodFlags = 1025;
    public static final int MethodFlags = 3391;
    public static final long LocalVarFlags = 0x200000010L;
    private static Map<Long, Set<Modifier>> modifierSets = new ConcurrentHashMap<Long, Set<Modifier>>(64);

    private Flags() {
    }

    public static String toString(long flags) {
        StringBuffer buf = new StringBuffer();
        if ((flags & 1L) != 0L) {
            buf.append("public ");
        }
        if ((flags & 2L) != 0L) {
            buf.append("private ");
        }
        if ((flags & 4L) != 0L) {
            buf.append("protected ");
        }
        if ((flags & 8L) != 0L) {
            buf.append("static ");
        }
        if ((flags & 0x10L) != 0L) {
            buf.append("final ");
        }
        if ((flags & 0x20L) != 0L) {
            buf.append("synchronized ");
        }
        if ((flags & 0x40L) != 0L) {
            buf.append("volatile ");
        }
        if ((flags & 0x80L) != 0L) {
            buf.append("transient ");
        }
        if ((flags & 0x100L) != 0L) {
            buf.append("native ");
        }
        if ((flags & 0x200L) != 0L) {
            buf.append("interface ");
        }
        if ((flags & 0x400L) != 0L) {
            buf.append("abstract ");
        }
        if ((flags & 0x800L) != 0L) {
            buf.append("strictfp ");
        }
        if ((flags & 0x80000000L) != 0L) {
            buf.append("bridge ");
        }
        if ((flags & 0x1000L) != 0L) {
            buf.append("synthetic ");
        }
        if ((flags & 0x20000L) != 0L) {
            buf.append("deprecated ");
        }
        if ((flags & 0x40000L) != 0L) {
            buf.append("hasinit ");
        }
        if ((flags & 0x4000L) != 0L) {
            buf.append("enum ");
        }
        if ((flags & 0x200000L) != 0L) {
            buf.append("iproxy ");
        }
        if ((flags & 0x400000L) != 0L) {
            buf.append("noouterthis ");
        }
        if ((flags & 0x800000L) != 0L) {
            buf.append("exists ");
        }
        if ((flags & 0x1000000L) != 0L) {
            buf.append("compound ");
        }
        if ((flags & 0x2000000L) != 0L) {
            buf.append("class_seen ");
        }
        if ((flags & 0x4000000L) != 0L) {
            buf.append("source_seen ");
        }
        if ((flags & 0x8000000L) != 0L) {
            buf.append("locked ");
        }
        if ((flags & 0x10000000L) != 0L) {
            buf.append("unattributed ");
        }
        if ((flags & 0x20000000L) != 0L) {
            buf.append("anonconstr ");
        }
        if ((flags & 0x40000000L) != 0L) {
            buf.append("acyclic ");
        }
        if ((flags & 0x200000000L) != 0L) {
            buf.append("parameter ");
        }
        if ((flags & 0x400000000L) != 0L) {
            buf.append("varargs ");
        }
        return buf.toString();
    }

    public static Set<Modifier> asModifierSet(long flags) {
        Set<Modifier> modifiers = modifierSets.get(flags);
        if (modifiers == null) {
            modifiers = EnumSet.noneOf(Modifier.class);
            if (0L != (flags & 1L)) {
                modifiers.add(Modifier.PUBLIC);
            }
            if (0L != (flags & 4L)) {
                modifiers.add(Modifier.PROTECTED);
            }
            if (0L != (flags & 2L)) {
                modifiers.add(Modifier.PRIVATE);
            }
            if (0L != (flags & 0x400L)) {
                modifiers.add(Modifier.ABSTRACT);
            }
            if (0L != (flags & 8L)) {
                modifiers.add(Modifier.STATIC);
            }
            if (0L != (flags & 0x10L)) {
                modifiers.add(Modifier.FINAL);
            }
            if (0L != (flags & 0x80L)) {
                modifiers.add(Modifier.TRANSIENT);
            }
            if (0L != (flags & 0x40L)) {
                modifiers.add(Modifier.VOLATILE);
            }
            if (0L != (flags & 0x20L)) {
                modifiers.add(Modifier.SYNCHRONIZED);
            }
            if (0L != (flags & 0x100L)) {
                modifiers.add(Modifier.NATIVE);
            }
            if (0L != (flags & 0x800L)) {
                modifiers.add(Modifier.STRICTFP);
            }
            modifiers = Collections.unmodifiableSet(modifiers);
            modifierSets.put(flags, modifiers);
        }
        return modifiers;
    }

    public static boolean isStatic(Symbol symbol) {
        return (symbol.flags() & 8L) != 0L;
    }

    public static boolean isEnum(Symbol symbol) {
        return (symbol.flags() & 0x4000L) != 0L;
    }

    public static boolean isConstant(Symbol.VarSymbol symbol) {
        return symbol.getConstValue() != null;
    }
}

