/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Table;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.util.EntityMethodGenerator;
import org.netbeans.modules.j2ee.persistence.util.JPAClassPathHelper;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPersistenceGenerator
implements PersistenceGenerator {
    private final Map<String, String> entityName2TableName = new HashMap<String, String>();
    private static boolean fieldAccess = true;
    private static boolean genNamedParams = true;
    private static boolean genSerializableEntities = true;
    private Set<FileObject> result;
    private final boolean addToAutoDiscoveredPU;
    private PersistenceUnit persistenceUnit;

    public JavaPersistenceGenerator() {
        this.persistenceUnit = null;
        this.addToAutoDiscoveredPU = true;
    }

    public JavaPersistenceGenerator(PersistenceUnit persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
        this.addToAutoDiscoveredPU = false;
    }

    @Override
    public void generateBeans(ProgressPanel progressPanel, RelatedCMPHelper relatedCMPHelper, FileObject fileObject, ProgressContributor progressContributor) throws IOException {
        this.generateBeans(relatedCMPHelper.getBeans(), relatedCMPHelper.isGenerateFinderMethods(), progressContributor, progressPanel);
    }

    void generateBeans(EntityClass[] entityClassArray, boolean bl, ProgressContributor progressContributor, ProgressPanel progressPanel) throws IOException {
        int n = entityClassArray.length * 2;
        progressContributor.start(n);
        this.result = new Generator(entityClassArray, bl, progressContributor, progressPanel).run();
        this.addToPersistenceUnit(this.result);
        progressContributor.progress(n);
    }

    private void addToPersistenceUnit(Set<FileObject> set) {
        if (set.isEmpty()) {
            return;
        }
        if (this.persistenceUnit == null && !this.addToAutoDiscoveredPU) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)set.iterator().next());
        if (project != null && !Util.isSupportedJavaEEVersion(project) && ProviderUtil.getDDFile(project) != null) {
            try {
                ClassPathProvider classPathProvider;
                PUDataObject pUDataObject = ProviderUtil.getPUDataObject(project);
                if (this.persistenceUnit == null && ((PersistenceUnit[])(classPathProvider = pUDataObject.getPersistence().getPersistenceUnit())).length == 1) {
                    this.persistenceUnit = classPathProvider[0];
                }
                if (this.persistenceUnit != null && (classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class)) != null) {
                    for (FileObject fileObject : set) {
                        String string = classPathProvider.findClassPath(fileObject, "classpath/source").getResourceName(fileObject, '.', false);
                        pUDataObject.addClass(this.persistenceUnit, string);
                    }
                }
            }
            catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
                Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.FINE, "Invalid persistence.xml: " + invalidPersistenceXmlException.getPath(), invalidPersistenceXmlException);
            }
        }
    }

    @Override
    public void init(WizardDescriptor wizardDescriptor) {
    }

    private void processEntities(Set<Entity> set) {
        for (Entity entity : set) {
            Table table = entity.getTable();
            if (table == null) continue;
            this.entityName2TableName.put(table.getName(), entity.getClass2());
        }
    }

    @Override
    public void uninit() {
    }

    @Override
    public String getFQClassName(String string) {
        return this.entityName2TableName.get(string);
    }

    @Override
    public String generateEntityName(String string) {
        return string;
    }

    @Override
    public Set<FileObject> createdObjects() {
        return this.result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Generator {
        private final ProgressPanel progressPanel;
        private final ProgressContributor progressContributor;
        private final Map<String, EntityClass> beanMap = new HashMap<String, EntityClass>();
        private final EntityClass[] entityClasses;
        private final boolean generateNamedQueries;
        private final Set<FileObject> generatedEntityFOs;
        private final Set<FileObject> generatedFOs;

        public Generator(EntityClass[] entityClassArray, boolean bl, ProgressContributor progressContributor, ProgressPanel progressPanel) {
            this.entityClasses = entityClassArray;
            this.generateNamedQueries = bl;
            this.progressContributor = progressContributor;
            this.progressPanel = progressPanel;
            this.generatedFOs = new HashSet<FileObject>();
            this.generatedEntityFOs = new HashSet<FileObject>();
        }

        public Set<FileObject> run() throws IOException {
            try {
                this.runImpl();
            }
            catch (IOException iOException) {
                for (FileObject fileObject : this.generatedFOs) {
                    fileObject.delete();
                }
                throw iOException;
            }
            return this.generatedEntityFOs;
        }

        public void runImpl() throws IOException {
            FileObject fileObject;
            Object object;
            FileObject fileObject2;
            String string;
            Object object2;
            String string2;
            EntityClass entityClass;
            int n;
            this.beanMap.clear();
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            HashSet<String> hashSet2 = new HashSet<String>();
            for (n = 0; n < this.entityClasses.length; ++n) {
                entityClass = this.entityClasses[n];
                string2 = entityClass.getClassName();
                object2 = entityClass.getPackageFileObject();
                this.beanMap.put(string2, entityClass);
                if (object2.getFileObject(string2, "java") != null) {
                    this.progressContributor.progress(n);
                    continue;
                }
                string = NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"TXT_GeneratingClass", (Object)string2);
                this.progressContributor.progress(string, n);
                if (this.progressPanel != null) {
                    this.progressPanel.setText(string);
                }
                hashSet.add((FileObject)object2);
                hashSet2.add(string2);
                fileObject2 = GenerationUtils.createClass((FileObject)object2, (String)string2, (String)NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_Javadoc_Class"));
                this.generatedEntityFOs.add(fileObject2);
                this.generatedFOs.add(fileObject2);
                if (entityClass.isUsePkField() || object2.getFileObject((String)(object = Generator.createPKClassName(string2)), "java") != null) continue;
                fileObject = GenerationUtils.createClass((FileObject)object2, (String)object, (String)NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_Javadoc_PKClass", (Object)object, (Object)string2));
                this.generatedFOs.add(fileObject);
            }
            for (n = 0; n < this.entityClasses.length; ++n) {
                Object object3;
                Object object4;
                Object object5;
                entityClass = this.entityClasses[n];
                string2 = entityClass.getClassName();
                if (!hashSet2.contains(string2)) {
                    this.progressContributor.progress(this.entityClasses.length + n);
                    continue;
                }
                object2 = NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"TXT_GeneratingClass", (Object)string2);
                this.progressContributor.progress((String)object2, this.entityClasses.length + n);
                if (this.progressPanel != null) {
                    this.progressPanel.setText((String)object2);
                }
                string = entityClass.getPackageFileObject();
                fileObject2 = string.getFileObject(string2, "java");
                object = string.getFileObject(Generator.createPKClassName(string2), "java");
                try {
                    fileObject = Generator.getAllClassPaths(hashSet, "classpath/boot");
                    object5 = Generator.getAllClassPaths(hashSet, "classpath/compile");
                    object4 = Generator.getAllClassPaths(hashSet, "classpath/source");
                    object3 = new JPAClassPathHelper((Set<ClassPath>)fileObject, (Set<ClassPath>)object5, (Set<ClassPath>)object4);
                    JavaSource javaSource = object != null ? JavaSource.create((ClasspathInfo)((JPAClassPathHelper)object3).createClasspathInfo(), (FileObject[])new FileObject[]{fileObject2, object}) : JavaSource.create((ClasspathInfo)((JPAClassPathHelper)object3).createClasspathInfo(), (FileObject[])new FileObject[]{fileObject2});
                    javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                        public void run(WorkingCopy workingCopy) throws IOException {
                            if (workingCopy.getFileObject().equals(fileObject2)) {
                                new EntityClassGenerator(workingCopy, entityClass, Generator.this.generateNamedQueries).run();
                            } else {
                                new PKClassGenerator(workingCopy, entityClass).run();
                            }
                        }
                    }).commit();
                    continue;
                }
                catch (IOException iOException) {
                    object5 = iOException.getMessage();
                    object4 = object5 == null ? NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"ERR_GeneratingClass_NoExceptionMessage", (Object)string2) : NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"ERR_GeneratingClass", (Object)string2, (Object)object5);
                    object3 = new IOException((String)object4);
                    ((Throwable)object3).initCause(iOException);
                    throw object3;
                }
            }
        }

        private static String createPKClassName(String string) {
            return string + "PK";
        }

        private static Set<ClassPath> getAllClassPaths(Set<FileObject> set, String string) {
            HashSet<ClassPath> hashSet = new HashSet<ClassPath>();
            for (FileObject fileObject : set) {
                hashSet.add(ClassPath.getClassPath((FileObject)fileObject, (String)string));
            }
            return hashSet;
        }

        private final class PKClassGenerator
        extends ClassGenerator {
            public PKClassGenerator(WorkingCopy workingCopy, EntityClass entityClass) throws IOException {
                super(workingCopy, entityClass);
            }

            protected void initialize() throws IOException {
                this.newClassTree = this.genUtils.ensureNoArgConstructor(this.newClassTree);
                this.newClassTree = this.genUtils.addImplementsClause(this.newClassTree, "java.io.Serializable");
                this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.persistence.Embeddable"));
            }

            protected void generateMember(EntityMember entityMember) throws IOException {
                if (!entityMember.isPrimaryKey()) {
                    return;
                }
                ClassGenerator.Property property = this.createProperty(entityMember);
                this.properties.add(property);
            }

            protected void afterMembersGenerated() {
            }

            protected void generateRelationship(RelationshipRole relationshipRole) {
            }

            protected void finish() {
                ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>(this.properties.size());
                for (ClassGenerator.Property property : this.properties) {
                    arrayList.add(this.genUtils.removeModifiers(property.getField()));
                }
                this.constructors.add(this.genUtils.createAssignmentConstructor(this.genUtils.createModifiers(Modifier.PUBLIC), this.pkClassName, arrayList));
                EntityMethodGenerator entityMethodGenerator = new EntityMethodGenerator(this.copy, this.genUtils, this.typeElement);
                this.methods.add(entityMethodGenerator.createHashCodeMethod(arrayList));
                this.methods.add(entityMethodGenerator.createEqualsMethod(this.pkClassName, arrayList));
                this.methods.add(entityMethodGenerator.createToStringMethod(this.pkFQClassName, arrayList));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class EntityClassGenerator
        extends ClassGenerator {
            private final String entityClassName;
            private final String entityFQClassName;
            private final List<ClassGenerator.Property> nonNullableProps;
            private final List<String> pkColumnNames;
            private final List<VariableTree> pkClassVariables;
            private final List<ExpressionTree> namedQueryAnnotations;
            private final boolean generateNamedQueries;
            private ClassGenerator.Property pkProperty;
            private String namedQueryPrefix;

            public EntityClassGenerator(WorkingCopy workingCopy, EntityClass entityClass, boolean bl) throws IOException {
                super(workingCopy, entityClass);
                this.nonNullableProps = new ArrayList<ClassGenerator.Property>();
                this.pkColumnNames = new ArrayList<String>();
                this.pkClassVariables = new ArrayList<VariableTree>();
                this.namedQueryAnnotations = new ArrayList<ExpressionTree>();
                this.generateNamedQueries = bl;
                this.entityClassName = entityClass.getClassName();
                assert (this.typeElement.getSimpleName().contentEquals(this.entityClassName));
                this.entityFQClassName = entityClass.getPackage() + "." + this.entityClassName;
            }

            @Override
            protected void initialize() throws IOException {
                this.newClassTree = this.genUtils.ensureNoArgConstructor(this.newClassTree);
                if (genSerializableEntities) {
                    this.newClassTree = this.genUtils.addImplementsClause(this.newClassTree, "java.io.Serializable");
                }
                this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.persistence.Entity"));
                ExpressionTree expressionTree = this.genUtils.createAnnotationArgument("name", (Object)this.dbMappings.getTableName());
                this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.persistence.Table", Collections.singletonList(expressionTree)));
                if (this.needsPKClass) {
                    String string = this.createFieldName(this.pkClassName);
                    this.pkProperty = (ClassGenerator)this.new ClassGenerator.Property(Modifier.PROTECTED, Collections.singletonList(this.genUtils.createAnnotation("javax.persistence.EmbeddedId")), this.pkFQClassName, string);
                    this.properties.add(this.pkProperty);
                }
            }

            @Override
            protected void generateMember(EntityMember entityMember) throws IOException {
                Object object;
                String string = entityMember.getMemberName();
                boolean bl = entityMember.isPrimaryKey();
                ClassGenerator.Property property = null;
                if (bl) {
                    if (this.needsPKClass) {
                        this.pkClassVariables.add(this.createVariable(entityMember));
                    } else {
                        this.pkProperty = property = this.createProperty(entityMember);
                    }
                    object = (String)this.dbMappings.getCMPFieldMapping().get(string);
                    this.pkColumnNames.add((String)object);
                } else {
                    property = this.createProperty(entityMember);
                    if (!entityMember.isNullable()) {
                        this.nonNullableProps.add(property);
                    }
                }
                assert (property != null || property == null && bl && this.needsPKClass);
                if (property != null) {
                    this.properties.add(property);
                }
                if (this.generateNamedQueries && !entityMember.isLobType()) {
                    object = new ArrayList();
                    object.add(this.genUtils.createAnnotationArgument("name", (Object)(this.entityClassName + ".findBy" + this.createCapitalizedFieldName(string))));
                    if (this.namedQueryPrefix == null) {
                        char c = this.entityClassName.toLowerCase().charAt(0);
                        this.namedQueryPrefix = "SELECT " + c + " FROM " + this.entityClassName + " " + c + " WHERE " + c + ".";
                    }
                    String string2 = this.needsPKClass && bl ? this.pkProperty.getField().getName().toString() + "." + string : string;
                    object.add(this.genUtils.createAnnotationArgument("query", (Object)(this.namedQueryPrefix + string2 + (genNamedParams ? " = :" + string : "= ?1"))));
                    this.namedQueryAnnotations.add(this.genUtils.createAnnotation("javax.persistence.NamedQuery", (List)object));
                }
            }

            @Override
            protected void afterMembersGenerated() {
                this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.persistence.NamedQueries", Collections.singletonList(this.genUtils.createAnnotationArgument(null, this.namedQueryAnnotations))));
            }

            @Override
            protected void generateRelationship(RelationshipRole relationshipRole) throws IOException {
                Object object;
                Object object2;
                String string = relationshipRole.getFieldName();
                String string2 = this.getRelationshipFieldType(relationshipRole, this.entityClass.getPackage());
                TypeMirror typeMirror = this.copy.getElements().getTypeElement(string2).asType();
                if (relationshipRole.isToMany()) {
                    object2 = this.copy.getElements().getTypeElement("java.util.Collection");
                    typeMirror = this.copy.getTypes().getDeclaredType((TypeElement)object2, typeMirror);
                }
                object2 = new ArrayList();
                ArrayList<ExpressionTree> arrayList = new ArrayList<ExpressionTree>();
                if (relationshipRole.isCascade()) {
                    arrayList.add(this.genUtils.createAnnotationArgument("cascade", "javax.persistence.CascadeType", "ALL"));
                }
                if (relationshipRole.equals(relationshipRole.getParent().getRoleB())) {
                    arrayList.add(this.genUtils.createAnnotationArgument("mappedBy", (Object)relationshipRole.getParent().getRoleA().getFieldName()));
                } else if (relationshipRole.isMany() && relationshipRole.isToMany()) {
                    String[] stringArray;
                    object = new ArrayList();
                    object.add(this.genUtils.createAnnotationArgument("name", (Object)((String)this.dbMappings.getJoinTableMapping().get(relationshipRole.getFieldName()))));
                    CMPMappingModel.JoinTableColumnMapping joinTableColumnMapping = this.dbMappings.getJoinTableColumnMppings().get(relationshipRole.getFieldName());
                    ArrayList<AnnotationTree> arrayList2 = new ArrayList<AnnotationTree>();
                    String[] stringArray2 = joinTableColumnMapping.getColumns();
                    String[] stringArray3 = joinTableColumnMapping.getReferencedColumns();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringArray = new ArrayList();
                        stringArray.add(this.genUtils.createAnnotationArgument("name", (Object)stringArray2[i]));
                        stringArray.add(this.genUtils.createAnnotationArgument("referencedColumnName", (Object)stringArray3[i]));
                        arrayList2.add(this.genUtils.createAnnotation("javax.persistence.JoinColumn", (List)stringArray));
                    }
                    object.add(this.genUtils.createAnnotationArgument("joinColumns", arrayList2));
                    ArrayList<AnnotationTree> arrayList3 = new ArrayList<AnnotationTree>();
                    stringArray = joinTableColumnMapping.getInverseColumns();
                    String[] stringArray4 = joinTableColumnMapping.getReferencedInverseColumns();
                    for (int i = 0; i < stringArray.length; ++i) {
                        ArrayList<ExpressionTree> arrayList4 = new ArrayList<ExpressionTree>();
                        arrayList4.add(this.genUtils.createAnnotationArgument("name", (Object)stringArray[i]));
                        arrayList4.add(this.genUtils.createAnnotationArgument("referencedColumnName", (Object)stringArray4[i]));
                        arrayList3.add(this.genUtils.createAnnotation("javax.persistence.JoinColumn", arrayList4));
                    }
                    object.add(this.genUtils.createAnnotationArgument("inverseJoinColumns", arrayList3));
                    object2.add(this.genUtils.createAnnotation("javax.persistence.JoinTable", (List)object));
                } else {
                    object = (String[])this.dbMappings.getCmrFieldMapping().get(relationshipRole.getFieldName());
                    CMPMappingModel cMPMappingModel = ((EntityClass)Generator.this.beanMap.get(relationshipRole.getParent().getRoleB().getEntityName())).getCMPMapping();
                    String[] stringArray = (String[])cMPMappingModel.getCmrFieldMapping().get(relationshipRole.getParent().getRoleB().getFieldName());
                    if (((String[])object).length == 1) {
                        ArrayList<ExpressionTree> arrayList5 = new ArrayList<ExpressionTree>();
                        arrayList5.add(this.genUtils.createAnnotationArgument("name", (Object)object[0]));
                        arrayList5.add(this.genUtils.createAnnotationArgument("referencedColumnName", (Object)stringArray[0]));
                        this.makeReadOnlyIfNecessary(this.pkColumnNames, (String)object[0], arrayList5);
                        object2.add(this.genUtils.createAnnotation("javax.persistence.JoinColumn", arrayList5));
                    } else {
                        Object object3;
                        ArrayList<AnnotationTree> arrayList6 = new ArrayList<AnnotationTree>();
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            object3 = new ArrayList<ExpressionTree>();
                            object3.add(this.genUtils.createAnnotationArgument("name", object[i]));
                            object3.add(this.genUtils.createAnnotationArgument("referencedColumnName", (Object)stringArray[i]));
                            this.makeReadOnlyIfNecessary(this.pkColumnNames, (String)object[i], (List<ExpressionTree>)object3);
                            arrayList6.add(this.genUtils.createAnnotation("javax.persistence.JoinColumn", (List)object3));
                        }
                        ExpressionTree expressionTree = this.genUtils.createAnnotationArgument(null, arrayList6);
                        object3 = this.genUtils.createAnnotation("javax.persistence.JoinColumns", Collections.singletonList(expressionTree));
                        object2.add(object3);
                    }
                }
                object = relationshipRole.isMany() && relationshipRole.isToMany() ? "ManyToMany" : (relationshipRole.isMany() ? "ManyToOne" : (relationshipRole.isToMany() ? "OneToMany" : "OneToOne"));
                object2.add(this.genUtils.createAnnotation("javax.persistence." + (String)object, arrayList));
                this.properties.add((ClassGenerator)this.new ClassGenerator.Property(Modifier.PRIVATE, (List<AnnotationTree>)object2, typeMirror, string));
            }

            private VariableTree createSerialVersionUID() {
                HashSet<Modifier> hashSet = new HashSet<Modifier>();
                hashSet.add(Modifier.PRIVATE);
                hashSet.add(Modifier.STATIC);
                hashSet.add(Modifier.FINAL);
                TreeMaker treeMaker = this.copy.getTreeMaker();
                VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(hashSet), (CharSequence)"serialVersionUID", this.genUtils.createType("long", this.typeElement), (ExpressionTree)treeMaker.Literal((Object)Long.valueOf("1")));
                return variableTree;
            }

            @Override
            protected void finish() {
                Object object;
                VariableTree variableTree = this.genUtils.removeModifiers(this.pkProperty.getField());
                List<VariableTree> list = Collections.singletonList(variableTree);
                this.constructors.add(this.genUtils.createAssignmentConstructor(this.genUtils.createModifiers(Modifier.PUBLIC), this.entityClassName, list));
                if (this.nonNullableProps.size() > 0) {
                    object = new ArrayList<VariableTree>(this.nonNullableProps.size() + 1);
                    object.add(variableTree);
                    for (ClassGenerator.Property property : this.nonNullableProps) {
                        object.add(this.genUtils.removeModifiers(property.getField()));
                    }
                    this.constructors.add(this.genUtils.createAssignmentConstructor(this.genUtils.createModifiers(Modifier.PUBLIC), this.entityClassName, (List)object));
                }
                if (this.pkClassVariables.size() > 0) {
                    object = new StringBuilder(30 + 30 * this.pkClassVariables.size());
                    ((StringBuilder)object).append("{");
                    ((StringBuilder)object).append("this." + this.pkProperty.getField().getName() + " = new " + this.pkClassName + "(");
                    Iterator<Object> iterator = this.pkClassVariables.iterator();
                    while (iterator.hasNext()) {
                        ((StringBuilder)object).append(((VariableTree)iterator.next()).getName());
                        ((StringBuilder)object).append(iterator.hasNext() ? ", " : ");");
                    }
                    ((StringBuilder)object).append("}");
                    iterator = this.copy.getTreeMaker();
                    this.constructors.add(iterator.Constructor(iterator.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.emptyList()), Collections.emptyList(), this.pkClassVariables, Collections.emptyList(), ((StringBuilder)object).toString()));
                }
                object = new EntityMethodGenerator(this.copy, this.genUtils, this.typeElement);
                this.methods.add(((EntityMethodGenerator)object).createHashCodeMethod(list));
                this.methods.add(((EntityMethodGenerator)object).createEqualsMethod(this.entityClassName, list));
                this.methods.add(((EntityMethodGenerator)object).createToStringMethod(this.entityFQClassName, list));
                this.fields.add(this.createSerialVersionUID());
            }

            private String getRelationshipFieldType(RelationshipRole relationshipRole, String string) {
                RelationshipRole relationshipRole2 = relationshipRole.getParent().getRoleA();
                RelationshipRole relationshipRole3 = relationshipRole.getParent().getRoleB();
                RelationshipRole relationshipRole4 = relationshipRole.equals(relationshipRole2) ? relationshipRole3 : relationshipRole2;
                return string.length() == 0 ? relationshipRole4.getEntityName() : string + "." + relationshipRole4.getEntityName();
            }

            private void makeReadOnlyIfNecessary(List<String> list, String string, List<ExpressionTree> list2) {
                if (list.contains(string)) {
                    list2.add(this.genUtils.createAnnotationArgument("insertable", (Object)false));
                    list2.add(this.genUtils.createAnnotationArgument("updatable", (Object)false));
                }
            }
        }

        private abstract class ClassGenerator {
            protected final WorkingCopy copy;
            protected final GenerationUtils genUtils;
            protected final EntityClass entityClass;
            protected final CMPMappingModel dbMappings;
            protected final boolean needsPKClass;
            protected final String pkClassName;
            protected final String pkFQClassName;
            protected final List<Property> properties = new ArrayList<Property>();
            protected final List<MethodTree> methods = new ArrayList<MethodTree>();
            protected final List<MethodTree> constructors = new ArrayList<MethodTree>();
            protected final List<VariableTree> fields = new ArrayList<VariableTree>();
            protected ClassTree originalClassTree;
            protected ClassTree newClassTree;
            protected TypeElement typeElement;

            public ClassGenerator(WorkingCopy workingCopy, EntityClass entityClass) throws IOException {
                this.copy = workingCopy;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                this.entityClass = entityClass;
                this.dbMappings = entityClass.getCMPMapping();
                this.needsPKClass = !entityClass.isUsePkField();
                this.pkClassName = this.needsPKClass ? Generator.createPKClassName(entityClass.getClassName()) : null;
                this.pkFQClassName = entityClass.getPackage() + "." + this.pkClassName;
                this.typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                if (this.typeElement == null) {
                    throw new IllegalStateException("Cannot find a public top-level class named " + entityClass.getClassName() + " in " + FileUtil.getFileDisplayName((FileObject)workingCopy.getFileObject()));
                }
                this.originalClassTree = workingCopy.getTrees().getTree(this.typeElement);
                assert (this.originalClassTree != null);
                this.newClassTree = this.originalClassTree;
                this.genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
            }

            protected String createFieldName(String string) {
                return this.createFieldNameImpl(string, false);
            }

            protected String createCapitalizedFieldName(String string) {
                return this.createFieldNameImpl(string, true);
            }

            private String createFieldNameImpl(String string, boolean bl) {
                StringBuffer stringBuffer = new StringBuffer(string);
                char c = stringBuffer.charAt(0);
                stringBuffer.setCharAt(0, bl ? Character.toUpperCase(c) : Character.toLowerCase(c));
                return stringBuffer.toString();
            }

            protected Property createProperty(EntityMember entityMember) throws IOException {
                boolean bl;
                boolean bl2 = entityMember.isPrimaryKey();
                ArrayList<AnnotationTree> arrayList = new ArrayList<AnnotationTree>();
                if (bl2 && !this.needsPKClass) {
                    arrayList.add(this.genUtils.createAnnotation("javax.persistence.Id"));
                }
                if (bl = entityMember.isLobType()) {
                    arrayList.add(this.genUtils.createAnnotation("javax.persistence.Lob"));
                }
                ArrayList<ExpressionTree> arrayList2 = new ArrayList<ExpressionTree>();
                String string = entityMember.getMemberName();
                String string2 = (String)this.dbMappings.getCMPFieldMapping().get(string);
                arrayList2.add(this.genUtils.createAnnotationArgument("name", (Object)string2));
                if (!entityMember.isNullable()) {
                    arrayList2.add(this.genUtils.createAnnotationArgument("nullable", (Object)false));
                }
                arrayList.add(this.genUtils.createAnnotation("javax.persistence.Column", arrayList2));
                String string3 = this.getMemberTemporalType(entityMember);
                if (string3 != null) {
                    ExpressionTree expressionTree = this.genUtils.createAnnotationArgument(null, "javax.persistence.TemporalType", string3);
                    arrayList.add(this.genUtils.createAnnotation("javax.persistence.Temporal", Collections.singletonList(expressionTree)));
                }
                return new Property(Modifier.PRIVATE, arrayList, this.getMemberType(entityMember), string);
            }

            protected VariableTree createVariable(EntityMember entityMember) {
                return this.genUtils.createVariable(this.typeElement, entityMember.getMemberName(), this.getMemberType(entityMember));
            }

            private String getMemberType(EntityMember entityMember) {
                String string = entityMember.getMemberType();
                if ("java.sql.Date".equals(string)) {
                    string = "java.util.Date";
                } else if ("java.sql.Time".equals(string)) {
                    string = "java.util.Date";
                } else if ("java.sql.Timestamp".equals(string)) {
                    string = "java.util.Date";
                }
                return string;
            }

            private String getMemberTemporalType(EntityMember entityMember) {
                String string = entityMember.getMemberType();
                String string2 = null;
                if ("java.sql.Date".equals(string)) {
                    string2 = "DATE";
                } else if ("java.sql.Time".equals(string)) {
                    string2 = "TIME";
                } else if ("java.sql.Timestamp".equals(string)) {
                    string2 = "TIMESTAMP";
                }
                return string2;
            }

            /*
             * WARNING - void declaration
             */
            public void run() throws IOException {
                this.initialize();
                for (EntityMember object : this.entityClass.getFields()) {
                    this.generateMember(object);
                }
                this.afterMembersGenerated();
                for (RelationshipRole relationshipRole : this.entityClass.getRoles()) {
                    this.generateRelationship(relationshipRole);
                }
                this.finish();
                Iterator<Object> iterator = this.copy.getTreeMaker();
                boolean bl = false;
                for (VariableTree variableTree : this.fields) {
                    void var2_6;
                    this.newClassTree = iterator.insertClassMember(this.newClassTree, (int)var2_6, variableTree);
                    ++var2_6;
                }
                for (Property property : this.properties) {
                    void var2_7;
                    this.newClassTree = iterator.insertClassMember(this.newClassTree, (int)var2_7, property.getField());
                    ++var2_7;
                }
                for (MethodTree methodTree : this.constructors) {
                    this.newClassTree = iterator.addClassMember(this.newClassTree, methodTree);
                }
                for (Property property : this.properties) {
                    this.newClassTree = iterator.addClassMember(this.newClassTree, property.getGetter());
                    this.newClassTree = iterator.addClassMember(this.newClassTree, property.getSetter());
                }
                for (MethodTree methodTree : this.methods) {
                    this.newClassTree = iterator.addClassMember(this.newClassTree, methodTree);
                }
                this.copy.rewrite((Tree)this.originalClassTree, (Tree)this.newClassTree);
            }

            protected abstract void initialize() throws IOException;

            protected abstract void generateMember(EntityMember var1) throws IOException;

            protected abstract void afterMembersGenerated() throws IOException;

            protected abstract void generateRelationship(RelationshipRole var1) throws IOException;

            protected abstract void finish() throws IOException;

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected final class Property {
                private final VariableTree field;
                private final MethodTree getter;
                private final MethodTree setter;

                public Property(Modifier modifier, List<AnnotationTree> list, String string, String string2) throws IOException {
                    this(modifier, list, classGenerator.genUtils.createType(string, classGenerator.typeElement), string2);
                }

                public Property(Modifier modifier, List<AnnotationTree> list, TypeMirror typeMirror, String string) throws IOException {
                    this(modifier, list, classGenerator.copy.getTreeMaker().Type(typeMirror), string);
                }

                private Property(Modifier modifier, List<AnnotationTree> list, Tree tree, String string) throws IOException {
                    TreeMaker treeMaker = ClassGenerator.this.copy.getTreeMaker();
                    this.field = treeMaker.Variable(treeMaker.Modifiers(EnumSet.of(modifier), fieldAccess ? list : Collections.emptyList()), (CharSequence)string, tree, null);
                    this.getter = ClassGenerator.this.genUtils.createPropertyGetterMethod(treeMaker.Modifiers(EnumSet.of(Modifier.PUBLIC), fieldAccess ? Collections.emptyList() : list), string, tree);
                    this.setter = ClassGenerator.this.genUtils.createPropertySetterMethod(ClassGenerator.this.genUtils.createModifiers(Modifier.PUBLIC), string, tree);
                }

                public VariableTree getField() {
                    return this.field;
                }

                public MethodTree getGetter() {
                    return this.getter;
                }

                public MethodTree getSetter() {
                    return this.setter;
                }
            }
        }
    }
}

