/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.moduleinfo.JPAModuleInfo;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.entity.WrapperPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Util {
    public static void changeLabelInComponent(JComponent jComponent, String string, String string2) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setText(string2);
        }
    }

    public static void hideLabelAndLabelFor(JComponent jComponent, String string) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setVisible(false);
            Component component = jLabel.getLabelFor();
            if (component != null) {
                component.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] componentArray, Collection collection) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            collection.add(componentArray[i]);
            if (((Container)componentArray[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)componentArray[i]).getComponents(), collection);
        }
    }

    public static JLabel findLabel(JComponent jComponent, String string) {
        Vector vector = new Vector();
        Util.getAllComponents(jComponent.getComponents(), vector);
        for (Component component : vector) {
            JLabel jLabel;
            if (!(component instanceof JLabel) || !(jLabel = (JLabel)component).getText().equals(string)) continue;
            return jLabel;
        }
        return null;
    }

    public static SourceGroup getClassSourceGroup(Project project, String string) {
        SourceGroup[] sourceGroupArray;
        String string2 = string.replace('.', '/') + ".java";
        for (SourceGroup sourceGroup : sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject fileObject = sourceGroup.getRootFolder().getFileObject(string2);
            if (fileObject == null) continue;
            return sourceGroup;
        }
        return null;
    }

    private static List getFileObjects(URL[] uRLArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < uRLArray.length; ++i) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[i]);
            if (fileObject != null) {
                arrayList.add(fileObject);
                continue;
            }
            if (!Logger.getLogger("global").isLoggable(Level.FINE)) continue;
            Logger.getLogger("global").log(Level.FINE, null, new IllegalStateException("No FileObject found for the following URL: " + uRLArray[i]));
        }
        return arrayList;
    }

    public static ClassPath getFullClasspath(FileObject fileObject) {
        int n;
        FileObject[] fileObjectArray = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getRoots();
        FileObject[] fileObjectArray2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot").getRoots();
        FileObject[] fileObjectArray3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile").getRoots();
        FileObject[] fileObjectArray4 = new FileObject[fileObjectArray.length + fileObjectArray2.length + fileObjectArray3.length];
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObjectArray4[n] = fileObjectArray[n];
        }
        for (n = 0; n < fileObjectArray2.length; ++n) {
            fileObjectArray4[fileObjectArray.length + n] = fileObjectArray2[n];
        }
        for (n = 0; n < fileObjectArray3.length; ++n) {
            fileObjectArray4[fileObjectArray.length + fileObjectArray2.length + n] = fileObjectArray3[n];
        }
        return ClassPathSupport.createClassPath((FileObject[])fileObjectArray4);
    }

    public static boolean isSupportedJavaEEVersion(Project project) {
        JPAModuleInfo jPAModuleInfo = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        if (jPAModuleInfo == null) {
            return false;
        }
        if (JPAModuleInfo.ModuleType.EJB == jPAModuleInfo.getType() && "3.0".equals(jPAModuleInfo.getVersion())) {
            return true;
        }
        return JPAModuleInfo.ModuleType.WEB == jPAModuleInfo.getType() && "2.5".equals(jPAModuleInfo.getVersion());
    }

    public static boolean isEjbModule(Project project) {
        JPAModuleInfo jPAModuleInfo = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        if (jPAModuleInfo == null) {
            return false;
        }
        return JPAModuleInfo.ModuleType.EJB == jPAModuleInfo.getType();
    }

    public static boolean isEjb21Module(Project project) {
        JPAModuleInfo jPAModuleInfo = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        if (jPAModuleInfo == null) {
            return false;
        }
        return JPAModuleInfo.ModuleType.EJB == jPAModuleInfo.getType() && "2.1".equals(jPAModuleInfo.getVersion());
    }

    public static boolean isJavaSE(Project project) {
        return project.getLookup().lookup(JPAModuleInfo.class) == null;
    }

    public static PersistenceUnit buildPersistenceUnitUsingWizard(Project project, String string, PersistenceUnitWizardPanel.TableGeneration tableGeneration) {
        Object object;
        boolean bl = Util.isSupportedJavaEEVersion(project);
        PersistenceUnitWizardPanel persistenceUnitWizardPanel = bl ? new PersistenceUnitWizardPanelDS(project, null, true, tableGeneration) : new PersistenceUnitWizardPanelJdbc(project, null, true, tableGeneration);
        if (string != null) {
            persistenceUnitWizardPanel.setPreselectedDB(string);
        }
        final JButton jButton = new JButton(NbBundle.getMessage(Util.class, (String)"LBL_CreatePersistenceUnitButton"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Util.class, (String)"ACSD_CreatePersistenceUnitButton"));
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new WrapperPanel(persistenceUnitWizardPanel), NbBundle.getMessage(Util.class, (String)"LBL_CreatePersistenceUnit"), true, objectArray, DialogDescriptor.OK_OPTION, 0, null, null);
        persistenceUnitWizardPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                    dialogDescriptor.setValid(((Boolean)object).booleanValue());
                    jButton.setEnabled((Boolean)object);
                }
            }
        });
        if (!persistenceUnitWizardPanel.isValidPanel()) {
            dialogDescriptor.setValid(false);
            jButton.setEnabled(false);
        }
        if ((object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor)) == jButton) {
            PersistenceUnit persistenceUnit = new PersistenceUnit();
            if (bl) {
                PersistenceUnitWizardPanelDS persistenceUnitWizardPanelDS = (PersistenceUnitWizardPanelDS)persistenceUnitWizardPanel;
                if (persistenceUnitWizardPanelDS.getDatasource() != null && !"".equals(persistenceUnitWizardPanelDS.getDatasource().trim())) {
                    if (persistenceUnitWizardPanelDS.isJTA()) {
                        persistenceUnit.setJtaDataSource(persistenceUnitWizardPanelDS.getDatasource());
                    } else {
                        if (persistenceUnitWizardPanelDS.isNonDefaultProviderEnabled()) {
                            persistenceUnit.setNonJtaDataSource(persistenceUnitWizardPanelDS.getDatasource());
                        }
                        persistenceUnit.setTransactionType("RESOURCE_LOCAL");
                    }
                }
                if (persistenceUnitWizardPanelDS.isNonDefaultProviderEnabled()) {
                    persistenceUnit.setProvider(persistenceUnitWizardPanelDS.getNonDefaultProvider());
                }
            } else {
                PersistenceUnitWizardPanelJdbc persistenceUnitWizardPanelJdbc = (PersistenceUnitWizardPanelJdbc)persistenceUnitWizardPanel;
                persistenceUnit = ProviderUtil.buildPersistenceUnit(persistenceUnitWizardPanelJdbc.getPersistenceUnitName(), persistenceUnitWizardPanelJdbc.getSelectedProvider(), persistenceUnitWizardPanelJdbc.getPersistenceConnection());
                persistenceUnit.setTransactionType("RESOURCE_LOCAL");
                if (persistenceUnitWizardPanelJdbc.getPersistenceLibrary() != null) {
                    Util.addLibraryToProject(project, persistenceUnitWizardPanelJdbc.getPersistenceLibrary());
                }
            }
            persistenceUnit.setName(persistenceUnitWizardPanel.getPersistenceUnitName());
            ProviderUtil.setTableGeneration(persistenceUnit, persistenceUnitWizardPanel.getTableGeneration(), project);
            return persistenceUnit;
        }
        return null;
    }

    public static boolean createPersistenceUnitUsingWizard(Project project, String string, PersistenceUnitWizardPanel.TableGeneration tableGeneration) throws InvalidPersistenceXmlException {
        PersistenceUnit persistenceUnit = Util.buildPersistenceUnitUsingWizard(project, string, tableGeneration);
        if (persistenceUnit == null) {
            return false;
        }
        PUDataObject pUDataObject = ProviderUtil.getPUDataObject(project);
        if (pUDataObject == null) {
            return false;
        }
        pUDataObject.addPersistenceUnit(persistenceUnit);
        pUDataObject.save();
        return true;
    }

    public static boolean createPersistenceUnitUsingWizard(Project project, String string) throws InvalidPersistenceXmlException {
        return Util.createPersistenceUnitUsingWizard(project, string, PersistenceUnitWizardPanel.TableGeneration.CREATE);
    }

    public static void addLibraryToProject(Project project, Library library) {
        ProjectClassPathExtender projectClassPathExtender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
        if (projectClassPathExtender != null) {
            try {
                projectClassPathExtender.addLibrary(library);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

