/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Properties;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Property;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourcePopulator;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.unit.AddEntityDialog;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceValidator;
import org.netbeans.modules.j2ee.persistence.util.PersistenceProviderComboboxHelper;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.JdbcListCellRenderer;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PersistenceUnitPanel
extends SectionInnerPanel {
    private final PersistenceUnit persistenceUnit;
    private PUDataObject dObj;
    private Project project;
    private boolean isContainerManaged;
    private JButton addClassButton;
    private ButtonGroup buttonGroup2;
    private JLabel datasourceLabel;
    private JRadioButton ddCreate;
    private JRadioButton ddDropCreate;
    private JRadioButton ddUnknown;
    private JComboBox dsCombo;
    private JList entityList;
    private JCheckBox includeAllEntities;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane2;
    private JComboBox jdbcComboBox;
    private JLabel jdbcLabel;
    private JCheckBox jtaCheckBox;
    private JComboBox libraryComboBox;
    private JLabel libraryLabel;
    private JTextField nameTextField;
    private JComboBox providerCombo;
    private JButton removeClassButton;
    private JLabel tableGenerationLabel;

    public PersistenceUnitPanel(SectionView sectionView, PUDataObject pUDataObject, PersistenceUnit persistenceUnit) {
        super(sectionView);
        this.dObj = pUDataObject;
        this.persistenceUnit = persistenceUnit;
        this.project = FileOwnerQuery.getOwner((FileObject)this.dObj.getPrimaryFile());
        assert (this.project != null) : "Could not resolve project for " + pUDataObject.getPrimaryFile();
        this.isContainerManaged = PersistenceLibrarySupport.getLibrary(persistenceUnit) != null && ProviderUtil.getConnection(persistenceUnit) != null ? false : (persistenceUnit.getJtaDataSource() != null || persistenceUnit.getNonJtaDataSource() != null ? true : Util.isSupportedJavaEEVersion(this.project));
        this.initComponents();
        PersistenceProviderComboboxHelper persistenceProviderComboboxHelper = new PersistenceProviderComboboxHelper(this.project);
        if (this.isContainerManaged) {
            persistenceProviderComboboxHelper.connect(this.providerCombo);
            Provider provider = ProviderUtil.getProvider(persistenceUnit);
            this.providerCombo.setSelectedItem(provider);
        } else {
            persistenceProviderComboboxHelper.connect(this.libraryComboBox);
            this.setSelectedLibrary();
        }
        this.setVisiblePanel();
        this.initIncludeAllEntities();
        this.initEntityList();
        this.initDataSource();
        this.initJdbcComboBox();
        this.nameTextField.setText(persistenceUnit.getName());
        this.setTableGeneration();
        this.handleCmAmSelection();
        this.registerModifiers();
    }

    private void registerModifiers() {
        if (this.isContainerManaged) {
            this.addImmediateModifier(this.dsCombo);
            this.addImmediateModifier(this.providerCombo);
            this.addImmediateModifier(this.jtaCheckBox);
        } else {
            this.addImmediateModifier(this.jdbcComboBox);
            this.addImmediateModifier(this.libraryComboBox);
        }
        this.addImmediateModifier(this.nameTextField);
        this.addImmediateModifier(this.ddDropCreate);
        this.addImmediateModifier(this.ddCreate);
        this.addImmediateModifier(this.ddUnknown);
        this.addImmediateModifier(this.includeAllEntities);
    }

    private void setVisiblePanel() {
        String string = this.isContainerManaged ? "container" : "application";
        ((CardLayout)this.jPanel3.getLayout()).show(this.jPanel3, string);
    }

    private void initDataSource() {
        this.jtaCheckBox.setEnabled(!Util.isJavaSE(this.project));
        if (this.isContainerManaged && ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            String string = this.persistenceUnit.getJtaDataSource();
            String string2 = this.persistenceUnit.getNonJtaDataSource();
            JPADataSourcePopulator jPADataSourcePopulator = (JPADataSourcePopulator)this.project.getLookup().lookup(JPADataSourcePopulator.class);
            if (jPADataSourcePopulator != null) {
                jPADataSourcePopulator.connect(this.dsCombo);
                this.addModifier((JTextComponent)this.dsCombo.getEditor().getEditorComponent(), false);
            }
            String string3 = string != null ? string : string2;
            this.selectDatasource(string3);
            this.jtaCheckBox.setSelected(string != null);
            String string4 = this.persistenceUnit.getProvider();
            for (int i = 0; i < this.providerCombo.getItemCount(); ++i) {
                Object e = this.providerCombo.getItemAt(i);
                if (!(e instanceof Provider) || !((Provider)e).getProviderClass().equals(string4)) continue;
                this.providerCombo.setSelectedIndex(i);
                break;
            }
        } else if (!this.isContainerManaged) {
            this.setSelectedConnection();
            this.setSelectedLibrary();
            this.jtaCheckBox.setSelected(false);
        }
    }

    private void initJdbcComboBox() {
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            this.jdbcComboBox.addItem(databaseConnectionArray[i]);
        }
        this.setSelectedConnection();
    }

    private void initIncludeAllEntities() {
        boolean bl = Util.isJavaSE(this.project);
        this.includeAllEntities.setEnabled(!bl);
        this.includeAllEntities.setSelected(!bl && !this.persistenceUnit.isExcludeUnlistedClasses());
        this.includeAllEntities.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_IncludeAllEntities", (Object[])new Object[]{ProjectUtils.getInformation((Project)this.project).getDisplayName()}));
    }

    private void initEntityList() {
        this.initEntityListControls();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : this.persistenceUnit.getClass2()) {
            defaultListModel.addElement(string);
        }
        this.entityList.setModel(defaultListModel);
    }

    private void initEntityListControls() {
        boolean bl = !this.includeAllEntities.isSelected();
        this.entityList.setEnabled(bl);
        this.addClassButton.setEnabled(bl);
        this.removeClassButton.setEnabled(bl);
    }

    private void setSelectedLibrary() {
        Provider provider = ProviderUtil.getProvider(this.persistenceUnit);
        if (provider == null) {
            return;
        }
        for (int i = 0; i < this.libraryComboBox.getItemCount(); ++i) {
            Object e = this.libraryComboBox.getItemAt(i);
            Provider provider2 = (Provider)(e instanceof Provider ? e : null);
            if (provider2 == null || !provider2.equals(provider)) continue;
            this.libraryComboBox.setSelectedIndex(i);
            break;
        }
    }

    private Provider getSelectedProvider() {
        if (this.isContainerManaged) {
            return (Provider)this.providerCombo.getSelectedItem();
        }
        Object object = this.libraryComboBox.getSelectedItem();
        Provider provider = (Provider)(object instanceof Provider ? object : null);
        if (provider != null) {
            return provider;
        }
        return ProviderUtil.getProvider(this.persistenceUnit.getProvider(), this.project);
    }

    private void setTableGeneration() {
        Provider provider = this.getSelectedProvider();
        Property property = ProviderUtil.getProperty(this.persistenceUnit, provider.getTableGenerationPropertyName());
        if (property != null) {
            if (provider.getTableGenerationCreateValue().equals(property.getValue())) {
                this.ddCreate.setSelected(true);
            } else if (provider.getTableGenerationDropCreateValue().equals(property.getValue())) {
                this.ddDropCreate.setSelected(true);
            }
        } else {
            this.ddUnknown.setSelected(true);
        }
        boolean bl = provider.supportsTableGeneration();
        this.ddCreate.setEnabled(bl);
        this.ddDropCreate.setEnabled(bl);
        this.ddUnknown.setEnabled(bl);
    }

    private void setSelectedConnection() {
        DatabaseConnection databaseConnection = ProviderUtil.getConnection(this.persistenceUnit);
        if (databaseConnection != null) {
            this.jdbcComboBox.setSelectedItem(databaseConnection);
        } else {
            Properties properties = this.persistenceUnit.getProperties();
            if (properties != null) {
                Property[] propertyArray = properties.getProperty2();
                String string = null;
                Provider provider = ProviderUtil.getProvider(this.persistenceUnit);
                for (int i = 0; i < propertyArray.length; ++i) {
                    String string2 = propertyArray[i].getName();
                    if (!provider.getJdbcUrl().equals(string2)) continue;
                    string = propertyArray[i].getValue();
                    break;
                }
                if (string == null) {
                    string = NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_CustomConnection");
                }
                this.jdbcComboBox.addItem(string);
                this.jdbcComboBox.setSelectedItem(string);
            }
        }
    }

    public void setValue(JComponent jComponent, Object object) {
        if (jComponent == this.nameTextField) {
            this.persistenceUnit.setName((String)object);
        } else if (jComponent == this.dsCombo) {
            this.setDataSource();
        } else if (jComponent == this.dsCombo.getEditor().getEditorComponent()) {
            this.setDataSource((String)object);
        } else if (jComponent == this.jdbcComboBox) {
            if (object instanceof DatabaseConnection) {
                ProviderUtil.setDatabaseConnection(this.persistenceUnit, (DatabaseConnection)object);
            }
        } else if (jComponent == this.libraryComboBox) {
            this.setProvider();
            this.setTableGeneration();
        } else if (this.providerCombo == jComponent) {
            this.setProvider();
            this.setDataSource();
        } else if (jComponent == this.ddCreate || jComponent == this.ddDropCreate || jComponent == this.ddUnknown) {
            ProviderUtil.setTableGeneration(this.persistenceUnit, this.getTableGeneration(), ProviderUtil.getProvider(this.persistenceUnit.getProvider(), this.project));
        } else if (jComponent == this.includeAllEntities) {
            this.persistenceUnit.setExcludeUnlistedClasses(!this.includeAllEntities.isSelected());
        } else if (jComponent == this.jtaCheckBox) {
            this.setDataSource();
        }
        this.performValidation();
    }

    private void performValidation() {
        PersistenceValidator persistenceValidator = new PersistenceValidator(this.dObj);
        List<Error> list = persistenceValidator.validate();
        if (!list.isEmpty()) {
            this.getSectionView().getErrorPanel().setError(list.get(0));
        } else {
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    private void setDataSource() {
        this.setDataSource(null);
    }

    private void setProvider() {
        if (this.isContainerManaged && this.providerCombo.getSelectedItem() instanceof Provider) {
            Provider provider = (Provider)this.providerCombo.getSelectedItem();
            ProviderUtil.removeProviderProperties(this.persistenceUnit);
            if (!(provider instanceof DefaultProvider)) {
                this.persistenceUnit.setProvider(provider.getProviderClass());
                this.setTableGeneration();
            }
            ProviderUtil.makePortableIfPossible(this.project, this.persistenceUnit);
        } else if (this.libraryComboBox.getSelectedItem() instanceof Provider) {
            Provider provider = (Provider)this.libraryComboBox.getSelectedItem();
            ProviderUtil.removeProviderProperties(this.persistenceUnit);
            if (!(provider instanceof DefaultProvider)) {
                ProviderUtil.setProvider(this.persistenceUnit, provider, this.getSelectedConnection(), this.getTableGeneration());
            }
        }
    }

    private void setDataSource(String string) {
        String string2 = string;
        if (string2 == null) {
            JPADataSource jPADataSource;
            int n = this.dsCombo.getSelectedIndex();
            Object object = this.dsCombo.getSelectedItem();
            JPADataSourceProvider jPADataSourceProvider = (JPADataSourceProvider)this.project.getLookup().lookup(JPADataSourceProvider.class);
            JPADataSource jPADataSource2 = jPADataSource = jPADataSourceProvider != null ? jPADataSourceProvider.toJPADataSource(object) : null;
            if (jPADataSource != null) {
                string2 = jPADataSource.getJndiName();
            } else if (n == -1 && object != null) {
                string2 = object.toString();
            }
        }
        if (string2 == null) {
            return;
        }
        if (this.isJta()) {
            this.persistenceUnit.setJtaDataSource(string2);
            this.persistenceUnit.setNonJtaDataSource(null);
        } else {
            this.persistenceUnit.setJtaDataSource(null);
            this.persistenceUnit.setNonJtaDataSource(string2);
        }
    }

    private boolean isJta() {
        return this.jtaCheckBox.isEnabled() && this.jtaCheckBox.isSelected();
    }

    private String getTableGeneration() {
        if (this.ddCreate.isSelected()) {
            return "tableGenerationCreate";
        }
        if (this.ddDropCreate.isSelected()) {
            return "tableGenerationDropCreate";
        }
        return "tableGenerationUnknown";
    }

    private DatabaseConnection getSelectedConnection() {
        DatabaseConnection databaseConnection = null;
        if (this.jdbcComboBox.getSelectedItem() instanceof DatabaseConnection) {
            databaseConnection = (DatabaseConnection)this.jdbcComboBox.getSelectedItem();
        }
        return databaseConnection;
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (this.nameTextField == jTextComponent) {
            this.nameTextField.setText(this.persistenceUnit.getName());
        } else if (this.dsCombo.getEditor().getEditorComponent() == jTextComponent) {
            String string = this.isJta() ? this.persistenceUnit.getJtaDataSource() : this.persistenceUnit.getNonJtaDataSource();
            this.selectDatasource(string);
        }
    }

    private void selectDatasource(String string) {
        Object object = this.findDatasource(string);
        this.dsCombo.setSelectedItem(object);
        if (this.dsCombo.getEditor() != null) {
            this.dsCombo.configureEditor(this.dsCombo.getEditor(), object);
        }
    }

    private Object findDatasource(String string) {
        if (string != null) {
            int n = this.dsCombo.getItemCount();
            for (int i = 0; i < n; ++i) {
                Object e = this.dsCombo.getItemAt(i);
                if (!(e instanceof JPADataSource) || !string.equals(((JPADataSource)e).getJndiName())) continue;
                return (JPADataSource)e;
            }
        }
        return string;
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        if ("name".equals(string)) {
            return this.nameTextField;
        }
        return null;
    }

    private void handleCmAmSelection() {
        boolean bl = this.isContainerManaged;
        this.datasourceLabel.setEnabled(bl);
        this.dsCombo.setEnabled(bl);
        this.jtaCheckBox.setEnabled(bl && !Util.isJavaSE(this.project));
        this.libraryLabel.setEnabled(!bl);
        this.libraryComboBox.setEnabled(!bl);
        this.jdbcLabel.setEnabled(!bl);
        this.jdbcComboBox.setEnabled(!bl);
        this.setTableGeneration();
    }

    private void initComponents() {
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.includeAllEntities = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.entityList = new JList();
        this.addClassButton = new JButton();
        this.removeClassButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jLabel2 = new JLabel();
        this.nameTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.jPanel6 = new JPanel();
        this.datasourceLabel = new JLabel();
        this.jtaCheckBox = new JCheckBox();
        this.dsCombo = new JComboBox();
        this.providerCombo = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jPanel5 = new JPanel();
        this.libraryLabel = new JLabel();
        this.jdbcLabel = new JLabel();
        this.libraryComboBox = new JComboBox();
        this.jdbcComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.tableGenerationLabel = new JLabel();
        this.ddCreate = new JRadioButton();
        this.ddDropCreate = new JRadioButton();
        this.ddUnknown = new JRadioButton();
        this.jPanel2.setOpaque(false);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle");
        this.includeAllEntities.setText(resourceBundle.getString("LBL_IncludeAllEntities"));
        this.includeAllEntities.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.includeAllEntities.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.includeAllEntitiesActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.includeAllEntities).addContainerGap(431, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.includeAllEntities).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setOpaque(false);
        this.jScrollPane2.setViewportView(this.entityList);
        this.addClassButton.setText(resourceBundle.getString("LBL_AddClasses"));
        this.addClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.addClassButtonActionPerformed(actionEvent);
            }
        });
        this.removeClassButton.setText(resourceBundle.getString("LBL_RemoveClass"));
        this.removeClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.removeClassButtonActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText(resourceBundle.getString("LBL_IncludeEntityClasses"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jScrollPane2, -2, 449, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1, false).add((Component)this.addClassButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeClassButton, -1, 125, Short.MAX_VALUE)).addPreferredGap(0, 20, Short.MAX_VALUE)).add(2, (Component)this.jLabel1, -1, 600, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabel1, -2, 17, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.addClassButton, -2, 23, -2).addPreferredGap(0).add((Component)this.removeClassButton)).add((Component)this.jScrollPane2, -2, 96, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel7.setOpaque(false);
        this.jLabel2.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_UnitName"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel7);
        this.jPanel7.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).add(32, 32, 32).add((Component)this.nameTextField, -2, 440, -2).addContainerGap(94, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.nameTextField, -2, -1, -2)).addContainerGap()));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new CardLayout());
        this.jPanel6.setOpaque(false);
        this.datasourceLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_DatasourceName"));
        this.jtaCheckBox.setSelected(true);
        this.jtaCheckBox.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_JTA"));
        this.jtaCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dsCombo.setEditable(true);
        this.providerCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle");
        this.jLabel3.setText(resourceBundle2.getString("LBL_Provider"));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jPanel6);
        this.jPanel6.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.datasourceLabel)).add(43, 43, 43).add((GroupLayout.Group)groupLayout4.createParallelGroup(1, false).add((Component)this.providerCombo, 0, -1, Short.MAX_VALUE).add((Component)this.dsCombo, 0, 436, Short.MAX_VALUE))).add((Component)this.jtaCheckBox)).add(79, 79, 79)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.providerCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.datasourceLabel).add((Component)this.dsCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.jtaCheckBox).add(48, 48, 48)));
        this.jPanel3.add((Component)this.jPanel6, "container");
        this.jPanel5.setOpaque(false);
        this.libraryLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_PersistenceLibrary"));
        this.jdbcLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_JdbcConnection"));
        this.libraryComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.libraryComboBoxActionPerformed(actionEvent);
            }
        });
        this.jdbcComboBox.setRenderer(new JdbcListCellRenderer());
        GroupLayout groupLayout5 = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.libraryLabel).add((Component)this.jdbcLabel)).add(47, 47, 47).add((GroupLayout.Group)groupLayout5.createParallelGroup(1, false).add((Component)this.jdbcComboBox, 0, -1, Short.MAX_VALUE).add((Component)this.libraryComboBox, 0, 442, Short.MAX_VALUE)).addContainerGap(103, Short.MAX_VALUE)));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.libraryLabel).add((Component)this.libraryComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.jdbcLabel).add((Component)this.jdbcComboBox, -2, -1, -2)).addContainerGap(42, Short.MAX_VALUE)));
        this.jPanel3.add((Component)this.jPanel5, "application");
        this.jPanel1.setOpaque(false);
        this.tableGenerationLabel.setText(resourceBundle.getString("LBL_TableGeneration"));
        this.buttonGroup2.add(this.ddCreate);
        this.ddCreate.setText(resourceBundle.getString("LBL_Create"));
        this.ddCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup2.add(this.ddDropCreate);
        this.ddDropCreate.setText(resourceBundle.getString("LBL_DropCreate"));
        this.ddDropCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup2.add(this.ddUnknown);
        this.ddUnknown.setText(resourceBundle.getString("LBL_None"));
        this.ddUnknown.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GroupLayout groupLayout6 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().addContainerGap().add((Component)this.tableGenerationLabel).addPreferredGap(0).add((Component)this.ddCreate).addPreferredGap(0).add((Component)this.ddDropCreate).addPreferredGap(0).add((Component)this.ddUnknown).addContainerGap(272, Short.MAX_VALUE)));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((GroupLayout.Group)groupLayout6.createParallelGroup(3).add((Component)this.ddCreate).add((Component)this.ddDropCreate).add((Component)this.ddUnknown).add((Component)this.tableGenerationLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout7 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout7);
        groupLayout7.setHorizontalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout7.createSequentialGroup().add((GroupLayout.Group)groupLayout7.createParallelGroup(2).add(1, (Component)this.jPanel3, -1, 729, Short.MAX_VALUE).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel7, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)this.jPanel4, -2, -1, -2))).addContainerGap()));
        groupLayout7.setVerticalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add((GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)this.jPanel7, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, 98, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void removeClassButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        for (Object object : objectArray = this.entityList.getSelectedValues()) {
            this.dObj.removeClass(this.persistenceUnit, (String)object);
            ((DefaultListModel)this.entityList.getModel()).removeElement(object);
        }
    }

    private void addClassButtonActionPerformed(ActionEvent actionEvent) {
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)this.dObj.getPrimaryFile());
        if (entityClassScope == null) {
            return;
        }
        String[] stringArray = this.persistenceUnit.getClass2();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        List<String> list = AddEntityDialog.open(entityClassScope, hashSet);
        for (String string : list) {
            if (!this.dObj.addClass(this.persistenceUnit, string)) continue;
            ((DefaultListModel)this.entityList.getModel()).addElement(string);
        }
    }

    private void libraryComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void includeAllEntitiesActionPerformed(ActionEvent actionEvent) {
        this.initEntityListControls();
    }
}

