/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.util.SQLTypeUtil;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.SQLType;

class DbSchemaEntityMember
extends EntityMember {
    private boolean isPrimaryKey;
    private SQLType sqlType;
    private ColumnElement columnElement;

    public DbSchemaEntityMember(ColumnElement columnElement) {
        this.columnElement = columnElement;
        this.sqlType = SQLType.getSQLType(columnElement.getType());
        this.setMemberName(DbSchemaEntityMember.makeFieldName(columnElement.getName().getName()));
        this.isPrimaryKey = false;
        this.setMemberType(this.sqlType.getMemberType(columnElement));
    }

    public boolean isNullable() {
        return this.columnElement.isNullable();
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setPrimaryKey(boolean bl, boolean bl2) {
        this.isPrimaryKey = bl;
        if (bl2) {
            this.setMemberType(this.getRespectiveNonPrimitiveType());
        }
    }

    private String getRespectiveNonPrimitiveType() {
        String string = this.getMemberType();
        if ("int".equals(string)) {
            return Integer.class.getName();
        }
        if ("long".equals(string)) {
            return Long.class.getName();
        }
        if ("short".equals(string)) {
            return Short.class.getName();
        }
        if ("byte".equals(string)) {
            return Byte.class.getName();
        }
        if ("double".equals(string)) {
            return Double.class.getName();
        }
        if ("float".equals(string)) {
            return Float.class.getName();
        }
        if ("char".equals(string)) {
            return Character.class.getName();
        }
        return this.sqlType.getFirstNonPrimitiveType();
    }

    private ColumnElement getColumnElement() {
        return this.columnElement;
    }

    public boolean supportsFinder() {
        return this.sqlType.supportsFinder();
    }

    public String getColumnName() {
        return this.getColumnElement().getName().getName();
    }

    public String getTableName() {
        return this.getColumnElement().getDeclaringTable().getName().getName();
    }

    public boolean isLobType() {
        return SQLTypeUtil.isLob((int)this.getColumnElement().getType());
    }
}

