<?php
/**
 * MyBB 1.4
 * Copyright  2008 MyBB Group, All Rights Reserved
 *
 * Website: http://www.mybboard.net
 * License: http://www.mybboard.net/about/license
 *
 * $Id$
 */

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

require_once MYBB_ROOT."/inc/functions_massmail.php";

$page->add_breadcrumb_item($lang->mass_mail, "index.php?module=user/mass_mail");

if($mybb->input['action'] == "send" || $mybb->input['action'] == "archive" || !$mybb->input['action'])
{
	$sub_tabs['mail_queue'] = array(
		'title' => $lang->mass_mail_queue,
		'link' => 'index.php?module=user/mass_mail',
		'description' => $lang->mass_mail_queue_desc
	);

	$sub_tabs['send_mass_mail'] = array(
		'title' => $lang->create_mass_mail,
		'link' => 'index.php?module=user/mass_mail&action=send',
		'description' => $lang->create_mass_mail_desc
	);

	$sub_tabs['archive'] = array(
		'title' => $lang->mass_mail_archive,
		'link' => 'index.php?module=user/mass_mail&action=archive',
		'description' => $lang->mass_mail_archive_desc
	);
}

if($mybb->input['action'] == "edit")
{	
	$page->add_breadcrumb_item($lang->edit_mass_mail);

	$query = $db->simple_select("massemails", "*", "mid='".intval($mybb->input['mid'])."'");
	$email = $db->fetch_array($query);
	if(!$email['mid'])
	{
		flash_message($lang->error_invalid_mid, 'error');
		admin_redirect("index.php?module=user/mass_mail");
	}
	
	if($email['conditions'] != '')
	{
		$email['conditions'] = unserialize($email['conditions']);
	}
	
	$sub_tabs['edit_mass_mail'] = array(
		'title' => $lang->edit_mass_mail,
		'link' => 'index.php?module=user/mass_mail&amp;action=edit&amp;mid='.$email['mid'],
		'description' => $lang->edit_mass_mail_desc
	);

	$replacement_fields = array(
		"{username}" => $lang->username,
		"{email}" => $lang->email_addr,
		"{bbname}" => $lang->board_name,
		"{bburl}" => $lang->board_url
	);
	
	$html_personalisation = $text_personalisation = "<script type=\"text/javascript\">\n<!--\ndocument.write('{$lang->personalize_message} ";
	foreach($replacement_fields as $value => $name)
	{
		$html_personalisation .= " [<a href=\"#\" onclick=\"insertText(\'{$value}\', \$(\'htmlmessage\')); return false;\">{$name}</a>], ";
		$text_personalisation .= " [<a href=\"#\" onclick=\"insertText(\'{$value}\', \$(\'message\')); return false;\">{$name}</a>], ";
	}
	$html_personalisation = substr($html_personalisation, 0, -2)."');\n// --></script>\n";;
	$text_personalisation = substr($text_personalisation, 0, -2)."');\n// --></script>\n";

	// All done here
	if($mybb->request_method == "post")
	{
		// Sending this message now
		if($mybb->input['delivery_type'] == "now")
		{
			$delivery_date = TIME_NOW;
		}
		// Delivering in the future
		else
		{
			if(strstr($mybb->input['deliverytime_time'], "pm"))
			{
				$mybb->input['deliveryhour'] += 12;
			}
			
			$exploded = explode(':', $mybb->input['endtime_time']);
			$mybb->input['deliveryhour'] = intval($exploded[0]);
			
			$exploded = explode(' ', $exploded[1]);
			$mybb->input['deliveryminute'] = intval($exploded[0]);
			
			$delivery_date = gmmktime($mybb->input['deliveryhour'], $mybb->input['deliveryminute'], 0, $mybb->input['endtime_month'], $mybb->input['endtime_day'], $mybb->input['endtime_year']) + $mybb->user['timezone']*3600;
			if($delivery_date <= TIME_NOW)
			{
				$errors[] = $lang->error_only_in_future;
			}
		}
		
		// Need to perform the search to fetch the number of users we're emailing
		$member_query = build_mass_mail_query($mybb->input['conditions']);
		$query = $db->simple_select("users u", "COUNT(uid) AS num", $member_query);
		$num = $db->fetch_field($query, "num");

		if($num == 0)
		{
			$errors[] = $lang->error_no_users;
		}
		
		if(!trim($mybb->input['subject']))
		{
			$errors[] = $lang->error_missing_subject;
		}
		
		if($mybb->input['type'] == 1)
		{
			if(!$mybb->input['message'])
			{
				$errors[] = $lang->error_missing_message;
			}
		}
		else
		{
			if($mybb->input['format'] == 2 && $mybb->input['automatic_text'] == 0 && !$mybb->input['message'])
			{
				$errors[] = $lang->error_missing_plain_text;
			}
			
			if(($mybb->input['format'] == 1 || $mybb->input['format'] == 2) && !$mybb->input['htmlmessage'])
			{
				$errors[] = $lang->error_missing_html;
			}
			else if($mybb->input['format'] == 0 && !$mybb->input['message'])
			{
				$errors[] = $lang->error_missing_plain_text;
			}
		}					
		
		if(!$errors)
		{
			// Sending via a PM
			if($mybb->input['type'] == 1)
			{
				$mybb->input['format'] = 0;
				$mybb->input['htmlmessage'] = '';
			}
			// Sending via email
			else
			{
				// Do we need to generate a text based version?
				if($mybb->input['format'] == 2 && $mybb->input['automatic_text'])
				{
					$mybb->input['message'] = create_text_message($mybb->input['htmlmessage']);
				}
				else if($mybb->input['format'] == 1)
				{
					$mybb->input['message'] = '';
				}
				else if($mybb->input['format'] == 0)
				{
					$mybb->input['htmlmessage'] = '';
				}
			}

			// Mark as queued for delivery
			$updated_email = array(
				"status" => 1,
				"senddate" => $delivery_date,
				"totalcount" => $num,
				"conditions" => $db->escape_string(serialize($mybb->input['conditions'])),
				"message" => $db->escape_string($mybb->input['message']),
				"subject" => $db->escape_string($mybb->input['subject']),
				"htmlmessage" => $db->escape_string($mybb->input['htmlmessage']),
				"format" => intval($mybb->input['format']),
				"type" => intval($mybb->input['type']),
			);
			$db->update_query("massemails", $updated_email, "mid='{$email['mid']}'");

			flash_message($lang->success_mass_mail_saved, 'success');
			admin_redirect("index.php?module=user/mass_mail");
		}
	}
	
	$page->output_header($lang->edit_mass_mail);

	$page->output_nav_tabs($sub_tabs, 'edit_mass_mail');
	
	// If we have any error messages, show them
	if($errors)
	{
		$page->output_inline_error($errors);
		$input = $mybb->input;
	}
	else
	{
		$input = $email;
		
		if($email['senddate'] != 0)
		{
			if($email['senddate'] <= TIME_NOW)
			{
				$input['delivery_type'] = "now";
				$delivery_type_checked['now'] = " checked=\"checked\"";
			}
			else
			{
				$input['delivery_type'] = "future";
				$time = date("d-n-Y-h-i-a", $email['senddate']);
				$time = explode('-', $time);
				$input['deliveryhour'] = (int)$time[3];
				$input['deliveryminute'] = (int)$time[4];
				$input['deliverymonth'] = (int)$time[1];
				$input['deliveryday'] = (int)$time[0];
				$input['deliveryyear'] = (int)$time[2];
				$input['deliverymeridiem'] = $time[5];
				$delivery_type_checked['future'] = " checked=\"checked\"";
			}
		}
		else
		{
			$input['delivery_type'] = "now";
			$delivery_type_checked['now'] = " checked=\"checked\"";
		}
	}
	
	if($input['deliveryhour'])
	{
		$input['endtime_time'] = intval($input['deliveryhour']).":";
	}
	else
	{
		$input['endtime_time'] = "12:";
	}
	
	if($input['deliveryminute'])
	{
		$input['endtime_time'] .= intval($input['deliveryminute'])." ";
	}
	else
	{
		$input['endtime_time'] .= "00 ";
	}
	
	if($input['deliverymeridiem'])
	{
		$input['endtime_time'] .= $input['deliverymeridiem'];
	}
	else
	{
		$input['endtime_time'] .= "am";
	}
	
	if(!$input['deliveryyear'])
	{
		$enddateyear = gmdate('Y', TIME_NOW);
	}
	else
	{
		$enddateyear = intval($input['deliveryyear']);
	}
	
	if(!$input['deliverymonth'])
	{
		$input['enddatemonth'] = gmdate('n', TIME_NOW);
	}
	else
	{
		$input['enddatemonth'] = intval($input['deliverymonth']);
	}
	
	if(!$input['deliveryday'])
	{
		$input['enddateday'] = gmdate('j', TIME_NOW);
	}
	else
	{
		$input['enddateday'] = intval($input['deliveryday']);
	}
	
	$form = new Form("index.php?module=user/mass_mail&amp;action=edit", "post");
	echo $form->generate_hidden_field("mid", $email['mid']);

	$mid_add = '';
	if($email['mid'])
	{
		$mid_add = "&amp;mid={$email['mid']}";
	}

	$form_container = new FormContainer("{$lang->edit_mass_mail}: {$lang->message_settings}");

	$form_container->output_row("{$lang->subject}: <em>*</em>", $lang->subject_desc, $form->generate_text_box('subject', $input['subject'], array('id' => 'subject')), 'subject');

	if($input['type'] == 0)
	{
		$type_email_checked = true;
		$type_pm_checked = false;
	}
	else if($input['type'] == 1)
	{
		$type_email_checked = false;
		$type_pm_checked = true;
	}

	$type_options = array(
		$form->generate_radio_button("type", 0, $lang->send_via_email, array("id" => "type_email", "checked" => $type_email_checked)),
		$form->generate_radio_button("type", 1, $lang->send_via_pm, array("id" => "type_pm", "checked" => $type_pm_checked))
	);
	$form_container->output_row("{$lang->message_type}: <em>*</em>", "", implode("<br />", $type_options));
	
	$monthnames = array(
		"offset",
		$lang->january,
		$lang->february,
		$lang->march,
		$lang->april,
		$lang->may,
		$lang->june,
		$lang->july,
		$lang->august,
		$lang->september,
		$lang->october,
		$lang->november,
		$lang->december,
	);
	
	$enddatemonth = "";
	foreach($monthnames as $key => $month)
	{
		if($month == "offset")
		{
			continue;
		}
		
		if($key == $input['enddatemonth'])
		{
			$enddatemonth .= "<option value=\"{$key}\" selected=\"selected\">{$month}</option>\n";
		}
		else
		{
			$enddatemonth .= "<option value=\"{$key}\">{$month}</option>\n";
		}
	}
	
	$enddateday = "";
	
	// Construct option list for days
	for($i = 1; $i <= 31; ++$i)
	{
		if($i == $input['enddateday'])
		{
			$enddateday .= "<option value=\"{$i}\" selected=\"selected\">{$i}</option>\n";
		}
		else
		{
			$enddateday .= "<option value=\"{$i}\">{$i}</option>\n";
		}
	}
	
	$actions = "<script type=\"text/javascript\">
		function checkAction(id)
		{
			var checked = '';

			$$('.'+id+'s_check').each(function(e)
			{
				if(e.checked == true)
				{
					checked = e.value;
				}
			});
			$$('.'+id+'s').each(function(e)
			{
				Element.hide(e);
			});
			if($(id+'_'+checked))
			{
				Element.show(id+'_'+checked);
			}
		}    
	</script>
		<dl style=\"margin-top: 0; margin-bottom: 0; width: 100%;\">
		<dt><label style=\"display: block;\"><input type=\"radio\" name=\"delivery_type\" value=\"now\" {$delivery_type_checked['now']} class=\"delivery_types_check\" onclick=\"checkAction('delivery_type');\" style=\"vertical-align: middle;\" /> <strong>{$lang->deliver_immediately}</strong></label></dt>

		<dt><label style=\"display: block;\"><input type=\"radio\" name=\"delivery_type\" value=\"future\" {$delivery_type_checked['future']} class=\"delivery_types_check\" onclick=\"checkAction('delivery_type');\" style=\"vertical-align: middle;\" /> <strong>{$lang->deliver_specific}</strong></label></dt>
			<dd style=\"margin-top: 4px;\" id=\"delivery_type_future\" class=\"delivery_types\">
				<table cellpadding=\"4\">
					<tr>
						<td><select name=\"endtime_day\">\n{$enddateday}</select>\n &nbsp; \n<select name=\"endtime_month\">\n{$enddatemonth}</select>\n &nbsp; \n<input type=\"text\" name=\"endtime_year\" value=\"{$enddateyear}\" class=\"text_input\" size=\"4\" maxlength=\"4\" />\n - {$lang->time} ".$form->generate_text_box('endtime_time', $input['endtime_time'], array('id' => 'endtime_time', 'style' => 'width: 60px;'))."</td>
					</tr>
				</table>
			</dd>
		</dl>
		<script type=\"text/javascript\">
		checkAction('delivery_type');
		</script>";
	$form_container->output_row("{$lang->delivery_date}: <em>*</em>", $lang->delivery_date_desc, $actions);
	
	$form_container->output_row("{$lang->per_page}: <em>*</em>", $lang->per_page_desc, $form->generate_text_box('perpage', $input['perpage'], array('id' => 'perpage')), 'perpage');
	
	$format_options = array(
		0 => $lang->plain_text_only,
		1 => $lang->html_only,
		2 => $lang->html_and_plain_text
	);
	
	$form_container->output_row("{$lang->message_format}: <em>*</em>", "", $form->generate_select_box('format', $format_options, $input['format'], array('id' => 'format')), 'format', null, array("id" => "format_container"));
	
	$form_container->end();

	if($input['format'] == 2)
	{
		if($input['automatic_text'] && !$email['mid'])
		{
			$automatic_text_check = true;
			$text_display = 'display: none';
			$automatic_display = 'display: none;';
		}
	}
	else if($input['format'] == 1 && $input['type'] != 1)
	{
		$text_display = 'display: none;';
	}
	else if($input['format'] == 0 || $input['type'] == 1)
	{
		$html_display = 'display: none';
	}


	echo "<div id=\"message_html\" style=\"{$html_display}\">";
	$form_container = new FormContainer("{$lang->edit_mass_mail}: {$lang->define_html_message}");
	$form_container->output_row("{$lang->define_html_message_desc}:", $html_personalisation, $form->generate_text_area('htmlmessage', $input['htmlmessage'], array('id' => 'htmlmessage', 'rows' => 15, 'cols '=> 70, 'style' => 'width: 95%'))."<div id=\"automatic_display\" style=\"{$automatic_display}\">".$form->generate_check_box('automatic_text', 1, $lang->auto_gen_plain_text, array('checked' => $automatic_text_check, "id" => "automatic_text"))."</div>");
	$form_container->end();
	echo "</div>";

	echo "<div id=\"message_text\" style=\"{$text_display}\">";
	$form_container = new FormContainer("{$lang->edit_mass_mail}: {$lang->define_text_version}");
	$form_container->output_row("{$lang->define_text_version_desc}:", $text_personalisation, $form->generate_text_area('message', $input['message'], array('id' => 'message', 'rows' => 15, 'cols '=> 70, 'style' => 'width: 95%')));
	$form_container->end();
	echo "</div>";

	echo "
	<script type=\"text/javascript\">
	function ToggleFormat()
	{
		var v = $('format').options[$('format').selectedIndex].value;
		if(v == 2)
		{
			$('automatic_display').show();
			$('message_html').show();
			if($('automatic_text').checked)
			{
				$('message_text').hide();
			}
			else
			{
				$('message_text').show();
			}
		}
		else if(v == 1)
		{
			$('message_text').hide();
			$('message_html').show();
			$('automatic_display').hide();
		}
		else
		{
			$('message_text').show();
			$('message_html').hide();
		}
	}
	Event.observe($('format'), 'change', ToggleFormat);

	function ToggleType()
	{
		var v = $('type_pm').checked;
		if(v == true)
		{
			$('message_html').hide();
			$('message_text').show();
			$('format_container').hide();
		}
		else
		{
			$('message_html').show();
			$('format_container').show();
			ToggleFormat();
		}
	}
	Event.observe($('type_pm'), 'click', ToggleType);
	Event.observe($('type_email'), 'click', ToggleType);
	ToggleType();

	function ToggleAutomatic()
	{
		var v = $('automatic_text').checked;
		if(v == true)
		{
			$('message_text').hide();
		}
		else
		{
			$('message_text').show();
		}
	}

	Event.observe($('automatic_text'), 'click', ToggleAutomatic);
	
	function insertText(value, textarea)
	{
		// Internet Explorer
		if(document.selection)
		{
			textarea.focus();
			var selection = document.selection.createRange();
			selection.text = value;
		}
		// Firefox
		else if(textarea.selectionStart || textarea.selectionStart == '0')
		{
			var start = textarea.selectionStart;
			var end = textarea.selectionEnd;
			textarea.value = textarea.value.substring(0, start)	+ value	+ textarea.value.substring(end, textarea.value.length);
		}
		else
		{
			textarea.value += value;
		}
	}
	
	</script>";

	$form_container = new FormContainer("{$lang->edit_mass_mail}: {$lang->define_the_recipients}");

	$form_container->output_row($lang->username_contains, "", $form->generate_text_box('conditions[username]', $input['conditions']['username'], array('id' => 'username')), 'username');
	$form_container->output_row($lang->email_addr_contains, "", $form->generate_text_box('conditions[email]', $input['conditions']['email'], array('id' => 'email')), 'email');

	$query = $db->simple_select("usergroups", "gid, title", "gid != '1'", array('order_by' => 'title'));
	while($usergroup = $db->fetch_array($query))
	{
		$options[$usergroup['gid']] = $usergroup['title'];
	}

	$form_container->output_row($lang->members_of, $lang->additional_user_groups_desc, $form->generate_select_box('conditions[usergroup][]', $options, $input['conditions']['usergroup'], array('id' => 'usergroups', 'multiple' => true, 'size' => 5)), 'usergroups');

	$greater_options = array(
		"greater_than" => $lang->greater_than,
		"is_exactly" => $lang->is_exactly,
		"less_than" => $lang->less_than
	);
	$form_container->output_row($lang->post_count_is, "", $form->generate_select_box('conditions[postnum_dir]', $greater_options, $input['conditions']['postnum_dir'], array('id' => 'numposts_dir'))." ".$form->generate_text_box('conditions[postnum]', $input['conditions']['numposts'], array('id' => 'numposts')), 'numposts');

	// Need to do reg date & last visit periods. FIGURE OUT HOW TO HANDLE/DISPLAY (Do the same as StoreSuite)

	$form_container->end();

	$buttons[] = $form->generate_submit_button($lang->save_mass_mail);
	$form->output_submit_wrapper($buttons);

	$form->end();
	$page->output_footer();
}


if($mybb->input['action'] == "send")
{
	$page->add_breadcrumb_item($lang->send_mass_mail);

	if($mybb->input['step'])
	{
		$query = $db->simple_select("massemails", "*", "status=0 and mid='".intval($mybb->input['mid'])."'");
		$email = $db->fetch_array($query);
		if(!$email['mid'] && $mybb->input['step'] != 1)
		{
			flash_message($lang->error_invalid_mid, 'error');
			admin_redirect("index.php?module=user/mass_mail");
		}
	}

	$replacement_fields = array(
		"{username}" => $lang->username,
		"{email}" => $lang->email_addr,
		"{bbname}" => $lang->board_name,
		"{bburl}" => $lang->board_url
	);
	
	$html_personalisation = $text_personalisation = "<script type=\"text/javascript\">\n<!--\ndocument.write('{$lang->personalize_message}: ";
	foreach($replacement_fields as $value => $name)
	{
		$html_personalisation .= " [<a href=\"#\" onclick=\"insertText(\'{$value}\', \$(\'htmlmessage\')); return false;\">{$name}</a>], ";
		$text_personalisation .= " [<a href=\"#\" onclick=\"insertText(\'{$value}\', \$(\'message\')); return false;\">{$name}</a>], ";
	}
	$html_personalisation = substr($html_personalisation, 0, -2)."');\n// --></script>\n";
	$text_personalisation = substr($text_personalisation, 0, -2)."');\n// --></script>\n";

	if($mybb->input['step'] == 4)
	{
		// All done here
		if($mybb->request_method == "post")
		{
			// Sending this message now
			if($mybb->input['delivery_type'] == "now")
			{
				$delivery_date = TIME_NOW;
			}
			// Delivering in the future
			else
			{
				if(strstr($mybb->input['deliverytime_time'], "pm"))
				{
					$mybb->input['deliveryhour'] += 12;
				}
				
				$exploded = explode(':', $mybb->input['endtime_time']);
				$mybb->input['deliveryhour'] = intval($exploded[0]);
				
				$exploded = explode(' ', $exploded[1]);
				$mybb->input['deliveryminute'] = intval($exploded[0]);
			
				$delivery_date = gmmktime($mybb->input['deliveryhour'], $mybb->input['deliveryminute'], 0, $mybb->input['endtime_month'], $mybb->input['endtime_day'], $mybb->input['endtime_year']) + $mybb->user['timezone']*3600;
				if($delivery_date <= TIME_NOW)
				{
					$errors[] = $lang->error_only_in_future;
				}
			}
			
			if(!$errors)
			{
				// Mark as queued for delivery
				$updated_email = array(
					"status" => 1,
					"senddate" => $delivery_date
				);
				$db->update_query("massemails", $updated_email, "mid='{$email['mid']}'");

				flash_message($lang->success_mass_mail_saved, 'success');
				admin_redirect("index.php?module=user/mass_mail");
			}
		}

		// Show summary of the mass email we've just been creating and allow the user to specify the delivery date
		$page->output_header("{$lang->send_mass_mail}: {$lang->step_four}");

		$page->output_nav_tabs($sub_tabs, 'send_mass_mail');
		
		// If we have any error messages, show them
		if($errors)
		{
			$page->output_inline_error($errors);
			$input = $mybb->input;
		}
		else
		{
			if($email['senddate'] != 0)
			{
				$input = array();
				if($email['senddate'] <= TIME_NOW)
				{
					$input['delivery_type'] = "now";
					$delivery_type_checked['now'] = " checked=\"checked\"";
				}
				else
				{
					$input['delivery_type'] = "future";
					$time = date("d-n-Y-h-i-a", $email['senddate']);
					$time = explode('-', $time);
					$input['deliveryhour'] = (int)$time[3];
					$input['deliveryminute'] = (int)$time[4];
					$input['deliverymonth'] = (int)$time[1];
					$input['deliveryday'] = (int)$time[0];
					$input['deliveryyear'] = (int)$time[2];
					$input['deliverymeridiem'] = $time[5];
					$delivery_type_checked['future'] = " checked=\"checked\"";
				}
			}
			else
			{
				$input['delivery_type'] = "now";
				$delivery_type_checked['now'] = " checked=\"checked\"";
			}
		}
		
		$table = new Table;
		$table->construct_cell("<strong>{$lang->delivery_method}:</strong>", array('width' => '25%'));
		if($email['type'] == 1)
		{
			$delivery_type = $lang->private_message;
		}
		else if($email['type'] == 0)
		{
			$delivery_type = $lang->email;
		}
		$table->construct_cell($delivery_type);
		$table->construct_row();
		
		$table->construct_cell("<strong>{$lang->subject}:</strong>");
		$table->construct_cell(htmlspecialchars_uni($email['subject']));
		$table->construct_row();
		
		$table->construct_cell("<strong>{$lang->message}:</strong>");
		$format_preview = '';
		if($email['format'] == 0 || $email['format'] == 2)
		{
			$format_preview .= "{$lang->text_based} - <a href=\"#\" onclick=\"javascript:MyBB.popupWindow('index.php?module=user/mass_mail&amp;action=preview&amp;mid={$email['mid']}&amp;format=text', 'preview', 450, 450);\">{$lang->preview}</a>";
		}
		if($email['format'] == 2)
		{
			$format_preview .= " {$lang->and} <br />";
		}
		if($email['format'] == 1 || $email['format'] == 2)
		{
			$format_preview.= "{$lang->html_based} - <a href=\"#\" onclick=\"javascript:MyBB.popupWindow('index.php?module=user/mass_mail&amp;action=preview&amp;mid={$email['mid']}', 'preview', 450, 450);\">{$lang->preview}</a>";
		}
		$table->construct_cell($format_preview);
		$table->construct_row();
		
		// Recipient counts & details
		$table->construct_cell("<strong>{$lang->total_recipients}:</strong>");
		$table->construct_cell(my_number_format($email['totalcount'])." - <a href=\"index.php?module=user/mass_mail&amp;action=send&amp;step=3&amp;mid={$email['mid']}\">{$lang->change_recipient_conds}</a>");
		$table->construct_row();
		
		$table->output("{$lang->send_mass_mail}: {$lang->step_four} - {$lang->review_message}");
		
		if($input['deliveryhour'])
		{
			$input['endtime_time'] = intval($input['deliveryhour']).":";
		}
		else
		{
			$input['endtime_time'] = "12:";
		}
		
		if($input['deliveryminute'])
		{
			$input['endtime_time'] .= intval($input['deliveryminute'])." ";
		}
		else
		{
			$input['endtime_time'] .= "00 ";
		}
		
		if($input['deliverymeridiem'])
		{
			$input['endtime_time'] .= $input['deliverymeridiem'];
		}
		else
		{
			$input['endtime_time'] .= "am";
		}
		
		if(!$input['deliveryyear'])
		{
			$enddateyear = gmdate('Y', TIME_NOW);
		}
		else
		{
			$enddateyear = intval($input['deliveryyear']);
		}
		
		if(!$input['deliverymonth'])
		{
			$input['enddatemonth'] = gmdate('n', TIME_NOW);
		}
		else
		{
			$input['enddatemonth'] = intval($input['deliverymonth']);
		}
		
		if(!$input['deliveryday'])
		{
			$input['enddateday'] = gmdate('j', TIME_NOW);
		}
		else
		{
			$input['enddateday'] = intval($input['deliveryday']);
		}
		
		$monthnames = array(
			"offset",
			$lang->january,
			$lang->february,
			$lang->march,
			$lang->april,
			$lang->may,
			$lang->june,
			$lang->july,
			$lang->august,
			$lang->september,
			$lang->october,
			$lang->november,
			$lang->december,
		);
		
		$enddatemonth = "";
		foreach($monthnames as $key => $month)
		{
			if($month == "offset")
			{
				continue;
			}
			
			if($key == $input['enddatemonth'])
			{
				$enddatemonth .= "<option value=\"{$key}\" selected=\"selected\">{$month}</option>\n";
			}
			else
			{
				$enddatemonth .= "<option value=\"{$key}\">{$month}</option>\n";
			}
		}
		
		$enddateday = "";
		
		// Construct option list for days
		for($i = 1; $i <= 31; ++$i)
		{
			if($i == $input['enddateday'])
			{
				$enddateday .= "<option value=\"{$i}\" selected=\"selected\">{$i}</option>\n";
			}
			else
			{
				$enddateday .= "<option value=\"{$i}\">{$i}</option>\n";
			}
		}
		
		$form = new Form("index.php?module=user/mass_mail&amp;action=send&amp;step=4&amp;mid={$email['mid']}", "post");
		$form_container = new FormContainer("{$lang->send_mass_mail}: {$lang->step_four} - {$lang->define_delivery_date}");

			$actions = "<script type=\"text/javascript\">
		    function checkAction(id)
		    {
		        var checked = '';

		        $$('.'+id+'s_check').each(function(e)
		        {
		            if(e.checked == true)
		            {
		                checked = e.value;
		            }
		        });
		        $$('.'+id+'s').each(function(e)
		        {
		        	Element.hide(e);
		        });
		        if($(id+'_'+checked))
		        {
		            Element.show(id+'_'+checked);
		        }
		    }    
		</script>
			<dl style=\"margin-top: 0; margin-bottom: 0; width: 100%;\">
			<dt><label style=\"display: block;\"><input type=\"radio\" name=\"delivery_type\" value=\"now\" {$delivery_type_checked['now']} class=\"delivery_types_check\" onclick=\"checkAction('delivery_type');\" style=\"vertical-align: middle;\" /> <strong>{$lang->deliver_immediately}</strong></label></dt>

			<dt><label style=\"display: block;\"><input type=\"radio\" name=\"delivery_type\" value=\"future\" {$delivery_type_checked['future']} class=\"delivery_types_check\" onclick=\"checkAction('delivery_type');\" style=\"vertical-align: middle;\" /> <strong>{$lang->deliver_specific}</strong></label></dt>
				<dd style=\"margin-top: 4px;\" id=\"delivery_type_future\" class=\"delivery_types\">
					<table cellpadding=\"4\">
						<tr>
							<td><select name=\"endtime_day\">\n{$enddateday}</select>\n &nbsp; \n<select name=\"endtime_month\">\n{$enddatemonth}</select>\n &nbsp; \n<input type=\"text\" name=\"endtime_year\" class=\"text_input\" value=\"{$enddateyear}\" size=\"4\" maxlength=\"4\" />\n - {$lang->time} ".$form->generate_text_box('endtime_time', $input['endtime_time'], array('id' => 'endtime_time', 'style' => 'width: 60px;'))."</td>
						</tr>
					</table>
				</dd>
			</dl>
			<script type=\"text/javascript\">
			checkAction('delivery_type');
			</script>";
			$form_container->output_row("{$lang->delivery_date}: <em>*</em>", $lang->delivery_date_desc, $actions);
			
		$form_container->end();

		$buttons[] = $form->generate_submit_button($lang->schedule_for_delivery);
		$form->output_submit_wrapper($buttons);

		$form->end();
		$page->output_footer();		
	}

	if($mybb->input['step'] == 3)
	{
		// Define the recipients/conditions
		if($mybb->request_method == "post")
		{
			// Need to perform the search to fetch the number of users we're emailing
			$member_query = build_mass_mail_query($mybb->input['conditions']);
			$query = $db->simple_select("users u", "COUNT(uid) AS num", $member_query);
			$num = $db->fetch_field($query, "num");

			if($num == 0)
			{
				$errors[] = $lang->error_no_users;
			}
			// Got one or more results
			else
			{
				$updated_email = array(
					"totalcount" => $num,
					"conditions" => $db->escape_string(serialize($mybb->input['conditions']))
				);
				$db->update_query("massemails", $updated_email, "mid='{$email['mid']}'");

				// Take the user to the next step
				admin_redirect("index.php?module=user/mass_mail&action=send&step=4&mid={$email['mid']}");
			}
		}

		$page->output_header("{$lang->send_mass_mail}: {$lang->step_three}");

		$form = new Form("index.php?module=user/mass_mail&amp;action=send&amp;step=3&amp;mid={$email['mid']}", "post");
		$page->output_nav_tabs($sub_tabs, 'send_mass_mail');

		// If we have any error messages, show them
		if($errors)
		{
			$page->output_inline_error($errors);
			$input = $mybb->input;
		}
		else
		{
			if($email['conditions'] != '')
			{
				$input = array(
					"conditions" => unserialize($email['conditions'])
				);
			}
		}

		$form_container = new FormContainer("{$lang->send_mass_mail}: {$lang->step_three} - {$lang->define_the_recipients}");

		$form_container->output_row($lang->username_contains, "", $form->generate_text_box('conditions[username]', $input['conditions']['username'], array('id' => 'username')), 'username');
		$form_container->output_row($lang->email_addr_contains, "", $form->generate_text_box('conditions[email]', $input['conditions']['email'], array('id' => 'email')), 'email');

		$query = $db->simple_select("usergroups", "gid, title", "gid != '1'", array('order_by' => 'title'));
		while($usergroup = $db->fetch_array($query))
		{
			$options[$usergroup['gid']] = $usergroup['title'];
		}

		$form_container->output_row($lang->members_of, $lang->additional_user_groups_desc, $form->generate_select_box('conditions[usergroup][]', $options, $input['conditions']['usergroup'], array('id' => 'usergroups', 'multiple' => true, 'size' => 5)), 'usergroups');

		$greater_options = array(
			"greater_than" => $lang->greater_than,
			"is_exactly" => $lang->is_exactly,
			"less_than" => $lang->less_than
		);
		$form_container->output_row($lang->post_count_is, "", $form->generate_select_box('conditions[postnum_dir]', $greater_options, $input['conditions']['postnum_dir'], array('id' => 'numposts_dir'))." ".$form->generate_text_box('conditions[postnum]', $input['conditions']['numposts'], array('id' => 'numposts')), 'numposts');

		// Need to do reg date & last visit periods. FIGURE OUT HOW TO HANDLE/DISPLAY (Do the same as StoreSuite)

		$form_container->end();

		$buttons[] = $form->generate_submit_button($lang->next_step);
		$form->output_submit_wrapper($buttons);

		$form->end();
		$page->output_footer();
	}

	// Reviewing the automatic text based version of the message.
	if($mybb->input['step'] == 2)
	{
		// Update text based version
		if($mybb->request_method == "post")
		{
			if(!trim($mybb->input['message']))
			{
				$errors[] = $lang->error_missing_plain_text;
			}
			else
			{
				$updated_email = array(
					"message" => $db->escape_string($mybb->input['message'])
				);
				$db->update_query("massemails", $updated_email, "mid='{$email['mid']}'");

				// Take the user to the next step
				admin_redirect("index.php?module=user/mass_mail&action=send&step=3&mid={$email['mid']}");
			}
		}

		$page->output_header("{$lang->send_mass_mail}: {$lang->step_two}");

		$form = new Form("index.php?module=user/mass_mail&amp;action=send&amp;step=2&amp;mid={$email['mid']}", "post");
		$page->output_nav_tabs($sub_tabs, 'send_mass_mail');

		// If we have any error messages, show them
		if($errors)
		{
			$page->output_inline_error($errors);
		}

		$form_container = new FormContainer("{$lang->send_mass_mail}: {$lang->step_two} - {$lang->review_text_version}");
		$form_container->output_row("{$lang->review_text_version_desc}:", $text_personalisation, $form->generate_text_area('message', $email['message'], array('id' => 'message', 'rows' => 15, 'cols '=> 70, 'style' => 'width: 95%')));
		$form_container->end();

		$buttons[] = $form->generate_submit_button($lang->next_step);
		$form->output_submit_wrapper($buttons);

		$form->end();
		$page->output_footer();
	}

	if(!$mybb->input['step'] || $mybb->input['step'] == 1)
	{
		if($mybb->request_method == "post")
		{
			if(!trim($mybb->input['subject']))
			{
				$errors[] = $lang->error_missing_subject;
			}
			
			if($mybb->input['type'] == 1)
			{
				if(!$mybb->input['message'])
				{
					$errors[] = $lang->error_missing_message;
				}
			}
			else
			{
				if($mybb->input['format'] == 2 && $mybb->input['automatic_text'] == 0 && !$mybb->input['message'])
				{
					$errors[] = $lang->error_missing_plain_text;
				}
				
				if(($mybb->input['format'] == 1 || $mybb->input['format'] == 2) && !$mybb->input['htmlmessage'])
				{
					$errors[] = $lang->error_missing_html;
				}
				else if($mybb->input['format'] == 0 && !$mybb->input['message'])
				{
					$errors[] = $lang->error_missing_plain_text;
				}
			}

			// No errors, insert away
			if(!$errors)
			{
				if(!$new_email['mid'])
				{
					// Sending via a PM
					if($mybb->input['type'] == 1)
					{
						$mybb->input['format'] = 0;
						$mybb->input['htmlmessage'] = '';
					}
					// Sending via email
					else
					{
						// Do we need to generate a text based version?
						if($mybb->input['format'] == 2 && $mybb->input['automatic_text'])
						{
							$mybb->input['message'] = create_text_message($mybb->input['htmlmessage']);
						}
						else if($mybb->input['format'] == 1)
						{
							$mybb->input['message'] = '';
						}
						else if($mybb->input['format'] == 0)
						{
							$mybb->input['htmlmessage'] = '';
						}
					}

					$new_email = array(
						"uid" => $mybb->user['uid'],
						"subject" => $db->escape_string($mybb->input['subject']),
						"message" => $db->escape_string($mybb->input['message']),
						"htmlmessage" => $db->escape_string($mybb->input['htmlmessage']),
						"format" => intval($mybb->input['format']),
						"type" => intval($mybb->input['type']),
						"dateline" => TIME_NOW,
						"senddate" => 0,
						"status" => 0,
						"sentcount" => 0,
						"totalcount" => 0,
						"conditions" => "",
						"perpage" => intval($mybb->input['perpage'])
					);
					$mid = $db->insert_query("massemails", $new_email);
				}
				// Updating an existing one
				else
				{
					$updated_email = array(
						"subject" => $db->escape_string($mybb->input['subject']),
						"message" => $db->escape_string($mybb->input['message']),
						"htmlmessage" => $db->escape_string($mybb->input['htmlmessage']),
						"format" => intval($mybb->input['format']),
						"type" => intval($mybb->input['type']),
						"perpage" => intval($mybb->input['perpage'])
					);
					$db->update_query("massemails", $updated_email, "mid='{$email['mid']}'");
					$mid = $email['mid'];
				}

				if($mybb->input['format'] == 2 && $mybb->input['automatic_text'] == 1)
				{
					$next = 2;
				}
				else
				{
					$next = 3;
				}
				admin_redirect("index.php?module=user/mass_mail&action=send&step={$next}&mid={$mid}");
			}
		}

		$page->output_header("{$lang->send_mass_mail}: {$lang->step_one}");

		$mid_add = '';
		if($email['mid'])
		{
			$mid_add = "&amp;mid={$email['mid']}";
		}

		$form = new Form("index.php?module=user/mass_mail&amp;action=send{$mid_add}", "post");
		$page->output_nav_tabs($sub_tabs, 'send_mass_mail');

		// If we have any error messages, show them
		if($errors)
		{
			$page->output_inline_error($errors);
			$input = $mybb->input;
		}
		else if(!$email)
		{
			$input = array(
				"type" => 0,
				"format" => 2,
				"automatic_text" => 1,
				"perpage" => 50,
			);
		}
		else
		{
			$input = $email;
		}

		$form_container = new FormContainer("{$lang->send_mass_mail}: {$lang->step_one} - {$lang->message_settings}");

		$form_container->output_row("{$lang->subject}: <em>*</em>", $lang->subject_desc, $form->generate_text_box('subject', $input['subject'], array('id' => 'subject')), 'subject');

		if($mybb->input['type'] == 0)
		{
			$type_email_checked = true;
			$type_pm_checked = false;
		}
		else if($mybb->input['type'] == 1)
		{
			$type_email_checked = false;
			$type_pm_checked = true;
		}

		$type_options = array(
			$form->generate_radio_button("type", 0, $lang->send_via_email, array("id" => "type_email", "checked" => $type_email_checked)),
			$form->generate_radio_button("type", 1, $lang->send_via_pm, array("id" => "type_pm", "checked" => $type_pm_checked))
		);
		$form_container->output_row("{$lang->message_type}:", "", implode("<br />", $type_options));

		$format_options = array(
			0 => $lang->plain_text_only,
			1 => $lang->html_only,
			2 => $lang->html_and_plain_text
		);

		$form_container->output_row("{$lang->message_format}:", "", $form->generate_select_box('format', $format_options, $input['format'], array('id' => 'format')), 'format', null, array("id" => "format_container"));
		
		$form_container->output_row("{$lang->per_page}: <em>*</em>", $lang->per_page_desc, $form->generate_text_box('perpage', $input['perpage'], array('id' => 'perpage')), 'perpage');
		
		$form_container->end();

		if($mybb->input['format'] == 2)
		{
			if($mybb->input['automatic_text'] && !$email['mid'])
			{
				$automatic_text_check = true;
				$text_display = 'display: none';
				$automatic_display = 'display: none;';
			}
		}
		else if($mybb->input['format'] == 1 && $mybb->input['type'] != 1)
		{
			$text_display = 'display: none;';
		}
		else if($mybb->input['format'] == 0 || $mybb->input['type'] == 1)
		{
			$html_display = 'display: none';
		}


		echo "<div id=\"message_html\" style=\"{$html_display}\">";
		$form_container = new FormContainer("{$lang->send_mass_mail}: {$lang->step_one} - {$lang->define_html_message}");
		$form_container->output_row("{$lang->define_html_message_desc}:", $html_personalisation, $form->generate_text_area('htmlmessage', $input['htmlmessage'], array('id' => 'htmlmessage', 'rows' => 15, 'cols '=> 70, 'style' => 'width: 95%'))."<div id=\"automatic_display\" style=\"{$automatic_display}\">".$form->generate_check_box('automatic_text', 1, $lang->auto_gen_plain_text, array('checked' => $automatic_text_check, "id" => "automatic_text"))."</div>");
		$form_container->end();
		echo "</div>";

		echo "<div id=\"message_text\" style=\"{$text_display}\">";
		$form_container = new FormContainer("{$lang->send_mass_mail}: {$lang->step_one} - {$lang->define_text_version}");
		$form_container->output_row("{$lang->define_text_version_desc}:", $text_personalisation, $form->generate_text_area('message', $input['message'], array('id' => 'message', 'rows' => 15, 'cols '=> 70, 'style' => 'width: 95%')));
		$form_container->end();
		echo "</div>";

		echo "
		<script type=\"text/javascript\">
		function ToggleFormat()
		{
			var v = $('format').options[$('format').selectedIndex].value;
			if(v == 2)
			{
				$('automatic_display').show();
				$('message_html').show();
				if($('automatic_text').checked)
				{
					$('message_text').hide();
				}
				else
				{
					$('message_text').show();
				}
			}
			else if(v == 1)
			{
				$('message_text').hide();
				$('message_html').show();
				$('automatic_display').hide();
			}
			else
			{
				$('message_text').show();
				$('message_html').hide();
			}
		}
		Event.observe($('format'), 'change', ToggleFormat);

		function ToggleType()
		{
			var v = $('type_pm').checked;
			if(v == true)
			{
				$('message_html').hide();
				$('message_text').show();
				$('format_container').hide();
			}
			else
			{
				$('message_html').show();
				$('format_container').show();
				ToggleFormat();
			}
		}
		Event.observe($('type_pm'), 'click', ToggleType);
		Event.observe($('type_email'), 'click', ToggleType);
		ToggleType();

		function ToggleAutomatic()
		{
			var v = $('automatic_text').checked;
			if(v == true)
			{
				$('message_text').hide();
			}
			else
			{
				$('message_text').show();
			}
		}

		Event.observe($('automatic_text'), 'click', ToggleAutomatic);
		
		function insertText(value, textarea)
		{
			// Internet Explorer
			if(document.selection)
			{
				textarea.focus();
				var selection = document.selection.createRange();
				selection.text = value;
			}
			// Firefox
			else if(textarea.selectionStart || textarea.selectionStart == '0')
			{
				var start = textarea.selectionStart;
				var end = textarea.selectionEnd;
				textarea.value = textarea.value.substring(0, start)	+ value	+ textarea.value.substring(end, textarea.value.length);
			}
			else
			{
				textarea.value += value;
			}
		}
		
		</script>";

		$buttons[] = $form->generate_submit_button($lang->next_step);
		$form->output_submit_wrapper($buttons);

		$form->end();
		$page->output_footer();
	}
}

if($mybb->input['action'] == "delete")
{
	$query = $db->simple_select("massemails", "*", "mid='".intval($mybb->input['mid'])."'");
	$mass_email = $db->fetch_array($query);
	
	if(!$mass_email['mid'])
	{
		flash_message($lang->error_delete_invalid_mid, 'error');
		admin_redirect("index.php?module=user/mass_mail");
	}

	// User clicked no
	if($mybb->input['no'])
	{
		admin_redirect("index.php?module=user/mass_mail");
	}

	if($mybb->request_method == "post")
	{
		$db->delete_query("massemails", "mid='{$mass_email['mid']}'");

		$plugins->run_hooks("admin_user_mass_email_delete_commit");

		// Log admin action
		log_admin_action($mass_email['mid'], $mass_email['subject']);
		
		if($mybb->input['archive'] == 1)
		{
			flash_message($lang->success_mass_mail_deleted, 'success');
			admin_redirect("index.php?module=user/mass_mail&action=archive");
		}
		else
		{
			flash_message($lang->success_mass_mail_deleted, 'success');
			admin_redirect("index.php?module=user/mass_mail");
		}
	}
	else
	{
		if($mybb->input['archive'] == 1)
		{
			$page->output_confirm_action("index.php?module=user/mass_mail&amp;action=delete&amp;mid={$mass_email['mid']}&amp;archive=1", $lang->mass_mail_deletion_confirmation);
		}
		else
		{
			$page->output_confirm_action("index.php?module=user/mass_mail&amp;action=delete&amp;mid={$mass_email['mid']}", $lang->mass_mail_deletion_confirmation);
		}
	}
}

if($mybb->input['action'] == "preview")
{
	$query = $db->simple_select("massemails", "*", "mid='".intval($mybb->input['mid'])."'");
	$mass_email = $db->fetch_array($query);
	
	if(!$mass_email['mid'])
	{
		flash_message($lang->error_invalid_mid, 'error');
		admin_redirect("index.php?module=user/mass_mail");
	}
	
	?>
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head profile="http://gmpg.org/xfn/1">
		<title>Mass Email Preview</title>
		<link rel="stylesheet" href="styles/<?php echo $page->style; ?>/main.css" type="text/css" />
		<link rel="stylesheet" href="styles/<?php echo $page->style; ?>/popup.css" type="text/css" />
	</head>
	<body id="popup">
		<div id="popup_container">
		<div class="popup_title"><a href="#" onClick="window.close();" class="close_link"><?php echo $lang->close_window; ?></a> Mass Email Preview</div>

		<div id="content">	
	<?php
	
	if($mybb->input['format'] == 'text' || !$mass_email['htmlmessage'])
	{
		// Show preview of the text version
		echo nl2br($mass_email['message']);
	}
	else
	{
		// Preview the HTML version
		echo $mass_email['htmlmessage'];
	}
	
		?>
		</div>
	</div>
	</body>
	</html>
	<?php
	exit;
}

if($mybb->input['action'] == "resend")
{
	// Copy and resend an email
	$query = $db->simple_select("massemails", "*", "mid='".intval($mybb->input['mid'])."'");
	$mass_email = $db->fetch_array($query);
	
	if(!$mass_email['mid'])
	{
		flash_message($lang->error_invalid_mid, 'error');
		admin_redirect("index.php?module=user/mass_mail");		
	}

	// Need to perform the search to fetch the number of users we're emailing
	$member_query = build_mass_mail_query(unserialize($mass_email['conditions']));
	$query = $db->simple_select("users u", "COUNT(uid) AS num", $member_query);
	$total_recipients = $db->fetch_field($query, "num");
	
	// Create the new email based off the old one.
	$new_email = array(
		"uid" => $mass_email['uid'],
		"subject" => $db->escape_string($mass_email['subject']),
		"message" => $db->escape_string($mass_email['message']),
		"htmlmessage" => $db->escape_string($mass_email['htmlmessage']),
		"type" => $db->escape_string($mass_email['type']),
		"format" => $db->escape_string($mass_email['format']),
		"dateline" => TIME_NOW,
		"senddate" => '0',
		"status" => 0,
		"sentcount" => 0,
		"totalcount" => $total_recipients,
		"conditions" => $db->escape_string($mass_email['conditions']),
		"perpage" => $mass_email['perpage']
	);
	$mid = $db->insert_query("massemails", $new_email);
	
	// Redirect the user to the summary page so they can select when to deliver this message
	flash_message($lang->success_mass_mail_resent, 'success');
	admin_redirect("index.php?module=user/mass_mail&action=send&step=4&mid={$mid}");
	exit;
}

if($mybb->input['action'] == "cancel")
{
	// Cancel the delivery of a mass-email.
	$query = $db->simple_select("massemails", "*", "mid='".intval($mybb->input['mid'])."'");
	$mass_email = $db->fetch_array($query);
	
	if(!$mass_email['mid'])
	{
		flash_message($lang->error_invalid_mid, 'error');
		admin_redirect("index.php?module=user/mass_mail");		
	}
	
	$updated_email = array(
		'status' => 4
	);
	$db->update_query("massemails", $updated_email, "mid='{$mass_email['mid']}'");
	
	flash_message($lang->success_mass_mail_canceled, 'success');
	admin_redirect("index.php?module=user/mass_mail");
	exit;		
}

if($mybb->input['action'] == "archive")
{
	// View a list of archived email messages
	$page->output_header($lang->mass_mail_archive);

	$page->output_nav_tabs($sub_tabs, 'archive');

	$table = new Table;
	$table->construct_header($lang->subject);
	$table->construct_header($lang->status, array('width' => '130', 'class' => 'align_center'));
	$table->construct_header($lang->delivery_date, array('width' => '130', 'class' => 'align_center'));
	$table->construct_header($lang->recipients, array('width' => '130', 'class' => 'align_center'));
	$table->construct_header($lang->controls, array("class" => "align_center", "colspan" => 2, "width" => 200));

	$query = $db->simple_select("massemails", "*", "status NOT IN (0, 1, 2)", array('order_by' => 'senddate'));
	while($email = $db->fetch_array($query))
	{
		$email['subject'] = htmlspecialchars_uni($email['subject']);
		if($email['senddate'] < TIME_NOW)
		{
			$table->construct_cell("<strong>{$email['subject']}</strong>");
		}
		if($email['status'] == 3)
		{
			$status = $lang->delivered;
		}
		else if($email['status'] == 4)
		{
			$status = $lang->canceled;
		}
		$table->construct_cell($status, array("class" => "align_center"));

		$delivery_date = my_date($mybb->settings['dateformat'], $email['senddate']);

		$table->construct_cell($delivery_date, array("class" => "align_center"));
		$table->construct_cell(my_number_format($email['totalcount']), array("class" => "align_center"));

		$table->construct_cell("<a href=\"index.php?module=user/mass_mail&amp;action=resend&amp;mid={$email['mid']}\">{$lang->resend}</a>", array("width" => 100, "class" => "align_center"));
		$table->construct_cell("<a href=\"index.php?module=user/mass_mail&amp;action=delete&amp;mid={$email['mid']}&amp;my_post_key={$mybb->post_code}&amp;archive=1\" onclick=\"return AdminCP.deleteConfirmation(this, '{$lang->mass_mail_deletion_confirmation}')\">{$lang->delete}</a>", array("width" => 100, "class" => "align_center"));

		$table->construct_row();
	}

	if($table->num_rows() == 0)
	{
		$table->construct_cell($lang->no_archived_messages, array('colspan' => 6));
		$table->construct_row();
		$no_results = true;
	}

	$table->output($lang->mass_mail_archive);

	$page->output_footer();
}

if(!$mybb->input['action'])
{
	$page->output_header($lang->mass_mail_queue);

	$page->output_nav_tabs($sub_tabs, 'mail_queue');

	$table = new Table;
	$table->construct_header($lang->subject);
	$table->construct_header($lang->status, array('width' => '130', 'class' => 'align_center'));
	$table->construct_header($lang->delivery_date, array('width' => '130', 'class' => 'align_center'));
	$table->construct_header($lang->recipients, array('width' => '130', 'class' => 'align_center'));
	$table->construct_header($lang->controls, array("class" => "align_center", "colspan" => 2, "width" => 200));

	$query = $db->simple_select("massemails", "*", "status IN (0, 1, 2)", array('order_by' => 'senddate'));
	while($email = $db->fetch_array($query))
	{
		$email['subject'] = htmlspecialchars_uni($email['subject']);
		if(TIME_NOW >= $email['senddate'] && $email['status'] > 1)
		{
			$table->construct_cell("<a href=\"index.php?module=user/mass_mail&amp;action=edit&amp;mid={$email['mid']}\"><strong>{$email['subject']}</strong></a>");
		}
		else
		{
			$table->construct_cell("<strong>{$email['subject']}</strong>");
		}
		if($email['status'] == 0)
		{
			$status = $lang->draft;
		}
		else if($email['status'] == 1)
		{
			$status = $lang->queued;
		}
		else if($email['status'] == 2)
		{
			$progress = ceil($email['sentcount']/$email['totalcount']*100);
			if($progress > 100)
			{
				$progress = 100;
			}
			$status = "{$lang->delivering} ({$progress}%)";
		}
		$table->construct_cell($status, array("class" => "align_center"));

		if($email['status'] != 0)
		{
			$delivery_date = my_date($mybb->settings['dateformat'], $email['senddate']);
		}
		else
		{
			$delivery_date = $lang->na;
		}

		$table->construct_cell($delivery_date, array("class" => "align_center"));
		$table->construct_cell(my_number_format($email['totalcount']), array("class" => "align_center"));
		if(TIME_NOW >= $email['senddate'] && $email['status'] > 1)
		{
			$table->construct_cell("<a href=\"index.php?module=user/mass_mail&amp;action=cancel&amp;mid={$email['mid']}&amp;my_post_key={$mybb->post_code}\" onclick=\"return AdminCP.deleteConfirmation(this, '{$lang->mass_mail_cancel_confirmation}')\">{$lang->cancel}</a>", array("width" => 100, "colspan" => 2, "class" => "align_center"));
		}
		else
		{
			$table->construct_cell("<a href=\"index.php?module=user/mass_mail&amp;action=edit&amp;mid={$email['mid']}\">{$lang->edit}</a>", array("width" => 100, "class" => "align_center"));
			$table->construct_cell("<a href=\"index.php?module=user/mass_mail&amp;action=delete&amp;mid={$email['mid']}&amp;my_post_key={$mybb->post_code}\" onclick=\"return AdminCP.deleteConfirmation(this, '{$lang->mass_mail_deletion_confirmation}')\">{$lang->delete}</a>", array("width" => 100, "class" => "align_center"));
		}
		$table->construct_row();
	}
	
	if($table->num_rows() == 0)
	{
		$table->construct_cell($lang->no_unsent_messages, array('colspan' => 6));
		$table->construct_row();
		$no_results = true;
	}

	$table->output($lang->mass_mail_queue);

	$page->output_footer();
}
?>