//--------------------------------------------------------------------------
// Copyright (C) 1992-1999 Dallas Semiconductor Corporation. 
// All rights Reserved. Printed in U.S.A.
// This software is protected by copyright laws of
// the United States and of foreign countries.
// This material may also be protected by patent laws of the United States 
// and of foreign countries.
// This software is furnished under a license agreement and/or a
// nondisclosure agreement and may only be used or copied in accordance
// with the terms of those agreements.
// The mere transfer of this software does not imply any licenses
// of trade secrets, proprietary technology, copyrights, patents,
// trademarks, maskwork rights, or any other form of intellectual
// property whatsoever. Dallas Semiconductor retains all ownership rights.
//--------------------------------------------------------------------------
//
//  Thermo.h - Include file for Thermochron demo.
//
//  Version: 1.03
//


#ifndef THERMO_TYPES

#define THERMO_TYPES

// defines
#define STATUS_PAGE     16
#define THERMO_FAM     0x21


// basic types
#ifndef MLAN_UCHAR
   #define MLAN_UCHAR
   typedef unsigned char  uchar;
   typedef unsigned short ushort;
   typedef unsigned long  ulong;
#endif

// structure to hold the mission status 
typedef struct 
{
   uchar serial_num[8];          // serial number of thermochron

   uchar mission_in_progress;    // 1 mission in progres, 0 mission over

   uchar sample_rate;            // minutes between samples

   uchar rollover_enable;        // 1 if roll-over enabled
   uchar rollover_occurred;      // 1 if roll-over occurred

   ushort start_delay;           // minutes before mission starts

   ulong mission_start_time;     // date/time when mission started
   ulong current_time;           // current real-time clock value
   ulong download_time;          // download stations time of reading

   ulong mission_samples;        // number of samples in this mission
   ulong samples_total;          // total number of samples taken by device
    
   uchar high_threshold;         // raw temp of high threshold
   uchar low_threshold;          // raw temp of low threshold

   // skip alarm modes and status for now

   uchar status_raw[32];

} MissionStatus;

// structure to hold the histogram data 
typedef struct 
{
   ushort bin_count[56];    // counter per bin 0 to 55 
   float  start_range[56];  // start temp range (C) in bin 0 to 55
   float  end_range[56];    // end temp range (C) in bin 0 to 55

   uchar  hist_raw[128];    // raw data for histogram

} Histogram;

// structure to hold the histogram data 
typedef struct 
{
   int num_low;               // number of low events
   ulong low_start_time[12];  // start time of event 0 to 12
   ulong low_end_time[12];    // end time of event 0 to 12 
   int num_high;              // number of high events
   ulong high_start_time[12]; // start time of event 0 to 12
   ulong high_end_time[12];   // end time of event 0 to 12

   uchar  alarm_raw[96];     // raw data for alarm events

} TempAlarmEvents;

// structure to hold the log data 
typedef struct 
{
   int   num_log;             // number of logs
   float temp[2048];          // temperature log in (C) 
   ulong start_time;          // start time of log
   int   interval;            // interval in seconds between logs

   uchar log_raw[2048];       // raw data for log

} Log;

// type structure to holde time/date 
typedef struct          
{
     ushort  second;
     ushort  minute;
     ushort  hour;
     ushort  day;
     ushort  month;
     ushort  year;
} timedate;

// structure to hold each state in the StateMachine
typedef struct
{
   int  Step;
   char StepDescription[50];

} ThermoState;

// step constants
enum { ST_SETUP=0, ST_READ_STATUS, ST_READ_ALARM, ST_READ_HIST,
       ST_READ_LOG, ST_CLEAR_MEM, ST_CLEAR_VERIFY, ST_WRITE_TIME,
       ST_WRITE_CONTROL, ST_WRITE_RATE, ST_FINISH, ST_GET_SESSION, 
       ST_FIND_THERMO, ST_REL_SESSION, ST_READ_PAGES, ST_WRITE_MEM,
       ST_CLEAR_SETUP };

// status contants
enum { STATUS_STEP_COMPLETE, STATUS_COMPLETE, STATUS_INPROGRESS,
       STATUS_ERROR_HALT, STATUS_ERROR_TRANSIENT };

#endif

#ifdef TMEXUTIL

// download steps
ThermoState DownloadThermo[] = 
    {{ ST_FIND_THERMO,  "Search for Thermochron"},
     { ST_READ_STATUS,  "Setup to read the mission status"},
     { ST_READ_PAGES,   "Read the status page"},
     { ST_READ_ALARM,   "Setup to read alarm pages"},
     { ST_READ_PAGES,   "Read the alarm pages"},
     { ST_READ_HIST,    "Setup to read histogram pages"},
     { ST_READ_PAGES,   "Read the histogram pages"},
     { ST_READ_LOG,     "Setup to read log pages"},
     { ST_READ_PAGES,   "Read the log pages"},
     { ST_FINISH,       "Finished"}}; 

// read status only steps
ThermoState StatusThermo[] = 
    {{ ST_FIND_THERMO,  "Search for Thermochron"},
     { ST_READ_STATUS,  "Setup to read the mission status"},
     { ST_READ_PAGES,   "Read the status page"},
     { ST_FINISH,       "Finished"}}; 

// mission steps (assume already did StatusThermo)
ThermoState MissionThermo[] = 
    {{ ST_CLEAR_SETUP,  "Setup clear memory"},
     { ST_WRITE_MEM,    "Write clear memory bit"},
     { ST_CLEAR_MEM,    "Clear the memory"},
     { ST_READ_STATUS,  "Setup to read the mission status"},
     { ST_READ_PAGES,   "Read the status page"},
     { ST_CLEAR_VERIFY, "Verify memory is clear"},
     { ST_WRITE_TIME,   "Setup to write the real time clock"},
     { ST_WRITE_MEM,    "Write the real time clock"},
     { ST_WRITE_CONTROL,"Setup to write the control"},
     { ST_WRITE_MEM,    "Write the control"},
     { ST_WRITE_RATE,   "Setup to write the sample rate to start mission"},
     { ST_WRITE_MEM,    "Write the sample rate"},
     { ST_READ_STATUS,  "Read the new mission status"},
     { ST_FINISH,       "Finished"}}; 

// current mission state
MissionStatus MissStat;

// current histogram data
Histogram HistData;

// current temperature alarm event data
TempAlarmEvents AlarmData;

// current log data
Log LogData;

#else

extern ThermoState DownloadThermo[];
extern ThermoState StatusThermo[]; 
extern ThermoState MissionThermo[]; 
extern MissionStatus MissStat;
extern Histogram HistData;
extern TempAlarmEvents AlarmData;
extern Log LogData;

#endif
