/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import net.minecraft.LoginForm;

public class TexturedPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Image img;
    private Image bgImage;

    public TexturedPanel() {
        this.setOpaque(true);
        try {
            this.bgImage = ImageIO.read(LoginForm.class.getResource("dirt.png")).getScaledInstance(32, 32, 16);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getWidth() / 2 + 1;
        int n2 = this.getHeight() / 2 + 1;
        if (this.img == null || this.img.getWidth(null) != n || this.img.getHeight(null) != n2) {
            int n3;
            this.img = this.createImage(n, n2);
            Graphics graphics2 = this.img.getGraphics();
            for (int i = 0; i <= n / 32; ++i) {
                for (n3 = 0; n3 <= n2 / 32; ++n3) {
                    graphics2.drawImage(this.bgImage, i * 32, n3 * 32, null);
                }
            }
            if (graphics2 instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics2;
                n3 = 1;
                graphics2D.setPaint(new GradientPaint(new Point2D.Float(0.0f, 0.0f), new Color(0x20FFFFFF, true), new Point2D.Float(0.0f, n3), new Color(0, true)));
                graphics2D.fillRect(0, 0, n, n3);
                n3 = n2;
                graphics2D.setPaint(new GradientPaint(new Point2D.Float(0.0f, 0.0f), new Color(0, true), new Point2D.Float(0.0f, n3), new Color(0x60000000, true)));
                graphics2D.fillRect(0, 0, n, n3);
            }
            graphics2.dispose();
        }
        graphics.drawImage(this.img, 0, 0, n * 2, n2 * 2, null);
    }
}

