/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.minecraft.LauncherFrame;
import net.minecraft.LogoPanel;
import net.minecraft.OptionsPanel;
import net.minecraft.TexturedPanel;
import net.minecraft.TransparentButton;
import net.minecraft.TransparentCheckbox;
import net.minecraft.TransparentLabel;
import net.minecraft.TransparentPanel;
import net.minecraft.Util;

public class LoginForm
extends TransparentPanel {
    private static final HyperlinkListener EXTERNAL_HYPERLINK_LISTENER = new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Util.openLink(hyperlinkEvent.getURL().toURI());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    };
    private static final int PANEL_SIZE = 100;
    private static final long serialVersionUID = 1L;
    private static final Color LINK_COLOR = new Color(0x8080FF);
    public JTextField userName = new JTextField(20);
    public JPasswordField password = new JPasswordField(20);
    private JScrollPane scrollPane;
    private TransparentCheckbox rememberBox = new TransparentCheckbox("Remember password");
    private TransparentButton launchButton = new TransparentButton("Login");
    private TransparentButton optionsButton = new TransparentButton("Options");
    private TransparentButton retryButton = new TransparentButton("Try again");
    private TransparentButton offlineButton = new TransparentButton("Play offline");
    private TransparentLabel errorLabel = new TransparentLabel("", 0);
    private LauncherFrame launcherFrame;
    private boolean outdated = false;
    private boolean playOfflineAsDemo = false;

    public LoginForm(final LauncherFrame launcherFrame) {
        this.launcherFrame = launcherFrame;
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.add((Component)this.buildMainLoginPanel(), "Center");
        this.readUsername();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginForm.this.doLogin();
            }
        };
        this.userName.addActionListener(actionListener);
        this.password.addActionListener(actionListener);
        this.retryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginForm.this.errorLabel.setText("");
                LoginForm.this.removeAll();
                LoginForm.this.add((Component)LoginForm.this.buildMainLoginPanel(), "Center");
                LoginForm.this.validate();
            }
        });
        this.offlineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                launcherFrame.playCached(LoginForm.this.userName.getText(), LoginForm.this.playOfflineAsDemo);
            }
        });
        this.launchButton.addActionListener(actionListener);
        this.optionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new OptionsPanel(launcherFrame).setVisible(true);
            }
        });
    }

    public void doLogin() {
        this.setLoggingIn();
        new Thread(){

            public void run() {
                try {
                    LoginForm.this.launcherFrame.login(LoginForm.this.userName.getText(), new String(LoginForm.this.password.getPassword()));
                }
                catch (Exception exception) {
                    LoginForm.this.setError(exception.toString());
                }
            }
        }.start();
    }

    private void readUsername() {
        try {
            File file = new File(Util.getWorkingDirectory(), "lastlogin");
            Cipher cipher = this.getCipher(2, "passwordfile");
            DataInputStream dataInputStream = cipher != null ? new DataInputStream(new CipherInputStream(new FileInputStream(file), cipher)) : new DataInputStream(new FileInputStream(file));
            this.userName.setText(dataInputStream.readUTF());
            this.password.setText(dataInputStream.readUTF());
            this.rememberBox.setSelected(this.password.getPassword().length > 0);
            dataInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeUsername() {
        try {
            File file = new File(Util.getWorkingDirectory(), "lastlogin");
            Cipher cipher = this.getCipher(1, "passwordfile");
            DataOutputStream dataOutputStream = cipher != null ? new DataOutputStream(new CipherOutputStream(new FileOutputStream(file), cipher)) : new DataOutputStream(new FileOutputStream(file));
            dataOutputStream.writeUTF(this.userName.getText());
            dataOutputStream.writeUTF(this.rememberBox.isSelected() ? new String(this.password.getPassword()) : "");
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Cipher getCipher(int n, String string) throws Exception {
        Random random = new Random(43287234L);
        byte[] byArray = new byte[8];
        random.nextBytes(byArray);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, 5);
        SecretKey secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec(string.toCharArray()));
        Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES");
        cipher.init(n, (Key)secretKey, pBEParameterSpec);
        return cipher;
    }

    private JScrollPane getUpdateNews() {
        if (this.scrollPane != null) {
            return this.scrollPane;
        }
        try {
            final JTextPane jTextPane = new JTextPane(){
                private static final long serialVersionUID = 1L;
            };
            jTextPane.setEditable(false);
            jTextPane.setMargin(null);
            jTextPane.setBackground(Color.DARK_GRAY);
            jTextPane.setContentType("text/html");
            jTextPane.setText("<html><body><font color=\"#808080\"><br><br><br><br><br><br><br><center><h1>Loading update news..</h1></center></font></body></html>");
            jTextPane.addHyperlinkListener(EXTERNAL_HYPERLINK_LISTENER);
            new Thread(){

                public void run() {
                    try {
                        jTextPane.setPage(new URL("http://mcupdate.tumblr.com/"));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        jTextPane.setText("<html><body><font color=\"#808080\"><br><br><br><br><br><br><br><center><h1>Failed to update news</h1><br>" + exception.toString() + "</center></font></body></html>");
                    }
                }
            }.start();
            this.scrollPane = new JScrollPane(jTextPane);
            this.scrollPane.setBorder(null);
            this.scrollPane.setBorder(new MatteBorder(0, 0, 2, 0, Color.BLACK));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.scrollPane;
    }

    private JPanel buildMainLoginPanel() {
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout());
        transparentPanel.add((Component)this.getUpdateNews(), "Center");
        TexturedPanel texturedPanel = new TexturedPanel();
        texturedPanel.setLayout(new BorderLayout());
        texturedPanel.add((Component)new LogoPanel(), "West");
        texturedPanel.add((Component)new TransparentPanel(), "Center");
        texturedPanel.add(this.center(this.buildLoginPanel()), "East");
        texturedPanel.setPreferredSize(new Dimension(100, 100));
        transparentPanel.add((Component)texturedPanel, "South");
        return transparentPanel;
    }

    private JPanel buildLoginPanel() {
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setInsets(4, 0, 4, 0);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(0);
        borderLayout.setVgap(8);
        transparentPanel.setLayout(borderLayout);
        GridLayout gridLayout = new GridLayout(0, 1);
        gridLayout.setVgap(2);
        GridLayout gridLayout2 = new GridLayout(0, 1);
        gridLayout2.setVgap(2);
        GridLayout gridLayout3 = new GridLayout(0, 1);
        gridLayout3.setVgap(2);
        TransparentPanel transparentPanel2 = new TransparentPanel(gridLayout);
        TransparentPanel transparentPanel3 = new TransparentPanel(gridLayout2);
        transparentPanel2.add(new TransparentLabel("Username:", 4));
        transparentPanel2.add(new TransparentLabel("Password:", 4));
        transparentPanel2.add(new TransparentLabel("", 4));
        transparentPanel3.add(this.userName);
        transparentPanel3.add(this.password);
        transparentPanel3.add(this.rememberBox);
        transparentPanel.add((Component)transparentPanel2, "West");
        transparentPanel.add((Component)transparentPanel3, "Center");
        TransparentPanel transparentPanel4 = new TransparentPanel(new BorderLayout());
        TransparentPanel transparentPanel5 = new TransparentPanel(gridLayout3);
        transparentPanel2.setInsets(0, 0, 0, 4);
        transparentPanel5.setInsets(0, 10, 0, 10);
        transparentPanel5.add(this.optionsButton);
        transparentPanel5.add(this.launchButton);
        try {
            if (this.outdated) {
                TransparentLabel transparentLabel = this.getUpdateLink();
                transparentPanel5.add(transparentLabel);
            } else {
                TransparentLabel transparentLabel = new TransparentLabel("Need account?"){
                    private static final long serialVersionUID = 0L;

                    public void paint(Graphics graphics) {
                        super.paint(graphics);
                        int n = 0;
                        int n2 = 0;
                        FontMetrics fontMetrics = graphics.getFontMetrics();
                        int n3 = fontMetrics.stringWidth(this.getText());
                        int n4 = fontMetrics.getHeight();
                        if (this.getAlignmentX() == 2.0f) {
                            n = 0;
                        } else if (this.getAlignmentX() == 0.0f) {
                            n = this.getBounds().width / 2 - n3 / 2;
                        } else if (this.getAlignmentX() == 4.0f) {
                            n = this.getBounds().width - n3;
                        }
                        n2 = this.getBounds().height / 2 + n4 / 2 - 1;
                        graphics.drawLine(n + 2, n2, n + n3 - 2, n2);
                    }

                    public void update(Graphics graphics) {
                        this.paint(graphics);
                    }
                };
                transparentLabel.setCursor(Cursor.getPredefinedCursor(12));
                transparentLabel.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        try {
                            Util.openLink(new URL("http://www.minecraft.net/register.jsp").toURI());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                transparentLabel.setForeground(LINK_COLOR);
                transparentPanel5.add(transparentLabel);
            }
        }
        catch (Error error) {
            // empty catch block
        }
        transparentPanel4.add((Component)transparentPanel5, "Center");
        transparentPanel.add((Component)transparentPanel4, "East");
        this.errorLabel.setFont(new Font(null, 2, 16));
        this.errorLabel.setForeground(new Color(0xFF4040));
        this.errorLabel.setText("");
        transparentPanel.add((Component)this.errorLabel, "North");
        return transparentPanel;
    }

    private TransparentLabel getUpdateLink() {
        TransparentLabel transparentLabel = new TransparentLabel("You need to update the launcher!"){
            private static final long serialVersionUID = 0L;

            public void paint(Graphics graphics) {
                super.paint(graphics);
                int n = 0;
                int n2 = 0;
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n3 = fontMetrics.stringWidth(this.getText());
                int n4 = fontMetrics.getHeight();
                if (this.getAlignmentX() == 2.0f) {
                    n = 0;
                } else if (this.getAlignmentX() == 0.0f) {
                    n = this.getBounds().width / 2 - n3 / 2;
                } else if (this.getAlignmentX() == 4.0f) {
                    n = this.getBounds().width - n3;
                }
                n2 = this.getBounds().height / 2 + n4 / 2 - 1;
                graphics.drawLine(n + 2, n2, n + n3 - 2, n2);
            }

            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        };
        transparentLabel.setCursor(Cursor.getPredefinedCursor(12));
        transparentLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    Util.openLink(new URL("http://www.minecraft.net/download.jsp").toURI());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        transparentLabel.setForeground(LINK_COLOR);
        return transparentLabel;
    }

    private JPanel buildMainOfflinePanel(boolean bl) {
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout());
        transparentPanel.add((Component)this.getUpdateNews(), "Center");
        TexturedPanel texturedPanel = new TexturedPanel();
        texturedPanel.setLayout(new BorderLayout());
        texturedPanel.add((Component)new LogoPanel(), "West");
        texturedPanel.add((Component)new TransparentPanel(), "Center");
        texturedPanel.add(this.center(this.buildOfflinePanel(bl)), "East");
        texturedPanel.setPreferredSize(new Dimension(100, 100));
        transparentPanel.add((Component)texturedPanel, "South");
        return transparentPanel;
    }

    private Component center(Component component) {
        TransparentPanel transparentPanel = new TransparentPanel(new GridBagLayout());
        transparentPanel.add(component);
        return transparentPanel;
    }

    private TransparentPanel buildOfflinePanel(boolean bl) {
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setInsets(0, 0, 0, 20);
        BorderLayout borderLayout = new BorderLayout();
        transparentPanel.setLayout(borderLayout);
        TransparentPanel transparentPanel2 = new TransparentPanel(new BorderLayout());
        GridLayout gridLayout = new GridLayout(0, 1);
        gridLayout.setVgap(2);
        TransparentPanel transparentPanel3 = new TransparentPanel(gridLayout);
        transparentPanel3.setInsets(0, 8, 0, 0);
        if (bl) {
            this.offlineButton.setText("Play Demo");
        } else {
            this.offlineButton.setText("Play Offline");
        }
        transparentPanel3.add(this.retryButton);
        transparentPanel3.add(this.offlineButton);
        transparentPanel2.add((Component)transparentPanel3, "East");
        boolean bl2 = this.launcherFrame.canPlayOffline(this.userName.getText()) || bl;
        this.offlineButton.setEnabled(bl2);
        if (!bl2) {
            transparentPanel2.add((Component)new TransparentLabel("(Not downloaded)", 4), "South");
        }
        transparentPanel.add((Component)transparentPanel2, "Center");
        TransparentPanel transparentPanel4 = new TransparentPanel(new GridLayout(0, 1));
        this.errorLabel.setFont(new Font(null, 2, 16));
        this.errorLabel.setForeground(new Color(0xFF4040));
        transparentPanel4.add(this.errorLabel);
        if (this.outdated) {
            TransparentLabel transparentLabel = this.getUpdateLink();
            transparentPanel4.add(transparentLabel);
        }
        transparentPanel2.add((Component)transparentPanel4, "Center");
        return transparentPanel;
    }

    public void setError(String string) {
        this.removeAll();
        this.add((Component)this.buildMainLoginPanel(), "Center");
        this.errorLabel.setText(string);
        this.validate();
    }

    public void loginOk() {
        this.writeUsername();
    }

    public void setLoggingIn() {
        this.removeAll();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getUpdateNews(), "Center");
        TexturedPanel texturedPanel = new TexturedPanel();
        texturedPanel.setLayout(new BorderLayout());
        texturedPanel.add((Component)new LogoPanel(), "West");
        texturedPanel.add((Component)new TransparentPanel(), "Center");
        TransparentLabel transparentLabel = new TransparentLabel("Logging in...                      ", 0);
        transparentLabel.setFont(new Font(null, 1, 16));
        texturedPanel.add(this.center(transparentLabel), "East");
        texturedPanel.setPreferredSize(new Dimension(100, 100));
        jPanel.add((Component)texturedPanel, "South");
        this.add((Component)jPanel, "Center");
        this.validate();
    }

    public void setNoNetwork(boolean bl) {
        this.playOfflineAsDemo = bl;
        this.removeAll();
        this.add((Component)this.buildMainOfflinePanel(bl), "Center");
        this.validate();
    }

    public void setOutdated() {
        this.outdated = true;
    }
}

