/****************************************************************************

    microdrv.c

    Code for handling Microdrive devices

****************************************************************************/

#include "emu.h"
#include "microdrv.h"

static DEVICE_START(microdrv)
{
}

DEVICE_GET_INFO(microdrv)
{
	switch (state)
	{
		/* --- the following bits of info are returned as 64-bit signed integers --- */
		case DEVINFO_INT_TOKEN_BYTES:					info->i = 1; break;
		case DEVINFO_INT_INLINE_CONFIG_BYTES:			info->i = 0; break;
		case DEVINFO_INT_IMAGE_TYPE:					info->i = IO_CASSETTE; break;
		case DEVINFO_INT_IMAGE_READABLE:				info->i = 1; break;
		case DEVINFO_INT_IMAGE_WRITEABLE:				info->i = 1; break;
		case DEVINFO_INT_IMAGE_CREATABLE:				info->i = 0; break;

		/* --- the following bits of info are returned as pointers to data or functions --- */
		case DEVINFO_FCT_START:							info->start = DEVICE_START_NAME(microdrv); break;

		/* --- the following bits of info are returned as NULL-terminated strings --- */
		case DEVINFO_STR_NAME:							strcpy(info->s, "Microdrive"); break;
		case DEVINFO_STR_FAMILY:						strcpy(info->s, "Microdrive"); break;
		case DEVINFO_STR_SOURCE_FILE:					strcpy(info->s, __FILE__); break;
		case DEVINFO_STR_IMAGE_FILE_EXTENSIONS:			strcpy(info->s, "mdv"); break;
	}
}

DEFINE_LEGACY_IMAGE_DEVICE(MICRODRIVE, microdrv);
