
%define _prefix	/usr
%define _SO_nr	0

Name:		libzen%{_SO_nr}
Version:	0.4.20
Release:	%mkrel 1
Summary:	Shared library for mediainfo
Summary(de):	Benötigte Bibliothek für MediaInfo
Group:		System/Libraries
License:	BSD
URL:		http://zenlib.sourceforge.net/
Source:		libzen_%{version}.tar.bz2
Source90:	libzen-rpmlintrc
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires:	dos2unix
BuildRequires:	doxygen
BuildRequires:	gcc-c++
Requires:   glibc >= 2.10.1
Requires:   libstdc++6 >= 4.4.1
Obsoletes:	%name < %version

%description
Shared library for libmediainfo and medianfo-gui.

#german
%description -l de
Benötigte Bibliothek für libmediainfo und MediaINFO-GUI.


%package -n libzen-devel
Summary:	Include files and libraries for development
Summary(de):	Include Dateien und Bibliotheken für die Entwicklung
Group:		Development/Libraries/C and C++
Requires:	libzen%{_SO_nr} = %{version}

%description -n libzen-devel
Include files and mandatory libraries for development.

#german
%description -n libzen-devel -l de
Include Dateien und benötigte Bibliotheken für die Entwicklung.


%prep
%setup -q -n ZenLib
dos2unix     *.txt Source/Doc/*.html
%__chmod 644 *.txt Source/Doc/*.html

%build
# generate docs
pushd Source/Doc
	doxygen -u 2> /dev/null
	doxygen Doxyfile
popd

export CFLAGS="$RPM_OPT_FLAGS"
export CPPFLAGS="$RPM_OPT_FLAGS"
export CXXFLAGS="$RPM_OPT_FLAGS"

pushd Project/GNU/Library
	%__chmod +x autogen
	./autogen
	%configure \
		--enable-shared

	%__make clean
	%__make %{?jobs:-j%{jobs}}
popd

%install
pushd Project/GNU/Library
	%makeinstall
popd

# Zenlib headers and ZenLib-config
%__install -dm 755 %{buildroot}%{_includedir}/ZenLib
%__install -m 644 Source/ZenLib/*.h \
	%{buildroot}%{_includedir}/ZenLib
for i in Base64 HTTP_Client; do
	%__install -dm 755 %{buildroot}%{_includedir}/ZenLib/$i
	%__install -m 644 Source/ZenLib/$i/*.h \
		%{buildroot}%{_includedir}/ZenLib/$i
done

%__sed -i -e 's|Version: |Version: %{version}|g' \
	Project/GNU/Library/libzen.pc
%__install -dm 755 %{buildroot}%{_libdir}/pkgconfig
%__install -m 644 Project/GNU/Library/libzen.pc \
	%{buildroot}%{_libdir}/pkgconfig

%__rm %{buildroot}%{_libdir}/libzen.la

%clean
[ -d "%{buildroot}" -a "%{buildroot}" != "" ] && %__rm -rf "%{buildroot}"

%post -n libzen%{_SO_nr} -p /sbin/ldconfig

%postun -n libzen%{_SO_nr} -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc *.txt
%{_libdir}/libzen.so.*

%files -n libzen-devel
%defattr(-,root,root,-)
%doc Source/Doc/Documentation.html
%doc Doc/*
%dir %{_includedir}/ZenLib
%{_includedir}/ZenLib/*
%{_libdir}/libzen.a
%{_libdir}/libzen.so
%{_libdir}/pkgconfig/*.pc

%changelog
* Wed Jan 06 2010 leiche >MeissSW01 at aol.com> 0.4.13-1pclos2010
- 0.4.13

* Fri Nov 13 2009 Leiche <MeissSW01 at aol.com> 0.4.9-1pclos2010
- 0.4.9

* Fri Sep 11 2009 slick50 <lxgator@gmail.com> 0.4.3-1pclos2009
- 0.4.3

* Mon Jun 01 2009 Texstar <texstar@gmail.com> 0.4.2-1pclos2009
- import from Toni Graffy
