/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.svg;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.mapyrus.Constants;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SVGFile
extends DefaultHandler {
    private Rectangle2D m_boundingBox;
    private StringBuffer m_contents;
    private StringBuffer m_SVGAttributes;
    private int m_SVGTagCount;

    public SVGFile(String string) throws IOException, MapyrusException {
        InputStream inputStream = null;
        try {
            XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setEntityResolver(this);
            inputStream = new FileOrURL(string).getInputStream();
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MapyrusException(MapyrusMessages.get("invalidsvg") + ": " + string + ": " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new MapyrusException(MapyrusMessages.get("invalidsvg") + ": " + string + ": " + sAXException.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Rectangle2D getBoundingBox() {
        return this.m_boundingBox;
    }

    @Override
    public void startDocument() {
        this.m_contents = new StringBuffer(1024);
        this.m_SVGAttributes = new StringBuffer(256);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new StringReader(""));
    }

    private double parseSize(String string) {
        double d = 1.0;
        if (string.endsWith("pt")) {
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("px")) {
            string = string.substring(0, string.length() - 2);
            d = 72.0 / (double)Constants.getScreenResolution();
        } else if (string.endsWith("mm")) {
            string = string.substring(0, string.length() - 2);
            d = 2.834645669291339;
        } else if (string.endsWith("cm")) {
            string = string.substring(0, string.length() - 2);
            d = 28.34645669291339;
        } else if (string.endsWith("in")) {
            string = string.substring(0, string.length() - 2);
            d = 72.0;
        }
        double d2 = Double.parseDouble(string);
        return d2 * d;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("svg")) {
            ++this.m_SVGTagCount;
        }
        if (string3.equals("svg") && this.m_SVGTagCount == 1) {
            String string4 = attributes.getValue("width");
            String string5 = attributes.getValue("height");
            this.m_boundingBox = new Rectangle2D.Double(0.0, 0.0, this.parseSize(string4), this.parseSize(string5));
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("width") || attributes.getQName(i).equals("height")) continue;
                this.m_SVGAttributes.append(attributes.getQName(i));
                this.m_SVGAttributes.append("=\"");
                this.m_SVGAttributes.append(attributes.getValue(i));
                this.m_SVGAttributes.append("\"");
                this.m_SVGAttributes.append(Constants.LINE_SEPARATOR);
            }
        } else {
            this.m_contents.append("<").append(string3).append(" ");
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.m_contents.append(attributes.getQName(i));
                this.m_contents.append("=\"");
                this.m_contents.append(attributes.getValue(i));
                this.m_contents.append("\"");
                this.m_contents.append(Constants.LINE_SEPARATOR);
            }
            this.m_contents.append(">");
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (string3.equals("svg")) {
            --this.m_SVGTagCount;
            if (this.m_SVGTagCount > 0) {
                this.m_contents.append("</svg>");
            }
        } else {
            this.m_contents.append("</").append(string3).append(">");
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            if (c == '&' || c == '<' || c == '>' || c == '\"' || c > '\u007f') {
                this.m_contents.append("&#").append(Integer.toString(c)).append(";");
                continue;
            }
            this.m_contents.append(c);
        }
    }

    public String toString() {
        return this.m_contents.toString();
    }

    public String getSVGAttributes() {
        return this.m_SVGAttributes.toString();
    }
}

