/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.script;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.mapyrus.FileOrURL;
import org.mapyrus.Interpreter;
import org.mapyrus.MapyrusException;
import org.mapyrus.script.MapyrusBindings;
import org.mapyrus.script.MapyrusScriptContext;
import org.mapyrus.script.MapyrusScriptEngineFactory;

public class MapyrusScriptEngine
implements ScriptEngine {
    MapyrusScriptEngineFactory m_factory;
    MapyrusScriptContext m_scriptContext;

    public MapyrusScriptEngine(MapyrusScriptEngineFactory mapyrusScriptEngineFactory) {
        this.m_factory = mapyrusScriptEngineFactory;
        this.m_scriptContext = new MapyrusScriptContext();
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        this.setContext(scriptContext);
        return this.eval(string);
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        this.setContext(scriptContext);
        return this.eval(reader);
    }

    @Override
    public Object eval(String string) throws ScriptException {
        return this.eval(new StringReader(string));
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        try {
            FileOrURL fileOrURL = new FileOrURL(reader, this.getClass().getSimpleName());
            byte[] byArray = new byte[]{};
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            Interpreter interpreter = this.m_scriptContext.getInterpreter();
            interpreter.interpret(this.m_scriptContext.getContextStack(), fileOrURL, byteArrayInputStream, printStream);
            Writer writer = this.m_scriptContext.getWriter();
            if (writer != null) {
                writer.write(byteArrayOutputStream.toString());
                writer.flush();
            }
        }
        catch (MapyrusException mapyrusException) {
            throw new ScriptException(mapyrusException);
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new ScriptException(interruptedException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String string, Bindings bindings) throws ScriptException {
        Object object = null;
        Bindings bindings2 = this.getBindings(100);
        try {
            this.setBindings(bindings, 100);
            object = this.eval(string);
        }
        finally {
            this.setBindings(bindings2, 100);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        Object object = null;
        Bindings bindings2 = this.getBindings(100);
        try {
            this.setBindings(bindings, 100);
            object = this.eval(reader);
        }
        finally {
            this.setBindings(bindings2, 100);
        }
        return object;
    }

    @Override
    public void put(String string, Object object) {
        this.getBindings(100).put(string, object);
    }

    @Override
    public Object get(String string) {
        return this.getBindings(100).get(string);
    }

    @Override
    public Bindings getBindings(int n) {
        return this.getContext().getBindings(n);
    }

    @Override
    public void setBindings(Bindings bindings, int n) {
        if (n == 100) {
            this.getContext().setBindings(bindings, n);
        }
    }

    @Override
    public Bindings createBindings() {
        return new MapyrusBindings();
    }

    @Override
    public ScriptContext getContext() {
        return this.m_scriptContext;
    }

    @Override
    public void setContext(ScriptContext scriptContext) {
        this.m_scriptContext = (MapyrusScriptContext)scriptContext;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.m_factory;
    }
}

