/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.mapyrus.Constants;

public class CrosshairMouseListener
implements MouseMotionListener,
MouseListener {
    private static DecimalFormat m_crosshairFormat = new DecimalFormat("#.####", Constants.US_DECIMAL_FORMAT_SYMBOLS);
    private static Color m_crosshairBgColor = new Color(240, 240, 150);
    private static Font m_fixedFont = new Font("Monospaced", 0, 12);
    private BufferedImage m_displayImage;
    private Rectangle2D.Double m_displayImageWorlds;
    private boolean m_isCrosshairCursor = false;

    public void setImage(BufferedImage bufferedImage) {
        this.m_displayImage = bufferedImage;
    }

    public void setWorlds(Rectangle2D.Double double_) {
        this.m_displayImageWorlds = double_;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.m_displayImage == null || this.m_displayImageWorlds == null) {
            return;
        }
        JPanel jPanel = (JPanel)mouseEvent.getComponent();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.m_displayImage.getWidth();
        int n4 = this.m_displayImage.getHeight();
        if (n < n3 && n2 < n4) {
            Object object;
            if (!this.m_isCrosshairCursor) {
                object = new BufferedImage(1, 1, 6);
                Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), "null");
                jPanel.setCursor(cursor);
                this.m_isCrosshairCursor = true;
            }
            object = jPanel.getGraphics();
            ((Graphics)object).drawImage(this.m_displayImage, 0, 0, null);
            ((Graphics)object).setColor(Color.BLACK);
            ((Graphics)object).drawLine(0, n2, n3 - 1, n2);
            ((Graphics)object).drawLine(n, 0, n, n4 - 1);
            ((Graphics)object).setColor(m_crosshairBgColor);
            ((Graphics)object).setFont(m_fixedFont);
            double d = this.m_displayImageWorlds.getMinX() + (double)n / (double)n3 * this.m_displayImageWorlds.getWidth();
            double d2 = this.m_displayImageWorlds.getMaxY() - (double)n2 / (double)n4 * this.m_displayImageWorlds.getHeight();
            StringBuffer stringBuffer = new StringBuffer();
            if (Math.abs(d) < 1000.0) {
                stringBuffer.append(m_crosshairFormat.format(d));
            } else {
                stringBuffer.append(Math.round(d));
            }
            stringBuffer.append(", ");
            if (Math.abs(d2) < 1000.0) {
                stringBuffer.append(m_crosshairFormat.format(d2));
            } else {
                stringBuffer.append(Math.round(d2));
            }
            Rectangle2D rectangle2D = ((Graphics)object).getFontMetrics().getStringBounds(stringBuffer.toString(), (Graphics)object);
            int n5 = n <= n3 / 2 ? 2 : -((int)(rectangle2D.getWidth() + 1.0));
            int n6 = n2 <= n4 / 2 ? (int)(rectangle2D.getHeight() + 1.0) : -2;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (i == 0 && j == 0) continue;
                    ((Graphics)object).drawString(stringBuffer.toString(), n + n5 + i, n2 + n6 + j);
                }
            }
            ((Graphics)object).setColor(Color.BLACK);
            ((Graphics)object).drawString(stringBuffer.toString(), n + n5, n2 + n6);
        } else {
            jPanel.setCursor(new Cursor(0));
            this.m_isCrosshairCursor = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        JPanel jPanel = (JPanel)mouseEvent.getComponent();
        jPanel.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

