/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.LinkedList;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

class Preprocessor {
    private static final String INCLUDE_KEYWORD = "include";
    private static final char COMMENT_CHAR_HASH = '#';
    private static final char COMMENT_CHAR_SLASH = '/';
    private static final char COMMENT_CHAR_ASTERISK = '*';
    private LinkedList<FileOrURL> m_fileStack;
    private FileOrURL m_initialFile;
    private StringBuffer m_currentLine = null;
    private int m_currentLineIndex = 0;
    private boolean m_InSingleLineComment = false;
    private boolean m_InMultiLineComment = false;
    private boolean m_isIncludeAllowed;

    private void initFileStack(FileOrURL fileOrURL, boolean bl) {
        this.m_fileStack = new LinkedList();
        this.m_fileStack.add(fileOrURL);
        this.m_initialFile = fileOrURL;
        this.m_isIncludeAllowed = bl;
    }

    public Preprocessor(FileOrURL fileOrURL, boolean bl) {
        this.initFileStack(fileOrURL, bl);
    }

    public Preprocessor(String string) throws IOException, MapyrusException {
        FileOrURL fileOrURL = new FileOrURL(string);
        this.initFileStack(fileOrURL, true);
    }

    private void openIncludedFile(String string) throws MalformedURLException, IOException, MapyrusException {
        FileOrURL fileOrURL = this.m_fileStack.getLast();
        FileOrURL fileOrURL2 = fileOrURL.isURL() ? new FileOrURL(string, fileOrURL) : new FileOrURL(string);
        if (fileOrURL2.isURL()) {
            String string2;
            try {
                string2 = fileOrURL2.getURLContentType();
            }
            catch (IOException iOException) {
                fileOrURL2.getReader().close();
                throw iOException;
            }
            if (!string2.startsWith("text/")) {
                fileOrURL2.getReader().close();
                throw new MapyrusException(MapyrusMessages.get("nottextfile") + ": " + fileOrURL2.toString());
            }
        }
        this.m_fileStack.add(fileOrURL2);
    }

    private int readSkipComments() throws IOException, MapyrusException {
        int n = this.read();
        while (this.m_InSingleLineComment || this.m_InMultiLineComment || n == 35 || n == 47) {
            if (this.m_InSingleLineComment && (n == 10 || n == -1)) {
                this.m_InSingleLineComment = false;
                continue;
            }
            if (this.m_InMultiLineComment && n == -1) {
                this.m_InMultiLineComment = false;
                continue;
            }
            if (this.m_InMultiLineComment && n == 42) {
                n = this.read();
                if (n != 47) continue;
                this.m_InMultiLineComment = false;
                n = this.read();
                continue;
            }
            if (this.m_InSingleLineComment || this.m_InMultiLineComment) {
                n = this.read();
                continue;
            }
            if (n == 35) {
                this.m_InSingleLineComment = true;
                n = this.read();
                continue;
            }
            if (n == 47) {
                int n2 = this.read();
                if (n2 == 47) {
                    this.m_InSingleLineComment = true;
                    n = this.read();
                    continue;
                }
                if (n2 == 42) {
                    this.m_InMultiLineComment = true;
                    n = this.read();
                    continue;
                }
                this.unread(n2);
                break;
            }
            n = this.read();
        }
        return n;
    }

    public int readNonSpace() throws IOException, MapyrusException {
        int n;
        while ((n = this.readSkipComments()) != -1 && Character.isWhitespace((char)n) && n != 10) {
        }
        return n;
    }

    public int read() throws IOException, MapyrusException {
        if (this.m_currentLine != null && this.m_currentLineIndex < this.m_currentLine.length()) {
            char c = this.m_currentLine.charAt(this.m_currentLineIndex++);
            return c;
        }
        this.m_currentLineIndex = 0;
        FileOrURL fileOrURL = this.m_fileStack.getLast();
        LineNumberReader lineNumberReader = fileOrURL.getReader();
        String string = lineNumberReader.readLine();
        if (string == null) {
            this.m_fileStack.removeLast();
            lineNumberReader.close();
            if (this.m_InMultiLineComment) {
                throw new MapyrusException(MapyrusMessages.get("unexpectedeof") + ": " + fileOrURL.toString());
            }
            if (this.m_fileStack.size() > 0) {
                this.m_currentLine = null;
                return this.read();
            }
            return -1;
        }
        this.m_currentLine = new StringBuffer(string);
        while (string != null && string.endsWith("\\")) {
            int n = this.m_currentLine.length();
            this.m_currentLine.deleteCharAt(n - 1);
            string = lineNumberReader.readLine();
            if (string == null) continue;
            this.m_currentLine.append(string);
        }
        this.m_currentLine.append('\n');
        String string2 = this.m_currentLine.toString().trim();
        if (string2.toLowerCase().startsWith(INCLUDE_KEYWORD)) {
            if (string2.length() == INCLUDE_KEYWORD.length()) {
                throw new MapyrusException(this.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("missingfilename"));
            }
            if (Character.isWhitespace(string2.charAt(INCLUDE_KEYWORD.length()))) {
                String string3 = string2.substring(INCLUDE_KEYWORD.length() + 1).trim();
                int n = string3.length();
                if (n > 1 && (string3.startsWith("\"") && string3.endsWith("\"") || string3.startsWith("'") && string3.endsWith("'") || string3.startsWith("\u2019") && string3.endsWith("\u2019") || string3.startsWith("<") && string3.endsWith(">"))) {
                    string3 = string3.substring(1, n - 1);
                }
                if (!this.m_isIncludeAllowed) {
                    throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string3);
                }
                try {
                    this.openIncludedFile(string3);
                }
                catch (Exception exception) {
                    throw new MapyrusException(this.getCurrentFilenameAndLineNumber() + ": " + exception.getMessage());
                }
                this.m_currentLine = null;
                return this.read();
            }
        }
        char c = this.m_currentLine.charAt(this.m_currentLineIndex++);
        return c;
    }

    public void unread(int n) {
        if (n == -1) {
            // empty if block
        }
        if (this.m_currentLine == null) {
            Character c = new Character((char)n);
            this.m_currentLine = new StringBuffer(c.toString());
            this.m_currentLineIndex = 0;
        } else if (this.m_currentLineIndex > 0 && n == this.m_currentLine.charAt(this.m_currentLineIndex - 1)) {
            --this.m_currentLineIndex;
        } else {
            Character c = new Character((char)n);
            this.m_currentLine.insert(this.m_currentLineIndex, c.toString());
        }
    }

    private FileOrURL getCurrentFileOrURL() {
        FileOrURL fileOrURL = this.m_fileStack.size() > 0 ? this.m_fileStack.getLast() : this.m_initialFile;
        return fileOrURL;
    }

    public String getCurrentFilename() {
        FileOrURL fileOrURL = this.getCurrentFileOrURL();
        return fileOrURL.toString();
    }

    public int getCurrentLineNumber() {
        FileOrURL fileOrURL = this.getCurrentFileOrURL();
        return fileOrURL.getReader().getLineNumber();
    }

    public String getCurrentFilenameAndLineNumber() {
        return this.getCurrentFilename() + ":" + this.getCurrentLineNumber();
    }

    public void close() {
        while (!this.m_fileStack.isEmpty()) {
            FileOrURL fileOrURL = this.m_fileStack.removeLast();
            LineNumberReader lineNumberReader = fileOrURL.getReader();
            try {
                ((Reader)lineNumberReader).close();
            }
            catch (IOException iOException) {}
        }
        this.m_fileStack = null;
    }
}

