/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.CMYKColorSpace;
import org.mapyrus.ColorDatabase;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.DefaultFieldNames;
import org.mapyrus.Expression;
import org.mapyrus.FileOrURL;
import org.mapyrus.LegendEntry;
import org.mapyrus.LegendEntryList;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;
import org.mapyrus.PageSize;
import org.mapyrus.ParsedStatement;
import org.mapyrus.Preprocessor;
import org.mapyrus.Row;
import org.mapyrus.Statement;
import org.mapyrus.StatementType;
import org.mapyrus.Throttle;
import org.mapyrus.function.UserFunction;

public class Interpreter
implements Cloneable {
    private static final char ARGUMENT_SEPARATOR = ',';
    private static final char PARAM_SEPARATOR = ',';
    private static final String BEGIN_KEYWORD = "begin";
    private static final String FUNCTION_KEYWORD = "function";
    private static final String END_KEYWORD = "end";
    private static final String IF_KEYWORD = "if";
    private static final String THEN_KEYWORD = "then";
    private static final String ELSE_KEYWORD = "else";
    private static final String ELIF_KEYWORD = "elif";
    private static final String ENDIF_KEYWORD = "endif";
    private static final String WHILE_KEYWORD = "while";
    private static final String REPEAT_KEYWORD = "repeat";
    private static final String DO_KEYWORD = "do";
    private static final String DONE_KEYWORD = "done";
    private static final String FOR_KEYWORD = "for";
    private static final String IN_KEYWORD = "in";
    private static final int AT_ARGUMENT = 1;
    private static final int AT_SEPARATOR = 2;
    private static final int AT_PARAM = 3;
    private static final int AT_PARAM_SEPARATOR = 4;
    public static final String CAP_BUTT_STRING = "butt";
    public static final String CAP_ROUND_STRING = "round";
    public static final String CAP_SQUARE_STRING = "square";
    public static final String JOIN_BEVEL_STRING = "bevel";
    public static final String JOIN_MITER_STRING = "miter";
    public static final String JOIN_ROUND_STRING = "round";
    private ContextStack m_context;
    private InputStream m_stdinStream;
    private PrintStream m_stdoutStream;
    private Throttle m_throttle;
    Argument[] m_executeArgs = null;
    private HashMap<String, Statement> m_statementBlocks = new HashMap();
    private HashMap<String, UserFunction> m_userFunctions = new HashMap();
    private static HashMap<String, Integer> m_worldUnitsLookup = new HashMap();
    private static HashMap<String, ParsedStatement> m_keywordLookup;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setColor(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        int n2 = 255;
        float f = 1.0f;
        if (n == 1 || n == 2) {
            Color color;
            String string = argumentArray[0].getStringValue();
            if (n == 2) {
                f = (float)argumentArray[1].getNumericValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                n2 = (int)Math.round((double)f * 255.0);
            }
            if ((color = ColorDatabase.getColor(string, n2, contextStack.getColor())) == null) {
                throw new MapyrusException(MapyrusMessages.get("colornotfound") + ": " + string);
            }
            contextStack.setColor(color);
            return;
        } else {
            if (n != 4 && n != 5 && n != 6) throw new MapyrusException(MapyrusMessages.get("invalidcolor"));
            String string = argumentArray[0].getStringValue();
            float f2 = (float)argumentArray[1].getNumericValue();
            float f3 = (float)argumentArray[2].getNumericValue();
            float f4 = (float)argumentArray[3].getNumericValue();
            float f5 = 0.0f;
            int n3 = 4;
            if (string.equalsIgnoreCase("cmyk")) {
                if (n < 5) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor"));
                }
                f5 = (float)argumentArray[4].getNumericValue();
                n3 = 5;
            } else if (n > 5) {
                throw new MapyrusException(MapyrusMessages.get("invalidcolor"));
            }
            if (n3 < n) {
                f = (float)argumentArray[n3].getNumericValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                n2 = (int)Math.round((double)f * 255.0);
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            if (f4 < 0.0f) {
                f4 = 0.0f;
            } else if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            if (f5 < 0.0f) {
                f5 = 0.0f;
            } else if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            if (string.equalsIgnoreCase("hsb")) {
                int n4 = Color.HSBtoRGB(f2, f3, f4);
                contextStack.setColor(new Color((n4 &= 0xFFFFFF) | n2 << 24, true));
                return;
            } else if (string.equalsIgnoreCase("rgb")) {
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                contextStack.setColor(new Color(f2, f3, f4, f));
                return;
            } else {
                if (!string.equalsIgnoreCase("cmyk")) throw new MapyrusException(MapyrusMessages.get("invalidcolortype") + ": " + string);
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                float[] fArray = new float[]{f2, f3, f4, f5};
                Color color = new Color(new CMYKColorSpace(), fArray, f);
                contextStack.setColor(color);
            }
        }
    }

    private void setLinestyle(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        String string;
        double d = 0.1;
        double d2 = 0.0;
        float[] fArray = null;
        int n2 = 2;
        int n3 = 0;
        if (n == 0) {
            throw new MapyrusException(MapyrusMessages.get("invalidlinestyle"));
        }
        d = argumentArray[0].getNumericValue();
        if (d < 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + d);
        }
        if (n >= 2) {
            string = argumentArray[1].getStringValue().toLowerCase();
            if (string.equals(CAP_BUTT_STRING)) {
                n2 = 0;
            } else if (string.equals("round")) {
                n2 = 1;
            } else if (string.equals(CAP_SQUARE_STRING)) {
                n2 = 2;
            } else {
                throw new MapyrusException(MapyrusMessages.get("invalidendcap") + ": " + string);
            }
        }
        if (n >= 3) {
            string = argumentArray[2].getStringValue().toLowerCase();
            if (string.equals(JOIN_BEVEL_STRING)) {
                n3 = 2;
            } else if (string.equals(JOIN_MITER_STRING)) {
                n3 = 0;
            } else if (string.equals("round")) {
                n3 = 1;
            } else {
                throw new MapyrusException(MapyrusMessages.get("invalidlinejoin") + ": " + string);
            }
        }
        if (n >= 4 && (d2 = argumentArray[3].getNumericValue()) < 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invaliddashphase") + ": " + d2);
        }
        if (n >= 5) {
            fArray = new float[n - 4];
            for (int i = 4; i < n; ++i) {
                fArray[i - 4] = (float)argumentArray[i].getNumericValue();
                if (!((double)fArray[i - 4] <= 0.0)) continue;
                throw new MapyrusException(MapyrusMessages.get("invaliddashpattern") + ": " + fArray[i - 4]);
            }
        }
        contextStack.setLinestyle(d, n2, n3, d2, fArray);
    }

    private void setJustify(ContextStack contextStack, String string) {
        int n = (string = string.toLowerCase()).indexOf("center") >= 0 || string.indexOf("centre") >= 0 ? 2 : (string.indexOf("right") >= 0 ? 4 : 1);
        n = string.indexOf("top") >= 0 ? (n |= 8) : (string.indexOf("middle") >= 0 ? (n |= 0x10) : (n |= 0x20));
        contextStack.setJustify(n);
    }

    private void setFont(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        double d;
        double d2 = 0.0;
        double d3 = 1.0;
        if (n == 2 || n == 3) {
            d = argumentArray[1].getNumericValue();
            if (d <= 0.0) {
                throw new MapyrusException(MapyrusMessages.get("invalidsize") + ": " + d);
            }
            if (n == 3) {
                String string = argumentArray[2].getStringValue();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2;
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("outlinewidth=")) {
                        string2 = string3.substring(13);
                        try {
                            d2 = Double.parseDouble(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + string2);
                        }
                        if (!(d2 < 0.0)) continue;
                        throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + d2);
                    }
                    if (!string3.startsWith("linespacing=")) continue;
                    string2 = string3.substring(12);
                    try {
                        d3 = Double.parseDouble(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidspacing") + ": " + string2);
                    }
                }
            }
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidfont"));
        }
        contextStack.setFont(argumentArray[0].getStringValue(), d, d2, d3);
    }

    private void displayLegend(Statement statement, ContextStack contextStack, double d) throws MapyrusException, IOException, InterruptedException {
        LegendEntryList legendEntryList = contextStack.getLegendEntries();
        ArrayList<Point2D> arrayList = contextStack.getMoveTos();
        legendEntryList.ignoreAdditions();
        long l = Math.min(legendEntryList.size(), arrayList.size());
        int n = 0;
        while ((long)n < l) {
            int n2;
            LegendEntry legendEntry = legendEntryList.pop();
            String string = legendEntry.getBlockName();
            Statement statement2 = this.m_statementBlocks.get(string);
            if (statement2 == null) {
                throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("undefinedproc") + ": " + string);
            }
            ArrayList<String> arrayList2 = statement2.getBlockParameters();
            if (legendEntry.getBlockArgs().length != arrayList2.size()) {
                throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongparameters"));
            }
            contextStack.saveState(string);
            Point2D.Float float_ = (Point2D.Float)arrayList.get(n);
            contextStack.setTranslation(float_.x, float_.y);
            contextStack.clearPath();
            contextStack.moveTo(d * 1.1 + 2.0, d / 2.0);
            String string2 = legendEntry.getDescription();
            while ((n2 = string2.indexOf("(#)")) >= 0) {
                string2 = string2.substring(0, n2 + 1) + legendEntry.getReferenceCount() + string2.substring(n2 + 2);
            }
            contextStack.label(string2);
            contextStack.clearPath();
            if (legendEntry.getType() == 1) {
                contextStack.setTranslation(d / 2.0, d / 2.0);
                contextStack.moveTo(0.0, 0.0);
            } else if (legendEntry.getType() == 2) {
                contextStack.moveTo(0.0, d / 2.0);
                contextStack.lineTo(d, d / 2.0);
            } else if (legendEntry.getType() == 3) {
                contextStack.moveTo(0.0, d / 2.0);
                contextStack.lineTo(d / 3.0, d);
                contextStack.lineTo(d * 2.0 / 3.0, 0.0);
                contextStack.lineTo(d, d / 2.0);
            } else if (legendEntry.getType() == 4) {
                contextStack.moveTo(0.0, 0.0);
                contextStack.lineTo(0.0, d);
                contextStack.lineTo(d, d);
                contextStack.lineTo(d, 0.0);
                contextStack.lineTo(0.0, 0.0);
            }
            if (legendEntry.getType() == 4) {
                contextStack.saveState(string);
            }
            this.makeCall(statement2, arrayList2, legendEntry.getBlockArgs());
            if (legendEntry.getType() == 4) {
                contextStack.restoreState();
                contextStack.setColor(Color.BLACK);
                contextStack.setLinestyle(0.1, 0, 2, 0.0, null);
                contextStack.stroke(null);
            }
            contextStack.restoreState();
            ++n;
        }
        legendEntryList.acceptAdditions();
    }

    private int addGeometryToPath(ContextStack contextStack, double[] dArray, int n) throws MapyrusException {
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        n += 2;
        switch (n2) {
            case 100: 
            case 101: 
            case 102: {
                for (int i = 0; i < n3; ++i) {
                    double d = dArray[n + 1];
                    double d2 = dArray[n + 2];
                    if (dArray[n] == 0.0) {
                        contextStack.moveTo(d, d2);
                    } else {
                        contextStack.lineTo(d, d2);
                    }
                    n += 3;
                }
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                for (int i = 0; i < n3; ++i) {
                    n = this.addGeometryToPath(contextStack, dArray, n);
                }
                break;
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execute(Statement statement, ContextStack contextStack) throws MapyrusException, IOException, InterruptedException {
        int n;
        double d = 0.0;
        if (Thread.interrupted()) {
            throw new InterruptedException(MapyrusMessages.get("interrupted"));
        }
        this.m_throttle.sleep();
        Expression[] expressionArray = statement.getExpressions();
        int n2 = expressionArray.length;
        StatementType statementType = statement.getType();
        if (statementType == StatementType.LOCAL) {
            for (n = 0; n < n2; ++n) {
                String string = expressionArray[n].getVariableName();
                if (string == null) {
                    throw new MapyrusException(MapyrusMessages.get("variableexpected"));
                }
                contextStack.setLocalScope(string);
            }
        } else {
            if (this.m_executeArgs == null || n2 > this.m_executeArgs.length) {
                this.m_executeArgs = new Argument[n2];
            }
            String string = statement.getFilename();
            for (int i = 0; i < n2; ++i) {
                this.m_executeArgs[i] = expressionArray[i].evaluate(contextStack, string);
            }
        }
        switch (statementType) {
            case COLOR: 
            case COLOUR: {
                this.setColor(contextStack, this.m_executeArgs, n2);
                return;
            }
            case BLEND: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidblend"));
                contextStack.setBlend(this.m_executeArgs[0].getStringValue());
                return;
            }
            case LINESTYLE: {
                this.setLinestyle(contextStack, this.m_executeArgs, n2);
                return;
            }
            case FONT: {
                this.setFont(contextStack, this.m_executeArgs, n2);
                return;
            }
            case JUSTIFY: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidjustify"));
                this.setJustify(contextStack, this.m_executeArgs[0].getStringValue());
                return;
            }
            case MOVE: 
            case DRAW: 
            case RDRAW: {
                if (n2 <= 0 || n2 % 2 != 0) throw new MapyrusException(MapyrusMessages.get("wrongcoordinate"));
                for (n = 0; n < n2; n += 2) {
                    if (statementType == StatementType.MOVE) {
                        contextStack.moveTo(this.m_executeArgs[n].getNumericValue(), this.m_executeArgs[n + 1].getNumericValue());
                        continue;
                    }
                    if (statementType == StatementType.DRAW) {
                        contextStack.lineTo(this.m_executeArgs[n].getNumericValue(), this.m_executeArgs[n + 1].getNumericValue());
                        continue;
                    }
                    contextStack.rlineTo(this.m_executeArgs[n].getNumericValue(), this.m_executeArgs[n + 1].getNumericValue());
                }
                return;
            }
            case ARC: {
                if (n2 != 5) throw new MapyrusException(MapyrusMessages.get("invalidarc"));
                n = this.m_executeArgs[0].getNumericValue() > 0.0 ? 1 : -1;
                contextStack.arcTo(n, this.m_executeArgs[1].getNumericValue(), this.m_executeArgs[2].getNumericValue(), this.m_executeArgs[3].getNumericValue(), this.m_executeArgs[4].getNumericValue());
                return;
            }
            case CIRCLE: {
                if (n2 != 3) throw new MapyrusException(MapyrusMessages.get("invalidcircle"));
                double d2 = this.m_executeArgs[0].getNumericValue();
                double d3 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                if (!(d > 0.0)) return;
                contextStack.moveTo(d2 - d, d3);
                contextStack.arcTo(1, d2, d3, d2 - d, d3);
                contextStack.closePath();
                return;
            }
            case ELLIPSE: {
                if (n2 != 4) throw new MapyrusException(MapyrusMessages.get("invalidellipse"));
                double d4 = this.m_executeArgs[0].getNumericValue();
                double d5 = this.m_executeArgs[1].getNumericValue();
                double d6 = this.m_executeArgs[2].getNumericValue();
                double d7 = this.m_executeArgs[3].getNumericValue();
                if (!(d6 > 0.0) || !(d7 > 0.0)) return;
                contextStack.ellipseTo(d4 - d6, d5 - d7, d4 + d6, d5 + d7);
                return;
            }
            case CYLINDER: {
                if (n2 != 4) throw new MapyrusException(MapyrusMessages.get("invalidcylinder"));
                double d8 = this.m_executeArgs[0].getNumericValue();
                double d9 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d10 = this.m_executeArgs[3].getNumericValue();
                if (!(d > 0.0) || !(d10 > 0.0)) return;
                double d11 = d * 0.552285;
                double d12 = d11 / 2.0;
                contextStack.moveTo(d8 - d, d9);
                contextStack.curveTo(d8 - d, d9 - d12, d8 - d11, d9 - d / 2.0, d8, d9 - d / 2.0);
                contextStack.curveTo(d8 + d11, d9 - d / 2.0, d8 + d, d9 - d12, d8 + d, d9);
                contextStack.lineTo(d8 + d, d9 + d10);
                contextStack.curveTo(d8 + d, d9 + d10 - d12, d8 + d11, d9 + d10 - d / 2.0, d8, d9 + d10 - d / 2.0);
                contextStack.curveTo(d8 - d11, d9 + d10 - d / 2.0, d8 - d, d9 + d10 - d12, d8 - d, d9 + d10);
                contextStack.closePath();
                contextStack.ellipseTo(d8 - d, d9 + d10 - d / 2.0, d8 + d, d9 + d10 + d / 2.0);
                return;
            }
            case RAINDROP: {
                if (n2 != 3) throw new MapyrusException(MapyrusMessages.get("invalidraindrop"));
                double d13 = this.m_executeArgs[0].getNumericValue();
                double d14 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                if (!(d > 0.0)) return;
                double d15 = d;
                contextStack.moveTo(d13 - d, d14);
                contextStack.arcTo(-1, d13, d14, d13 + d, d14);
                contextStack.curveTo(d13 + d, d14 + d15, d13, d14 + d * 3.0 - d15, d13, d14 + d * 3.0);
                contextStack.curveTo(d13, d14 + d * 3.0 - d15, d13 - d, d14 + d15, d13 - d, d14);
                contextStack.closePath();
                return;
            }
            case BEZIER: {
                if (n2 != 6) throw new MapyrusException(MapyrusMessages.get("invalidbezier"));
                double d16 = this.m_executeArgs[0].getNumericValue();
                double d17 = this.m_executeArgs[1].getNumericValue();
                double d18 = this.m_executeArgs[2].getNumericValue();
                double d19 = this.m_executeArgs[3].getNumericValue();
                double d20 = this.m_executeArgs[4].getNumericValue();
                double d21 = this.m_executeArgs[5].getNumericValue();
                contextStack.curveTo(d16, d17, d18, d19, d20, d21);
                return;
            }
            case SINEWAVE: {
                if (n2 != 4) throw new MapyrusException(MapyrusMessages.get("invalidsinewave"));
                double d22 = this.m_executeArgs[0].getNumericValue();
                double d23 = this.m_executeArgs[1].getNumericValue();
                double d24 = this.m_executeArgs[2].getNumericValue();
                double d25 = this.m_executeArgs[3].getNumericValue();
                contextStack.sineWaveTo(d22, d23, d24, d25);
                return;
            }
            case WEDGE: {
                if (n2 != 5 && n2 != 6) throw new MapyrusException(MapyrusMessages.get("invalidwedge"));
                double d26 = this.m_executeArgs[0].getNumericValue();
                double d27 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d28 = this.m_executeArgs[3].getNumericValue();
                double d29 = this.m_executeArgs[4].getNumericValue();
                double d30 = d28 + d29;
                double d31 = n2 == 6 ? this.m_executeArgs[5].getNumericValue() : 0.0;
                int n3 = d29 > 0.0 ? -1 : 1;
                d28 = Math.toRadians(d28);
                d30 = Math.toRadians(d30);
                if (!(d > 0.0) || d29 == 0.0) return;
                double d32 = Math.cos(d28);
                double d33 = Math.sin(d28);
                double d34 = Math.cos(d30);
                double d35 = Math.sin(d30);
                double d36 = d26 + d32 * d;
                double d37 = d27 + d33 * d;
                double d38 = d26 + d34 * d;
                double d39 = d27 + d35 * d;
                contextStack.moveTo(d26, d27);
                contextStack.lineTo(d36, d37);
                contextStack.arcTo(n3, d26, d27, d38, d39);
                contextStack.closePath();
                if (!(d31 > 0.0)) return;
                if (n3 == 1 && d32 < 0.0 || n3 == -1 && d32 > 0.0) {
                    contextStack.moveTo(d36, d37);
                    contextStack.lineTo(d36, d37 - d31);
                    contextStack.lineTo(d26, d27 - d31);
                    contextStack.lineTo(d26, d27);
                    contextStack.closePath();
                }
                if (n3 == 1 && d34 > 0.0 || n3 == -1 && d34 < 0.0) {
                    contextStack.moveTo(d38, d39);
                    contextStack.lineTo(d38, d39 - d31);
                    contextStack.lineTo(d26, d27 - d31);
                    contextStack.lineTo(d26, d27);
                    contextStack.closePath();
                }
                if (!(d33 < 0.0) && !(d35 < 0.0) && !(Math.abs(d29) > 180.0)) return;
                double d40 = d36;
                double d41 = d37;
                if (d33 > 0.0) {
                    d40 = d26 + d * (double)n3;
                    d41 = d27;
                }
                contextStack.moveTo(d40, d41);
                contextStack.lineTo(d40, d41 - d31);
                double d42 = d38;
                double d43 = d39;
                if (d35 > 0.0) {
                    d42 = d26 - d * (double)n3;
                    d43 = d27;
                }
                contextStack.arcTo(n3, d26, d27 - d31, d42, d43 - d31);
                contextStack.lineTo(d42, d43);
                contextStack.arcTo(-n3, d26, d27, d40, d41);
                contextStack.closePath();
                return;
            }
            case SPIRAL: {
                if (n2 != 5) throw new MapyrusException(MapyrusMessages.get("invalidspiral"));
                double d44 = this.m_executeArgs[0].getNumericValue();
                double d45 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d46 = this.m_executeArgs[3].getNumericValue();
                double d47 = this.m_executeArgs[4].getNumericValue();
                d47 = Math.toRadians(d47);
                if (!(d > 0.0) || d46 == 0.0) return;
                double d48 = contextStack.getResolution();
                double d49 = Math.acos((d - d48) / d);
                double d50 = d49 / (Math.PI * 2);
                d50 /= Math.abs(d46);
                double d51 = 1.0;
                int n4 = 0;
                while (d51 > 0.0) {
                    double d52 = d * d51 * Math.cos(Math.PI * 2 * d46 * d51 + d47) + d44;
                    double d53 = d * d51 * Math.sin(Math.PI * 2 * d46 * d51 + d47) + d45;
                    if (n4 == 0) {
                        contextStack.moveTo(d52, d53);
                    } else {
                        contextStack.lineTo(d52, d53);
                    }
                    d51 = 1.0 - (double)(++n4) * d50;
                }
                contextStack.lineTo(d44, d45);
                return;
            }
            case LOGSPIRAL: {
                if (n2 != 6) throw new MapyrusException(MapyrusMessages.get("invalidlogspiral"));
                double d54 = this.m_executeArgs[0].getNumericValue();
                double d55 = this.m_executeArgs[1].getNumericValue();
                double d56 = this.m_executeArgs[2].getNumericValue();
                double d57 = this.m_executeArgs[3].getNumericValue();
                double d58 = this.m_executeArgs[4].getNumericValue();
                double d59 = this.m_executeArgs[5].getNumericValue();
                d59 = Math.toRadians(d59);
                if (d58 == 0.0 || !(d57 > 0.0) || !(d56 > 0.0)) return;
                contextStack.moveTo(d54, d55);
                double d60 = contextStack.getResolution();
                double d61 = 0.0;
                double d62 = Math.abs(d58) * Math.PI * 2.0;
                while (d61 < d62) {
                    d = d56 * Math.exp(d57 * d61);
                    if (d >= d60) {
                        double d63 = d58 > 0.0 ? d59 + d61 : d59 - d61;
                        double d64 = d * Math.cos(d63) + d54;
                        double d65 = d * Math.sin(d63) + d55;
                        contextStack.lineTo(d64, d65);
                        d61 += Math.asin(d60 / d);
                        continue;
                    }
                    d61 += Math.PI / 90;
                }
                return;
            }
            case HEXAGON: {
                if (n2 != 3) throw new MapyrusException(MapyrusMessages.get("invalidhexagon"));
                double d66 = this.m_executeArgs[0].getNumericValue();
                double d67 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d68 = 0.8660254 * d;
                double d69 = 0.5 * d;
                if (!(d > 0.0)) return;
                contextStack.moveTo(d66 - d69, d67 - d68);
                contextStack.lineTo(d66 + d69, d67 - d68);
                contextStack.lineTo(d66 + d, d67);
                contextStack.lineTo(d66 + d69, d67 + d68);
                contextStack.lineTo(d66 - d69, d67 + d68);
                contextStack.lineTo(d66 - d, d67);
                contextStack.closePath();
                return;
            }
            case PENTAGON: {
                if (n2 != 3) throw new MapyrusException(MapyrusMessages.get("invalidpentagon"));
                double d70 = this.m_executeArgs[0].getNumericValue();
                double d71 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d72 = 0.809017 * d;
                double d73 = 0.59778525 * d;
                double d74 = 0.309017 * d;
                double d75 = 0.95105652 * d;
                if (!(d > 0.0)) return;
                contextStack.moveTo(d70 - d73, d71 - d72);
                contextStack.lineTo(d70 + d73, d71 - d72);
                contextStack.lineTo(d70 + d75, d71 + d74);
                contextStack.lineTo(d70, d71 + d);
                contextStack.lineTo(d70 - d75, d71 + d74);
                contextStack.closePath();
                return;
            }
            case TRIANGLE: {
                if (n2 != 4) throw new MapyrusException(MapyrusMessages.get("invalidtriangle"));
                double d76 = this.m_executeArgs[0].getNumericValue();
                double d77 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d78 = this.m_executeArgs[3].getNumericValue();
                d78 = Math.toRadians(d78);
                double d79 = 0.5 * d;
                double d80 = 0.8660254 * d;
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(d76, d77);
                affineTransform.rotate(d78);
                Point2D.Double double_ = new Point2D.Double(0.0, d);
                affineTransform.transform(double_, double_);
                contextStack.moveTo(double_.x, double_.y);
                double_.x = d80;
                double_.y = -d79;
                affineTransform.transform(double_, double_);
                contextStack.lineTo(double_.x, double_.y);
                double_.x = -d80;
                double_.y = -d79;
                affineTransform.transform(double_, double_);
                contextStack.lineTo(double_.x, double_.y);
                contextStack.closePath();
                return;
            }
            case STAR: {
                if (n2 != 4) throw new MapyrusException(MapyrusMessages.get("invalidstar"));
                double d81 = this.m_executeArgs[0].getNumericValue();
                double d82 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                n = (int)this.m_executeArgs[3].getNumericValue();
                if (!(d > 0.0) || n <= 0) return;
                double d83 = Math.PI * 2 / (double)n;
                double d84 = 1.5707963267948966;
                double d85 = d83 / 3.0;
                double d86 = d * Math.sin(d85 / 2.0) / Math.sin(Math.PI - d85 / 2.0 - d83 / 2.0);
                for (int i = 0; i < n; ++i) {
                    double d87 = d81 + Math.cos(d84) * d;
                    double d88 = d82 + Math.sin(d84) * d;
                    if (i == 0) {
                        contextStack.moveTo(d87, d88);
                    } else {
                        contextStack.lineTo(d87, d88);
                    }
                    d87 = d81 + Math.cos(d84 - d83 / 2.0) * d86;
                    d88 = d82 + Math.sin(d84 - d83 / 2.0) * d86;
                    contextStack.lineTo(d87, d88);
                    d84 -= d83;
                }
                contextStack.closePath();
                return;
            }
            case BOX: 
            case ROUNDEDBOX: 
            case BOX3D: 
            case CHESSBOARD: 
            case GUILLOTINE: 
            case PROTECT: 
            case UNPROTECT: {
                if (n2 == 4 || (statementType == StatementType.ROUNDEDBOX || statementType == StatementType.BOX3D || statementType == StatementType.CHESSBOARD) && n2 == 5) {
                    double d89;
                    double d90;
                    double d91;
                    double d92;
                    double d93;
                    double d94;
                    double d95 = this.m_executeArgs[0].getNumericValue();
                    double d96 = this.m_executeArgs[1].getNumericValue();
                    double d97 = this.m_executeArgs[2].getNumericValue();
                    double d98 = this.m_executeArgs[3].getNumericValue();
                    double d99 = 1.0;
                    double d100 = 0.0;
                    if (d95 < d97) {
                        d94 = d95;
                        d93 = d97;
                    } else {
                        d94 = d97;
                        d93 = d95;
                    }
                    if (d96 < d98) {
                        d92 = d96;
                        d91 = d98;
                    } else {
                        d92 = d98;
                        d91 = d96;
                    }
                    if (statementType == StatementType.ROUNDEDBOX) {
                        d90 = d91 - d92;
                        d89 = d93 - d94;
                        if (n2 == 5) {
                            d = this.m_executeArgs[4].getNumericValue();
                            if (d > d89 / 2.0) {
                                d = d89 / 2.0;
                            }
                            if (d > d90 / 2.0) {
                                d = d90 / 2.0;
                            }
                        } else {
                            d = Math.min(d89 / 10.0, d90 / 10.0);
                        }
                        if (d <= 0.0) {
                            statementType = StatementType.BOX;
                        }
                    } else if (statementType == StatementType.BOX3D) {
                        d100 = Math.min(d93 - d94, d91 - d92);
                        if (n2 == 5) {
                            d100 = this.m_executeArgs[4].getNumericValue();
                        }
                    } else if (statementType == StatementType.CHESSBOARD) {
                        if (n2 == 5) {
                            d99 = this.m_executeArgs[4].getNumericValue();
                        }
                        if (d99 <= 0.0) {
                            throw new MapyrusException(MapyrusMessages.get("invalidsize") + ": " + d99);
                        }
                    }
                    if (statementType == StatementType.BOX || statementType == StatementType.BOX3D) {
                        contextStack.moveTo(d94, d92);
                        contextStack.lineTo(d94, d91);
                        contextStack.lineTo(d93, d91);
                        contextStack.lineTo(d93, d92);
                        contextStack.closePath();
                        if (statementType != StatementType.BOX3D) return;
                        d90 = Math.cos(Math.toRadians(30.0));
                        d89 = Math.sin(Math.toRadians(30.0));
                        d95 = d93 + d100 * d90;
                        d96 = d91 + d100 * d89;
                        contextStack.moveTo(d93, d91);
                        contextStack.lineTo(d95, d96);
                        contextStack.lineTo(d95, d96 - (d91 - d92));
                        contextStack.lineTo(d93, d92);
                        contextStack.closePath();
                        d95 = d94 + d100 * d90;
                        d96 = d91 + d100 * d89;
                        contextStack.moveTo(d94, d91);
                        contextStack.lineTo(d95, d96);
                        contextStack.lineTo(d95 + (d93 - d94), d96);
                        contextStack.lineTo(d93, d91);
                        contextStack.closePath();
                        return;
                    }
                    if (statementType == StatementType.ROUNDEDBOX) {
                        contextStack.moveTo(d94, d91 - d);
                        contextStack.arcTo(1, d94 + d, d91 - d, d94 + d, d91);
                        contextStack.lineTo(d93 - d, d91);
                        contextStack.arcTo(1, d93 - d, d91 - d, d93, d91 - d);
                        contextStack.lineTo(d93, d92 + d);
                        contextStack.arcTo(1, d93 - d, d92 + d, d93 - d, d92);
                        contextStack.lineTo(d94 + d, d92);
                        contextStack.arcTo(1, d94 + d, d92 + d, d94, d92 + d);
                        contextStack.closePath();
                        return;
                    }
                    if (statementType == StatementType.CHESSBOARD) {
                        int n5 = 0;
                        d96 = d92;
                        while (d96 < d91) {
                            d98 = d96 + d99;
                            if (d98 > d91) {
                                d98 = d91;
                            }
                            int n6 = 0;
                            d95 = d94;
                            while (d95 < d93) {
                                if ((n5 + n6) % 2 == 0) {
                                    d97 = d95 + d99;
                                    if (d97 > d93) {
                                        d97 = d93;
                                    }
                                    contextStack.moveTo(d95, d96);
                                    contextStack.lineTo(d95, d98);
                                    contextStack.lineTo(d97, d98);
                                    contextStack.lineTo(d97, d96);
                                    contextStack.closePath();
                                }
                                d95 = d94 + (double)(++n6) * d99;
                            }
                            d96 = d92 + (double)(++n5) * d99;
                        }
                        return;
                    }
                    if (statementType == StatementType.GUILLOTINE) {
                        contextStack.guillotine(d94, d92, d93, d91);
                        return;
                    }
                    if (statementType == StatementType.PROTECT) {
                        contextStack.protect(d94, d92, d93, d91);
                        return;
                    }
                    contextStack.unprotect(d94, d92, d93, d91);
                    return;
                }
                if (n2 == 1 && (statementType == StatementType.PROTECT || statementType == StatementType.UNPROTECT)) {
                    Argument argument = this.m_executeArgs[0];
                    if (statementType == StatementType.PROTECT) {
                        contextStack.protect(argument);
                        return;
                    }
                    contextStack.unprotect(argument);
                    return;
                }
                if (n2 == 0 && statementType == StatementType.PROTECT) {
                    contextStack.protect();
                    return;
                }
                if (n2 != 0 || statementType != StatementType.UNPROTECT) throw new MapyrusException(MapyrusMessages.get("invalidbox"));
                contextStack.unprotect();
                return;
            }
            case ADDPATH: {
                for (n = 0; n < n2; ++n) {
                    double[] dArray = this.m_executeArgs[n].getGeometryValue();
                    this.addGeometryToPath(contextStack, dArray, 0);
                }
                return;
            }
            case CLEARPATH: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.clearPath();
                return;
            }
            case CLOSEPATH: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.closePath();
                return;
            }
            case SAMPLEPATH: {
                if (n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidpathsample"));
                contextStack.samplePath(this.m_executeArgs[0].getNumericValue(), this.m_executeArgs[1].getNumericValue());
                return;
            }
            case STRIPEPATH: {
                if (n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidpathstripe"));
                double d101 = this.m_executeArgs[1].getNumericValue();
                contextStack.stripePath(this.m_executeArgs[0].getNumericValue(), Math.toRadians(d101));
                return;
            }
            case SHIFTPATH: {
                if (n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidpathshift"));
                contextStack.translatePath(this.m_executeArgs[0].getNumericValue(), this.m_executeArgs[1].getNumericValue());
                return;
            }
            case PARALLELPATH: {
                if (n2 <= 0) throw new MapyrusException(MapyrusMessages.get("invaliddistance"));
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = this.m_executeArgs[i].getNumericValue();
                }
                contextStack.parallelPath(dArray);
                return;
            }
            case SELECTPATH: {
                if (n2 <= 0 || n2 % 2 != 0) throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                double[] dArray = new double[n2 / 2];
                double[] dArray2 = new double[n2 / 2];
                for (int i = 0; i < n2 / 2; ++i) {
                    dArray[i] = this.m_executeArgs[i * 2].getNumericValue();
                    dArray2[i] = this.m_executeArgs[i * 2 + 1].getNumericValue();
                }
                contextStack.selectPath(dArray, dArray2);
                return;
            }
            case REVERSEPATH: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.reversePath();
                return;
            }
            case SINKHOLE: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.createSinkhole();
                return;
            }
            case STROKE: {
                if (n2 > 0) {
                    StringBuffer stringBuffer = new StringBuffer(this.m_executeArgs[0].getStringValue());
                    for (int i = 1; i < n2; ++i) {
                        stringBuffer.append(this.m_executeArgs[i].getStringValue()).append(Constants.LINE_SEPARATOR);
                    }
                    contextStack.stroke(stringBuffer.toString());
                    return;
                }
                contextStack.stroke(null);
                return;
            }
            case FILL: {
                if (n2 > 0) {
                    StringBuffer stringBuffer = new StringBuffer(this.m_executeArgs[0].getStringValue());
                    for (int i = 1; i < n2; ++i) {
                        stringBuffer.append(this.m_executeArgs[i].getStringValue()).append(Constants.LINE_SEPARATOR);
                    }
                    contextStack.fill(stringBuffer.toString());
                    return;
                }
                contextStack.fill(null);
                return;
            }
            case GRADIENTFILL: {
                if (n2 != 4 && n2 != 5) throw new MapyrusException(MapyrusMessages.get("invalidgradientfill"));
                Color color = contextStack.getColor();
                Color color2 = ColorDatabase.getColor(this.m_executeArgs[0].toString(), 255, color);
                if (color2 == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.m_executeArgs[0].toString());
                }
                Color color3 = ColorDatabase.getColor(this.m_executeArgs[1].toString(), 255, color);
                if (color3 == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.m_executeArgs[1].toString());
                }
                Color color4 = ColorDatabase.getColor(this.m_executeArgs[2].toString(), 255, color);
                if (color4 == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.m_executeArgs[2].toString());
                }
                Color color5 = ColorDatabase.getColor(this.m_executeArgs[3].toString(), 255, color);
                if (color5 == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.m_executeArgs[3].toString());
                }
                Color color6 = null;
                if (n2 == 5 && (color6 = ColorDatabase.getColor(this.m_executeArgs[4].toString(), 255, color)) == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.m_executeArgs[4].toString());
                }
                contextStack.gradientFill(color2, color3, color4, color5, color6);
                return;
            }
            case EVENTSCRIPT: {
                if (n2 < 1) throw new MapyrusException(MapyrusMessages.get("invalidscript"));
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n2; ++i) {
                    if (i > 0) {
                        stringBuffer.append(Constants.LINE_SEPARATOR);
                    }
                    stringBuffer.append(this.m_executeArgs[i].toString());
                }
                contextStack.setEventScript(stringBuffer.toString());
                return;
            }
            case CLIP: {
                if (n2 != 1) {
                    throw new MapyrusException(MapyrusMessages.get("noclipside"));
                }
                String string = this.m_executeArgs[0].toString();
                if (string.startsWith(IN_KEYWORD) || string.startsWith("IN")) {
                    contextStack.clipInside();
                    return;
                }
                contextStack.clipOutside();
                return;
            }
            case SETOUTPUT: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidsetoutput"));
                try {
                    PrintStream printStream;
                    String string = this.m_executeArgs[0].getStringValue();
                    if (string.equals("-")) {
                        printStream = this.m_stdoutStream;
                    } else {
                        if (!contextStack.getThrottle().isIOAllowed()) {
                            throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string);
                        }
                        if (string.startsWith("|")) {
                            String string2 = string.substring(1).trim();
                            String[] stringArray = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{string2} : new String[]{"sh", "-c", string2};
                            Process process = Runtime.getRuntime().exec(stringArray);
                            OutputStream outputStream = process.getOutputStream();
                            printStream = new PrintStream(outputStream);
                        } else {
                            FileOutputStream fileOutputStream = new FileOutputStream(string);
                            printStream = new PrintStream(fileOutputStream);
                        }
                    }
                    contextStack.setStdout(printStream);
                    return;
                }
                catch (SecurityException securityException) {
                    throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage());
                }
            }
            case LABEL: 
            case PRINT: 
            case FLOWLABEL: {
                int n7;
                String string = "";
                int n8 = 0;
                double d102 = 0.0;
                double d103 = 0.0;
                boolean bl = true;
                if (statementType == StatementType.FLOWLABEL) {
                    String string3;
                    int n9;
                    if (n2 < 2) {
                        throw new MapyrusException(MapyrusMessages.get("invalidpathoffset"));
                    }
                    d103 = this.m_executeArgs[0].getNumericValue();
                    d102 = this.m_executeArgs[1].getNumericValue();
                    n7 = 2;
                    if (n2 > 2 && (n9 = (string3 = this.m_executeArgs[2].getStringValue()).indexOf("rotate=")) >= 0) {
                        bl = string3.substring(n9 + 7).equalsIgnoreCase("true");
                        n7 = 3;
                    }
                } else {
                    n7 = 0;
                }
                if (n7 < n2) {
                    if (n2 == n7 + 1) {
                        string = this.m_executeArgs[n7].toString();
                        n8 += string.length();
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = n7; i < n2; ++i) {
                            if (i > n7) {
                                stringBuffer.append(' ');
                            }
                            String string4 = this.m_executeArgs[i].toString();
                            stringBuffer.append(string4);
                            n8 += string4.length();
                        }
                        string = stringBuffer.toString();
                    }
                }
                if (statementType == StatementType.PRINT) {
                    PrintStream printStream = contextStack.getStdout();
                    printStream.println(string);
                    return;
                }
                if (n8 <= 0) return;
                if (statementType == StatementType.FLOWLABEL) {
                    contextStack.flowLabel(d103, d102, bl, string);
                    return;
                }
                contextStack.label(string);
                return;
            }
            case TABLE: 
            case TREE: {
                if (statementType == StatementType.TREE && n2 == 2 || statementType == StatementType.TABLE && n2 >= 2) {
                    String string = this.m_executeArgs[0].getStringValue();
                    ArrayList<Argument> arrayList = new ArrayList<Argument>(n2 - 1);
                    for (int i = 1; i < n2; ++i) {
                        Argument argument;
                        if (this.m_executeArgs[i].getType() == 2) {
                            argument = this.m_executeArgs[i];
                        } else {
                            argument = new Argument();
                            argument.addHashMapEntry("1", this.m_executeArgs[i]);
                        }
                        arrayList.add(argument);
                    }
                    if (statementType == StatementType.TABLE) {
                        contextStack.drawTable(string, arrayList);
                        return;
                    }
                    contextStack.drawTree(string, arrayList.get(0));
                    return;
                }
                if (statementType != StatementType.TABLE) throw new MapyrusException(MapyrusMessages.get("invalidtree"));
                throw new MapyrusException(MapyrusMessages.get("invalidtable"));
            }
            case ICON: {
                if (n2 != 1 && n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidicon"));
                double d104 = n2 == 2 ? this.m_executeArgs[1].getNumericValue() : 0.0;
                contextStack.drawIcon(this.m_executeArgs[0].getStringValue(), d104);
                return;
            }
            case GEOIMAGE: {
                if (n2 != 1 && n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidgeoimage"));
                String string = this.m_executeArgs[0].getStringValue();
                String string5 = n2 == 2 ? this.m_executeArgs[1].getStringValue() : "";
                contextStack.drawGeoImage(string, string5, this.m_throttle);
                return;
            }
            case EPS: {
                if (n2 != 1 && n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalideps"));
                double d105 = n2 == 2 ? this.m_executeArgs[1].getNumericValue() : 0.0;
                contextStack.drawEPS(this.m_executeArgs[0].getStringValue(), d105);
                return;
            }
            case SVG: {
                if (n2 != 1 && n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidsvg"));
                double d106 = n2 == 2 ? this.m_executeArgs[1].getNumericValue() : 0.0;
                contextStack.drawSVG(this.m_executeArgs[0].getStringValue(), d106);
                return;
            }
            case SVGCODE: {
                for (int i = 0; i < n2; ++i) {
                    contextStack.addSVGCode(this.m_executeArgs[i].getStringValue());
                }
                return;
            }
            case PDF: {
                if (n2 != 2 && n2 != 3) throw new MapyrusException(MapyrusMessages.get("invalidpdf"));
                double d107 = n2 == 3 ? this.m_executeArgs[2].getNumericValue() : 0.0;
                long l = Math.round(this.m_executeArgs[1].getNumericValue());
                contextStack.drawPDF(this.m_executeArgs[0].getStringValue(), (int)l, d107);
                return;
            }
            case PDFGROUP: {
                if (n2 <= 0) throw new MapyrusException(MapyrusMessages.get("invalidpdfgroup"));
                String string = this.m_executeArgs[0].getStringValue();
                if (string.equalsIgnoreCase(BEGIN_KEYWORD)) {
                    if (n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidpdfgroup"));
                    String string6 = this.m_executeArgs[1].getStringValue();
                    contextStack.beginPDFGroup(string6);
                    return;
                }
                if (!string.equalsIgnoreCase(END_KEYWORD) || n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidpdfgroup"));
                contextStack.endPDFGroup();
                return;
            }
            case SCALE: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidscaling"));
                double d108 = this.m_executeArgs[0].getNumericValue();
                contextStack.setScaling(d108);
                return;
            }
            case ROTATE: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidrotation"));
                double d109 = this.m_executeArgs[0].getNumericValue();
                contextStack.setRotation(Math.toRadians(d109));
                return;
            }
            case WORLDS: {
                double d110;
                double d111;
                double d112;
                double d113;
                String string;
                StringTokenizer stringTokenizer;
                double d114;
                double d115;
                double d116;
                double d117;
                if (n2 == 1 || n2 == 2) {
                    d117 = 0.0;
                    d116 = 0.0;
                    d115 = 0.0;
                    d114 = 0.0;
                    stringTokenizer = new StringTokenizer(this.m_executeArgs[0].getStringValue(), ",");
                    if (stringTokenizer.countTokens() != 4) throw new MapyrusException(MapyrusMessages.get("invalidworlds"));
                    string = "";
                    try {
                        string = stringTokenizer.nextToken();
                        d113 = Double.parseDouble(string);
                        string = stringTokenizer.nextToken();
                        d112 = Double.parseDouble(string);
                        string = stringTokenizer.nextToken();
                        d111 = Double.parseDouble(string);
                        string = stringTokenizer.nextToken();
                        d110 = Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidworlds") + ": " + string);
                    }
                } else {
                    if (n2 == 4 || n2 == 5) {
                        d117 = 0.0;
                        d116 = 0.0;
                        d115 = 0.0;
                        d114 = 0.0;
                    } else {
                        if (n2 != 8 && n2 != 9) throw new MapyrusException(MapyrusMessages.get("invalidworlds"));
                        d114 = this.m_executeArgs[4].getNumericValue();
                        d115 = this.m_executeArgs[5].getNumericValue();
                        d116 = this.m_executeArgs[6].getNumericValue();
                        d117 = this.m_executeArgs[7].getNumericValue();
                    }
                    d113 = this.m_executeArgs[0].getNumericValue();
                    d112 = this.m_executeArgs[1].getNumericValue();
                    d111 = this.m_executeArgs[2].getNumericValue();
                    d110 = this.m_executeArgs[3].getNumericValue();
                }
                int n10 = 1;
                boolean bl = false;
                String string7 = n2 == 2 ? this.m_executeArgs[1].getStringValue() : (n2 == 5 ? this.m_executeArgs[4].getStringValue() : (n2 == 9 ? this.m_executeArgs[8].getStringValue() : ""));
                stringTokenizer = new StringTokenizer(string7);
                while (stringTokenizer.hasMoreTokens()) {
                    String string8;
                    string = stringTokenizer.nextToken();
                    if (string.startsWith("units=")) {
                        string8 = string.substring(6);
                        Integer n11 = m_worldUnitsLookup.get(string8);
                        if (n11 == null) {
                            throw new MapyrusException(MapyrusMessages.get("invalidworldunits") + ": " + string8);
                        }
                        n10 = n11;
                        continue;
                    }
                    if (!string.startsWith("distortion=")) continue;
                    string8 = string.substring(11);
                    bl = string8.equalsIgnoreCase("true");
                }
                contextStack.setWorlds(d113, d112, d111, d110, d114, d115, d116, d117, n10, bl);
                return;
            }
            case DATASET: {
                if (n2 != 2 && n2 != 3) throw new MapyrusException(MapyrusMessages.get("invaliddataset"));
                String string = "";
                if (n2 > 2) {
                    string = this.m_executeArgs[2].getStringValue();
                }
                String string9 = this.m_executeArgs[1].getStringValue();
                contextStack.setDataset(this.m_executeArgs[0].getStringValue(), string9, string, this.m_stdinStream);
                return;
            }
            case FETCH: {
                Row row = contextStack.fetchRow();
                String[] stringArray = contextStack.getDatasetFieldNames();
                for (int i = 0; i < row.size(); ++i) {
                    String string = stringArray != null ? stringArray[i] : DefaultFieldNames.get(i);
                    contextStack.defineVariable(string, (Argument)row.get(i));
                }
                return;
            }
            case NEWPAGE: {
                int n12;
                double d118;
                double d119;
                if (n2 < 3 || n2 > 5) throw new MapyrusException(MapyrusMessages.get("invalidpage"));
                String string = this.m_executeArgs[0].getStringValue();
                String string10 = this.m_executeArgs[1].getStringValue();
                if (n2 == 3) {
                    String string11 = this.m_executeArgs[2].getStringValue();
                    PageSize pageSize = new PageSize(string11);
                    d119 = pageSize.getDimension().getX();
                    d118 = pageSize.getDimension().getY();
                    n12 = 3;
                } else if (this.m_executeArgs[2].getType() == 1) {
                    try {
                        String string12 = this.m_executeArgs[2].getStringValue();
                        PageSize pageSize = new PageSize(string12);
                        d119 = pageSize.getDimension().getX();
                        d118 = pageSize.getDimension().getY();
                        n12 = 3;
                    }
                    catch (MapyrusException mapyrusException) {
                        d119 = this.parseDimension(this.m_executeArgs[2]);
                        d118 = this.parseDimension(this.m_executeArgs[3]);
                        n12 = 4;
                    }
                } else {
                    d119 = this.parseDimension(this.m_executeArgs[2]);
                    d118 = this.parseDimension(this.m_executeArgs[3]);
                    n12 = 4;
                }
                String string13 = n12 < n2 ? this.m_executeArgs[n12].getStringValue() : "";
                if (d119 <= 1.0) {
                    throw new MapyrusException(MapyrusMessages.get("invalidpagesize") + ": " + d119);
                }
                if (d118 <= 1.0) {
                    throw new MapyrusException(MapyrusMessages.get("invalidpagesize") + ": " + d118);
                }
                contextStack.setOutputFormat(string, string10, d119, d118, string13, contextStack.getStdout(), this.m_throttle);
                return;
            }
            case ENDPAGE: {
                contextStack.closeOutputFormat();
                return;
            }
            case LOCAL: {
                return;
            }
            case EVAL: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalideval"));
                String string = this.m_executeArgs[0].getStringValue();
                StringReader stringReader = new StringReader(string);
                String string14 = statement.getFilename();
                FileOrURL fileOrURL = new FileOrURL(stringReader, string14);
                byte[] byArray = new byte[]{};
                this.interpret(contextStack, fileOrURL, new ByteArrayInputStream(byArray), contextStack.getStdout());
                return;
            }
            case LET: {
                return;
            }
            case KEY: {
                if (n2 < 2) throw new MapyrusException(MapyrusMessages.get("invalidlegendentry"));
                String string = this.m_executeArgs[0].getStringValue();
                String string15 = this.m_executeArgs[1].getStringValue();
                int n13 = LegendEntry.parseTypeString(string);
                if (n13 < 0) {
                    throw new MapyrusException(MapyrusMessages.get("invalidlegendtype") + ": " + string);
                }
                this.m_context.addLegendEntry(string15, n13, this.m_executeArgs, 2, n2 - 2);
                return;
            }
            case LEGEND: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("nolegendsize"));
                double d120 = this.m_executeArgs[0].getNumericValue();
                this.displayLegend(statement, contextStack, d120);
                return;
            }
            case MIMETYPE: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("nomimetype"));
                String string = this.m_executeArgs[0].getStringValue();
                String string16 = "HTTP/1.0 200 OK" + Constants.LINE_SEPARATOR + "Content-Type" + ": " + string + Constants.LINE_SEPARATOR;
                contextStack.setHTTPReponse(string16);
                return;
            }
            case HTTPRESPONSE: {
                StringBuffer stringBuffer = new StringBuffer(128);
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(this.m_executeArgs[i].getStringValue());
                    stringBuffer.append(Constants.LINE_SEPARATOR);
                }
                contextStack.setHTTPReponse(stringBuffer.toString());
            }
        }
    }

    private double parseDimension(Argument argument) throws MapyrusException {
        String string;
        int n;
        double d = 1.0;
        if (argument.getType() != 0 && (n = (string = argument.getStringValue()).length()) >= 2) {
            String string2 = string.substring(n - 2, n);
            if (string2.equals("px")) {
                d = 25.4 / (double)Constants.getScreenResolution();
                argument = new Argument(1, string.substring(0, n - 2));
            } else if (string2.equals("pt")) {
                d = 0.35277777777777775;
                argument = new Argument(1, string.substring(0, n - 2));
            } else if (string2.equals("mm")) {
                d = 1.0;
                argument = new Argument(1, string.substring(0, n - 2));
            } else if (string2.equals("cm")) {
                d = 10.0;
                argument = new Argument(1, string.substring(0, n - 2));
            } else if (string2.equals(IN_KEYWORD)) {
                d = 25.4;
                argument = new Argument(1, string.substring(0, n - 2));
            }
        }
        double d2 = argument.getNumericValue();
        return d2 *= d;
    }

    private String parseWord(int n, Preprocessor preprocessor) throws IOException, MapyrusException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!Character.isLetter((char)n) && n != 36) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidkeyword"));
        }
        do {
            stringBuffer.append((char)n);
        } while (Character.isLetterOrDigit((char)(n = preprocessor.read())) || n == 46 || n == 95 || n == 58);
        preprocessor.unread(n);
        return stringBuffer.toString();
    }

    private Statement parseSimpleStatement(String string, Preprocessor preprocessor) throws MapyrusException, IOException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        Statement statement = null;
        boolean bl = false;
        int n = 1;
        int n2 = preprocessor.readNonSpace();
        while (!bl) {
            if (n2 == -1 || n2 == 10 || n2 == 59) {
                bl = true;
                continue;
            }
            if (Character.isWhitespace((char)n2)) {
                n2 = preprocessor.readNonSpace();
                continue;
            }
            if (n == 2) {
                if (n2 != 44) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '" + ',' + "'");
                }
                n2 = preprocessor.readNonSpace();
                n = 1;
                continue;
            }
            preprocessor.unread(n2);
            Expression expression = new Expression(preprocessor, this.m_userFunctions);
            arrayList.add(expression);
            n2 = preprocessor.readNonSpace();
            n = 2;
        }
        if (n2 == -1 && arrayList.size() == 0) {
            statement = null;
        } else {
            Expression[] expressionArray = new Expression[arrayList.size()];
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i] = (Expression)arrayList.get(i);
            }
            statement = new Statement(string, expressionArray);
            statement.setFilenameAndLineNumber(preprocessor.getCurrentFilename(), preprocessor.getCurrentLineNumber());
        }
        return statement;
    }

    private ArrayList<String> parseParameters(Preprocessor preprocessor) throws IOException, MapyrusException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 3;
        int n2 = preprocessor.readNonSpace();
        while (n2 != -1 && n2 != 10 && n2 != 59) {
            if (Character.isWhitespace((char)n2)) {
                n2 = preprocessor.readNonSpace();
                continue;
            }
            if (n == 3) {
                arrayList.add(this.parseWord(n2, preprocessor));
                n = 4;
                n2 = preprocessor.readNonSpace();
                continue;
            }
            if (n2 != 44) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '" + ',' + "'");
            }
            n = 3;
            n2 = preprocessor.readNonSpace();
        }
        return arrayList;
    }

    private ParsedStatement parseProcedureBlock(Preprocessor preprocessor, boolean bl) throws IOException, MapyrusException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        boolean bl2 = false;
        UserFunction userFunction = null;
        int n = preprocessor.readNonSpace();
        while (Character.isWhitespace((char)n)) {
            n = preprocessor.readNonSpace();
        }
        String string = this.parseWord(n, preprocessor);
        ArrayList<String> arrayList2 = this.parseParameters(preprocessor);
        if (bl) {
            userFunction = new UserFunction(string, arrayList2, null, this);
            this.m_userFunctions.put(string, userFunction);
        }
        do {
            ParsedStatement parsedStatement;
            if ((parsedStatement = this.parseStatementOrKeyword(preprocessor, true)) == null) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
            }
            if (parsedStatement.isStatement()) {
                arrayList.add(parsedStatement.getStatement());
                continue;
            }
            if (parsedStatement.getKeywordType() == 1) {
                bl2 = true;
                continue;
            }
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + END_KEYWORD);
        } while (!bl2);
        if (bl) {
            userFunction.setStatements(arrayList);
        }
        Statement statement = new Statement(string, arrayList2, arrayList);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseLoopStatement(Preprocessor preprocessor, boolean bl, boolean bl2) throws IOException, MapyrusException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        String string = preprocessor.getCurrentFilename();
        int n = preprocessor.getCurrentLineNumber();
        Expression expression = new Expression(preprocessor, this.m_userFunctions);
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, bl2);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 7) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DO_KEYWORD);
        }
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl2);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        while (parsedStatement.isStatement()) {
            arrayList.add(parsedStatement.getStatement());
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl2);
            if (parsedStatement != null) continue;
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.getKeywordType() != 8) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DONE_KEYWORD);
        }
        Statement statement = new Statement(expression, arrayList, bl);
        statement.setFilenameAndLineNumber(string, n);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseForStatement(Preprocessor preprocessor, boolean bl) throws IOException, MapyrusException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        String string = preprocessor.getCurrentFilename();
        int n = preprocessor.getCurrentLineNumber();
        Expression expression = new Expression(preprocessor, this.m_userFunctions);
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 9) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + IN_KEYWORD);
        }
        Expression expression2 = new Expression(preprocessor, this.m_userFunctions);
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 7) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DO_KEYWORD);
        }
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        while (parsedStatement.isStatement()) {
            arrayList.add(parsedStatement.getStatement());
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
            if (parsedStatement != null) continue;
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.getKeywordType() != 8) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DONE_KEYWORD);
        }
        Statement statement = new Statement(expression, expression2, arrayList);
        statement.setFilenameAndLineNumber(string, n);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseIfStatement(Preprocessor preprocessor, boolean bl) throws IOException, MapyrusException {
        String string = preprocessor.getCurrentFilename();
        int n = preprocessor.getCurrentLineNumber();
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        ArrayList<Statement> arrayList2 = new ArrayList<Statement>();
        boolean bl2 = true;
        Expression expression = new Expression(preprocessor, this.m_userFunctions);
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 2) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + THEN_KEYWORD);
        }
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        while (parsedStatement.isStatement()) {
            arrayList.add(parsedStatement.getStatement());
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
            if (parsedStatement != null) continue;
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.getKeywordType() == 3) {
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
            if (parsedStatement == null) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
            }
            while (parsedStatement.isStatement()) {
                arrayList2.add(parsedStatement.getStatement());
                parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
                if (parsedStatement != null) continue;
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
            }
        } else if (parsedStatement.getKeywordType() == 4) {
            parsedStatement = this.parseIfStatement(preprocessor, bl);
            if (!parsedStatement.isStatement()) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + ENDIF_KEYWORD);
            }
            arrayList2.add(parsedStatement.getStatement());
            bl2 = false;
        }
        if (bl2 && parsedStatement.getKeywordType() != 5) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + ENDIF_KEYWORD);
        }
        Statement statement = new Statement(expression, arrayList, arrayList2);
        statement.setFilenameAndLineNumber(string, n);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseStatementOrKeyword(Preprocessor preprocessor, boolean bl) throws MapyrusException, IOException {
        ParsedStatement parsedStatement = null;
        boolean bl2 = false;
        int n = preprocessor.readNonSpace();
        bl2 = false;
        while (!bl2) {
            if (n == -1) {
                bl2 = true;
                break;
            }
            if (Character.isWhitespace((char)n)) {
                n = preprocessor.readNonSpace();
                continue;
            }
            String string = this.parseWord(n, preprocessor);
            String string2 = string.toLowerCase();
            if (string2.equals(BEGIN_KEYWORD) || string2.equals(FUNCTION_KEYWORD)) {
                if (bl) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("nestedproc"));
                }
                parsedStatement = this.parseProcedureBlock(preprocessor, string2.equals(FUNCTION_KEYWORD));
            } else if (string2.equals(IF_KEYWORD)) {
                parsedStatement = this.parseIfStatement(preprocessor, bl);
            } else if (string2.equals(WHILE_KEYWORD)) {
                parsedStatement = this.parseLoopStatement(preprocessor, true, bl);
            } else if (string2.equals(REPEAT_KEYWORD)) {
                parsedStatement = this.parseLoopStatement(preprocessor, false, bl);
            } else if (string2.equals(FOR_KEYWORD)) {
                parsedStatement = this.parseForStatement(preprocessor, bl);
            } else {
                parsedStatement = m_keywordLookup.get(string2);
                if (parsedStatement == null) {
                    Statement statement = this.parseSimpleStatement(string, preprocessor);
                    parsedStatement = new ParsedStatement(statement);
                } else {
                    n = preprocessor.readNonSpace();
                    if (n != -1 && n != 59) {
                        preprocessor.unread(n);
                    }
                }
            }
            bl2 = true;
        }
        return parsedStatement;
    }

    private Statement parseStatement(Preprocessor preprocessor) throws IOException, MapyrusException {
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, false);
        if (parsedStatement == null) {
            return null;
        }
        if (!parsedStatement.isStatement()) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidkeyword"));
        }
        return parsedStatement.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpret(ContextStack contextStack, FileOrURL fileOrURL, InputStream inputStream, PrintStream printStream) throws IOException, InterruptedException, MapyrusException {
        boolean bl = this.m_throttle.isIOAllowed();
        Preprocessor preprocessor = new Preprocessor(fileOrURL, bl);
        this.m_stdinStream = inputStream;
        this.m_stdoutStream = printStream;
        this.m_context = contextStack;
        contextStack.setStdout(printStream);
        contextStack.setThrottle(this.m_throttle);
        try {
            Statement statement;
            while ((statement = this.parseStatement(preprocessor)) != null) {
                Argument argument = this.executeStatement(statement);
                if (argument == null) continue;
                break;
            }
        }
        finally {
            preprocessor.close();
        }
    }

    private void makeCall(Statement statement, ArrayList<String> arrayList, Argument[] argumentArray) throws IOException, InterruptedException, MapyrusException {
        Statement statement2;
        for (int i = 0; i < argumentArray.length; ++i) {
            String string = arrayList.get(i);
            this.m_context.setLocalScope(string);
            this.m_context.defineVariable(string, argumentArray[i]);
        }
        ArrayList<Statement> arrayList2 = statement.getStatementBlock();
        for (int i = 0; i < arrayList2.size() && this.executeStatement(statement2 = arrayList2.get(i)) == null; ++i) {
        }
    }

    public Argument executeStatement(Statement statement) throws IOException, MapyrusException, InterruptedException {
        Argument argument;
        block31: {
            StatementType statementType;
            block35: {
                Argument argument2;
                block34: {
                    Argument argument3;
                    block33: {
                        Argument argument4;
                        block32: {
                            block30: {
                                statementType = statement.getType();
                                argument = null;
                                if (statementType != StatementType.BLOCK) break block30;
                                this.m_statementBlocks.put(statement.getBlockName(), statement);
                                break block31;
                            }
                            if (statementType != StatementType.RETURN) break block32;
                            Expression[] expressionArray = statement.getExpressions();
                            if (expressionArray.length > 1) {
                                throw new MapyrusException(MapyrusMessages.get("invalidexpression"));
                            }
                            argument = expressionArray.length == 0 ? Argument.emptyString : expressionArray[0].evaluate(this.m_context, statement.getFilename());
                            break block31;
                        }
                        if (statementType != StatementType.CONDITIONAL) break block33;
                        Expression[] expressionArray = statement.getExpressions();
                        try {
                            argument4 = expressionArray[0].evaluate(this.m_context, statement.getFilename());
                        }
                        catch (MapyrusException mapyrusException) {
                            throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                        }
                        if (argument4.getType() != 0) {
                            throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                        }
                        ArrayList<Statement> arrayList = argument4.getNumericValue() != 0.0 ? statement.getThenStatements() : statement.getElseStatements();
                        if (arrayList == null) break block31;
                        for (int i = 0; i < arrayList.size() && (argument = this.executeStatement(statement = arrayList.get(i))) == null; ++i) {
                        }
                        break block31;
                    }
                    if (statementType != StatementType.WHILE_LOOP && statementType != StatementType.REPEAT_LOOP) break block34;
                    Expression[] expressionArray = statement.getExpressions();
                    ArrayList<Statement> arrayList = statement.getLoopStatements();
                    try {
                        argument3 = expressionArray[0].evaluate(this.m_context, statement.getFilename());
                    }
                    catch (MapyrusException mapyrusException) {
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                    }
                    if (argument3.getType() != 0) {
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                    }
                    int n = 0;
                    if (statementType == StatementType.REPEAT_LOOP) {
                        double d = argument3.getNumericValue();
                        n = NumericalAnalysis.equals(d, (double)((int)d)) ? (int)Math.round(d) : (int)argument3.getNumericValue();
                    }
                    StatementType statementType2 = statementType;
                    for (int i = 0; argument == null && (statementType2 == StatementType.WHILE_LOOP && argument3.getNumericValue() != 0.0 || statementType2 == StatementType.REPEAT_LOOP && i < n); ++i) {
                        Statement statement2;
                        for (int j = 0; j < arrayList.size() && (argument = this.executeStatement(statement2 = arrayList.get(j))) == null; ++j) {
                        }
                        if (arrayList.isEmpty()) {
                            this.m_throttle.sleep();
                        }
                        if (statementType2 != StatementType.WHILE_LOOP || argument != null || (argument3 = expressionArray[0].evaluate(this.m_context, statement.getFilename())).getType() == 0) continue;
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                    }
                    break block31;
                }
                if (statementType != StatementType.FOR_LOOP) break block35;
                Expression[] expressionArray = statement.getExpressions();
                Expression expression = statement.getForHashMap();
                ArrayList<Statement> arrayList = statement.getLoopStatements();
                String string = expressionArray[0].getVariableName();
                try {
                    argument2 = expression.evaluate(this.m_context, statement.getFilename());
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                if (string == null) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("variableexpected"));
                }
                if (argument2.getType() != 2) break block31;
                Object[] objectArray = argument2.getHashMapKeys();
                boolean bl = false;
                for (int i = 0; i < objectArray.length && !bl; ++i) {
                    Statement statement3;
                    String string2 = (String)objectArray[i];
                    this.m_context.defineVariable(string, new Argument(1, string2));
                    for (int j = 0; j < arrayList.size() && (argument = this.executeStatement(statement3 = arrayList.get(j))) == null; ++j) {
                    }
                }
                break block31;
            }
            if (statementType == StatementType.CALL) {
                int n;
                Argument[] argumentArray;
                String string = statement.getBlockName();
                Statement statement4 = this.m_statementBlocks.get(string);
                if (statement4 == null) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("undefinedproc") + ": " + string);
                }
                ArrayList<String> arrayList = statement4.getBlockParameters();
                Expression[] expressionArray = statement.getExpressions();
                if (expressionArray.length != arrayList.size()) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongparameters"));
                }
                try {
                    argumentArray = new Argument[expressionArray.length];
                    for (n = 0; n < argumentArray.length; ++n) {
                        argumentArray[n] = expressionArray[n].evaluate(this.m_context, statement.getFilename());
                    }
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                n = this.m_context.getMoveToCount();
                int n2 = this.m_context.getLineToCount();
                if (n > 0 && n2 == 0) {
                    ArrayList<Point2D> arrayList2 = this.m_context.getMoveTos();
                    ArrayList<Double> arrayList3 = this.m_context.getMoveToRotations();
                    for (int i = 0; i < n; ++i) {
                        this.m_context.saveState(string);
                        Point2D.Float float_ = (Point2D.Float)arrayList2.get(i);
                        this.m_context.setTranslation(float_.x, float_.y);
                        this.m_context.clearPath();
                        double d = arrayList3.get(i);
                        this.m_context.setRotation(d);
                        this.makeCall(statement4, arrayList, argumentArray);
                        this.m_context.restoreState();
                    }
                } else {
                    this.m_context.saveState(string);
                    this.makeCall(statement4, arrayList, argumentArray);
                    this.m_context.restoreState();
                }
            } else {
                try {
                    this.execute(statement, this.m_context);
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                catch (IOException iOException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + iOException.getMessage());
                }
            }
        }
        return argument;
    }

    public Interpreter() {
        this.m_throttle = new Throttle();
    }

    public void setThrottle(Throttle throttle) {
        this.m_throttle = throttle;
    }

    public Throttle getThrottle() {
        return this.m_throttle;
    }

    public Object clone() {
        Interpreter interpreter = new Interpreter();
        interpreter.m_executeArgs = null;
        interpreter.m_context = null;
        interpreter.m_throttle = this.m_throttle.clone();
        interpreter.m_statementBlocks = new HashMap(this.m_statementBlocks.size());
        interpreter.m_statementBlocks.putAll(this.m_statementBlocks);
        interpreter.m_userFunctions = new HashMap(this.m_userFunctions.size());
        for (String string : this.m_userFunctions.keySet()) {
            UserFunction userFunction = this.m_userFunctions.get(string);
            interpreter.m_userFunctions.put(string, userFunction.clone(interpreter));
        }
        interpreter.m_stdinStream = null;
        interpreter.m_stdoutStream = null;
        return interpreter;
    }

    static {
        m_worldUnitsLookup.put("m", 1);
        m_worldUnitsLookup.put("metres", 1);
        m_worldUnitsLookup.put("meters", 1);
        m_worldUnitsLookup.put("feet", 2);
        m_worldUnitsLookup.put("foot", 2);
        m_worldUnitsLookup.put("ft", 2);
        m_worldUnitsLookup.put("degrees", 3);
        m_worldUnitsLookup.put("degree", 3);
        m_worldUnitsLookup.put("deg", 3);
        m_keywordLookup = new HashMap();
        m_keywordLookup.put(END_KEYWORD, new ParsedStatement(1));
        m_keywordLookup.put(THEN_KEYWORD, new ParsedStatement(2));
        m_keywordLookup.put(ELSE_KEYWORD, new ParsedStatement(3));
        m_keywordLookup.put(ELIF_KEYWORD, new ParsedStatement(4));
        m_keywordLookup.put(ENDIF_KEYWORD, new ParsedStatement(5));
        m_keywordLookup.put(DO_KEYWORD, new ParsedStatement(7));
        m_keywordLookup.put(DONE_KEYWORD, new ParsedStatement(8));
        m_keywordLookup.put(IN_KEYWORD, new ParsedStatement(9));
    }
}

