/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.geom;

import java.awt.geom.Point2D;
import org.mapyrus.NumericalAnalysis;

public class LineEquation {
    private double m_A;
    private double m_B;
    private double m_C;
    private double m_X1;
    private double m_X2;
    private double m_Y1;
    private double m_Y2;

    public LineEquation(double d, double d2, double d3, double d4) {
        this.m_A = d4 - d2;
        this.m_B = d - d3;
        this.m_C = d3 * d2 - d * d4;
        this.m_X1 = d;
        this.m_Y1 = d2;
        this.m_X2 = d3;
        this.m_Y2 = d4;
    }

    public LineEquation createParallel(double d) {
        double d2 = this.m_X2 - this.m_X1;
        double d3 = this.m_Y2 - this.m_Y1;
        double d4 = Math.atan2(d3, d2);
        double d5 = this.m_X1 + Math.cos(d4 -= 1.5707963267948966) * d;
        double d6 = this.m_Y1 + Math.sin(d4) * d;
        LineEquation lineEquation = new LineEquation(d5, d6, d5 + d2, d6 + d3);
        return lineEquation;
    }

    public double getAngle() {
        double d = Math.atan2(this.m_Y2 - this.m_Y1, this.m_X2 - this.m_X1);
        return d;
    }

    private boolean isBetweenPoints(LineEquation lineEquation, double d, double d2) {
        boolean bl = true;
        if (lineEquation.m_X1 <= lineEquation.m_X2) {
            if (d < lineEquation.m_X1 || d > lineEquation.m_X2) {
                bl = false;
            }
        } else if (d > lineEquation.m_X1 || d < lineEquation.m_X2) {
            bl = false;
        }
        if (lineEquation.m_Y1 <= lineEquation.m_Y2) {
            if (d2 < lineEquation.m_Y1 || d2 > lineEquation.m_Y2) {
                bl = false;
            }
        } else if (d2 > lineEquation.m_Y1 || d2 < lineEquation.m_Y2) {
            bl = false;
        }
        return bl;
    }

    public Point2D.Double getStartPoint() {
        Point2D.Double double_ = new Point2D.Double(this.m_X1, this.m_Y1);
        return double_;
    }

    public Point2D.Double getEndPoint() {
        Point2D.Double double_ = new Point2D.Double(this.m_X2, this.m_Y2);
        return double_;
    }

    public Point2D.Double intersect(LineEquation lineEquation, boolean bl) {
        Point2D.Double double_;
        double d = this.m_A * lineEquation.m_B - lineEquation.m_A * this.m_B;
        if (NumericalAnalysis.equals(d, 0.0)) {
            double_ = null;
        } else {
            double d2 = (this.m_B * lineEquation.m_C - lineEquation.m_B * this.m_C) / d;
            double d3 = -(this.m_A * lineEquation.m_C - lineEquation.m_A * this.m_C) / d;
            double_ = new Point2D.Double(d2, d3);
            if (bl) {
                if (!this.isBetweenPoints(this, d2, d3)) {
                    double_ = null;
                }
                if (!this.isBetweenPoints(lineEquation, d2, d3)) {
                    double_ = null;
                }
            }
        }
        return double_;
    }

    public String toString() {
        return this.m_A + "x + " + this.m_B + "y + " + this.m_C + " = 0";
    }

    public static void main(String[] stringArray) {
        LineEquation lineEquation = new LineEquation(5.0, 5.0, 10.0, 6.0);
        LineEquation lineEquation2 = new LineEquation(8.0, 4.0, 7.0, 17.0);
        Point2D.Double double_ = lineEquation.intersect(lineEquation2, false);
        System.out.println(double_);
    }
}

