/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.function;

import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import com.jhlabs.map.proj.ProjectionFactory;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Hashtable;
import org.mapyrus.Argument;
import org.mapyrus.ContextStack;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.function.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reproject
implements Function {
    private Hashtable<String, Projection> m_projectionCache = new Hashtable();

    public Reproject() {
        try {
            String[] stringArray = new String[]{"+proj=latlong"};
            ProjectionFactory.fromPROJ4Specification((String[])stringArray);
        }
        catch (ProjectionException projectionException) {
            // empty catch block
        }
    }

    @Override
    public Argument evaluate(ContextStack contextStack, ArrayList<Argument> arrayList) throws MapyrusException {
        Argument argument = null;
        String string = arrayList.get(0).getStringValue();
        String string2 = arrayList.get(1).getStringValue();
        Projection projection = this.getProjection(string);
        Projection projection2 = this.getProjection(string2);
        if (arrayList.size() == 4) {
            double d = arrayList.get(2).getNumericValue();
            double d2 = arrayList.get(3).getNumericValue();
            Point2D.Double double_ = new Point2D.Double(d, d2);
            this.reproject(projection, projection2, double_);
            boolean bl = !Double.isNaN(double_.x) && !Double.isNaN(double_.y);
            double[] dArray = new double[]{100.0, (double)bl, 0.0, double_.x, double_.y};
            argument = new Argument(100, dArray);
        } else {
            Argument argument2 = arrayList.get(2);
            double[] dArray = argument2.getGeometryValue();
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            this.reproject(projection, projection2, dArray2, 0);
            argument = new Argument((int)dArray[0], dArray2);
        }
        return argument;
    }

    private int reproject(Projection projection, Projection projection2, double[] dArray, int n) throws MapyrusException {
        int n2 = (int)dArray[n++];
        Point2D.Double double_ = new Point2D.Double();
        switch (n2) {
            case 100: 
            case 101: 
            case 102: {
                int n3 = n++;
                int n4 = (int)dArray[n3];
                for (int i = 0; i < n4; ++i) {
                    double_.x = dArray[n + 1];
                    double_.y = dArray[n + 2];
                    this.reproject(projection, projection2, double_);
                    if (Double.isNaN(double_.x) || Double.isNaN(double_.y)) {
                        int n5 = n3;
                        dArray[n5] = dArray[n5] - 1.0;
                        int n6 = (int)dArray[n];
                        System.arraycopy(dArray, n + 3, dArray, n, dArray.length - n - 3);
                        if (n6 != 0 || !(dArray[n3] > 0.0)) continue;
                        dArray[n] = n6;
                        continue;
                    }
                    dArray[n + 1] = double_.x;
                    dArray[n + 2] = double_.y;
                    n += 3;
                }
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                int n7 = (int)dArray[n++];
                for (int i = 0; i < n7; ++i) {
                    n = this.reproject(projection, projection2, dArray, n);
                }
                break;
            }
        }
        return n;
    }

    private void reproject(Projection projection, Projection projection2, Point2D.Double double_) throws MapyrusException {
        if (!projection.isRectilinear()) {
            projection.inverseTransform(double_, double_);
        }
        if (!projection2.isRectilinear()) {
            projection2.transform(double_, double_);
        }
    }

    private Projection getProjection(String string) throws MapyrusException {
        Projection projection = this.m_projectionCache.get(string);
        if (projection == null) {
            String[] stringArray = string.trim().split("\\s+");
            try {
                projection = stringArray.length > 0 && stringArray[0].startsWith("+") ? ProjectionFactory.fromPROJ4Specification((String[])stringArray) : ProjectionFactory.getNamedPROJ4CoordinateSystem((String)string);
            }
            catch (ProjectionException projectionException) {
                throw new MapyrusException(projectionException.getMessage() + ": " + string);
            }
            if (projection != null) {
                this.m_projectionCache.put(string, projection);
            }
        }
        if (projection == null) {
            throw new MapyrusException(MapyrusMessages.get("unknownprojection") + ": " + string);
        }
        return projection;
    }

    @Override
    public int getMaxArgumentCount() {
        return 4;
    }

    @Override
    public int getMinArgumentCount() {
        return 3;
    }

    @Override
    public String getName() {
        return "reproject";
    }
}

