/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class Throttle {
    private long m_startTime = System.currentTimeMillis();
    private long m_millisToUse = 1000L;
    private long m_timeLimit = -1L;
    private boolean m_allowIO = true;

    public void restart() {
        this.m_startTime = System.currentTimeMillis();
    }

    public void setMaxLoad(int n) {
        if (n < 5) {
            n = 5;
        } else if (n > 100) {
            n = 100;
        }
        this.m_millisToUse = n * 10;
    }

    public void setMaxTime(long l) {
        this.m_timeLimit = l;
    }

    public long getMaxTime() {
        return this.m_timeLimit;
    }

    public void sleep() throws MapyrusException {
        if (this.m_millisToUse != 1000L || this.m_timeLimit > 0L) {
            long l = System.currentTimeMillis();
            long l2 = l - this.m_startTime;
            long l3 = l2 % 1000L;
            if (this.m_timeLimit > 0L && l2 > this.m_timeLimit) {
                throw new MapyrusException(MapyrusMessages.get("timeout") + ": " + this.m_timeLimit / 1000L);
            }
            if (l3 > this.m_millisToUse) {
                try {
                    Thread.sleep(1000L - this.m_millisToUse);
                }
                catch (InterruptedException interruptedException) {
                    throw new MapyrusException(MapyrusMessages.get("interrupted"));
                }
            }
        }
    }

    public void setIOAllowed(boolean bl) {
        this.m_allowIO = bl;
    }

    public boolean isIOAllowed() {
        return this.m_allowIO;
    }

    public Throttle clone() {
        Throttle throttle = new Throttle();
        throttle.m_timeLimit = this.m_timeLimit;
        throttle.m_millisToUse = this.m_millisToUse;
        return throttle;
    }
}

