/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class FileOrURL {
    private String m_name;
    private URL m_URL;
    private BufferedInputStream m_inputStream;
    private LineNumberReader m_reader;
    private boolean m_isURL;

    public FileOrURL(String string) throws IOException, MapyrusException {
        this.init(string, null);
    }

    public FileOrURL(String string, String string2) throws IOException, MapyrusException {
        this.init(string, string2);
    }

    private void init(String string, String string2) throws IOException, MapyrusException {
        InputStream inputStream;
        try {
            this.m_URL = new URL(string);
            try {
                inputStream = this.m_URL.openStream();
            }
            catch (IOException iOException) {
                throw new MapyrusException(MapyrusMessages.get("cannotopenurl") + ": " + this.m_URL.toString() + Constants.LINE_SEPARATOR + iOException.getMessage());
            }
            this.m_isURL = true;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (SecurityException securityException) {
                throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage() + ": " + string);
            }
            this.m_isURL = false;
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage() + ": " + string);
        }
        try {
            String string3 = string.toLowerCase();
            boolean bl = string3.endsWith(".gz") || string3.endsWith(".svgz");
            boolean bl2 = string3.endsWith(".zip");
            this.m_inputStream = bl ? new BufferedInputStream(new GZIPInputStream(inputStream)) : (bl2 ? new BufferedInputStream(new ZipInputStream(inputStream)) : new BufferedInputStream(inputStream));
            InputStreamReader inputStreamReader = string2 != null ? new InputStreamReader((InputStream)this.m_inputStream, string2) : new InputStreamReader(this.m_inputStream);
            this.m_reader = new LineNumberReader(inputStreamReader);
            this.m_name = string;
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
    }

    public FileOrURL(String string, FileOrURL fileOrURL) throws IOException, MapyrusException {
        InputStream inputStream = null;
        try {
            this.m_URL = fileOrURL != null ? new URL(fileOrURL.m_URL, string) : new URL(string);
            try {
                inputStream = this.m_URL.openStream();
            }
            catch (IOException iOException) {
                throw new MapyrusException(MapyrusMessages.get("cannotopenurl") + ": " + this.m_URL.toString() + Constants.LINE_SEPARATOR + iOException.getMessage());
            }
            this.m_isURL = true;
            this.m_name = this.m_URL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            this.m_URL = null;
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage() + ": " + string);
        }
        if (this.m_URL == null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (SecurityException securityException) {
                throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage() + ": " + string);
            }
            this.m_isURL = false;
            this.m_name = string;
        }
        try {
            boolean bl;
            boolean bl2 = string.endsWith(".gz") || string.endsWith(".GZ");
            boolean bl3 = bl = string.endsWith(".zip") || string.endsWith(".ZIP");
            this.m_inputStream = bl2 ? new BufferedInputStream(new GZIPInputStream(inputStream)) : (bl ? new BufferedInputStream(new ZipInputStream(inputStream)) : new BufferedInputStream(inputStream));
            this.m_reader = new LineNumberReader(new InputStreamReader(this.m_inputStream));
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
    }

    public FileOrURL(Reader reader, String string) {
        this.m_isURL = false;
        this.m_name = string;
        this.m_reader = new LineNumberReader(reader);
        this.m_inputStream = null;
    }

    public boolean isURL() {
        return this.m_isURL;
    }

    public String getURLContentType() throws IOException {
        return this.m_URL.openConnection().getContentType();
    }

    public BufferedInputStream getInputStream() {
        return this.m_inputStream;
    }

    public LineNumberReader getReader() {
        return this.m_reader;
    }

    public String toString() {
        return this.m_name;
    }
}

