/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.pdf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.pdf.PDFObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFFile {
    private String m_filename;
    private RandomAccessFile m_pdfFile;
    private HashMap<Integer, PDFObject> m_objects;
    private ArrayList<PDFObject> m_pageObjects;

    public PDFFile(String string) throws IOException, MapyrusException {
        try {
            this.m_filename = string;
            this.m_pdfFile = new RandomAccessFile(string, "r");
            String string2 = this.m_pdfFile.readLine();
            if (!string2.startsWith("%PDF-")) {
                throw new MapyrusException(MapyrusMessages.get("failedpdf") + ": " + this.m_filename);
            }
            byte[] byArray = new byte[20];
            this.m_pdfFile.seek(this.m_pdfFile.length() - (long)byArray.length);
            this.m_pdfFile.readLine();
            String string3 = this.m_pdfFile.readLine();
            long l = Long.parseLong(string3);
            HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
            this.m_pdfFile.seek(l);
            PDFObject pDFObject = this.readXrefSection(hashMap);
            this.m_objects = new HashMap(hashMap.size());
            for (Integer object2 : hashMap.keySet()) {
                Long l2 = hashMap.get(object2);
                this.m_pdfFile.seek(l2);
                int n = this.readObjectBegin();
                if (n != object2) {
                    throw new MapyrusException(MapyrusMessages.get("failedpdf") + ": " + this.m_filename);
                }
                PDFObject pDFObject2 = this.readObject();
                long l3 = this.readObjectEnd();
                pDFObject2.setStreamOffset(l3);
                this.m_objects.put(object2, pDFObject2);
            }
            PDFObject pDFObject3 = this.getDictionaryValue(pDFObject, "/Root");
            PDFObject pDFObject4 = this.getDictionaryValue(pDFObject3, "/Pages");
            this.m_pageObjects = this.buildPageObjectList(pDFObject4);
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        catch (MapyrusException mapyrusException) {
            this.close();
            throw mapyrusException;
        }
    }

    private ArrayList<PDFObject> buildPageObjectList(PDFObject pDFObject) throws MapyrusException {
        ArrayList<PDFObject> arrayList = new ArrayList<PDFObject>();
        PDFObject pDFObject2 = this.getDictionaryValue(pDFObject, "/Kids");
        PDFObject[] pDFObjectArray = pDFObject2.getArray();
        for (int i = 0; i < pDFObjectArray.length; ++i) {
            PDFObject pDFObject3;
            PDFObject pDFObject4 = pDFObjectArray[i];
            if (pDFObject4.isReference()) {
                pDFObject4 = this.m_objects.get(pDFObject4.getReference());
            }
            if ((pDFObject3 = this.getDictionaryValue(pDFObject4, "/Type")).getValue().equals("/Page")) {
                arrayList.add(pDFObject4);
                continue;
            }
            arrayList.addAll(this.buildPageObjectList(pDFObject4));
        }
        return arrayList;
    }

    private PDFObject readXrefSection(HashMap<Integer, Long> hashMap) throws IOException, MapyrusException {
        Object object;
        String string = this.m_pdfFile.readLine();
        string = this.m_pdfFile.readLine();
        while (!string.equals("trailer")) {
            object = new StringTokenizer(string);
            if (((StringTokenizer)object).countTokens() < 2) {
                throw new MapyrusException(MapyrusMessages.get("failedpdf") + ": " + this.m_filename);
            }
            int n = Integer.parseInt(((StringTokenizer)object).nextToken());
            int n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
            for (int i = 0; i < n2; ++i) {
                Integer n3;
                string = this.m_pdfFile.readLine();
                object = new StringTokenizer(string);
                if (((StringTokenizer)object).countTokens() < 3) {
                    throw new MapyrusException(MapyrusMessages.get("failedpdf") + ": " + this.m_filename);
                }
                Long l = Long.valueOf(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
                String string2 = ((StringTokenizer)object).nextToken();
                if (!string2.equals("n") || hashMap.containsKey(n3 = Integer.valueOf(i + n))) continue;
                hashMap.put(n3, l);
            }
            string = this.m_pdfFile.readLine();
        }
        object = this.readObject();
        PDFObject pDFObject = this.getDictionaryValue((PDFObject)object, "/Prev");
        if (pDFObject != null) {
            String string3 = pDFObject.getValue();
            long l = Long.parseLong(string3);
            this.m_pdfFile.seek(l);
            this.readXrefSection(hashMap);
        }
        return object;
    }

    public void close() {
        if (this.m_pdfFile != null) {
            try {
                this.m_pdfFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_pdfFile = null;
        }
    }

    public int getPageCount() {
        return this.m_pageObjects.size();
    }

    private PDFObject getResources(int n) throws MapyrusException {
        PDFObject pDFObject = this.m_pageObjects.get(n - 1);
        PDFObject pDFObject2 = this.getDictionaryValue(pDFObject, "/Resources");
        return pDFObject2;
    }

    public byte[] getContents(int n) throws IOException, MapyrusException {
        byte[] byArray = null;
        PDFObject pDFObject = this.m_pageObjects.get(n - 1);
        PDFObject pDFObject2 = this.getDictionaryValue(pDFObject, "/Contents");
        if (pDFObject2 != null) {
            this.resolveAllReferences(pDFObject2);
            if (pDFObject2.isArray()) {
                int n2;
                PDFObject[] pDFObjectArray = pDFObject2.getArray();
                byte[][] byArrayArray = new byte[pDFObjectArray.length][];
                int n3 = 0;
                for (n2 = 0; n2 < pDFObjectArray.length; ++n2) {
                    byArrayArray[n2] = pDFObjectArray[n2].getStream(this.m_pdfFile, this.m_filename, this.m_objects);
                    n3 += byArrayArray[n2].length;
                }
                byArray = new byte[n3];
                n2 = 0;
                for (int i = 0; i < byArrayArray.length; ++i) {
                    System.arraycopy(byArrayArray[i], 0, byArray, n2, byArrayArray[i].length);
                    n2 += byArrayArray[i].length;
                }
            } else {
                byArray = pDFObject2.getStream(this.m_pdfFile, this.m_filename, this.m_objects);
            }
        }
        return byArray;
    }

    private ArrayList<StringBuffer> getResource(int n, int n2, String string) throws IOException, MapyrusException {
        ArrayList<StringBuffer> arrayList = null;
        PDFObject pDFObject = this.getResources(n);
        PDFObject pDFObject2 = this.getDictionaryValue(pDFObject, string);
        if (pDFObject2 != null) {
            arrayList = pDFObject2.toPDFString(n2, false, false, this.m_objects, this.m_pdfFile, this.m_filename);
        }
        return arrayList;
    }

    public ArrayList<StringBuffer> getExtGState(int n, int n2) throws IOException, MapyrusException {
        ArrayList<StringBuffer> arrayList = this.getResource(n, n2, "/ExtGState");
        return arrayList;
    }

    public ArrayList<StringBuffer> getColorSpace(int n, int n2) throws IOException, MapyrusException {
        ArrayList<StringBuffer> arrayList = this.getResource(n, n2, "/ColorSpace");
        return arrayList;
    }

    public ArrayList<StringBuffer> getPattern(int n, int n2) throws IOException, MapyrusException {
        ArrayList<StringBuffer> arrayList = this.getResource(n, n2, "/Pattern");
        return arrayList;
    }

    public ArrayList<StringBuffer> getShading(int n, int n2) throws IOException, MapyrusException {
        ArrayList<StringBuffer> arrayList = this.getResource(n, n2, "/Shading");
        return arrayList;
    }

    public ArrayList<StringBuffer> getFont(int n, int n2) throws IOException, MapyrusException {
        ArrayList<StringBuffer> arrayList = this.getResource(n, n2, "/Font");
        return arrayList;
    }

    public ArrayList<StringBuffer> getXObject(int n, int n2) throws IOException, MapyrusException {
        ArrayList<StringBuffer> arrayList = this.getResource(n, n2, "/XObject");
        return arrayList;
    }

    public int[] getMediaBox(int n) throws MapyrusException {
        PDFObject pDFObject = this.m_pageObjects.get(n - 1);
        PDFObject pDFObject2 = this.getDictionaryValue(pDFObject, "/MediaBox");
        PDFObject[] pDFObjectArray = pDFObject2.getArray();
        int[] nArray = new int[4];
        for (int i = 0; i < nArray.length; ++i) {
            PDFObject pDFObject3 = pDFObjectArray[i];
            if (pDFObject3.isReference()) {
                pDFObject3 = this.m_objects.get(pDFObject3.getReference());
            }
            String string = pDFObject3.getValue();
            nArray[i] = (int)Math.round(Double.parseDouble(string));
        }
        return nArray;
    }

    private int readChar(boolean bl) throws IOException, MapyrusException {
        int n = this.m_pdfFile.read();
        if (n == -1) {
            throw new MapyrusException(MapyrusMessages.get("unexpectedeof") + ": " + this.m_filename);
        }
        if (bl && n == 37) {
            n = this.readChar(bl);
            while (n != 13 && n != 10) {
                n = this.readChar(bl);
            }
        }
        return n;
    }

    private int peekChar(boolean bl) throws IOException, MapyrusException {
        long l = this.m_pdfFile.getFilePointer();
        int n = this.readChar(bl);
        this.m_pdfFile.seek(l);
        return n;
    }

    private PDFObject readObject() throws IOException, MapyrusException {
        PDFObject pDFObject = null;
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.readChar(true);
        while (Character.isWhitespace((char)n2)) {
            n2 = this.readChar(true);
        }
        if (n2 == 40) {
            stringBuffer.append((char)n2);
            do {
                n = n2;
                n2 = this.readChar(false);
                stringBuffer.append((char)n2);
            } while (n2 != 41 || n == 92);
            pDFObject = new PDFObject(stringBuffer.toString());
        } else if (n2 == 60) {
            n2 = this.peekChar(true);
            if (n2 != 60) {
                stringBuffer.append('<');
                do {
                    n = n2;
                    n2 = this.readChar(false);
                    stringBuffer.append((char)n2);
                } while (n2 != 62 || n == 92);
                pDFObject = new PDFObject(stringBuffer.toString());
            } else {
                this.readChar(true);
                HashMap<String, PDFObject> hashMap = new HashMap<String, PDFObject>();
                n2 = this.readChar(true);
                while (Character.isWhitespace((char)n2)) {
                    n2 = this.readChar(true);
                }
                while (n2 == 47) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append((char)n2);
                    n2 = this.peekChar(false);
                    while (!Character.isWhitespace((char)n2) && n2 != 91 && n2 != 47 && n2 != 40 && n2 != 60) {
                        this.readChar(false);
                        stringBuffer.append((char)n2);
                        n2 = this.peekChar(false);
                    }
                    PDFObject pDFObject2 = this.readObject();
                    hashMap.put(stringBuffer.toString(), pDFObject2);
                    n2 = this.readChar(true);
                    while (Character.isWhitespace((char)n2)) {
                        n2 = this.readChar(true);
                    }
                }
                n2 = this.readChar(true);
                pDFObject = new PDFObject(hashMap);
            }
        } else if (n2 == 91) {
            ArrayList<PDFObject> arrayList = new ArrayList<PDFObject>();
            PDFObject pDFObject3 = this.readObject();
            while (pDFObject3 != null) {
                arrayList.add(pDFObject3);
                pDFObject3 = this.readObject();
            }
            PDFObject[] pDFObjectArray = new PDFObject[arrayList.size()];
            arrayList.toArray(pDFObjectArray);
            pDFObject = new PDFObject(pDFObjectArray);
        } else if (n2 == 93) {
            pDFObject = null;
        } else {
            stringBuffer = new StringBuffer();
            stringBuffer.append((char)n2);
            n2 = this.peekChar(false);
            while (!Character.isWhitespace((char)n2) && n2 != 47 && n2 != 93 && n2 != 62) {
                this.readChar(false);
                stringBuffer.append((char)n2);
                n2 = this.peekChar(false);
            }
            long l = this.m_pdfFile.getFilePointer();
            n2 = this.readChar(true);
            while (Character.isWhitespace((char)n2)) {
                n2 = this.readChar(true);
            }
            if (n2 == 48) {
                n2 = this.readChar(true);
                while (Character.isWhitespace((char)n2)) {
                    n2 = this.readChar(true);
                }
                if (n2 == 82) {
                    int n3 = Integer.parseInt(stringBuffer.toString());
                    pDFObject = new PDFObject(n3);
                } else {
                    pDFObject = new PDFObject(stringBuffer.toString());
                    this.m_pdfFile.seek(l);
                }
            } else {
                pDFObject = new PDFObject(stringBuffer.toString());
                this.m_pdfFile.seek(l);
            }
        }
        return pDFObject;
    }

    private int readObjectBegin() throws IOException, MapyrusException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.readChar(true);
        while (!Character.isWhitespace((char)n2)) {
            stringBuffer.append((char)n2);
            n2 = this.readChar(true);
        }
        try {
            n = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new MapyrusException(MapyrusMessages.get("failedpdf") + ": " + this.m_filename + ": " + stringBuffer.toString());
        }
        for (int i = 0; i < 2; ++i) {
            while (Character.isWhitespace((char)n2)) {
                n2 = this.readChar(true);
            }
            n2 = this.peekChar(true);
            while (!Character.isWhitespace((char)n2) && n2 != 60 && n2 != 91) {
                this.readChar(true);
                n2 = this.peekChar(true);
            }
        }
        return n;
    }

    private long readObjectEnd() throws IOException, MapyrusException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.readChar(true);
        while (Character.isWhitespace((char)n)) {
            n = this.readChar(true);
        }
        while (!Character.isWhitespace((char)n)) {
            stringBuffer.append((char)n);
            n = this.readChar(true);
        }
        if (n == 13) {
            this.readChar(false);
        }
        long l = -1L;
        if (stringBuffer.toString().equals("stream")) {
            l = this.m_pdfFile.getFilePointer();
        }
        return l;
    }

    private PDFObject getDictionaryValue(PDFObject pDFObject, String string) throws MapyrusException {
        HashMap<String, PDFObject> hashMap = pDFObject.getDictionary();
        if (hashMap == null) {
            throw new MapyrusException(MapyrusMessages.get("failedpdf") + ": " + this.m_filename);
        }
        PDFObject pDFObject2 = hashMap.get(string);
        if (pDFObject2 != null && pDFObject2.isReference()) {
            pDFObject2 = this.m_objects.get(pDFObject2.getReference());
        }
        return pDFObject2;
    }

    private void resolveAllReferences(PDFObject pDFObject) throws IOException, MapyrusException {
        if (pDFObject.isDictionary()) {
            Set<String> set = pDFObject.getDictionary().keySet();
            for (String string : set) {
                PDFObject pDFObject2 = pDFObject.getDictionary().get(string);
                this.resolveAllReferences(pDFObject2);
            }
        } else if (pDFObject.isArray()) {
            PDFObject[] pDFObjectArray = pDFObject.getArray();
            for (int i = 0; i < pDFObjectArray.length; ++i) {
                this.resolveAllReferences(pDFObjectArray[i]);
            }
        } else if (pDFObject.isReference()) {
            PDFObject pDFObject3 = this.m_objects.get(pDFObject.getReference());
            this.resolveAllReferences(pDFObject3);
            pDFObject.setValue(pDFObject3);
        }
    }

    public String getFilename() {
        return this.m_filename;
    }

    public static void main(String[] stringArray) {
        try {
            PDFFile pDFFile = new PDFFile("/tmp/text1.pdf");
            int n = pDFFile.getPageCount();
            for (int i = 1; i <= n; ++i) {
                int n2;
                System.out.println("-- Page " + i);
                int[] nArray = pDFFile.getMediaBox(i);
                System.out.println("[" + nArray[0] + " " + nArray[1] + " " + nArray[2] + " " + nArray[3] + "]");
                System.out.println("-- ExtGState");
                ArrayList<StringBuffer> arrayList = pDFFile.getExtGState(i, 300);
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    System.out.println(arrayList.get(n2));
                }
                System.out.println("-- XObject");
                arrayList = pDFFile.getXObject(i, 400);
                if (arrayList != null) {
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        System.out.println(arrayList.get(n2));
                    }
                }
                System.out.println("-- Contents");
                byte[] byArray = pDFFile.getContents(i);
                System.out.println("contents.length=" + byArray.length);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

