/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.function;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.mapyrus.Argument;
import org.mapyrus.ContextStack;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;
import org.mapyrus.function.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFunction
implements Function {
    private String m_className;
    private String m_methodName;
    private ArrayList<Method> m_methods;
    private int m_minArgs;
    private int m_maxArgs;

    public JavaFunction(String string, String string2, ArrayList<Method> arrayList) {
        this.m_className = string;
        this.m_methodName = string2;
        this.m_methods = arrayList;
        this.m_minArgs = Integer.MAX_VALUE;
        this.m_maxArgs = 0;
        for (Method method : arrayList) {
            int n = method.getParameterTypes().length;
            if (n < this.m_minArgs) {
                this.m_minArgs = n;
            }
            if (n <= this.m_maxArgs) continue;
            this.m_maxArgs = n;
        }
    }

    @Override
    public Argument evaluate(ContextStack contextStack, ArrayList<Argument> arrayList) throws MapyrusException, InterruptedException {
        if (!contextStack.getThrottle().isIOAllowed()) {
            throw new MapyrusException(MapyrusMessages.get("nojavafunctions"));
        }
        Argument argument = null;
        int n = arrayList.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (n2 = 0; n2 < this.m_methods.size() && argument == null; ++n2) {
            Object object;
            Method method = this.m_methods.get(n2);
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != n) continue;
            boolean bl = true;
            for (int i = 0; i < n && bl; ++i) {
                object = classArray[i].getName();
                if (((String)object).equals("java.lang.Object") || ((String)object).equals("java.lang.String")) {
                    objectArray[i] = arrayList.get(i).toString();
                    continue;
                }
                if (((String)object).equals(Argument.class.getSimpleName())) {
                    objectArray[i] = arrayList.get(i);
                    continue;
                }
                if (((String)object).equals("boolean") || ((String)object).equals("java.lang.Boolean")) {
                    double d;
                    boolean bl2;
                    String string = arrayList.get(i).toString();
                    boolean bl3 = string.equalsIgnoreCase("true") ? true : (string.equalsIgnoreCase("false") ? false : !(bl2 = NumericalAnalysis.equals(d = arrayList.get(i).getNumericValue(), 0.0)));
                    objectArray[i] = bl3;
                    continue;
                }
                if (((String)object).equals("byte") || ((String)object).equals("java.lang.Byte")) {
                    double d = arrayList.get(i).getNumericValue();
                    objectArray[i] = (byte)d;
                    continue;
                }
                if (((String)object).equals("char") || ((String)object).equals("java.lang.Character")) {
                    String string = arrayList.get(i).toString();
                    char c = string.length() > 0 ? string.charAt(0) : (char)'\u0000';
                    objectArray[i] = Character.valueOf(c);
                    continue;
                }
                if (((String)object).equals("short") || ((String)object).equals("java.lang.Short")) {
                    double d = arrayList.get(i).getNumericValue();
                    objectArray[i] = (short)d;
                    continue;
                }
                if (((String)object).equals("int") || ((String)object).equals("java.lang.Integer")) {
                    double d = arrayList.get(i).getNumericValue();
                    objectArray[i] = (int)d;
                    continue;
                }
                if (((String)object).equals("long") || ((String)object).equals("java.lang.Long")) {
                    double d = arrayList.get(i).getNumericValue();
                    objectArray[i] = (long)d;
                    continue;
                }
                if (((String)object).equals("float") || ((String)object).equals("java.lang.Float")) {
                    double d = arrayList.get(i).getNumericValue();
                    objectArray[i] = Float.valueOf((float)d);
                    continue;
                }
                if (((String)object).equals("double") || ((String)object).equals("java.lang.Double")) {
                    double d = arrayList.get(i).getNumericValue();
                    objectArray[i] = d;
                    continue;
                }
                bl = false;
            }
            if (!bl) continue;
            try {
                Object object2 = method.invoke(null, objectArray);
                if (object2 == null) {
                    argument = Argument.emptyString;
                    continue;
                }
                argument = new Argument(1, object2.toString());
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MapyrusException(MapyrusMessages.get("failedjavafunction") + ": " + illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException.getCause();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(MapyrusMessages.get("failedjavafunction"));
                stringBuffer.append(": ");
                if (object != null) {
                    stringBuffer.append(((Throwable)object).getMessage());
                } else {
                    stringBuffer.append(invocationTargetException.getMessage());
                }
                if (object instanceof InterruptedException) {
                    throw new InterruptedException(stringBuffer.toString());
                }
                throw new MapyrusException(stringBuffer.toString());
            }
        }
        if (argument == null) {
            throw new MapyrusException(MapyrusMessages.get("failedjavafunction"));
        }
        return argument;
    }

    @Override
    public int getMaxArgumentCount() {
        return this.m_maxArgs;
    }

    @Override
    public int getMinArgumentCount() {
        return this.m_minArgs;
    }

    @Override
    public String getName() {
        return this.m_className + "." + this.m_methodName;
    }
}

