/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Properties;
import org.mapyrus.dataset.TimeStampedConnection;

public class ConnectionPool {
    private static HashMap<String, LinkedList<TimeStampedConnection>> m_pool = new HashMap();

    public static synchronized Connection get(String string, Properties properties) throws SQLException {
        Connection connection;
        LinkedList<TimeStampedConnection> linkedList = m_pool.get(string);
        if (linkedList != null) {
            long l = System.currentTimeMillis();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                TimeStampedConnection timeStampedConnection = (TimeStampedConnection)listIterator.next();
                long l2 = l - timeStampedConnection.getLastUseTimeStamp();
                if (l2 <= 600000L) continue;
                try {
                    timeStampedConnection.getConnection().close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                listIterator.remove();
            }
        }
        if (linkedList == null) {
            linkedList = new LinkedList();
            m_pool.put(string, linkedList);
        }
        if (linkedList.isEmpty()) {
            DriverManager.setLoginTimeout(30);
            connection = DriverManager.getConnection(string, properties);
            try {
                connection.setReadOnly(true);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        } else {
            connection = linkedList.removeFirst().getConnection();
        }
        return connection;
    }

    public static synchronized void put(String string, Connection connection, boolean bl) {
        if (bl) {
            LinkedList<TimeStampedConnection> linkedList = m_pool.get(string);
            linkedList.add(new TimeStampedConnection(connection));
        } else {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

