/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.FileOrURL;
import org.mapyrus.Interpreter;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.MimeTypes;
import org.mapyrus.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPRequest
extends Thread {
    public static final String HTTP_KEYWORD = "HTTP/1.0";
    public static final String HTTP_OK_KEYWORD = "HTTP/1.0 200 OK";
    private static final String HTTP_BAD_KEYWORD = "HTTP/1.0 400 Bad Request";
    private static final String HTTP_NOT_FOUND_KEYWORD = "HTTP/1.0 404 Not Found";
    private static final int HTTP_OK_CODE = 200;
    private static final int HTTP_BAD_CODE = 400;
    private static final int HTTP_NOT_FOUND_CODE = 404;
    public static final String CONTENT_TYPE_KEYWORD = "Content-Type";
    private static final String CONTENT_LENGTH_KEYWORD = "Content-Length";
    private static final String GET_REQUEST_KEYWORD = "GET";
    private static final int GET_REQUEST = 1;
    private static final String POST_REQUEST_KEYWORD = "POST";
    private static final int POST_REQUEST = 2;
    public static final String HTTP_HEADER_ARRAY = "Mapyrus.http.header";
    private Pool<Interpreter> m_pool;
    private Interpreter m_interpreter;
    private Socket m_socket;
    private String m_mimeType;
    private String m_filename;
    private Point m_imagemapPoint;
    private String m_variables;
    private String m_commands;
    private int m_returnStatus;
    private String m_errorMessage;
    private Logger m_logger;
    private long m_creationTimeMillis;

    public HTTPRequest(Socket socket, Interpreter interpreter, Pool<Interpreter> pool, Logger logger) {
        this.m_socket = socket;
        this.m_interpreter = interpreter;
        this.m_pool = pool;
        this.m_imagemapPoint = null;
        this.m_returnStatus = 200;
        this.m_logger = logger;
        this.m_creationTimeMillis = System.currentTimeMillis();
    }

    public static boolean isLegalVariable(String string) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n && bl; ++i) {
            char c = string.charAt(i);
            bl = Character.isLetterOrDigit(c) || c == '$' && i == 0 || (c == '.' || c == '_' || c == ':') && i > 0;
        }
        return bl;
    }

    public static StringBuffer addVariable(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("let ");
        stringBuffer.append(string);
        stringBuffer.append("='");
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '\'') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            if (c != '\r' && c != '\n' || i + 1 >= n || string2.charAt(i + 1) != 'i') continue;
            stringBuffer.append('\\');
        }
        stringBuffer.append("'");
        stringBuffer.append(Constants.LINE_SEPARATOR);
        return stringBuffer;
    }

    private StringBuffer parseForm(String string) throws MapyrusException, IOException {
        int n;
        StringTokenizer stringTokenizer;
        String string2;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n2 = string.lastIndexOf(63);
        if (n2 >= 0) {
            try {
                string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
                stringTokenizer = new StringTokenizer(string2, ",");
                if (stringTokenizer.countTokens() == 2) {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    this.m_imagemapPoint = new Point(n, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            n = (string2 = URLDecoder.decode(string2, "UTF-8")).indexOf(61);
            if (n <= 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (!HTTPRequest.isLegalVariable(string3)) {
                throw new MapyrusException(MapyrusMessages.get("variableexpected") + ": " + string2);
            }
            HTTPRequest.addVariable(stringBuffer, string3.toUpperCase(), string4);
        }
        return stringBuffer;
    }

    private void parseRequest(BufferedReader bufferedReader) throws IOException, MapyrusException {
        String string;
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        String string2 = bufferedReader.readLine();
        if (string2 == null) {
            string2 = "";
        }
        if (this.m_logger.isLoggable(Level.INFO)) {
            object = this.getName() + ": " + MapyrusMessages.get("httpheader") + ": " + string2;
            this.m_logger.info((String)object);
        }
        if (((StringTokenizer)(object = new StringTokenizer(string2))).countTokens() < 3) {
            throw new MapyrusException(MapyrusMessages.get("invalidhttp") + ": " + string2);
        }
        String string3 = ((StringTokenizer)object).nextToken();
        if (string3.equals(GET_REQUEST_KEYWORD)) {
            n = 1;
        } else if (string3.equals(POST_REQUEST_KEYWORD)) {
            n = 2;
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidhttp") + ": " + string2);
        }
        String string4 = ((StringTokenizer)object).nextToken();
        if (!string4.startsWith("/")) {
            throw new MapyrusException(MapyrusMessages.get("invalidhttp") + ": " + string2);
        }
        int n3 = string4.indexOf(63);
        this.m_filename = n3 >= 0 ? string4.substring(1, n3) : string4.substring(1);
        File file = new File(this.m_filename);
        if (this.m_filename.indexOf(File.separatorChar) >= 0 || this.m_filename.indexOf(47) >= 0 || this.m_filename.indexOf(92) >= 0 || !file.exists()) {
            throw new FileNotFoundException(MapyrusMessages.get("httpnotfound") + ": " + this.m_filename);
        }
        int n4 = this.m_filename.lastIndexOf(46);
        if (n4 > 0) {
            string = this.m_filename.substring(n4 + 1);
            this.m_mimeType = MimeTypes.get(string);
        } else {
            this.m_mimeType = null;
        }
        if (this.m_mimeType == null && n3 >= 0 && n == 1) {
            stringBuffer.append(this.parseForm(string4.substring(n3 + 1)));
        }
        string = bufferedReader.readLine();
        while (string != null && string.length() > 0) {
            int n5;
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.finer(this.getName() + ": " + MapyrusMessages.get("httpheader") + ": " + string);
            }
            if ((n5 = string.indexOf(58)) >= 0) {
                String string5 = string.substring(0, n5);
                String string6 = string.substring(n5 + 1).trim();
                int n6 = string5.length();
                boolean bl = true;
                for (int i = 0; i < n6; ++i) {
                    char c = string5.charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '-') continue;
                    bl = false;
                }
                if (bl) {
                    HTTPRequest.addVariable(stringBuffer, "Mapyrus.http.header['" + string5 + "']", string6);
                }
                if (string5.equals(CONTENT_LENGTH_KEYWORD)) {
                    try {
                        n2 = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidhttp") + ": " + string);
                    }
                }
            }
            string = bufferedReader.readLine();
        }
        if (n == 2) {
            StringBuffer stringBuffer3 = new StringBuffer(n2);
            for (int i = 0; i < n2; ++i) {
                int n7 = bufferedReader.read();
                if (n7 < 0) {
                    throw new MapyrusException(MapyrusMessages.get("missinghttppost"));
                }
                stringBuffer3.append((char)n7);
            }
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.fine(this.getName() + ": " + MapyrusMessages.get("httpheader") + ": " + stringBuffer3.toString());
            }
            stringBuffer.append(this.parseForm(stringBuffer3.toString()));
        }
        this.m_variables = stringBuffer.toString();
        if (this.m_mimeType == null) {
            stringBuffer2.append("include ");
            stringBuffer2.append(this.m_filename);
            stringBuffer2.append(Constants.LINE_SEPARATOR);
            this.m_commands = stringBuffer2.toString();
        }
    }

    private String exceptionToString(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = exception.getMessage();
        if (string != null) {
            stringBuffer.append(exception.getMessage()).append(Constants.LINE_SEPARATOR);
        }
        stringBuffer.append(exception.getClass().getName());
        stringBuffer.append(Constants.LINE_SEPARATOR);
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string = stackTraceElementArray[i].toString();
            if (string == null) continue;
            stringBuffer.append(string).append(Constants.LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Object object2;
        String string;
        BufferedInputStream bufferedInputStream;
        BufferedReader bufferedReader;
        BufferedOutputStream bufferedOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        block62: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            bufferedOutputStream = null;
            bufferedReader = null;
            bufferedInputStream = null;
            string = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.m_socket.getInputStream()));
                try {
                    this.parseRequest(bufferedReader);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.m_returnStatus = 404;
                    this.m_errorMessage = fileNotFoundException.getMessage();
                }
                if (this.m_returnStatus == 404) break block62;
                if (this.m_mimeType == null) {
                    object2 = new FileOrURL(new StringReader(this.m_variables), this.getName());
                    object = new FileOrURL(new StringReader(this.m_commands), this.getName());
                    ContextStack contextStack = new ContextStack();
                    if (this.m_imagemapPoint != null) {
                        contextStack.setImagemapPoint(this.m_imagemapPoint);
                    }
                    PrintStream printStream = new PrintStream(byteArrayOutputStream);
                    try {
                        byte[] byArray = new byte[]{};
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        this.m_interpreter.getThrottle().restart();
                        this.m_interpreter.interpret(contextStack, (FileOrURL)object2, byteArrayInputStream, null);
                        this.m_interpreter.interpret(contextStack, (FileOrURL)object, byteArrayInputStream, printStream);
                        string = contextStack.getHTTPResponse().trim() + Constants.LINE_SEPARATOR + Constants.LINE_SEPARATOR;
                        contextStack.closeContextStack();
                        contextStack = null;
                    }
                    finally {
                        try {
                            if (contextStack != null) {
                                contextStack.closeContextStack();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        catch (MapyrusException mapyrusException) {}
                    }
                    printStream.flush();
                    break block62;
                }
                bufferedInputStream = new BufferedInputStream(new FileInputStream(this.m_filename));
            }
            catch (IOException iOException) {
                this.m_returnStatus = 400;
                this.m_errorMessage = iOException.getMessage();
            }
            catch (MapyrusException mapyrusException) {
                this.m_returnStatus = 400;
                this.m_errorMessage = mapyrusException.getMessage();
            }
            catch (Exception exception) {
                this.m_returnStatus = 400;
                this.m_errorMessage = this.exceptionToString(exception);
            }
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(this.m_socket.getOutputStream());
            if (this.m_returnStatus == 200) {
                String string2 = this.m_mimeType == null ? string : HTTP_OK_KEYWORD + Constants.LINE_SEPARATOR + CONTENT_TYPE_KEYWORD + ": " + this.m_mimeType + Constants.LINE_SEPARATOR + Constants.LINE_SEPARATOR;
                if (this.m_logger.isLoggable(Level.FINE)) {
                    object2 = new StringTokenizer(string2, Constants.LINE_SEPARATOR);
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        this.m_logger.fine(this.getName() + ": " + MapyrusMessages.get("httpreturn") + ": " + (String)object);
                    }
                }
                bufferedOutputStream.write(string2.getBytes());
                if (this.m_mimeType == null) {
                    byteArrayOutputStream.writeTo(bufferedOutputStream);
                    if (this.m_logger.isLoggable(Level.FINE)) {
                        this.m_logger.fine(this.getName() + ": " + MapyrusMessages.get("httpreturned") + ": " + byteArrayOutputStream.size());
                    }
                } else {
                    int n = 0;
                    object = new byte[512];
                    int n2 = bufferedInputStream.read((byte[])object);
                    while (n2 > 0) {
                        bufferedOutputStream.write((byte[])object, 0, n2);
                        n += n2;
                        n2 = bufferedInputStream.read((byte[])object);
                    }
                    if (this.m_logger.isLoggable(Level.FINE)) {
                        this.m_logger.fine(this.getName() + ": " + MapyrusMessages.get("httpreturned") + ": " + n);
                    }
                }
            } else {
                object2 = MimeTypes.get("txt");
                Object object3 = object = this.m_returnStatus == 404 ? HTTP_NOT_FOUND_KEYWORD : HTTP_BAD_KEYWORD;
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.fine(this.getName() + ": " + MapyrusMessages.get("httpreturn") + ": " + (String)object);
                    this.m_logger.fine(this.getName() + ": " + MapyrusMessages.get("httpreturn") + ": " + CONTENT_TYPE_KEYWORD + ": " + (String)object2);
                }
                String string3 = (String)object + Constants.LINE_SEPARATOR + CONTENT_TYPE_KEYWORD + ": " + (String)object2 + Constants.LINE_SEPARATOR + Constants.LINE_SEPARATOR + this.m_errorMessage + Constants.LINE_SEPARATOR;
                bufferedOutputStream.write(string3.getBytes());
            }
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            if (this.m_returnStatus == 200) {
                this.m_returnStatus = 400;
                this.m_errorMessage = iOException.toString();
            }
        }
        finally {
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (this.m_socket != null) {
                    this.m_socket.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.m_pool.put(this.m_interpreter);
    }

    public boolean getStatus() {
        return this.m_returnStatus == 200;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public long getCreationTime() {
        return this.m_creationTimeMillis;
    }
}

