/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.io;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.Deflater;
import org.mapyrus.Constants;

public class ASCII85Writer {
    private int[] m_unencodedBytes = new int[4];
    private int m_nUnencodedBytes = 0;
    private char[] m_encodedChars = new char[5];
    private Writer m_writer;
    private int m_nCharsOnLine;
    private Deflater m_deflater;
    private byte[] m_deflateBuffer;
    private int m_nBytesBuffered;

    public ASCII85Writer(Writer writer, boolean bl) throws IOException {
        this.m_writer = writer;
        if (bl) {
            this.m_deflater = new Deflater();
            this.m_deflateBuffer = new byte[512];
            this.m_nBytesBuffered = 0;
        }
        this.m_writer.write(32);
        this.m_nCharsOnLine = 1;
    }

    private void writeEncoded(boolean bl) throws IOException {
        long l = (long)this.m_unencodedBytes[0] << 24;
        l |= (long)this.m_unencodedBytes[1] << 16;
        l |= (long)this.m_unencodedBytes[2] << 8;
        if (!bl && (l |= (long)this.m_unencodedBytes[3]) == 0L) {
            this.m_writer.write(122);
            ++this.m_nCharsOnLine;
        } else {
            this.m_encodedChars[4] = (char)(l % 85L + 33L);
            this.m_encodedChars[3] = (char)((l /= 85L) % 85L + 33L);
            this.m_encodedChars[2] = (char)((l /= 85L) % 85L + 33L);
            this.m_encodedChars[1] = (char)((l /= 85L) % 85L + 33L);
            this.m_encodedChars[0] = (char)(l / 85L + 33L);
            if (bl) {
                this.m_writer.write(this.m_encodedChars, 0, this.m_nUnencodedBytes + 1);
            } else {
                this.m_writer.write(this.m_encodedChars);
                this.m_nCharsOnLine += this.m_encodedChars.length;
            }
        }
        if (this.m_nCharsOnLine > 72) {
            this.m_writer.write(Constants.LINE_SEPARATOR + " ");
            this.m_nCharsOnLine = 0;
        }
    }

    private void save(int n) throws IOException {
        this.m_unencodedBytes[this.m_nUnencodedBytes++] = n;
        if (this.m_nUnencodedBytes == this.m_unencodedBytes.length) {
            this.writeEncoded(false);
            this.m_nUnencodedBytes = 0;
        }
    }

    public void write(int n) throws IOException {
        if (this.m_deflater != null) {
            if (n >= 128) {
                n -= 256;
            }
            this.m_deflateBuffer[this.m_nBytesBuffered++] = (byte)n;
            if (this.m_nBytesBuffered == this.m_deflateBuffer.length) {
                int n2;
                this.m_deflater.setInput(this.m_deflateBuffer);
                this.m_deflateBuffer = new byte[this.m_deflateBuffer.length];
                this.m_nBytesBuffered = 0;
                while ((n2 = this.m_deflater.deflate(this.m_deflateBuffer)) > 0) {
                    for (int i = 0; i < n2; ++i) {
                        this.save(this.m_deflateBuffer[i] & 0xFF);
                    }
                }
            }
        } else {
            this.save(n);
        }
    }

    public void close() throws IOException {
        int n;
        if (this.m_deflater != null) {
            if (this.m_nBytesBuffered > 0) {
                this.m_deflater.setInput(this.m_deflateBuffer, 0, this.m_nBytesBuffered);
            }
            this.m_deflater.finish();
            this.m_deflateBuffer = new byte[this.m_deflateBuffer.length];
            while (!this.m_deflater.finished()) {
                n = this.m_deflater.deflate(this.m_deflateBuffer);
                for (int i = 0; i < n; ++i) {
                    this.save(this.m_deflateBuffer[i] & 0xFF);
                }
            }
        }
        if (this.m_nUnencodedBytes > 0) {
            for (n = this.m_nUnencodedBytes; n < this.m_unencodedBytes.length; ++n) {
                this.m_unencodedBytes[n] = 0;
            }
            this.writeEncoded(true);
        }
    }

    public static void main(String[] stringArray) {
        String string = "The quick brown fox jumped over the lazy dog.";
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter("/tmp/ascii85.txt"));
            ASCII85Writer aSCII85Writer = new ASCII85Writer(printWriter, false);
            byte[] byArray = string.getBytes();
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < byArray.length; ++j) {
                    aSCII85Writer.write(byArray[j]);
                }
            }
            aSCII85Writer.close();
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }
}

