/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenStreetMapDataset
extends DefaultHandler
implements GeographicDataset {
    private static String[] FIELD_NAMES = new String[]{"TYPE", "ID", "GEOMETRY", "TAGS"};
    private static Argument NODE_TYPE_ARGUMENT = new Argument(1, "node");
    private static Argument WAY_TYPE_ARGUMENT = new Argument(1, "way");
    private LinkedList<Row> m_data;
    private double m_xMin;
    private double m_yMin;
    private double m_xMax;
    private double m_yMax;
    private HashMap<String, double[]> m_allNodes;
    private String m_OSMVersion;
    private String m_OSMGenerator;
    private String m_nodeId;
    private String m_wayId;
    private double m_lat;
    private double m_lon;
    private boolean m_visible;
    private Argument m_tags;
    private ArrayList<String> m_wayNodes;

    /*
     * Loose catch block
     */
    public OpenStreetMapDataset(String string, String string2, InputStream inputStream) throws IOException, MapyrusException {
        block34: {
            Object object;
            this.m_xMin = Double.MAX_VALUE;
            this.m_yMin = Double.MAX_VALUE;
            this.m_xMax = Double.MIN_VALUE;
            this.m_yMax = Double.MIN_VALUE;
            this.m_OSMVersion = "";
            this.m_OSMGenerator = "";
            this.m_nodeId = "";
            this.m_wayId = "";
            this.m_lat = 0.0;
            this.m_lon = 0.0;
            this.m_visible = true;
            this.m_tags = null;
            this.m_wayNodes = null;
            InputStream inputStream2 = null;
            Process process = null;
            this.m_data = new LinkedList();
            this.m_allNodes = new HashMap();
            if (string.equals("-")) {
                inputStream2 = inputStream;
            } else if (string.endsWith("|")) {
                object = string.substring(0, string.length() - 1).trim();
                String[] stringArray = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{object} : new String[]{"sh", "-c", object};
                process = Runtime.getRuntime().exec(stringArray);
                inputStream2 = new BufferedInputStream(process.getInputStream());
            } else {
                object = new FileOrURL(string);
                inputStream2 = ((FileOrURL)object).getInputStream();
            }
            object = SAXParserFactory.newInstance().newSAXParser();
            ((SAXParser)object).parse(inputStream2, (DefaultHandler)this);
            Object var9_10 = null;
            try {
                if (process != null) {
                    while (inputStream2.read() > 0) {
                    }
                }
            }
            catch (IOException exception) {
                // empty catch block
            }
            try {
                int n;
                if (process != null && (n = process.waitFor()) != 0) {
                    throw new MapyrusException(MapyrusMessages.get("processerror") + ": " + string);
                }
                break block34;
            }
            catch (InterruptedException exception) {
                throw new MapyrusException(exception.getMessage() + ": " + string);
            }
            finally {
                try {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (IOException iOException) {}
            }
            {
                catch (SAXException sAXException) {
                    throw new MapyrusException(sAXException.getMessage() + ": " + string);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new MapyrusException(parserConfigurationException.getMessage() + ": " + string);
                }
            }
            catch (Throwable throwable) {
                block37: {
                    Exception exception2222;
                    block36: {
                        int n;
                        Object var9_11 = null;
                        try {
                            if (process != null) {
                                while (inputStream2.read() > 0) {
                                }
                            }
                        }
                        catch (IOException exception2222) {
                            // empty catch block
                        }
                        if (process == null || (n = process.waitFor()) == 0) break block36;
                        throw new MapyrusException(MapyrusMessages.get("processerror") + ": " + string);
                    }
                    try {
                        if (inputStream2 != null) {
                            inputStream2.close();
                        }
                        break block37;
                    }
                    catch (IOException iOException) {}
                    break block37;
                    catch (InterruptedException exception2222) {
                        try {}
                        catch (Throwable throwable2) {
                            try {
                                if (inputStream2 != null) {
                                    inputStream2.close();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable2;
                        }
                        throw new MapyrusException(exception2222.getMessage() + ": " + string);
                    }
                }
                throw throwable;
            }
        }
    }

    private String getAttribute(String string, Attributes attributes, String string2) throws SAXException {
        String string3 = attributes.getValue(string2);
        if (string3 == null) {
            throw new SAXException(MapyrusMessages.get("missingxmlattribute") + ": <" + string + "> " + string2);
        }
        return string3;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("node")) {
            String string4 = this.getAttribute(string3, attributes, "visible");
            this.m_visible = Boolean.parseBoolean(string4);
            if (this.m_visible) {
                this.m_nodeId = this.getAttribute(string3, attributes, "id");
                String string5 = this.getAttribute(string3, attributes, "lat");
                try {
                    this.m_lat = Double.parseDouble(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException(MapyrusMessages.get("invalidnumber") + ": <node> lat: " + string5);
                }
                String string6 = this.getAttribute(string3, attributes, "lon");
                try {
                    this.m_lon = Double.parseDouble(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException(MapyrusMessages.get("invalidnumber") + ": <node> lon: " + string6);
                }
                this.m_tags = null;
                if (this.m_lat < this.m_yMin) {
                    this.m_yMin = this.m_lat;
                }
                if (this.m_lat > this.m_yMax) {
                    this.m_yMax = this.m_lat;
                }
                if (this.m_lon < this.m_xMin) {
                    this.m_xMin = this.m_lon;
                }
                if (this.m_lon > this.m_xMax) {
                    this.m_xMax = this.m_lon;
                }
            }
        } else if (string3.equals("way")) {
            String string7 = this.getAttribute(string3, attributes, "visible");
            this.m_visible = Boolean.parseBoolean(string7);
            if (this.m_visible) {
                this.m_wayId = this.getAttribute(string3, attributes, "id");
                this.m_wayNodes = new ArrayList();
                this.m_tags = null;
            }
        } else if (string3.equals("tag") && this.m_visible) {
            if (this.m_tags == null) {
                this.m_tags = new Argument();
            }
            String string8 = this.getAttribute(string3, attributes, "k");
            String string9 = this.getAttribute(string3, attributes, "v");
            this.m_tags.addHashMapEntry(string8, new Argument(1, string9));
        } else if (string3.equals("nd") && this.m_visible) {
            String string10 = this.getAttribute(string3, attributes, "ref");
            this.m_wayNodes.add(string10);
        } else if (string3.equals("osm")) {
            this.m_OSMVersion = this.getAttribute(string3, attributes, "version");
            this.m_OSMGenerator = this.getAttribute(string3, attributes, "generator");
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("node")) {
            if (this.m_visible) {
                Row row = new Row(FIELD_NAMES.length);
                row.add(NODE_TYPE_ARGUMENT);
                row.add(new Argument(1, this.m_nodeId));
                double[] dArray = new double[]{100.0, 1.0, 0.0, this.m_lon, this.m_lat};
                Argument argument = new Argument(100, dArray);
                row.add(argument);
                if (this.m_tags != null) {
                    row.add(this.m_tags);
                } else {
                    row.add(Argument.emptyString);
                }
                this.m_tags = null;
                this.m_data.add(row);
                this.m_allNodes.put(this.m_nodeId, dArray);
            }
        } else if (string3.equals("way") && this.m_visible) {
            Object object;
            Object object2;
            Object object3;
            Row row = new Row(FIELD_NAMES.length);
            row.add(WAY_TYPE_ARGUMENT);
            row.add(new Argument(1, this.m_wayId));
            boolean bl = false;
            int n = this.m_wayNodes.size();
            if (n > 1) {
                object3 = this.m_wayNodes.get(0);
                String string4 = this.m_wayNodes.get(n - 1);
                double[] dArray = this.m_allNodes.get(object3);
                bl = dArray[3] == (object2 = this.m_allNodes.get(string4))[3] && dArray[4] == object2[4];
            }
            object3 = new double[n * 3 + 2];
            object3[0] = bl ? 102.0 : 101.0;
            object3[1] = (double)n;
            int n2 = 2;
            boolean bl2 = false;
            object2 = this.m_wayNodes.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                double[] dArray = this.m_allNodes.get(object);
                object3[n2] = (double)bl2;
                object3[n2 + 1] = dArray[3];
                object3[n2 + 2] = dArray[4];
                n2 += 3;
                bl2 = true;
            }
            object = new Argument((int)object3[0], (double[])object3);
            row.add(object);
            if (this.m_tags != null) {
                row.add(this.m_tags);
            } else {
                row.add(Argument.emptyString);
            }
            this.m_tags = null;
            this.m_data.add(row);
        }
    }

    public String getProjection() {
        return "GEOGCS[\"wgs84\",DATUM[\"WGS_1984\",SPHEROID[\"wgs84\",6378137,298.257223563],TOWGS84[0.000,0.000,0.000]],PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.0174532925199433]]";
    }

    public Hashtable getMetadata() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("version", this.m_OSMVersion);
        hashtable.put("generator", this.m_OSMGenerator);
        return hashtable;
    }

    public String[] getFieldNames() {
        return FIELD_NAMES;
    }

    public Rectangle2D.Double getWorlds() {
        return new Rectangle2D.Double(this.m_xMin, this.m_yMin, this.m_xMax - this.m_xMin, this.m_yMax - this.m_yMin);
    }

    public Row fetch() throws MapyrusException {
        Row row = this.m_data == null || this.m_data.isEmpty() ? null : this.m_data.removeFirst();
        return row;
    }

    public void close() throws MapyrusException {
        this.m_data = null;
    }
}

