/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.FileOrURL;
import org.mapyrus.HTTPRequest;
import org.mapyrus.Interpreter;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Pool;
import org.mapyrus.Throttle;
import org.mapyrus.gui.MapyrusFrame;
import org.mapyrus.logging.SingleLineFormatter;

public class Mapyrus {
    private static final String OUT_OF_MEMORY_MESSAGE = "Out of memory.  Use Java -Xmx option to increase memory\navailable to Mapyrus.  For example, java -Xmx256m -classpath ...\n";
    private Interpreter m_interpreter = new Interpreter();
    private ContextStack m_context = new ContextStack();

    private StringReader makeStringReader(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(Constants.LINE_SEPARATOR);
        }
        StringReader stringReader = new StringReader(stringBuffer.toString());
        return stringReader;
    }

    public void interpret(String[] stringArray, InputStream inputStream, PrintStream printStream) throws IOException, InterruptedException, MapyrusException {
        StringReader stringReader = this.makeStringReader(stringArray);
        FileOrURL fileOrURL = new FileOrURL(stringReader, "commands");
        this.m_interpreter.interpret(this.m_context, fileOrURL, inputStream, printStream);
    }

    public void setPage(BufferedImage bufferedImage, String string) throws IOException, MapyrusException {
        if (string == null) {
            string = "";
        }
        this.m_context.setOutputFormat(bufferedImage, string);
    }

    public void close() throws IOException, MapyrusException {
        try {
            if (this.m_context != null) {
                this.m_context.closeContextStack();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (MapyrusException mapyrusException) {
            throw mapyrusException;
        }
        finally {
            this.m_context = null;
            this.m_interpreter = null;
        }
    }

    private static void printUsageAndExit() {
        int n;
        String[] stringArray = new String[]{"Usage:", "java [-D<variable>=<value>] ... -classpath " + "Mapyrus".toLowerCase() + ".jar org.mapyrus.Mapyrus", "        [options] filename ...", "", "Mapyrus reads each file or URL in turn.", "If filename is '-' then standard input is read.", "", "Variables are passed to Mapyrus using the Java -D option.", "", "Options:", "  -e <commands> runs given commands instead of reading commands from a file", "  -g            starts Mapyrus GUI for each filename", "  -h            print this message", "  -l <level>    sets logging level for HTTP server.  One of ", "                FINEST, FINER, FINE, CONFIG, INFO, WARNING, SEVERE.", "  -r <percent>:<maxtime> restricts CPU usage.  percent value in", "                range 1-100 gives maximum CPU load, a lower value gives", "                other processes more time to run.  maxtime defines", "                the maximum number of seconds to run for.  Mapyrus will", "                exit with error if it runs for longer.", "  -s <port>     starts Mapyrus as a self-contained HTTP server on the", "                given port.  Refer to manual for detailed instructions.", "  -v            print version information and exit"};
        String[] stringArray2 = Constants.getLicense();
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println(stringArray[n]);
        }
        System.out.println("");
        for (n = 0; n < stringArray2.length; ++n) {
            System.out.println(stringArray2[n]);
        }
        System.exit(1);
    }

    private static boolean processFile(ContextStack contextStack, FileOrURL fileOrURL, Interpreter interpreter, boolean bl) {
        try {
            interpreter.interpret(contextStack, fileOrURL, System.in, System.out);
            if (bl) {
                fileOrURL.getReader().close();
            }
        }
        catch (MapyrusException mapyrusException) {
            System.err.println(mapyrusException.getMessage());
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println(OUT_OF_MEMORY_MESSAGE);
            outOfMemoryError.printStackTrace();
            return false;
        }
        return true;
    }

    private static Socket acceptConnection(ServerSocket serverSocket, Logger logger) throws IOException {
        Socket socket = null;
        while (socket == null) {
            try {
                socket = serverSocket.accept();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                logger.info(MapyrusMessages.get("idle"));
            }
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serveHttp(Interpreter interpreter, int n, Level level) {
        ServerSocket serverSocket = null;
        Pool<Interpreter> pool = new Pool<Interpreter>();
        pool.put(interpreter);
        for (int i = 1; i < 8; ++i) {
            pool.put((Interpreter)interpreter.clone());
        }
        HashSet<HTTPRequest> hashSet = new HashSet<HTTPRequest>();
        String string = Mapyrus.class.getName();
        Logger logger = Logger.getLogger(string);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new SingleLineFormatter());
        if (level != null) {
            logger.setLevel(level);
            consoleHandler.setLevel(level);
        }
        logger.addHandler(consoleHandler);
        logger.setUseParentHandlers(false);
        try {
            serverSocket = new ServerSocket(n);
            n = serverSocket.getLocalPort();
        }
        catch (IOException iOException) {
            System.err.println(MapyrusMessages.get("inithttpfailed") + ": " + iOException.getMessage());
            return;
        }
        String string2 = "Mapyrus " + Constants.getVersion() + " " + Constants.getReleaseDate();
        String string3 = MapyrusMessages.get("httpthreadedserver") + ": " + 8;
        String string4 = MapyrusMessages.get("acceptinghttp") + ": " + n;
        logger.config(string2);
        logger.config(string3);
        logger.config(string4);
        if (!logger.isLoggable(Level.CONFIG)) {
            System.out.println(string2);
            System.out.println(string3);
            System.out.println(string4);
        }
        block26: while (true) {
            Socket socket = null;
            try {
                socket = Mapyrus.acceptConnection(serverSocket, logger);
                socket.setSoTimeout(30000);
                interpreter = (Interpreter)pool.get(30000L);
                if (interpreter == null) {
                    throw new MapyrusException(MapyrusMessages.get("httptimeout"));
                }
                HTTPRequest hTTPRequest = new HTTPRequest(socket, interpreter, pool, logger);
                hashSet.add(hTTPRequest);
                logger.fine(MapyrusMessages.get("startedthread") + ": " + hTTPRequest.getName());
                socket = null;
                hTTPRequest.start();
                Iterator iterator = hashSet.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block26;
                    HTTPRequest hTTPRequest2 = (HTTPRequest)iterator.next();
                    if (!hTTPRequest2.isAlive()) {
                        hTTPRequest2.join();
                        logger.fine(MapyrusMessages.get("joinedthread") + ": " + hTTPRequest2.getName());
                        if (!hTTPRequest2.getStatus()) {
                            logger.severe(hTTPRequest2.getName() + ": " + hTTPRequest2.getErrorMessage());
                        }
                        iterator.remove();
                        continue;
                    }
                    long l = System.currentTimeMillis();
                    long l2 = l - hTTPRequest2.getCreationTime();
                    if (l2 <= 30000L) continue;
                    hTTPRequest2.interrupt();
                }
            }
            catch (IOException iOException) {
                logger.severe(iOException.getMessage());
                continue;
            }
            catch (InterruptedException interruptedException) {
                logger.severe(interruptedException.getMessage());
                continue;
            }
            catch (MapyrusException mapyrusException) {
                logger.severe(mapyrusException.getMessage());
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.severe(OUT_OF_MEMORY_MESSAGE);
                continue;
            }
            finally {
                try {
                    if (socket == null) continue;
                    socket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
    }

    private static String getJavaConfiguration() {
        String string;
        String string2;
        String string3 = System.getProperty("java.vendor");
        if (string3 == null) {
            string3 = "null";
        }
        if ((string2 = System.getProperty("java.version")) == null) {
            string2 = "null";
        }
        if ((string = System.getProperty("java.home")) == null) {
            string = "null";
        }
        return "Java version " + string2 + " (" + string3 + ") in " + string;
    }

    public static void main(String[] stringArray) {
        Object object;
        FileOrURL fileOrURL = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        Level level = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        Throttle throttle = null;
        if (stringArray.length == 0) {
            bl2 = true;
        }
        while (n < stringArray.length && stringArray[n].startsWith("-") && stringArray[n].length() > 1) {
            object = stringArray[n];
            if (object.equals("-h") || object.equals("--help") || object.equals("-?")) {
                Mapyrus.printUsageAndExit();
                continue;
            }
            if (object.equals("-v") || object.equals("--version")) {
                System.out.println("Mapyrus " + Constants.getVersion() + " " + Constants.getReleaseDate());
                System.out.println(Mapyrus.getJavaConfiguration());
                System.exit(1);
                continue;
            }
            if (object.equals("-s")) {
                if (n + 1 == stringArray.length) {
                    Mapyrus.printUsageAndExit();
                }
                try {
                    n2 = Integer.parseInt(stringArray[n + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(MapyrusMessages.get("invalidnumber") + ": " + stringArray[n + 1]);
                    Mapyrus.printUsageAndExit();
                }
                n += 2;
                bl = true;
                continue;
            }
            if (object.equals("-e")) {
                if (n + 1 == stringArray.length) {
                    Mapyrus.printUsageAndExit();
                }
                stringBuffer.append(stringArray[n + 1]);
                stringBuffer.append(Constants.LINE_SEPARATOR);
                n += 2;
                continue;
            }
            if (object.equals("-g")) {
                bl2 = true;
                ++n;
                continue;
            }
            if (object.equals("-l")) {
                if (n + 1 == stringArray.length) {
                    Mapyrus.printUsageAndExit();
                }
                try {
                    level = Level.parse(stringArray[n + 1]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(illegalArgumentException.getMessage());
                    System.exit(1);
                }
                n += 2;
                continue;
            }
            if (object.equals("-r")) {
                if (n + 1 == stringArray.length) {
                    Mapyrus.printUsageAndExit();
                }
                try {
                    int n3 = 100;
                    int n4 = -1;
                    StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n + 1], ":");
                    if (stringTokenizer.hasMoreTokens()) {
                        n3 = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        n4 = Integer.parseInt(stringTokenizer.nextToken()) * 1000;
                    }
                    throttle = new Throttle();
                    if (n3 != 100) {
                        throttle.setMaxLoad(n3);
                    }
                    if (n4 != -1) {
                        throttle.setMaxTime(n4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(MapyrusMessages.get("invalidnumber") + ": " + stringArray[n + 1]);
                    Mapyrus.printUsageAndExit();
                }
                n += 2;
                continue;
            }
            if (object.equals("--")) {
                ++n;
                break;
            }
            System.err.println(MapyrusMessages.get("invalidoption") + ": " + (String)object);
            System.exit(1);
        }
        if (bl2) {
            object = null;
            if (stringArray != null && n < stringArray.length) {
                object = new String[stringArray.length - n];
                System.arraycopy(stringArray, n, object, 0, ((String[])object).length);
            }
            try {
                new MapyrusFrame((String[])object);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                System.exit(1);
            }
            System.exit(0);
        }
        ContextStack contextStack = new ContextStack();
        object = new Interpreter();
        if (throttle != null) {
            if (bl && throttle.getMaxTime() < 0L) {
                throttle.setMaxTime(30000L);
            }
            object.setThrottle(throttle);
        }
        if (stringBuffer.length() > 0) {
            fileOrURL = new FileOrURL(new StringReader(stringBuffer.toString()), "-e");
            if (!Mapyrus.processFile(contextStack, fileOrURL, (Interpreter)object, false)) {
                System.exit(1);
            }
        } else {
            for (int i = n; i < stringArray.length; ++i) {
                boolean bl3 = stringArray[i].equals("-");
                if (bl3) {
                    fileOrURL = new FileOrURL(new InputStreamReader(System.in), "standard input");
                } else {
                    try {
                        fileOrURL = new FileOrURL(stringArray[i]);
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                        System.exit(1);
                    }
                    catch (MapyrusException mapyrusException) {
                        System.err.println(mapyrusException.getMessage());
                        System.exit(1);
                    }
                }
                if (Mapyrus.processFile(contextStack, fileOrURL, (Interpreter)object, !bl3)) continue;
                System.exit(1);
            }
        }
        try {
            contextStack.closeContextStack();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        catch (MapyrusException mapyrusException) {
            System.err.println(mapyrusException.getMessage());
            System.exit(1);
        }
        if (bl) {
            Mapyrus.serveHttp((Interpreter)object, n2, level);
            System.exit(1);
        }
        System.exit(0);
    }
}

