/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.pdf;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.io.ASCII85Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFObject {
    private String mValue = null;
    private int mReference = -1;
    private PDFObject[] mArray = null;
    private HashMap<String, PDFObject> mDictionary = null;
    private long mStreamOffset = -1L;

    public PDFObject(String string) {
        this.mValue = string;
    }

    public PDFObject(PDFObject[] pDFObjectArray) {
        this.mArray = pDFObjectArray;
    }

    public PDFObject(HashMap<String, PDFObject> hashMap) {
        this.mDictionary = hashMap;
    }

    public PDFObject(int n) {
        this.mReference = n;
    }

    public void setStreamOffset(long l) {
        this.mStreamOffset = l;
    }

    public String getValue() {
        return this.mValue;
    }

    public void setValue(PDFObject pDFObject) {
        this.mValue = pDFObject.mValue;
        this.mReference = pDFObject.mReference;
        this.mArray = pDFObject.mArray;
        this.mDictionary = pDFObject.mDictionary;
        this.mStreamOffset = pDFObject.mStreamOffset;
    }

    public boolean isArray() {
        return this.mArray != null;
    }

    public PDFObject[] getArray() {
        return this.mArray;
    }

    public boolean isDictionary() {
        return this.mDictionary != null;
    }

    public HashMap<String, PDFObject> getDictionary() {
        return this.mDictionary;
    }

    public boolean isReference() {
        return this.mReference != -1;
    }

    public int getReference() {
        return this.mReference;
    }

    public long getStreamOffset() {
        return this.mStreamOffset;
    }

    public ArrayList<StringBuffer> toPDFString(int n, boolean bl, boolean bl2, HashMap<Integer, PDFObject> hashMap, RandomAccessFile randomAccessFile, String string) throws IOException, MapyrusException {
        int n2;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<StringBuffer> arrayList2 = new ArrayList<StringBuffer>();
        if (bl) {
            stringBuffer.append(n).append(" 0 obj\r\n");
            ++n;
        }
        if (this.mValue != null) {
            stringBuffer.append(this.mValue).append("\r\n");
        } else if (this.mArray != null) {
            stringBuffer.append("[");
            for (int i = 0; i < this.mArray.length; ++i) {
                ArrayList<StringBuffer> arrayList3 = this.mArray[i].toPDFString(n + arrayList2.size(), false, true, hashMap, randomAccessFile, string);
                stringBuffer.append(arrayList3.get(0).toString());
                if (arrayList3.size() <= 1) continue;
                for (int j = 1; j < arrayList3.size(); ++j) {
                    arrayList2.add(arrayList3.get(j));
                }
            }
            stringBuffer.append("]\r\n");
        } else if (this.mDictionary != null) {
            if (bl2) {
                stringBuffer.append("<<\r\n");
            }
            for (String string2 : this.mDictionary.keySet()) {
                PDFObject pDFObject = this.mDictionary.get(string2);
                if (string2.equals("/Length") || string2.equals("/Filter")) continue;
                stringBuffer.append(string2);
                stringBuffer.append(" ");
                object = pDFObject.toPDFString(n + arrayList2.size(), false, true, hashMap, randomAccessFile, string);
                stringBuffer.append(((StringBuffer)((ArrayList)object).get(0)).toString());
                if (((ArrayList)object).size() <= 1) continue;
                for (n2 = 1; n2 < ((ArrayList)object).size(); ++n2) {
                    arrayList2.add((StringBuffer)((ArrayList)object).get(n2));
                }
            }
        } else if (this.mReference >= 0) {
            stringBuffer.append(n + arrayList2.size()).append(" 0 R\r\n");
            PDFObject pDFObject = hashMap.get(new Integer(this.mReference));
            ArrayList<StringBuffer> arrayList = pDFObject.toPDFString(n + arrayList2.size(), true, true, hashMap, randomAccessFile, string);
            arrayList2.addAll(arrayList);
        }
        if (this.mStreamOffset >= 0L) {
            byte[] byArray = this.getStream(randomAccessFile, string, hashMap);
            StringWriter stringWriter = new StringWriter(byArray.length);
            PrintWriter printWriter = new PrintWriter(stringWriter);
            object = new ASCII85Writer(printWriter, true);
            for (n2 = 0; n2 < byArray.length; ++n2) {
                ((ASCII85Writer)object).write(byArray[n2] & 0xFF);
            }
            ((ASCII85Writer)object).close();
            printWriter.write("~>\r\n");
            printWriter.flush();
            byArray = null;
            StringBuffer stringBuffer2 = stringWriter.getBuffer();
            stringBuffer.append("/Filter [/ASCII85Decode /FlateDecode]\r\n");
            stringBuffer.append("/Length ").append(stringBuffer2.length());
            stringBuffer.append("\r\n");
            stringBuffer.append(">>\r\n");
            stringBuffer.append("stream\r\n");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("endstream\r\n");
        } else if (this.mDictionary != null && bl2) {
            stringBuffer.append(">>\r\n");
        }
        if (bl) {
            stringBuffer.append("endobj\r\n");
        }
        arrayList2.add(0, stringBuffer);
        return arrayList2;
    }

    public byte[] getStream(RandomAccessFile randomAccessFile, String string, HashMap<Integer, PDFObject> hashMap) throws IOException, MapyrusException {
        PDFObject pDFObject = this.mDictionary.get("/Length");
        if (pDFObject.isReference()) {
            pDFObject = hashMap.get(new Integer(pDFObject.mReference));
        }
        int n = Integer.parseInt(pDFObject.mValue);
        PDFObject pDFObject2 = this.mDictionary.get("/Filter");
        if (pDFObject.isReference()) {
            pDFObject = hashMap.get(new Integer(pDFObject.mReference));
        }
        byte[] byArray = new byte[n];
        randomAccessFile.seek(this.mStreamOffset);
        randomAccessFile.readFully(byArray);
        if (pDFObject2 != null) {
            String[] stringArray;
            if (!pDFObject2.isArray()) {
                stringArray = new String[]{pDFObject2.getValue()};
            } else {
                PDFObject[] pDFObjectArray = pDFObject2.getArray();
                stringArray = new String[pDFObjectArray.length];
                for (int i = 0; i < pDFObjectArray.length; ++i) {
                    pDFObject2 = pDFObjectArray[i];
                    if (pDFObject2.isReference()) {
                        pDFObject2 = hashMap.get(new Integer(pDFObject2.getReference()));
                    }
                    stringArray[i] = pDFObject2.getValue();
                }
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("/FlateDecode")) {
                    byArray = this.decodeDeflatedBytes(byArray, string);
                    continue;
                }
                if (stringArray[i].equals("/ASCII85Decode")) {
                    byArray = this.decodeASCII85Bytes(byArray);
                    continue;
                }
                if (stringArray[i].equals("/ASCIIHexDecode")) {
                    byArray = this.decodeHexBytes(byArray);
                    continue;
                }
                throw new MapyrusException(MapyrusMessages.get("extendedpdf") + ": " + string + ": " + stringArray[i]);
            }
        }
        return byArray;
    }

    private byte[] decodeDeflatedBytes(byte[] byArray, String string) throws MapyrusException {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        int n = 0;
        byArray = new byte[byArray.length * 5];
        try {
            while (!inflater.finished()) {
                int n2;
                if ((n += (n2 = inflater.inflate(byArray, n, byArray.length - n))) != byArray.length) continue;
                byte[] byArray2 = new byte[byArray.length * 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 0, byArray3, 0, n);
            byArray = byArray3;
        }
        catch (DataFormatException dataFormatException) {
            throw new MapyrusException(MapyrusMessages.get("failedpdf") + ": " + string + ": " + dataFormatException.getMessage());
        }
        return byArray;
    }

    private byte[] decodeASCII85Bytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        for (int i = 0; i < byArray.length && byArray[i] != 126; ++i) {
            if (Character.isWhitespace((char)byArray[i])) continue;
            stringBuffer.append((char)byArray[i]);
            if (stringBuffer.length() == 5) {
                byte[] byArray3 = this.decodeASCII85(stringBuffer.toString(), stringBuffer.length());
                System.arraycopy(byArray3, 0, byArray2, n, byArray3.length);
                n += byArray3.length;
                stringBuffer.setLength(0);
                continue;
            }
            if (stringBuffer.charAt(0) != 'z') continue;
            for (int j = 0; j < 5; ++j) {
                byArray2[n++] = 0;
            }
            stringBuffer.setLength(0);
        }
        if (stringBuffer.length() > 0) {
            int n2 = stringBuffer.length();
            while (stringBuffer.length() < 5) {
                stringBuffer.append('!');
            }
            byte[] byArray4 = this.decodeASCII85(stringBuffer.toString(), n2);
            System.arraycopy(byArray4, 0, byArray2, n, byArray4.length);
            n += byArray4.length;
        }
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    private byte[] decodeASCII85(String string, int n) {
        int n2 = string.charAt(0) - 33;
        long l = n2 * 85 * 85 * 85 * 85;
        n2 = string.charAt(1) - 33;
        l += (long)(n2 * 85 * 85 * 85);
        if (n > 2) {
            n2 = string.charAt(2) - 33;
            l += (long)(n2 * 85 * 85);
        }
        if (n > 3) {
            n2 = string.charAt(3) - 33;
            l += (long)(n2 * 85);
        }
        if (n > 4) {
            n2 = string.charAt(4) - 33;
            l += (long)n2;
        }
        byte[] byArray = new byte[n - 1];
        long l2 = l >> 24 & 0xFFL;
        if (l2 > 127L) {
            l2 -= 256L;
        }
        byArray[0] = (byte)l2;
        if (n > 2) {
            l2 = l >> 16 & 0xFFL;
            if (l2 > 127L) {
                l2 -= 256L;
            }
            byArray[1] = (byte)l2;
        }
        if (n > 3) {
            l2 = l >> 8 & 0xFFL;
            if (l2 > 127L) {
                l2 -= 256L;
            }
            byArray[2] = (byte)l2;
        }
        if (n > 4) {
            l2 = l & 0xFFL;
            if (l2 > 127L) {
                l2 -= 256L;
            }
            byArray[3] = (byte)l2;
        }
        if (n < 5 && (l & 0xFFL) > 127L) {
            l2 = byArray[n - 2] & 0xFF;
            if (++l2 > 127L) {
                l2 -= 256L;
            }
            byArray[n - 2] = (byte)l2;
        }
        return byArray;
    }

    private byte[] decodeHexBytes(byte[] byArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        for (int i = 0; i < byArray.length && byArray[i] != 62; ++i) {
            if (!Character.isLetterOrDigit((char)byArray[i])) continue;
            stringBuffer.append((char)byArray[i]);
            if (stringBuffer.length() != 2) continue;
            n = Integer.parseInt(stringBuffer.toString(), 16);
            if (n > 127) {
                n -= 256;
            }
            byArray2[n2++] = (byte)n;
            stringBuffer.setLength(0);
        }
        if (stringBuffer.length() == 1) {
            stringBuffer.append('0');
            n = Integer.parseInt(stringBuffer.toString(), 16);
            if (n > 127) {
                n -= 256;
            }
            byArray2[n2++] = (byte)n;
        }
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return byArray;
    }
}

